;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = POINTER.INC
;*
;* DESCRIPTIVE NAME = 
;*
;*          This file contains definitions relating to the pointer shape.
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/29/88
;*
;* DESCRIPTION  Constants are defined for the pointer drawing routine describing
;*              the size of the poinetr shape.  Some of these constants are also
;*              required for memory allocation in EGA/VGA VRAM.
;*
;*              Public Data:          PTR_ROUND_RIGHT
;*                                     PTR_ROUND_LEFT
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        public  PTR_ROUND_RIGHT                  ;Pointer exclusion needs these
        public  PTR_ROUND_LEFT
        public  PTR_WIDTH_BITS
        public  PTR_HEIGHT

;/*
;** The pointer parameters are the size of the pointer as received from
;** DeviceSetCursor.
;*/

if SCAN_CNT eq 200
PTR_HEIGHT      equ     16                        ;Height of pointer
endif

if SCAN_CNT eq 350
PTR_HEIGHT      equ     32
endif

if SCAN_CNT eq 480
PTR_HEIGHT      equ     32
endif

PTR_WIDTH       equ     4                          ;Width in bytes of pointer
PTR_WIDTH_BITS  equ     PTR_WIDTH*8                ;Width in bits of pointer

;/*
;** The work width/height is the size of a pointer as manipulated by
;** the pointer drawing code.
;*/

WORK_WIDTH      equ     PTR_WIDTH+1               ;Width of mask, work area
WORK_HEIGHT     equ     PTR_HEIGHT+0              ;Height of mask, work area
MASK_LENGTH     equ     WORK_WIDTH*WORK_HEIGHT    ;#bytes in mask, work area
CLR_MASK_LENGTH equ     WORK_WIDTH*WORK_HEIGHT*BITS_PEL ;#bytes in color mask
        .errnz  BITS_PEL-4

;/*
;** The save area parameters control the size of the buffer used for
;** saveing the bits underneath the pointer image.  It should be a
;** power of two to allow for easy wrap calculations.
;/

SAVE_BUFFER_WIDTH  equ    8                          ;Width  of the save area
SAVE_BUFFER_HEIGHT equ    32                         ;Height of the save area
                   .errnz  PTR_WIDTH  GT SAVE_BUFFER_WIDTH
                   .errnz  PTR_HEIGHT GT SAVE_BUFFER_HEIGHT

;/*
;** The following values allow us to set rounding for cursor exclusion.
;** These values are applied as an AND mask (for rounding left) and as
;** an OR mask (for rounding right).
;*/

ROUNDING_SIZE   equ     8                          ;Round to byte boundaries
                .errnz  ROUNDING_SIZE and 111b    ;Must be at least byte boundary
PTR_ROUND_RIGHT equ     ROUNDING_SIZE-1
PTR_ROUND_LEFT  equ     -ROUNDING_SIZE
