;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EGAMEMD.INC
;*
;* DESCRIPTIVE NAME = EGA/VGA definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         02/23/87
;*
;* DESCRIPTION This file contains the definition of memory for the EGA and 
;*              VGA Winthorn display drivers.
;*
;*          The layout of EGA/VGA memory is defined, based on the number of
;*          scanlines and bytes-per-scanline of the adapter.  A flag is
;*          defined indicating what type of adapter is in use.  This flag
;*          is the SCAN_CNT flag and is given a value as follows:
;*       
;*              -DSCAN_CNT=350
;*       
;*        Restrictions:
;*       
;*          This is the only file which should have any dependancies on the
;*          screen height.
;*
;*        Public Data:          SCREEN_CX
;*                              SCREEN_CY
;*                              SCREEN_CBSCAN
;*                              SCREEN_DSCAN
;*       
;*                              EGAMem:abPointerSave
;*                              EGAMem:abPointerWork
;*                              EGAMem:current_brush
;*                              EGAMem:known_word
;*                              EGAMem:saved_latches
;*                              EGAMem:reserved_latches
;*                              EGAMem:plane_index
;*                              EGAMem:enable_test
;*                              EGAMem:tonys_bar_n_grill
;*       
;*                              SCREEN_CBRESERVED
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;**************************************************************************/

        .xlist
        include cmacros.inc
        include pmgre.inc
        include driver.inc                 ; DAK
        include pointer.inc
        .list

        public  SCREEN_CY
        public  SCREEN_CX
        public  SCREEN_CBSCAN
        public  SCREEN_DSCAN
        public  INIT_POINTER_X
        public  INIT_POINTER_Y
        public  PATTERN_SCAN_UPDATE        ; DAK

;/*
;** These values must be defined before pointer.inc can be included
;*/

SCREEN_CY       =       SCAN_CNT        ;Screen height in scans
ifdef VGA132    ; DAK changed 80 -> 84 when using non-standard VGA modes
SCREEN_CX       =       664             ;Screen width in pixels
SCREEN_CBSCAN   =       84              ;# bytes in one scanline
SCREEN_DSCAN    =       84              ;Delta to next scanline
else
SCREEN_CX       =       640             ;Screen width in pixels
SCREEN_CBSCAN   =       80              ;# bytes in one scanline
SCREEN_DSCAN    =       80              ;Delta to next scanline
endif    ; DAK

PATTERN_SCAN_UPDATE = (SIZE_PATTERN-1) * SCREEN_CBSCAN  ;DAK for special.blt

        .xlist
        include pointer.inc
        .list

INIT_POINTER_X  equ     SCREEN_CX/2     ;Initial pointer x
INIT_POINTER_Y  equ     SCREEN_CY/2     ;Initial pointer x


;/*
;** Define the layout of EGA/VGA memory.
;**
;** The pointer save area and work area will be allocated in unused
;** screen RAM.  This will allow the EGA's special hardware to
;** be used for moving all planes of a byte with a single movsb
;** instruction.  It will also allow the EGA's drawing modes to
;** be used for writing to all planes with a single mov instruction.
;** Besides, it also saves a lot of space!
;**
;** Special EGA locations will be made public by this routine since
;** it knows exactly what must be where better than anybody else.
;*/

        public  abPointerSave
        public  abPointerWork
        public  current_brush
        public  known_word
        public  saved_latches
        public  reserved_latches
        public  plane_index
        public  enable_test
        public  tonys_bar_n_grill

        public  SCREEN_CBRESERVED


EGAMem          segment at 0

abScreenImage   db      (SCREEN_CBSCAN*SCREEN_CY) dup (?)
abPointerSave   db      (SAVE_BUFFER_WIDTH*SAVE_BUFFER_HEIGHT) dup (?)
abPointerWork   db      MASK_LENGTH dup (?)
current_brush   db      8 dup (?)
known_word      dw      ?
saved_latches   db      ?
reserved_latches db     ?
plane_index     db      ?
enable_test     db      ?
tonys_bar_n_grill db    ?

SCREEN_CBRESERVED =     $-abScreenImage

EGAMem        ends

end
