;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EGAMEM.INC
;*
;* DESCRIPTIVE NAME = EGA memory definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/06/87
;*
;* DESCRIPTION This file contains the external definitions of the EGA memory
;*              locations which driver output routines need to reference.
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/06/87                     Written by Walt Moore
;*****************************************************************************/

;/*
;**     EGAMem defines offsets of locations in the EGA's address
;**     space used both to determine and save the state of the EGA.
;**
;**     The actual address within the EGA's Regen RAM is determined
;**     at link time, and is based on the number of vertical scans.
;*/



EGAMem  segment at 0

        externB abPointerSave                     ;Saved bits under pointer
        externB abPointerWork                     ;Working buffer for pointer code
        externB current_brush                     ;One brush may be stored here
        externW known_word                        ;Known value in the word
        externB saved_latches                     ;Saved processor latches
        externB plane_index                       ;Plane index goes here
        externB enable_test                       ;Used for Data Rotate test
                                                  ;     and Bit Mask test
                                                  ;     and Enable Set/Reset test
        externB tonys_bar_n_grill                 ;For output routine use.  Valid
                                                  ;  only during the current function.
EGAMem  ends
