;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EGA.INC
;*
;* DESCRIPTIVE NAME = EGA driver definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/06/87
;*
;* DESCRIPTION  This file contains the definitions of the EGA registers 
;*              used by the driver.
;*
;*      Restrictions:
;*     
;*            The following rules apply to the use of the EGA registers
;*            for the drivers (excluding pointer code and state detection
;*            code):
;*     
;*     
;*            1)  Routines are allowed to alter the following registers:
;*     
;*                Sequencer:
;*     
;*                    SEQ_DATA                SEQ_MAP_MASK
;*     
;*                Graphics Controller:
;*     
;*                    GRAF_ADDR
;*                    GRAF_DATA               GRAF_DATA_ROT
;*                    GRAF_SET_RESET          GRAF_READ_MAP
;*                    GRAF_ENAB_SR            GRAF_MODE
;*                    GRAF_COL_COMP           GRAF_BIT_MASK
;*     
;*     
;*            2)  The following registers will always contain the indicated
;*                value.  Routines are not allowed to alter them:
;*     
;*                Sequencer:
;*     
;*                    SEQ_ADDR        set to point SEQ_MAP_MASK
;*     
;*                Graphics Controller:
;*     
;*                    GRAF_CDC        set appropriately for color model
;*     
;*     
;*            3)  Rotation counts for GRAF_DATA_ROT are not allowed.
;*     
;*     
;*            4)  The following EGA registers will contain the indicated
;*                value upon entry to a routine.  Any routine which alters
;*                them must restore them to the indicated state.
;*     
;*                    Map Mask            all planes enabled
;*                    Enable Set/Reset    all planes disabled
;*                    Data Rotate         Set, no rotation
;*                    Mode                Processor write, data read
;*                    Bit Mask            all bits enabled
;*     
;*     
;*            5)  The Mode Register is always shadowed in EGA memory for
;*                the state detection code.  At interrupt time, the mode
;*                will be restored from the structure "shadowed_graf_mode".
;*                Any routine altering the Mode Register must keep this location
;*                current.  This is the only EGA register which requires
;*                shadowing.
;*     
;*     
;*            6)  Pointer drawing will save and restore the contents of
;*                the processor latches.
;*     
;*     
;*            7)  Pointer drawing will leave GRAF_ADDR set to GRAF_BIT_MASK.
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;**       Miscellaneous Registers used only at EGA initialization time
;*/

MISC_OUTPUT     equ     0C2h            ;Miscellaneous Output Register
CRTC_ADDR       equ     0D4h            ;CRTC Address Register for color mode
CRTC_DATA       equ     0D5h            ;CRTC Data    Register for color mode
GRAF_1_POS      equ     0CCh            ;Graphics 1 Address Register
GRAF_2_POS      equ     0CAh            ;Graphics 2 Address Register
ATTR_READ       equ     0DAh            ;Attribute Controler Read  Address
ATTR_WRITE      equ     0C0h            ;Attribute Controler Write Address
IN_STAT_0       equ     0C2h            ;Input Status Register 0
IN_STAT_1       equ     0DAh            ;Input Status Register 1



;/*
;**       EGA Register Definitions.
;**
;**       The following definitions are the EGA registers and values
;**       used by this driver.  All other registers are set up at
;**       when the EGA is placed into graphics mode and never altered
;**       afterwards.
;**
;**       All unspecified bits in the following registers must be 0.
;*/


EGA_BASE        equ     300h            ;Base address of the EGA (3xx)


;/*
;**       Sequencer Registers Used
;*/

SEQ_ADDR        equ     0C4h            ;Sequencer Address Register
SEQ_DATA        equ     0C5h            ;Sequencer Data    Register

SEQ_MAP_MASK    equ     02h             ;Write Plane Enable Mask
MM_C0           equ     00000001b       ;  C0 plane enable
MM_C1           equ     00000010b       ;  C1 plane enable
MM_C2           equ     00000100b       ;  C2 plane enable
MM_C3           equ     00001000b       ;  C3 plane enable
MM_ALL          equ     00001111b       ;  All planes

SEQ_MODE        equ     04h             ;Memory Mode
SM_ALPHA        equ     00000001b       ;  Char map select enable
SM_EXTENDED     equ     00000010b       ;  Extended memory present
SM_ODD_PLANE    equ     00000100b       ;  Odd/even bytes to same plane

;/*
;**       VGA DAC Controller Registers
;*/

FEATURE_CONTROL_1       equ     0DAh    ; touching this resets on some VGAs
FEATURE_CONTROL_2       equ     0BAh    ; and touching this resets on others
ATTR_REG                equ     0C0h
COLOR_SELECT            equ     014h    ; "attribute" 14h of attr reg
PAL_ADDR_SRC            equ     020h    ; palette address source flag
DAC_INDEX               equ     0C8h
DAC_DATA                equ     0C9h

;/*
;**       Graphics Controller Registers Used
;*/

GRAF_ADDR       equ     0CEh            ;Graphics Controller Address Register
GRAF_DATA       equ     0CFh            ;Graphics Controller Data    Register

GRAF_SET_RESET  equ     00h             ;  Set/Reset Plane Color
GRAF_ENAB_SR    equ     01h             ;  Set/Reset Enable
GRAF_COL_COMP   equ     02h             ;  Color Compare Register

GRAF_DATA_ROT   equ     03h             ;  Data Rotate Register
DR_ROT_CNT      equ     00000111b       ;    Data Rotate Count
DR_SET          equ     00000000b       ;    Data Unmodified
DR_AND          equ     00001000b       ;    Data ANDed with latches
DR_OR           equ     00010000b       ;    Data ORed  with latches
DR_XOR          equ     00011000b       ;    Data XORed with latches

GRAF_READ_MAP   equ     04h             ;  Read Map Select Register
RM_C0           equ     00000000b       ;    Read C0 plane
RM_C1           equ     00000001b       ;    Read C1 plane
RM_C2           equ     00000010b       ;    Read C2 plane
RM_C3           equ     00000011b       ;    Read C3 plane

GRAF_MODE       equ     05h             ;  Mode Register
M_PROC_WRITE    equ     00000000b       ;    Write processor data rotated
M_LATCH_WRITE   equ     00000001b       ;    Write latched data
M_COLOR_WRITE   equ     00000010b       ;    Write processor data as color
M_AND_WRITE     equ     00000011b       ;    Write (procdata AND bitmask)
M_DATA_READ     equ     00000000b       ;    Read selected plane
M_COLOR_READ    equ     00001000b       ;    Read color compare

GRAF_MISC       equ     06h             ;  Miscellaneous Register
MS_NON_ALPHA    equ     00000001b       ;    Char generator disabled
MS_ODD_EVEN     equ     00000010b       ;    Map odd addresses to even
MS_A0000_128K   equ     00000000b       ;    Memory present at A0000, 128kb
MS_A0000_64K    equ     00000100b       ;    Memory present at A0000, 64kb
MS_B0000_32K    equ     00001000b       ;    Memory present at B0000, 32kb
MS_B8000_32K    equ     00001100b       ;    Memory present at B8000, 32kb
MS_ADDR_MASK    equ     00001100b

GRAF_CDC        equ     07h             ;  Color Don't Care Register
GRAF_BIT_MASK   equ     08h             ;  Bit Mask Register

;/*
;**$001 --- Begin Insertion ---
;*/

ifdef SLITE
GRAF_ESR        equ     0Fh             ; Environment Status Register
ESR_UNLOCK      equ     00000101b       ; ESR Unlock key
ESR_LOCK        equ     00000000b       ; ESR Lock key

GRAF_BBCR       equ     10h             ; Bit Blt Configuration Register
BBCR_TS         equ     10000000b       ; Tri-States video mem/address/control
BBCR_RBLT       equ     01000000b       ; Resets Blt engine state machine
BBCR_BBEN       equ     00001000b       ; Bit Blt Enable address decode
BBCR_BBAS       equ     00000100b       ; Bit Blt Address Select (0 = primary)
BBCR_BCD        equ     00000010b       ; Bus Clock Disable
BBCR_FFP        equ     00000001b       ; FIFO Priority (0 = compatible)

;/*
;** BLT Engine Register Definitions
;*/

SL_BSrcAddr     equ     23C0h           ; Byte address of source bitmap
                ;       23C1h           ;  high byte
SL_BWidth       equ     23C2h           ; Width of the bitmap in bytes
                ;       23C3h           ;  high byte
SL_BHeight      equ     23C4h           ; # of scanlines in bitmap
                ;       23C5h           ;  high byte
SL_BHeightW     equ     23C8h           ; READ ONLY reg, # scanlines left to do
                ;       23C9h           ;  high byte
SL_BPitch       equ     23CAh           ; Width of the device in bytes (i.e.
                                        ; inc to next scanline) If -ve then
                                        ; BLT goes up!
                ;       23CBh           ;  high byte
SL_BDestOff     equ     23CCh           ; Byte offset from begining of source bitmap
                ;       23CDh           ;  high byte
SL_BStartMask   equ     33C0h           ; First byte pixel mask
SL_BEndMask     equ     33C1h           ; Last byte pixel mask
SL_ROP3         equ     33C2h           ; Plane 3 two operand raster op
SL_ROP2         equ     33C3h           ; Plane 2 two operand raster op
SL_ROP1         equ     33C4h           ; Plane 1 two operand raster op
SL_ROP0         equ     33C5h           ; Plane 0 two operand raster op
SL_ROPA         equ     33C7h           ; Write to all raster op regs at once
SL_BRot         equ     33C8h           ; Phase between source & dest bitmaps
SL_BSkewMask    equ     33C9h           ; 
SL_PReg0        equ     33CAh           ; Plane 0 source data register
SL_PReg1        equ     33CBh           ; Plane 1 source data register
SL_PReg2        equ     33CCh           ; Plane 2 source data register
SL_PReg3        equ     33CDh           ; Plane 3 source data register
SL_BCommand1    equ     33CEh           ; Control Code Register 1
BC1_SS          equ     00000001b       ; Start/Stop
BC1_PL          equ     00000010b       ; Preload
BC1_SKL         equ     00000100b       ; Skip Last
BC1_SKS         equ     00001000b       ; Skip Source
BC1_SKD         equ     00010000b       ; Skip Destination
BC1_BSW         equ     00100000b       ; Byte Swap
BC1_HDIR        equ     01000000b       ; Horizontal Direction
;**             eqy     10000000b
SL_BCommand2    equ     33CFh           ; Control Code Register 2
BC2_SMX0        equ     00000001b       ; Source Multiplexer Selects
BC2_SMX1        equ     00000010b       ; "      "           "
BC2_SMX2        equ     00000100b       ; "      "           "
BC2_SMX3        equ     00001000b       ; "      "           "
BC2_ROPE        equ     00010000b       ; Raster Operation Enable
BC2_DSR         equ     00100000b       ; Disable Set/Reset Registers
;**             equ     01000000b
;**             eqy     10000000b
endif

;/*
;**$001 --- End Insertion ---
;*/
