;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DRIVER.INC
;*
;* DESCRIPTIVE NAME = driver include file
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/12/88
;*
;* DESCRIPTION  This file contains the structure, flag, constant, and macro
;*              definitions for various driver functions.
;*
;*              Certain flags can be defined to include various definitions included
;*              in this file:
;*
;*              DINCL_ENABLE          Include definitions for the enable function
;*              DINCL_DEVBITMAP       Include definitions for Create/Delete Bitmap
;*              DINCL_ERROR           Include definitions for error routines
;*              DINCL_CLR_TBL         Include Color table definitions
;*              DINCL_VIO             Include VIO constant definitions
;*              DINCL_ROP             Include old         ROP2 definitions
;*              DINCL_SKIP_DDC        Skip definition of the ddc structure
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/09/89                     Michael Kerekes [mikeke] Made it work.
;*   06/28/88                     Lee A. Newberg [leen] Put the string 
;*                                in the FIRESEG.
;*****************************************************************************/


;/*
;** Segments used throughout the driver.  All segments are defined here
;** for consistancy.  Segments must be defined before the .386 directive.
;*/

createSeg _PTRDATA,     PtrData,        WORD, PUBLIC, DATA
createSeg _COMPLCODE,   CompileCodeData,WORD, PUBLIC, DATA
createSeg _CACHE,       Cache,          WORD, PUBLIC,DATA

ifdef VGA
createSeg _STRING,      String,         WORD, PUBLIC,DATA
endif

createSeg _RING3CODE,   Ring3Code,      WORD, PUBLIC, CODE, RING2CONF
createSeg _RING2CONF,   Ring2Conform,   WORD, PUBLIC, CODE, RING2CONF

defgrp RING2CONF,       <Ring3Code,Ring2Conform>

createSeg _TEXT,        Code,           WORD, PUBLIC, CODE, TEXT
createSeg _BITBLT,      BitBlt,         WORD, PUBLIC, CODE, TEXT
createSeg _FARTEXT,     FarCode,        WORD, PUBLIC, CODE, TEXT
createSeg _INITSEG,     InitSeg,        WORD, PUBLIC, CODE, TEXT
createSeg _BLUEMOON,    BlueMoon,       WORD, PUBLIC, CODE, TEXT

createSeg _PALSEG,      PalSeg,         WORD, PUBLIC, CODE, SECSEG
createSeg _BITMAP,      Bitmap,         WORD, PUBLIC, CODE, SECSEG
createSeg _PTR,         PtrCode,        WORD, PUBLIC, CODE, SECSEG
createSeg _VIOSEG,      VioSeg,         WORD, PUBLIC, CODE, SECSEG

createSeg _INSTANCE,    InstanceData    WORD, PUBLIC, DATA
createSeg _RING3DATA,   Ring3Data,      WORD, PUBLIC, DATA

defgrp TEXT,    <BitBlt,FarCode,InitSeg,BlueMoon>
defgrp SECSEG,  <PalSeg,Bitmap,PtrCode,VioSeg>
 
.386

;/***************************************************************************
;*
;* Processor selection macros
;*
;* DESCRIPTION   = Enable assembly of a particular processor's instructions,
;*                 and set a flag which can be read for conditional assembly.
;*
;* INPUT         = which_proc
;*                                                                          
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

?cpumode = 286

;/*
;***** CPUMode - put a wrapper around .processor directives
;*/

CPUMode macro cpu
    ifidn <cpu>,<8086>
        ?cpumode = 8086
        .8086
    elseifidn <cpu>,<8088>
        ?cpumode = 8086
        .8086
    elseifidn <cpu>,<286>
        ?cpumode = 286
        .286p
    elseifidn <cpu>,<386>
        ?cpumode = 386
        .386p
    elseifidni <cpu>,<reset>
        if ?cpumode eq 386
            .386p
        elseif ?cpumode eq 286
            .286p
        elseif ?cpumode eq 8086
            .8086
        endif
    else
        %out Unknown processor type cpu
        .err
    endif
endm

;/*
;** Some basic constants
;*/

MAXSHORT        equ     7FFFh           ;Kinda majorly positive
MINSHORT        equ     8000h           ;Kinda majorly negative
MAXLONG         equ     7FFFFFFFh       ;Massively positive
MINLONG         equ     80000000h       ;Massively negative

MAX_COORDINATE  equ   007FFFFFFh        ;Limit width and height to 27 bits
MIN_COORDINATE  equ   0F8000000h

SIZE_BYTE       equ     1               ;I hope you never use this!
SIZE_WORD       equ     2               ;# of bytes in a word
SIZE_DWORD      equ     4               ;# of bytes in a dword
SHIFT_BYTE      equ     0               ;I wish they had a power function
SHIFT_WORD      equ     1
SHIFT_DWORD     equ     2


INVALID_SEL     equ     0FFFFh
INVALID_ADDRESS equ   (-1)

SIZE_IPC        equ     2               ;Size of an internal physical color
INVALID_IPC     equ     8000h           ;Invalid internal physical color

WE_BE_DEAD      equ     -1              ;Screen has been switched away

;/*
;** The next 2 symbols are used with "screen_busy", defined in CURSORSC.ASM
;*/
IS_BUSY         equ     0               ;  Pointer operation in progress
NOT_BUSY        equ     1               ;  No pointer operation in progress

ifdef INCL_GPITRANSFORMS
CVTC_SCREEN     equ     CVTC_DEVICE+1   ;Internal device to screen conversion
endif



;/*
;** Object Identifiers
;*/

DS_IDENT                equ     'dg'    ;Identifier for our DGROUP
SM_IDENT                equ     'SM'    ;Identifier for a semaphore
DDC_IDENT               equ     'cd'    ;Identifier for a ddc
RDDC_IDENT              equ     'dr'    ;Identifier for a rddc
SAVED_DDC_IDENT         equ     'ds'    ;Identifier for a saved ddc
SURFACE_IDENT           equ     'is'    ;Identifier for a surface
HDBM_IDENT              equ     'bh'    ;Identifier for a handle to a bitmap
HDDC_IDENT              equ     'dh'    ;Identifier for a handle to a ddc
CT_IDENT                equ     'tc'    ;Identifier for a color table
DELETED_IDENT           equ     0       ;Dead objects have 0 for ident


;/*
;** Some structure definitions
;*/

OurRECTS        struc                   ;A better RECTS structure
rcs_xLeft       dw      ?
rcs_yBottom     dw      ?
rcs_xRight      dw      ?
rcs_yTop        dw      ?
OurRECTS        ends
                .errnz  rcs_xLeft   - (rcs_pts1.pts_x)
                .errnz  rcs_yBottom - (rcs_pts1.pts_y)
                .errnz  rcs_xRight  - (rcs_pts2.pts_x)
                .errnz  rcs_yTop    - (rcs_pts2.pts_y)
                .errnz  (SIZE OurRECTS) - (SIZE RECTS)

LONG    struc                           ;Used to access the low and
lo      dw      ?                       ;   high words of a dword
hi      dw      ?
LONG    ends

FARPOINTER      struc                   ;Used to access the offset
off     dw      ?                       ;   and selector of a pointer
sel     dw      ?
FARPOINTER      ends


ifdef DINCL_ENABLE

;/*
;** Equates needed by the enable function
;*/

PDEV_MAGIC_COOKIE       equ     'PDEV'  ;Physical ID returned from enable

;/*
;** INIT_VRAM is a parameter to the physical_enable routine indicating
;** that video memory should be set to some initial value
;*/

INIT_VRAM       equ     1



;/*
;** Base symbol set resource constants for the default font and markers
;** contained within our .exe as resources and loaded on the first call
;** to enable.  The FONT_RES structure defines the data used to load
;** in the resources.  It may be written over at initialization time if
;** a .ini entry specifies a different font.
;*/

RT_OUR_MARKER   equ     2000            ;Default type for us
RT_OUR_FONT     equ     1000
RES_ID_LOWER    equ     100
RES_ID_HIGHER   equ     101

FONT_RES        struc
fr_pp           dd      INVALID_ADDRESS ;Where resource pointer goes
fr_hModule      dw      -1              ;Module of the resource
fr_usType       dw      -1              ;Type of the resource
fr_usId         dw      -1              ;Id of the resource
FONT_RES        ends


;/*
;** GSSP is the structure passed to GetScreenSelector.  It contains the
;** physical starting address of video memory, the number of selectors
;** required (limited to 1 or 2), and the number of bytes to allocate
;** in the last segment (0=64K).
;**
;** The first structure element is the number of bytes of data in the
;** structure.  If this number doesn't equal the size of the GSSP
;** structure, no screen selector will be allocated by the Enable
;** function of the driver.
;*/


GSSP            struc                   ;Get Screen Selector Parameters
gssp_size       dw      size GSSP       ;   0 if no selector is needed
gssp_cSel       dw      0               ;   Number selectors required (1 or 2)
gssp_cb         dw      0               ;   Size of memory in last selector
gssp_pPhysMem   dd      0               ;   Start of Physical Memory
GSSP            ends


;/*
;** fun1_parm is the definition of the u32_param1 structure passed to the
;** driver for the fill_log_dev_blk call.  fun1_ret is the definition of
;** the structure passed for u32_param2.
;**
;**       fun1_ver        is the version number of the Engine.
;**       fun1_cpfn       is the number of entries in the passed dispatch
;**                       table.  The driver can only write this many
;**                       entries into the table.
;**       fun1_pfb        is a pointer to where the flags controlling
;**                       calls to fill_phys_dev_blk go.
;**       fun1_papfn      is the pointer to the default dispatch table
;**                       where we get the addresses of the default
;**                       handlers and where we return our handlers.
;*/


fun1_parm       struc                   
fun1_ver        dd      ?               
fun1_cpfn       dd      ?
fun1_parm       ends

fun1_ret        struc                   
fun1_pfb        dd      ?               
fun1_papfn      dd      ?
fun1_ret        ends


;/*
;** fun5_parm is the definition of the parameters passed to enable_dc
;** in pFun5Parm.
;**
;**       fun5_hState     is the handle to the PDevice block created in
;**                       fill_phys_dev_blk.
;**       fun5_type       is the DC type (memory, output, ect.), passed
;**                       to the OpenDC call.
;**       fun5_hdc        is the Engine's DC handle which will be
;**                       associated with this ddc.
;*/


fun5_parm       struc                   
fun5_hState     dd      ?               
fun5_type       dd      ?
fun5_hdc        dd      ?
fun5_parm       ends


;/*
;** Logical device flags indicating how we want DDC to be managed.  The
;** values are returned in the location pointed to bu fun1_pfb.
;*/

MUSTHAVEPDEV            equ     0001h   
LDEVSINGLEDC            equ     0002h   
LDEVIGNORENAMES         equ     0004h

endif


ifdef DINCL_BITMAP

;/*
;** The BMC structure contains parameters for DeviceCreateBitmap
;** and DeviceDeleteBitmap.
;**
;** bmc_cbInfo    This is the number of bytes needed for a BITMAPINFO
;**               structure for this format bitmap.  This is used for
;**               the TRANSLATE option to DeviceDeleteBitmap.
;**
;** bmc_cBitCount This is the BitCount field returned in the BITMAPINFO
;**               structure when translating during DeviceDeleteBitmap.
;**               The plane count is always returned as one.
;**
;** bmc_cRound    This value is used to round a scanline of the given
;**               format to a double word.  It is added to sd_cx, and
;**               then its inverse is ANDed with the sum.
;**
;** bmc_cShr      This value is a shift count used to shift the above
;**               result to get the total number of bytes to allocate
;**               for one scanline of one plane (sd_cbScan).
;**
;** bmc_cPlanes   This value is a multiplier used to multiply sd_cbScan
;**               to give the size of all planes of one scan (sd_dScan).
;**
;** bmc_fbColor   This value is the color bit.  It is set to SD_COLOR
;**               if the bitmap is color, else it is zero.
;*/


BMC             struc
bmc_cbInfo      dw      0
bmc_cBitCount   db      0
bmc_cRound      db      0
bmc_cShr        db      0
bmc_cPlanes     db      0
bmc_fbColor     db      0
BMC             ends

endif


ifdef DINCL_ERROR

;/*
;** Device driver flags loaded from the environment at load time
;*/

DDF_RIP_ERROR   equ     01h
GREFLAGS_RIP    equ     <word ptr 'R'>
GREFLAGS_RIP_LC equ     <word ptr 'r'>

;/*
;** The base value of all driver errors reported to WinSetErrorInfo
;*/

DDIERR_BASE     equ     6000h

endif


ifdef DINCL_CLR_TBL
;/*
;** color table constants
;*/

;/*
;** number of entries in default color table
;*/

DEFAULT_COLOR_TABLE_SIZE      equ     16        ; same on all devices

ifdef CLR256

;/*
;** number of entries in logical color table
;*/

LOGICAL_COLOR_TABLE_SIZE        equ     256

else
LOGICAL_COLOR_TABLE_SIZE      equ     64
endif

COLOR_TABLE     struc
ct_usId         dw      ?               ;Identifier
ct_npargb       dw      ?               ;Points to the rgb triplets
ct_cSave        dw      ?               ;Number of reference for Save/RestoreDC
ct_iMin         dw      ?               ;Minimum loaded color index
ct_iMax         dw      ?               ;Maximum loaded color index
COLOR_TABLE     ends

ct_aipc         equ     size COLOR_TABLE ;The physical colors start here

endif


ifdef DINCL_VIO

;/*
;** Vio Font resource name ids are constructed by adding the font height to
;** RES_ID_VIO_FONT_BASE.
;*/

RES_ID_VIO_FONT_BASE    equ     2000

;/*
;** Selected offsets into the adDevCapsData structure
;*/

DEF_HEIGHT_OFFSET   EQU CAPS_CHAR_HEIGHT*4
DEF_WIDTH_OFFSET    EQU CAPS_CHAR_WIDTH *4

ALT_HEIGHT_OFFSET   EQU CAPS_SMALL_CHAR_HEIGHT*4
ALT_WIDTH_OFFSET    EQU CAPS_SMALL_CHAR_WIDTH *4

;/*
;** Code Page Mapping Constants
;*/

DEFAULTVIOCODEPAGE  equ 850

endif


ifdef DINCL_ROPS

;/*
;** Various internal values for the mix modes
;*/

ROP_DDX         equ     0               ;DDx    This is Window's ordering
ROP_DPON        equ     1               ;DPon
ROP_DPNA        equ     2               ;DPna
ROP_PN          equ     3               ;Pn
ROP_PDNA        equ     4               ;PDna
ROP_DN          equ     5               ;Dn
ROP_DPX         equ     6               ;DPx
ROP_DPAN        equ     7               ;DPan
ROP_DPA         equ     8               ;DPa
ROP_DPXN        equ     9               ;DPxn
ROP_D           equ     10              ;D
ROP_DPNO        equ     11              ;DPno
ROP_P           equ     12              ;P
ROP_PDNO        equ     13              ;PDno
ROP_DPO         equ     14              ;DPo
ROP_DDXN        equ     15              ;DDxn

CHAR_ROP_DPO    equ     0               ;OR
CHAR_ROP_P      equ     1               ;Overpaint
CHAR_ROP_D      equ     2               ;Leave alone
CHAR_ROP_DPX    equ     3               ;XOR

endif

ifdef DINCL_BB_ROPS

;/*
;** Bitblt ROP (mixes) definitions
;*/
                                        ; pmgpi.inc names
BB_ROP_D        equ     0AAh            ; ---------------
BB_ROP_DDx      equ       0h            ; ROP_ZERO
BB_ROP_DDxn     equ     0FFh            ; ROP_ONE
BB_ROP_Dn       equ     055h            ; ROP_DSTINVERT
BB_ROP_DPx      equ     05Ah            ; ROP_PATINVERT
BB_ROP_DSa      equ     088h            ; ROP_SRCAND
BB_ROP_DSan     equ     077h
BB_ROP_DSna     equ     022h
BB_ROP_DSno     equ     0BBh            ; ROP_MERGEPAINT
BB_ROP_DSo      equ     0EEh            ; ROP_SRCPAINT
BB_ROP_DSon     equ     011h            ; ROP_NOTSRCERASE
BB_ROP_DSx      equ     066h            ; ROP_SRCINVERT
BB_ROP_DSxn     equ     099h
BB_ROP_P        equ     0F0h            ; ROP_PATCOPY
BB_ROP_Pn       equ      0Fh
BB_ROP_S        equ     0CCh            ; ROP_SRCCOPY
BB_ROP_SDna     equ      44h            ; ROP_SRCERASE
BB_ROP_SDno     equ     0DDh
BB_ROP_Sn       equ      33h            ; ROP_NOTSRCCOPY

endif


ifdef DINCL_SAVE_SCREEN_BITS

;/*
;** Allowed values for the function ("Options") RestoreScreenBits is
;** to perform.
;*/

RSB_FREE        equ     00000001b
RSB_RESTORE     equ     00000010b

endif


ifdef DINCL_PAT_CACHE_DEFS

;/*
;** Flags for pattern caching
;*/

PAT_CACHE_INVALID  equ  0               ;Pattern cache is invalid
PAT_CACHE_GRAY     equ  1               ;Cache contains special gray pat
;                                       ; 2-15 reserved for us!
PAT_CACHE_FIRST_ID equ  16              ;First user ID

endif



ifndef DINCL_SKIP_DDC

NUM_CLIP_RECTS  equ     4

;/*
;** A note on bitmap organization.
;**
;** A bitmap as an application sees it on the screen looks something
;** like:
;**
;**                 (0,n-1)                 (j-1,n-1)
;**                    -----------------------
;**                   |      scan n-1         |
;**                   |-----------------------|
;**                   |      scan 2           |
;**                   |-----------------------|
;**                   |      scan 1           |
;**                   |-----------------------|
;**                   |      scan 0           |
;**                    -----------------------
;**                 (0,0)                   (j-1,0)
;**                first pel                last pel
;**
;** 
;**  The origin is in the lower left of the screen.  This unfortunately
;**  is not how video memory is organized.  Video memory is organized:
;** 
;**                  (0,0)                   (j-1,0)
;**                     -----------------------
;**                    |      scan 0           |
;**                    |-----------------------|
;**                    |      scan 1           |
;**                    |-----------------------|
;**                    |      scan 2           |
;**                    |-----------------------|
;**                    |      scan n-1         |
;**                     -----------------------
;**                  (0,n-1)                 (j-1,n-1)
;**                 first pel                last pel
;** 
;**  All internal drawing routines will convert Y coordinates from the first
;**  format into the second format (subtract the given Y from the height of
;**  the surface - 1).  The smallest address within the bitmap will be that
;**  of pel (0,0).  The highest address within the bitmap will be that of
;**  pel (m-1,n-1).
;** 
;** 
;**  The actual organization of a memory bitmap will be as follows:
;** 
;**    Bitmap characteristics:
;** 
;**        1  plane of information, z bits per pel (z=1,4,8)
;** 
;**        j  pels across
;** 
;**        k  bytes per scan line.  This is rounded to a dword
;**           value and computed as k = (((j*p)+31)/8) & 0xFFFC.
;** 
;**        l  scan lines fitting within a 64K segment.  This is
;**           computed as l = 65536/(k*1).  This field is only
;**           relevant for bitmaps which require more than 64K
;**           bytes of memory.
;** 
;**        m  unused bytes per 64K segment.  This is computed as
;**           m = 65536 mod (k*1).  This field is only relevant
;**           for bitmaps which require more than 64K bytes of
;**           memory.
;** 
;**        n  total scanlines
;** 
;** 
;** 
;**                     <-------k bytes------->
;**                        (dword multiple)
;** 
;**                  (0,0)                  (0,j-1)
;**     lowest ---      -----------------------        ---         ---
;**     addr in |      |      scan 0           |        |           |
;**     memory  |      |-----------------------|        |           |
;**             |      |      scan 1           |        |           |
;**             |      |-----------------------|                    |
;**                    |      scan 2           |    l scanlines     |
;**            64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**             |      |-----------------------|        |           |
;**             |      |      scan l-1         |        |           |
;**             |      |-----------------------        ---          |
;**             |      | (unused)  |       (l-1,j-1)                |
;**            ---      -----------                                 |
;**                                                                 |
;**                     <-m bytes->                                 |
;**                                                                 |
;**                                                                 |
;**                  (l,0)                  (l,j-1)                 |
;**            ---      -----------------------        ---          |
;**             |      |      scan l           |        |           |
;**             |      |-----------------------|        |
;**             |      |      scan l+1         |        |        h scans
;**             |      |-----------------------|
;**                    |      scan l+2         |    l scanlines     |
;**            64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**             |      |-----------------------|        |           |
;**             |      |      scan 2l-1        |        |           |
;**             |      |-----------------------        ---          |
;**             |      | (unused)  |      (2l-1,j-1)                |
;**            ---      -----------                                 |
;**                                                                 |
;**                                                                 |
;**                  (2l,0)                (2l,j-1)                 |
;**            ---      -----------------------        ---          |
;**             |      |      scan 2l          |        |           |
;**             |      |-----------------------|                    |
;**                    |      scan 2l+1        |    l scanlines     |
;**          > 64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**     highest |      |-----------------------|        |           |
;**     addr in |      |      scan n-1         |       ---          |
;**     memory ---      -----------------------                    ---
;**                 (n-1,0)                (n-1,j-1)
;** 
;** 
;**    If the bitmap requires less than 64K of memory, only the last
;**    segment pictured is relevant.
;** 
;** 
;**    Bitmap characteristics:
;** 
;**        4  planes of information, 1 bit per plane per pel
;** 
;**        j  pels across
;** 
;**        k  bytes per scan line.  This is rounded to a dword
;**           value and computed as k = (((j*1)+31)/8) & 0xFFFC.
;** 
;**        l  scan lines fitting within a 64K segment.  This is
;**           computed as l = (65536 / (k*4)).  This field is
;**           only relevant for bitmaps which require more than
;**           64K total memory.
;** 
;**           NOTE:  This calculation insures that all planes of
;**                  a given scanline are contained within the
;**                  same 64K segment.
;** 
;**        m  unused bytes per 64K segment.  This is computed as
;**           m = 65536 mod (k*4).  This field is only relevant
;**           for bitmaps which require more than 64K total memory.
;** 
;**        n  total scanlines
;** 
;** 
;**        For color bitmaps, each scan line consists of four planes
;**        of information.  Extra information is computed for color
;**        bitmaps:
;** 
;**            d  bytes between scans of the same plane.  This is
;**               computed as d = (4 * k).
;** 
;**                     -----------------------       ---         -----
;**                    |   scan 0, plane 0     |       |            |
;**                    |-----------------------|       |         this is
;**                    |   scan 0, plane 1     |                 refered
;**                    |-----------------------|   4 * k bytes   to as a
;**                    |   scan 0, plane 2     |                 c-scan
;**                    |-----------------------|       |         below
;**                    |   scan 0, plane 3     |       |            |
;**                    |-----------------------|      ---         -----
;**                    |   scan 1, plane 0     |       |
;**                    |-----------------------|       |
;**                    |   scan 1, plane 1     |
;**                    |-----------------------|   4 * k bytes
;**                    |   scan 1, plane 2     |
;**                    |-----------------------|       |
;**                    |   scan 1, plane 3     |       |
;**                    |-----------------------|      ---
;**                             ....
;** 
;**                    |-----------------------|      ---
;**                    |   scan n-1, plane 0   |       |
;**                    |-----------------------|       |
;**                    |   scan n-1, plane 1   |
;**                    |-----------------------|   4 * k bytes
;**                    |   scan n-1, plane 2   |
;**                    |-----------------------|       |
;**                    |   scan n-1, plane 3   |       |
;**                     -----------------------       ---
;** 
;** 
;**                     <-------k bytes------->
;**                        (dword multiple)
;** 
;**                  (0,0)                  (0,j-1)
;**     lowest ---      -----------------------        ---         ---
;**     addr in |      |    c-scan 0           |        |           |
;**     memory  |      |-----------------------|        |           |
;**             |      |    c-scan 1           |        |           |
;**             |      |-----------------------|                    |
;**                    |    c-scan 2           |    l scanlines     |
;**            64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**             |      |-----------------------|        |           |
;**             |      |    c-scan l-1         |        |           |
;**             |      |-----------------------        ---          |
;**             |      | (unused)  |       (l-1,j-1)                |
;**            ---      -----------                                 |
;**                                                                 |
;**                     <-m bytes->                                 |
;**                                                                 |
;**                                                                 |
;**                  (l,0)                  (l,j-1)                 |
;**            ---      -----------------------        ---          |
;**             |      |    c-scan l           |        |           |
;**             |      |-----------------------|        |
;**             |      |    c-scan l+1         |        |        h scans
;**             |      |-----------------------|
;**                    |    c-scan l+2         |    l scanlines     |
;**            64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**             |      |-----------------------|        |           |
;**             |      |    c-scan 2l-1        |        |           |
;**             |      |-----------------------        ---          |
;**             |      | (unused)  |      (2l-1,j-1)                |
;**            ---      -----------                                 |
;**                                                                 |
;**                     <-m bytes->                                 |
;**                                                                 |
;**                                                                 |
;**                  (2l,0)                (2l,j-1)                 |
;**            ---      -----------------------        ---          |
;**             |      |    c-scan 2l          |        |           |
;**             |      |-----------------------|                    |
;**                    |    c-scan 2l+1        |    l scanlines     |
;**          > 64K     |-----------------------|                    |
;**                    |       ...             |        |           |
;**     highest |      |-----------------------|        |           |
;**     addr in |      |    c-scan n-1         |       ---          |
;**     memory ---      -----------------------                    ---
;**                 (n-1,0)                (n-1,j-1)
;** 
;** 
;**    If the bitmap requires less than 64K of memory, only the last
;**    segment pictured is relevant.
;** 
;** 
;**  The same values computed for bitmaps can be applied to the video
;**  adapter.  The values computed for the display treat it as if it
;**  were a monochrome device, with special plane selection logic to
;**  get between planes (we pretend to repeat the operation four times).
;*/



;/*
;**  The surface structure definition (sd_)
;** 
;**  The surface structure contains characteristics of the writing surface.
;**  It is part of all memory bitmaps and device contexts.  It contains
;**  the following information:
;** 
;** 
;**  sd_usId       This field contains the identifier for the surface.
;**                It will be SURFACE_IDENT.  It must be the first field
;**                of the surface structure so that bitblt can do error
;**                checking on the second hddc/hbm.
;** 
;**  sd_npsd       Pointer to the surface.  In a surface definition this
;**                field points backwards to the sd_usId field (this
;**                generally is of no use, but read on).  The equivalent
;**                field in a ddc will point to the start of the real
;**                surface definition.  This allows bitblt to use either
;**                a bitmap or ddc as the source, dereferencing the same
;**                offset to get to the real surface information.
;** 
;**                   ddc              screen             bitmap
;**                 -------            -------            -------
;**                |sd_usId|     ---> |sd_usId| <-       |sd_usId| <-
;**                 -------     |      -------    |       -------    |
;**                |sd_npsd| ---      |sd_npsd| --       |sd_npsd| --
;**                 -------            -------            -------
;** 
;**  sd_fb         Flags as defined later
;** 
;**  sd_fbAccel    Flags as defined later
;** 
;**  sd_cx         This is the width of the surface in pels.
;** 
;**  sd_cy         This is the height of the surface in scans
;** 
;**  sd_cbScan     This is the width of a scan line in bytes.  It will
;**                always be a multiple of four for a memory bitmap.
;**                For the physical display, it will be the width of the
;**                display in bytes.
;** 
;**                This number can be used to get to the next plane of a
;**                scanline.
;** 
;**  sd_dScan      This is the index to the next scan of a plane in a color
;**                bitmap (BITS_PEL * sd_cbScan).  For monochrome
;**                bitmaps and the display, it will be 0.
;** 
;**  sd_cbFill     Number of unused bytes at the end of a 64K segment of
;**                a huge bitmap.  This is used in computing if overflow
;**                has occured into another segment of the bitmap.  This
;**                field is valid if SD_HUGE is set in sd_fb.
;** 
;**  OR
;** 
;**  sd_pbmi       The far pointer to the caller-supplied bitmap info structure
;**                describing the bits pointed by sd_pBits (see below) if it
;**                is also caller-supplied.
;** 
;** *****************************************************************************
;**  Warning:      The sd_dScan and sd_cbFill fields overlay the sd_pbmi field
;**  ========      if sd_pBits actually points to the bits of the surface.
;** *****************************************************************************
;** 
;**  sd_cySeg      Number of scanlines which fit within a 64K segment of
;**                memory.
;** 
;**  sd_selIncr    For huge bitmaps, the sd_pBits field contains the 1st selector
;**                and an increment is added to that to get to the 2nd selector.
;**                The increment value is either 10h for the physical display
;**                or DOSHUGEINCR for memory bitmaps.  This field contains
;**                the appropriate increment value.
;** 
;**  OR
;** 
;**  sd_pClrTab    The far pointer to the color mapping table
;**                if the pBits points to a caller-supplied bitmap
;** 
;** *****************************************************************************
;**  Warning:      The sd_cySeg and sd_selIncr fields overlay the sd_pClrTab field
;**  ========      if sd_pBits actually points to the bits of the surface.
;** *****************************************************************************
;** 
;**  sd_pBits      This is the far pointer to the bits of the surface.
;**                Scan sd_cy-1 is at this address (see picture above).
;** 
;**                Will be INVALID_SEL if a bitmap surface is NULL (a width
;**                or height of 0), if the ddc is for an information context
;**                context, or the device doesn't require a selector.
;** 
;**  Flag values for sd_fb:
;** 
;**  SD_DEVICE     1 The surface is the physical display
;**                0 ddc surface is a memory bitmap
;** 
;**  SD_COLOR      1 The surface is color
;**                0 The surface is monochrome
;** 
;**  SD_HUGE       1 The surface is     a huge bitmap
;**                0 The surface is not a huge bitmap
;** 
;**  SD_NONNULL    1 The surface is present.  This will be the case for
;**                  any normal display ddc, and for non-null bitmaps.
;**                0 No surface present.  This will be the case for
;**                  null bitmaps (width or height of 0), and when the
;**                  ddc created was for an Information Context.
;*/


SURFACE         struc
sd_usId         dw      ?
sd_npsd         dw      ?
sd_fb           db      ?
sd_fbAccel      db      ?
sd_cx           dw      ?
sd_cy           dw      ?
sd_cbScan       dw      ?
sd_dScan        dw      ?
sd_cbFill       dw      ?
sd_cySeg        dw      ?
sd_selIncr      dw      ?
sd_pBits        dd      ?
SURFACE         ends

sd_pbmi         equ     sd_dScan         ;DWORD field overlays sd_dScan&sd_cbFill
sd_pClrTab      equ     sd_cySeg         ;DWORD field overlays sd_cySeg&sd_selIncr

                .errnz  (size SURFACE) and 1

SD_DEVICE       equ     10000000b       ;sd_fb
SD_COLOR        equ     01000000b
SD_HUGE         equ     00100000b
SD_HEAPBITS     equ     00010000b
;**             equ     00001000b
;**             equ     00000100b
;**             equ     00000010b
SD_NONNULL      equ     00000001b

;**             equ     10000000b       ;sd_fbAccel
;**             equ     01000000b
;**             equ     00100000b
;**             equ     00010000b
;**             equ     00001000b
;**             equ     00000100b
;**             equ     00000010b
;**             equ     00000001b



;/*
;** Bitmap Structure Definition (bm_)
;**
;** bm_sd         Surface definition as defined above
;**
;** bm_hddc       Handle of the hddc this bitmap is currently selected
;**               into.  If the bitmap isn't selected into an hddc, this
;**               field will be NULL.  This field will have to change
;**               whenever a SaveDC/RestoreDC is performed if the
;**               hddc changes.
;**
;**               Should be NULL whenever bm_cSelect is zero.
;**
;** bm_cSelect    Number of times this bitmap is selected into a DC.
;**               A bitmap can be selected into multiple levels of a
;**               saved DC.  This count keeps us from considering the
;**               bitmap free if a ddc was saved and another bitmap
;**               selected into it.
;*/

BITMAP          struc
bm_sd           db      (size SURFACE) dup (?)
bm_hddc         dw      ?
bm_cSelect      dw      ?
BITMAP          ends



;/*
;**  basic attributes structure (ba_)
;** 
;**  I wanted to call this the basica structure!  The basic attributes are
;**  those attributes common to the five bundles (markers, lines, patterns,
;**  characters, and image data).  The following fields are contained in
;**  the structure:
;** 
;**  ba_clr        This is the foreground color as specified by the caller.
;**                It is stored as passed in so that we can rerealize as
;**                color table attributes change.  This value will always
;**                be used for color mapping unless BA_CLR_DEF is set, in
;**                which case the default color should be used.
;** 
;**  ba_clrBack    This is the background color as specified by the caller.
;**                It is stored as passed in so that we can rerealize as
;**                color table attributes change.  This value will always
;**                be used for color mapping unless BA_CLR_BACK_DEF is set,
;**                in which case the default color should be used.
;** 
;**  ba_ipc        This is the internal physical color representation of
;**                ba_clr.  All drawing primitives will reference this value
;**                instead of ba_clr.
;** 
;**  ba_ipcBack    This is the internal physical color representation of
;**                ba_clrBack.  All drawing primimitives will reference
;**                this value instead of ba_clrBack.
;** 
;**  ba_bmix       This is the foreground mix mode.  Mix modes will be
;**                mapped into ranges appropriate for each of the attribute
;**                bundles (e.g. text will have the passed mix mode mapped
;**                into a range of 0:2 (assuming it supports overwrite, XOR,
;**                and OR).
;** 
;**  ba_bkmix      This is the background mix mode.  Mix modes will be
;**                mapped into ranges appropriate for each of the attribute
;**                bundles (e.g. text will have the passed mix mode mapped
;**                into a range of 0:2 (assuming it supports overwrite, XOR,
;**                and OR).
;** 
;**  ba_fb         Flags as defined later.
;** 
;** 
;**  Flag values for ba_fb:
;** 
;**  BA_CLR_INV            1 if ba_ipc is not the correct representation
;**                          of ba_clr.
;**                        0 if ba_ipc is the correct representation of
;**                          ba_clr.
;** 
;**  BA_CLR_BACK_INV       1 if ba_ipcBack is not the correct representation
;**                          of ba_clrback.
;**                        0 if ba_ipcBack is the correct representation of
;**                          ba_clrback.
;** 
;**  BA_CLR_DEF            1 if the default color should be used instead of
;**                          ba_ipc
;**                        0 if ba_ipc is to be used
;** 
;**  BA_CLR_BACK_DEF       1 if the default color should be used instead of
;**                          ba_ipc_back
;**                        0 if ba_ipc_back is to be used
;** 
;**  BA_XFORM_CHANGE       1 if a transform change has occured since the
;**                          last time this flag was cleared.
;**                        0 if no transform change has occured since
;**                          the last time this flag was cleared
;** 
;**  BA_REREALIZE          1 if for some reason the attribute must be
;**                          realized.
;**                        0 if the attribute is valid.
;** 
;**                        This bit is included for optimizing performance.
;**                        Only this bit must be tested in the drawing
;**                        routines to see if some rerealization of the
;**                        attributes must be performed.
;*/

BASIC_ATTRS     struc
ba_clr          dd      ?
ba_clrBack      dd      ?
ba_ipc          db      SIZE_IPC dup (?)
ba_ipcBack      db      SIZE_IPC dup (?)
ba_bReserved    db      ?
ba_fb           db      ?
ba_bmix         db      ?
ba_bkmix        db      ?
BASIC_ATTRS     ends
                .errnz  (size BASIC_ATTRS) and 1

BA_CLR_INVALID  equ     10000000b       ;ba_fb
BA_CLR_BACK_INV equ     01000000b
BA_CLR_DEF      equ     00100000b
BA_CLR_BACK_DEF equ     00010000b
BA_XFORM_CHANGE equ     00001000b
BA_REREALIZE    equ     00000100b
BA_IS_OPAQUE    equ     00000001b
BA_IS_XPARENT   equ     00000000b


;/*
;** image_attributes (ia_)
;**
;** ia_ba         Basic attributes as defined above.
;*/

IMAGE_ATTRS     struc
ia_ba           db      (size BASIC_ATTRS) dup (?)
IMAGE_ATTRS     ends
                .errnz  (size IMAGE_ATTRS) and 1

IA_DSA_SAVE_LIM equ     size IMAGE_ATTRS ;Setting attributes error recovery


;/*
;**  About brushes (patterns)
;** 
;**  A brush contains whatever information is required to represent the
;**  current fill attributes.  There are two distinct parts of the brush:
;**  the color portion for color surfaces, and the mono portion for
;**  monochrome surfaces.  Each brush is stored ready for use in opaque
;**  mode (that is, the background color has already been placed into the
;**  bits to be used for the brush).
;** 
;**  Brushes can come from many sources.  Monochrome sources which can
;**  be used as patterns are codepoints within a font, base patterns,
;**  and monochrome bitmaps.  For fonts and bitmaps, only the first
;**  8x8 bits are used.  !!! Be sure and get lower left 8 pels !!!!
;** 
;**  When a brush comes from a monochrome source, the color portion of the
;**  brush is created from the foreground and background colors.  All pels
;**  of the brush which are 1 are converted to the foreground color.  All
;**  pels which are 0 are converted to the background color.  The brush
;**  colors will change as the current foreground/background colors change.
;**  For monochrome sources, the monochrome portion of the brush will also
;**  track the foreground/background colors as they change.
;** 
;**  The original monochrome source will be saved for use as a transparency
;**  mask.  When the background mode is set to transparent, only those pels
;**  of the brush which have a corresponding 1 bit in the transparency mask
;**  will be processed in the current foreground mix mode.  When the back-
;**  ground mode is opaque, pels of the brush which have a corresponding 1
;**  bit in the transparency mask will be drawn using the foreground mix.
;**  The other pels will be written in the background color. !!! we don't
;**  do it this way but that is the way the definition seems to be.!!!
;** 
;**  Color brushes can only come from one of our color bitmaps.  When a
;**  color bitmap is the source of a brush, the color portion of the brush
;**  doesn't track the foreground/background colors; the colors remain the
;**  same.  The transparency mask is generated from the color brush.  All
;**  pels of the color brush which match the background color will have
;**  their corresponding transparency mask bit set to 0.  All other bits
;**  in the transparency mask will be set to 1.  The transparency mask
;**  will track the current foreground/background colors.
;** 
;**  Once the transparency mask has been generated from the color source,
;**  the monochrome portion of the brush will be generated in the same
;**  manner as for monochrome sources; 1 bits in the transparency mask
;**  will be mapped to the foreground color and 0 bits will be mapped to
;**  the background color.
;** 
;**  It can be argued that there should be certain brushes which don't
;**  have any "background bits" (e.g. dithered brushes).  There is no
;**  problem with bitblt since none of its rops handle transparency.
;**  !!! which causes problems with image data !!!
;**  There could be problems with polygon filling - there is no way to
;**  turn off background filling.  If in transparent mode, some bits may
;**  not show, while in opaque mode they don't have the raster-op applied
;**  to them.  This indicates that there is a need for a class of "solid"
;**  patterns so we don't try to synthesize a transparency mask.
;*/


;/*
;** 
;**  pattern_attributes (pa_)
;** 
;**  pa_ba         Basic attributes as defined above.
;** 
;**  pa_pFont      Pointer to a font to use for patterns or a handle to
;**                the bitmap to use, as defined by the PA_BITMAP_SRC flag.
;** 
;**  pa_fs         Flags as defined for ca_fs.  Use of these flags allows
;**                us to use the character bundle code for getting the
;**                font
;** 
;**  pa_paus       Pointer to the code-point mapping array.  Used to map
;**                850 fonts into other fonts.
;** 
;**  pa_ch         Code point to use for the pattern definition.
;** 
;**  pa_fb         Flags for the pattern as defined below.
;** 
;**  pa_ptlOrg     Origin for the pattern in WORLD coordinates.
;** 
;**  pa_ptsOrg     Origin for the pattern in DEVICE coordinates.
;** 
;**  pa_cRcr       Current right rotation of the pattern.
;** 
;**                The brush is rotated in X by the sum of the DC origin
;**                and the transformed pa_ptlOrg.  Y rotation never occurs.
;**                Y rotation is performed by adding the contents of
;**                pa_ptsOrg.pts_y to the Y coordinate, then taking this
;**                mod 8 for the pattern scan to use.
;** 
;**  pa_cxFill     The number of bits at the right and top, respectively,
;**  pa_cyFill     of the color brush to fill with the background color.
;**                These allow a program to select a color bitmap of arbitrary
;**                size into the pattern bundle, by telling the brush
;**                realization code which bits to change when the background
;**                color changes.
;** 
;**  pa_idBrush    Reference count for this brush.
;** 
;**  pa_ipcFore    Current ipc of foreground bits in pa_abColor, pa_abMono.
;**  pa_ipcBack    Current ipc of foreground bits in pa_abColor, pa_abMono.
;** 
;**                These two colors are part of the brush caching scheme.
;**                If the new colors that the brush is to be created in
;**                match these colors, then we don't have to rerealize the
;**                bits which would force any hardware brush cache to be
;**                invalidated.
;** 
;**  pa_abColor    The actual bits making up the brush for color surface.
;** 
;**  pa_abMono     The actual bits making up the brush for a mono surface.
;** 
;**  pa_abMask     The bits making up the transparency mask
;** 
;**  Flag values for pa_fb:
;** 
;**  PA_COLOR_TRUTH        1 if the color portion of the pattern was the
;**                          original pattern.  The monochrome portion of
;**                          the pattern must be synthesized from the color
;**                          portion of the pattern using the current
;**                          pattern foreground/background colors.
;**                        0 if the monochrome portion of the pattern was
;**                          the original pattern (as is the case when
;**                          fonts are used for filling).  The color
;**                          portion of the pattern must be synthesized from
;**                          the mono pattern using the current foreground
;**                          and background colors.
;** 
;**  PA_BITMAP_SRC         1 if the source came from a bitmap.
;**                        0 if the source came from a font.
;** 
;**  PA_SINGLE_CLR         1 if the brush consists of all 1 or all 0 in
;**                          each of its planes
;**                        0 if the brush is arbitrary
;** 
;**  PA_GRAY               1 if a gray brush (any given bit is the same
;**                          in all planes).
;**                        0 if the brush is arbitrary
;** 
;**  PA_HOLLOW             1 if the code point comes from the base symbol
;**                          set and is PATSYM_BLANK or PATSYM_NOSHADING
;**                        0 if the code point comes from a use symbol set,
;**                          or isn't PATSYM_BLANK or PATSYM_NOSHADING.
;*/
 

SIZE_PATTERN    equ     8               ;Patterns are 8 bits by 8 bytes


PATTERN_ATTRS   struc
pa_ba           db      (size BASIC_ATTRS) dup (?)
pa_pFont        dd      ?
pa_paus         dd      ?
pa_fs           dw      ?
pa_ch           db      ?
pa_fb           db      ?
pa_ptlOrg       db      (size POINTL) dup (?)
pa_ptsOrg       db      (size POINTS) dup (?)
pa_cRcr         db      ?
pa_cxFill       db      ?
pa_cyFill       db      ?
                db      ?
pa_idBrush      dd      ?
pa_ipcFore      db      SIZE_IPC dup (?)
pa_ipcBack      db      SIZE_IPC dup (?)
pa_abColor      db      (BITS_PEL * SIZE_PATTERN) dup (?)
pa_abMono       db      SIZE_PATTERN dup (?)
pa_abMask       db      SIZE_PATTERN dup (?)
PATTERN_ATTRS   ends
                .errnz  (size PATTERN_ATTRS) and 1

PA_DSA_SAVE_LIM equ     pa_abColor      ;For SetAttrs error recovery


PA_SINGLE_CLR   equ     10000000b       ;pa_fb
PA_GRAY         equ     01000000b
PA_HOLLOW       equ     00100000b
PA_COLOR_TRUTH  equ     00010000b
PA_BITMAP_SRC   equ     00001000b
;**             equ     00000100b
;**             equ     00000010b
;**             equ     00000001b



;/*
;**  character_attributes (ca_)
;** 
;**  ca_ba         Basic attributes as defined above.
;** 
;**  ca_pFont      Pointer to the font to use.
;** 
;**  ca_fs         Flags as defined below.
;** 
;**  ca_paus       Pointer to the code-point mapping array.  Used to map
;**                850 fonts into other fonts.
;** 
;**  ca_idCodePage Current code page.  Affects tonly the default font
;** 
;**  ca_usTextAlign Text alignment attribute from dc.
;** 
;**  ca_fxExtra    Character extra in fixed WORLD coordinates.
;** 
;**  ca_fxBreakExtra Character break extra in fixed WORLD coordinates.
;** 
;** 
;**  Flag values for ca_fs.  Note that these flags are also used for
;**  markers and patterns where appropriate:
;** 
;**  CA_USER_FONT          1 if user supplied font is in use
;**                        0 if default font is in use
;** 
;**  CA_VECTOR             1 if current font is vector or outline
;**                        0 if current font is a raster font
;** 
;**  CA_PREC_NOT_1         1 if precision is 2 or 3
;**                        0 if precision is 1
;** 
;**  CA_CHANGED            1 if the font or font attributes have changed
;**                        0 if the font or font attributes have not changed
;** 
;**                        For markers and patterns, this bit will also
;**                        be set when the code point changes.
;** 
;**  CA_MUST_MAP           1 if the characters are to be mapped via the
;**                          code-page mapping array ca_paus
;**                        0 if no mapping is required
;** 
;**  CA_CHAR_EXTRA         1 if ca_cExtraPels contains the count of extra
;**                          pels needed per character
;**                        0 if no extra pels per character are needed
;** 
;**  CA_ABC_SPACE          1 if the font is an ABC spaced font.
;**                        0 if the font is proportional or fixed pitch.
;** 
;**                        This flag takes precedence over CA_FIXED_PITCH
;**                        and CA_WIDTH_IS_8.
;** 
;**  CA_FIXED_PITCH        1 if the font is a fixed pitch font.
;**                        0 if the font is proportional.
;** 
;**  CA_WIDTH_IS_8         1 if the font is 8 pels wide.  Only valid if
;**                          CA_FIXED_PITCH is set.
;**                        0 if the font isn't 8 pels wide.
;** 
;**  CA_STRIKEOUT          Text simulation flag
;**  CA_UNDERSCORE         Text simulation flag
;**  CA_ITALIC             Text simulation flag
;**  CA_BOLD               Text simulation flag
;** 
;**  CA_DIRECTION          xx direction as specified by CHDIRN_*, -1
;*/


CHAR_ATTRS      struc
ca_ba           db      (size BASIC_ATTRS) dup (?)
ca_pFont        dd      ?
ca_paus         dd      ?
ca_fs           dw      ?
ca_cExtraPels   dw      ?
ca_idCodePage   dw      ?
ca_usTextAlign  dw      ?
ca_fxExtra      dd      ?
ca_fxBreakExtra dd      ?
CHAR_ATTRS      ends
                .errnz  (size CHAR_ATTRS) and 1

CA_DSA_SAVE_LIM equ     size CHAR_ATTRS


CA_USER_FONT    equ     8000h           ;ca_fs
CA_VECTOR       equ     4000h
CA_PREC_NOT_1   equ     2000h
;**             equ     1000h
CA_CHANGED      equ     0800h
CA_MUST_MAP     equ     0400h
CA_CHAR_EXTRA   equ     0200h
CA_ABC_SPACE    equ     0100h
CA_FIXED_PITCH  equ     0080h
CA_WIDTH_IS_8   equ     0040h
CA_STRIKEOUT    equ     0020h
CA_UNDERSCORE   equ     0010h
CA_ITALIC       equ     0008h
CA_BOLD         equ     0004h
CA_DIRECTION    equ     0003h                   ;Note 00000011b

;!!! these will be defined somday in pmddi.  until then, define them
;!!! here.  They are passed to the driver in cdef_fFlags

CDEF_BOLD       equ     0002h                   
CDEF_ITALIC     equ     0004h                   
CDEF_UNDERSCORE equ     0008h                   
CDEF_STRIKEOUT  equ     0010h                   


;/*
;** marker_attributes (ma_)
;**
;** Markers are implemented using the character routines.  The marker
;** structure must contain enough information that it can be passed to
;** the character functions as if a normal character output operation
;** is to be performed.
;**
;** ma_ba         Basic attributes as defined above.
;**
;** ma_pFont      Pointer to the font to use.
;**
;** ma_fs         Flags as defined for ca_fs.  Use of these flags allow
;**               us to skip many of the character attribute fields.
;**               when using the character routine to draw the markers.
;**
;** ma_paus       Pointer to the code-point mapping array.  Used to map
;**               850 fonts into other fonts.
;**
;** ma_ch         Code point to use for the marker
;**
;** ma_fb         Flags as defined below.
;**
;** Flag values for ma_fb:
;*/


MARKER_ATTRS    struc
ma_ba           db      (size BASIC_ATTRS) dup (?)
ma_pFont        dd      ?
ma_paus         dd      ?
ma_fs           dw      ?
ma_ch           db      ?
ma_fb           db      ?
MARKER_ATTRS    ends
                .errnz  (size MARKER_ATTRS) and 1

MA_DSA_SAVE_LIM equ     size MARKER_ATTRS


;**             equ     10000000b       ;ma_fb  (see ca_fs)
;**             equ     01000000b
;**             equ     00100000b
;**             equ     00010000b
;**             equ     00001000b
;**             equ     00000100b
;**             equ     00000010b
;**             equ     00000001b



;/*
;** line_attributes (la_)
;**
;** la_ba         Basic attributes as defined above.
;**
;** la_usType     Line style type.  Will be zero based.  API calls
;**               are 1 based.
;**
;** la_bError     The line style error term.
;**
;** la_bMask      The line style mask position.
;**
;** la_bStepX     The style step in the x direction.
;**
;** la_bStepY     The style step in the y direction.
;**
;** la_sWidth     The line width
;**
;*/


LINE_ATTRS      struc
la_ba           db      (size BASIC_ATTRS) dup (?)
la_usType       dw      ?
la_bError       db      ?
la_bMask        db      ?
la_bStepX       db      ?
la_bStepY       db      ?
la_sWidth       dw      ?
LINE_ATTRS      ends
                .errnz  (size LINE_ATTRS) and 1

LA_DSA_SAVE_LIM equ     size LINE_ATTRS


;/*
;**  ddc - device's device context (or state block)
;** 
;**  The following field are "above the line" in that RestoreDC/ResetDC
;**  will not alter them.
;** 
;**  ddc_usId              Identifier of a ddc.  Must be DDC_IDENT.
;** 
;**  ddc_npsd              Near pointer to the surface definition.  This is
;**                        also the driver's handle to the bitmap currently
;**                        selected into this ddc if it is a memory ddc.
;**                        It will be INVALID_ADDRESS when no bitmap is
;**                        selected into a memory ddc.
;** 
;**  ddc_hdc               The Engine's handle to this ddc as passed to
;**                        the Enable function.  Must match the hdc passed
;**                        as a parameter to the current function.
;** 
;**  ddc_ptsOrg            DC origin.  All DEVICE coordinates are offset
;**                        by this amount to get SCREEN coordinates.  All
;**                        SCREEN coordinates stored in the ddc must be
;**                        adjusted by the delta of the old and new DC
;**                        origin when it changes.
;** 
;**  ddc_crcsClip          The number of rectangles in the visible region
;**                        for this ddc.  If this number is 0, then nothing
;**                        is visible for this DDC.
;** 
;**  ddc_arcsClip          An array of clipping rectangles used to cache
;**                        small clipping regions.  If ddc_crcsClip is
;**                        less than NUM_CLIP_RECTS, then all rectangles
;**                        are contained here and no calls to the Engine
;**                        are required.
;** 
;**  ddc_fb                Flags as defined later.
;** 
;**  ddc_fbAbove           Flags as defined later.
;** 
;**  The following field are "below the line" in that RestoreDC/ResetDC
;**  will alter them.
;** 
;**  ddc_ia                Image     attributes as defined above
;** 
;**  ddc_pa                Pattern   attributes as defined above
;** 
;**  ddc_la                Line      attributes as defined above
;** 
;**  ddc_ca                Character attributes as defined above
;** 
;**  ddc_ma                Marker    attributes as defined above
;** 
;**  ddc_fbBelow           Flags as defined later.
;** 
;**  ddc_fbClrTbl          Flags as defined later.
;** 
;**  ddc_iSysClr           Index of current system colors.  Incremented
;**                        each time a system color is changed.
;** 
;**  ddc_ptlWorldPos       Current position in WORLD coordinates.  Will
;**                        always be valid.
;** 
;**  ddc_ptsCurPos         Current position in SCREEN coordinates.  Will
;**                        always be valid.
;** 
;**  ddc_npddcPrev         Pointer to a previously saved version of the ddc.
;**                        Will be INVALID_ADDRESS if no previous version of
;**                        the ddc exists.
;** 
;**  ddc_cLevel            The ddc save level.  The first level is 1.
;** 
;**  ddc_pClrTbl           Address of the color table to use for mapping
;**                        API colors to internal physical colors (IPCs).
;**                        NOTE: This pointer is ALWAYS valid.  It points
;**                        to either a user's color table, if one is selected,
;**                        or the default table.  It points to the default
;**                        table even when we are in RGB mode.
;** 
;**  ddc_rcsGpiBound       Rectangle for GPI bounds accumulation.  It is
;**                        accumulated in SCREEN coordinates when the
;**                        COM_BOUNDS command is set.
;** 
;**  ddc_rcsUsrBound       Rectangle for Window manager bounds accumulation.
;**                        Accumulated in SCREEN coordinates when the
;**                        COM_ALT_BOUNDS command is set.
;** 
;**  ddc_rclPick           Pick (correlation) rectangle in PAGE coordinates.
;**                        Only display drivers deal with correlation, so
;**                        this rectangle MUST be maintained by the driver
;**                        in PAGE coordinates so that it can be returned
;**                        without any round-off error.  The engine will not
;**                        keep a copy of this rectangle.
;** 
;**  ddc_rcsCorr           Correlation rectangle in DEVICE coordinates.
;**                        This form of the correlation rectangle is used by
;**                        the actual drawing primitives.  Correlation must
;**                        be performed against primitives clipped to the
;**                        actual visible region.  This will require the
;**                        lowest level routines to perform the correlation
;**                        (since they get each rectangle which is visible).
;** 
;**  ifdef PALMGR
;**  ddc_npdevpal          Pointer to palette associated with ddc.
;**                        (will point to the default palette if none created)
;**  endif
;** 
;**  Flag values for ddc_fb:
;** 
;**  DDC_DEVICE            1 The surface is the physical display
;**                        0 ddc surface is a memory bitmap
;** 
;**                          This bit will match the bit in the attached
;**                          surface definition.
;** 
;**  DDC_VISIBLE           1 if some portion of the writing surface is
;**                          visible.
;**                        0 if no portion of the writing surface is
;**                          visible.
;** 
;**                          This flag is a combination of the DDC_PRESENT
;**                          flag, the SD_NONNULL flag, and the number of
;**                          rectangles in the current visible clip region.
;** 
;**                          When there is a valid writing surface and some
;**                          part of the surface is visible, this flag will
;**                          be set.  It can then be used as a test mask
;**                          against the COM_DRAW bit to see drawing must
;**                          occur.
;** 
;**  DDC_CLIP_NOTIFY       1 NotifyClipChange has been received.
;**                        0 NotifyClipChange has not been received.
;** 
;**                          This flag is cleared whenever a surface is
;**                          selected into a ddc, or on a CreateDC call.
;**                          This will be used for a FIREWALL which makes
;**                          sure that there is a clipping region selected
;**                          into the ddc.
;** 
;**  DDC_IDENT_XFORM       1 No transforming is needed.  Only translation by
;**                          the DC origin is needed.
;**                        0 Arbitrary transformation needed.
;** 
;**  DDC_CORR_INV          1 rcsCorr is invalid due to transform or DC origin
;**                          change.  Must transform rclPick to get new rcsCorr
;**                        0 rcsCorr is correct.
;** 
;**  DDC_SSB_CALL          1 SSB calling bitblt.  Allow blting from off-
;**                          screen memory.
;**                        0 Arbitrary call.  Clip to ddc_sd.sd_cy.
;** 
;**  DDC_PRESENT           1 if a  writing surface is selected into the ddc.
;**                        0 if no writing surface is selected into the ddc.
;** 
;**                          For device DCs and ICs, this flag will always
;**                          be 1.  For memory bitmaps, this flag will be
;**                          1 whenever a bitmap is selected into the ddc,
;**                          and 0 whenever no bitmap is selected (it will
;**                          mirror the state of ddc_npsd).
;** 
;**                          Any output call made while this bit is 0 will
;**                          be an error.
;** 
;**  DDC_FIRST_PEL         1 A SetCurrentPosition was the last "drawing"
;**                          function called.
;**                        0 Any line primitive call resets this flag.
;** 
;**                          This flag is used to determine whether the first
;**                          pel of a fillet or line is to be drawn.  Only for
;**                          the first drawing primitive after a
;**                          SetCurrentPosition is the first pel drawn.
;** 
;** 
;**  Flag values for ddc_fbAbove:
;** 
;**  DDC_INFO_DC           1 This is an info context
;**                        0 Normal DC
;** 
;**  DDC_DIRTY_VISRGN      1 The vis region has changed and pmwin should be
;**                            called to update it before using the ddc.
;**                        0 The vis region is correct.
;** 
;**  Flag values for ddc_fbClrTbl:
;** 
;**  DDC_REALIZED          1 RealizeColorTable in effect
;**                        0 Default palette/DACs in effect
;** 
;**  DDC_REALIZABLE        1 Logical color table may be realized
;**                        0 Logical color table may not be realized
;** 
;**  DDC_CLR_0_USERS       1 Color 0 in logical color table defined by user
;**                        0 Color 0 in logical color table is the default
;** 
;**  DDC_CLR_7_USERS       1 Color 7 in logical color table defined by user
;**                        0 Color 7 in logical color table is the default
;** 
;**  DDC_RGB_MODE          1 The ddc is in RGB mode
;**                        0 The ddc is in color table mode
;** 
;**  DDC_LOG_CLR_TBL       1 A user-defined color table has been selected
;**                        0 The default color table is in use
;** 
;**  DDC_DITHER            1 Dithering allowed for fill patterns
;**                        0 Dithering is not allowed for fill patterns
;** 
;**      NOTE:  DDC_RGB_MODE and DDC_LOG_CLR_TBL are mutually exclusive.
;** 
;** 
;**  Flag values for ddc_fbBelow:
;** 
;**  DDC_DIRTY_ATTRS       1 Attribute have changed which will require extra
;**                          copying in ResetDC.
;**                        0 No attributes have changed.
;** 
;**  DDC_PALETTE           1 The field ddc_npdevpal points to a custom palette.
;**                        0 The field ddc_npdevpal points to a default palette.
;*/

DDC             struc
ddc_usId        dw      ?
ddc_npsd        dw      ?
ddc_hdc         dd      ?
ddc_crcsClip    dw      ?
ddc_fb          db      ?
ddc_fbAbove     db      ?
ddc_prddc       dd      ?

;/*
;**----------- reset_ddc_state initializes only below -----------------
;*/

ddc_ia          db      (size IMAGE_ATTRS)   dup (?)
ddc_pa          db      (size PATTERN_ATTRS) dup (?)
ddc_la          db      (size LINE_ATTRS)    dup (?)
ddc_ca          db      (size CHAR_ATTRS)    dup (?)
ddc_ma          db      (size MARKER_ATTRS)  dup (?)
ddc_fbBelow     db      ?
ddc_fbClrTbl    db      ?
ddc_iSysClr     dw      ?
ddc_npddcPrev   dw      ?
ddc_cLevel      dw      ?
ddc_pClrTbl     dd      ?
ifdef PALMGR
ddc_npdevpal    dw      ?
endif
DDC             ends
                .errnz  (size DDC) and 1

RDDC            struc
rddc_usId       dw      ?
rddc_npddc      dw      ?
rddc_ptsOrg     db      (size POINTS) dup (?)
rddc_arcsClip   db      (NUM_CLIP_RECTS * (size RECTS)) dup (?)
rddc_rcsUsrBound db     (size RECTS) dup (?)

;/*
;**----------- reset_rddc_state initializes only below -----------------
;*/

rddc_ptlWorldPos db     (size POINTL) dup (?)
rddc_ptsCurPos   db     (size POINTS) dup (?)
rddc_rclGpiBound db     (size RECTL) dup (?)
rddc_rclPick     db     (size RECTL) dup (?)
rddc_rcsCorr     db     (size RECTS) dup (?)
RDDC             ends
                .errnz  (size RDDC) and 3

                .errnz  ddc_usId-sd_usId
                .errnz  ddc_npsd-sd_npsd

RESET_DDC_BUNDLES       equ     ddc_ia
RESET_DDC_POST_BUNDLES  equ     ddc_fbBelow

RESET_RDDC_START        equ     rddc_ptlWorldPos


DDC_DEVICE      equ     10000000b       ;ddc_fb
DDC_CLIP_NOTIFY equ     01000000b
DDC_FIRST_PEL   equ     00100000b
DDC_UNIT_XFORM  equ     00010000b
DDC_CORR_INV    equ     00001000b
DDC_SSB_CALL    equ     00000100b
DDC_PRESENT     equ     00000010b
DDC_VISIBLE     equ     00000001b

;**             equ     10000000b       ;ddc_fbAbove
;**             equ     01000000b
;**             equ     00100000b
;**             equ     00010000b
;**             equ     00001000b
;**             equ     00000100b
DDC_DIRTY_VISRGN equ    00000010b
DDC_INFO_DC     equ     00000001b

DDC_DIRTY_ATTRS equ     10000000b       ;ddc_fbBelow
DDC_PALETTE     equ     01000000b
;**             equ     00100000b
;**             equ     00010000b
;**             equ     00001000b
;**             equ     00000100b
;**             equ     00000010b
;**             equ     00000001b

;**             equ     10000000b       ;ddc_fbClrTbl
DDC_REALIZED    equ     01000000b
DDC_REALIZABLE  equ     00100000b
DDC_USER_CLR_0  equ     00010000b
DDC_USER_CLR_7  equ     00001000b
DDC_RGB_MODE    equ     00000100b
DDC_LOG_CLR_TBL equ     00000010b
DDC_DITHER      equ     00000001b
endif


;/*
;** Various Display identifiers returned from VioGetConfig
;*/

DISPLAY_8503    equ     3       ; Mono
DISPLAY_8514    equ     9       ; 
DISPLAY_PLASMA  equ    10       ; Mono
DISPLAY_8515    equ    12       ; Dallas

VGA_EXPRESSWAY  equ     0       ; VGA adapter is an ExpressWay card (bVGAtype)

SFONT_RASTER_8515   equ 102     ; Dallas System font

;/***************************************************************************
;*
;* MACRO NAME    = save_error_code
;*
;* DESCRIPTION   = Calls the appropriate routine to save the error code.
;*
;* INPUT         = AX = error code
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
 
ifndef SAVE_THAT_ERROR_DEFINED
        externFP save_that_error
endif

save_error_code macro
        call    save_that_error
endm

;/***************************************************************************
;*
;* MACRO NAME    = save_warning_code
;*
;* DESCRIPTION   = Calls the appropriate routine to save the warning code.
;*
;* INPUT         = AX = error code
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


ifndef SAVE_THAT_WARNING_DEFINED
        externFP save_that_warning
endif

save_warning_code       macro
        call    save_that_warning
endm

ifndef SAVE_THAT_UNRECOVERABLE_DEFINED
        externFP save_that_unrecoverable_error
endif

save_unrecoverable_code macro
        call    save_that_unrecoverable_error
endm


;/***************************************************************************
;*
;* MACRO NAME    = out16
;*
;* DESCRIPTION   = 
;*
;*       out16 is a macro used wherever any 16-bit output is performed.
;*       The macro is intended to serve as documentation for those machines
;*       which do not perform 16-bit outputs correctly (where correctly is
;*       defined as the way the IBM AT does it).
;*
;*       usage
;*
;*           out16   d,a
;*
;*       where
;*
;*           d   -   I/O address register. Included as documentation
;*                   only.  Must always be DX (lower case).
;*
;*           a   -   Register to output.  Included as documentation
;*                   only.  Must always be AX (lower case).
;*
;*                 Registers Destroyed:
;*                       FLAGS
;*                 Registers Preserved:
;*                       AX,BX,CX,DX,SI,DI,BP,DS,ES
;*
;* INPUT         = AX      = data to output
;*                 DX      = I/O port address
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ifndef  IO8                             ;;If normal 16 bit outputs
  out16   equ     out
else                                    ;;If 8-bit outputs
  out16 macro d,a
        ifdif <a>,<ax>
        %out out16 - invalid register, must be ax
        .err
        endif
        ifdif   <d>,<dx>
        %out    out16 - invalid register, must be dx
        .err
        endif
        ifdif <is>,<cli>                ;;  If interrupts not off
        cli                             ;;    then turn them off
        endif                           ;;
        out     dx,al                   ;;  Output LSB portion
        inc     dx                      ;;  --> next address
        xchg    al,ah                   ;;  Get MSB of output value
        out     dx,al                   ;;  Output MSB portion
        ifdif <ie>,<cli>                ;;  If not explicitly told to leave
        sti                             ;;    interrupts off, turn them on
        endif                           ;;
        ifdif <rd>,<dont_save_DL>       ;;  If not explicitly told to trash DX,
        dec     dx                      ;;    restore it.
        xchg    al,ah
        endif
        endm
endif



;/***************************************************************************
;*
;* MACRO NAME    = odd
;*
;* DESCRIPTION   = odd   --- macro for odd alignment, counterpart for masm's "even".
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

odd     macro
        ife (offset $) AND 1
        nop
        endif
        endm

;/***************************************************************************
;*
;* MACRO NAME    = ret_near
;*
;* DESCRIPTION   = ret_near --- macro for generating a near return instruction
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ret_near        macro
        db      0C3h                    ;Near return, no parameters popped
        endm

;/***************************************************************************
;*
;* MACRO NAME    = ret_far
;*
;* DESCRIPTION   = ret_far --- macro for generating a far return instruction
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ret_far         macro
        db      0CBh                    ;Far return, no parameters popped
        endm

;/***************************************************************************
;*
;* MACRO NAME    = pushem  
;*                 popem   
;*
;* DESCRIPTION   = Allows giving a list of registers to push/pop on a single line.
;*                 Also allows easy verificaton that pushes and pops are balanced
;*                 because arguements are given in the same order:
;*
;*                       pushem  ax,bx,cx   goes with
;*                       popem   ax,bx,cx
;*
;* INPUT         = registers to push/pop
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

pushem  macro   r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
        irp     x,<r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12>
        ifnb    <x>
        push    x
        endif
        endm
        endm

popem   macro   r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
        irp     x,<r12,r11,r10,rF,rE,rD,rC,rB,rA,r9,r8,r7,r6,r5,r4,r3,r2,r1>
        ifnb    <x>
        pop     x
        endif
        endm
        endm


;/***************************************************************************
;*
;* MACRO NAME    = abs_ax  
;*
;* DESCRIPTION   = takes absolute value of AX
;*
;*                 Registers Destroyed:
;*                       DX,FLAGS
;*                 Registers Preserved:
;*                       BX,CX,SI,DI,DS,ES,BP
;*
;* INPUT         = AX      = integer
;*
;* OUTPUT        = AX      = abs(AX) 
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

abs_ax  macro
        cwd
        xor     ax,dx
        sub     ax,dx
        endm


;/***************************************************************************
;*
;* MACRO NAME    = usmin_ax
;*
;* DESCRIPTION   = returns unsigned min of AX and REG/MEM
;*
;*                 Registers Destroyed:
;*                       FLAGS         
;*                 Registers Preserved:
;*                       BX,CX,DX,SI,DI,DS,ES,BP 
;*
;* INPUT         = AX      = unsigned integer 
;*                 REG/MEM = unsigned integer 
;* OUTPUT        = AX      = min(AX,REG/MEM)  
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

usmin_ax        macro   REG
        local   got_it
        cmp     ax,REG
        jb      got_it
        mov     ax,REG
got_it:
        endm


;/***************************************************************************
;*
;* MACRO NAME    = usmax_ax
;*
;* DESCRIPTION   = returns unsigned max of AX and REG/MEM
;*
;*                 Registers Destroyed:
;*                       FLAGS
;*                 Registers Preserved:
;*                       BX,CX,DX,SI,DI,DS,ES,BP
;*
;* INPUT         = AX      = unsigned integer 
;*                 REG/MEM = unsigned integer 
;* OUTPUT        = AX      = max(AX,REG/MEM)
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

usmax_ax        macro   REG
        local   got_it
        cmp     ax,REG
        ja      got_it
        mov     ax,REG
got_it:
        endm


;/***************************************************************************
;*
;* MACRO NAME    = smin_ax
;*
;* DESCRIPTION   = returns signed min of AX and REG/MEM
;*
;*                 Registers Destroyed:
;*                       FLAGS
;*                 Registers Preserved:
;*                       BX,CX,DX,SI,DI,DS,ES,BP
;*
;* INPUT         = AX      = signed integer 
;*                 REG/MEM = signed integer 
;* OUTPUT        = AX      = min(AX,REG/MEM)  
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

smin_ax macro   REG
        local   got_it
        cmp     ax,REG
        jl      got_it
        mov     ax,REG
got_it:
        endm


;/***************************************************************************
;*
;* MACRO NAME    = smax_ax
;*
;* DESCRIPTION   = returns signed max of AX and REG/MEM
;*
;*                 Registers Destroyed:
;*                       FLAGS                                             
;*                 Registers Preserved:                                    
;*                       BX,CX,DX,SI,DI,DS,ES,BP                           
;*
;* INPUT         = AX      = signed integer 
;*                 REG/MEM = signed integer 
;* OUTPUT        = AX      = max(AX,REG/MEM)
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

smax_ax macro   REG
        local   got_it
        cmp     ax,REG
        jg      got_it
        mov     ax,REG
got_it:
        endm


;/***************************************************************************
;*
;* MACRO NAME    = jmpcx         
;*                 jmpcx  stop   
;*
;* DESCRIPTION   = 
;*
;*          jmpcx is used in the generation of fall through chains.  It
;*          generates the opcode used to swallow the next two bytes of object
;*          code (cmp ax,immediate word), and performs error checking to
;*          ensure that only two bytes of object code exist between any
;*          use of jmpcx.
;*
;*          The chain is terminated by use of an optional parameter to jmpcx.
;*          If this optional field is non-blank, the chain is terminated.
;*
;*          WARNING:  jmpcx destroys CX!
;*
;*          Registers Destroyed:
;*                FLAGS or CL or CX
;*          Registers Preserved:
;*                AX,BX,CX,DX,SI,DI,BP,DS,ES
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

??ji    =       0                       ;;Initial index value

jmpcl   macro e                         ;;mov cl,<next byte>
jn %??ji,%(??ji+1),0B1h,+1,e            ;;Set next label
endm

jmpcx   macro e                         ;;mov cx,<next word>
jn %??ji,%(??ji+1),0B9h,+2,e            ;;Set next label
endm

jmpnext macro e                         ;;cmp ax,<next two bytes>
jn %??ji,%(??ji+1),03Dh,+2,e            ;;Set next label
endm

jn macro i,j,c,d,e
.sall
??ji&i:
.xall
ifb <e>                                 ;;If not the end of the chain
        db      c
errn$   ??ji&j,d                        ;;next lable must be two bytes away
endif
??ji=j                                  ;;increment counter
endm


;/***************************************************************************
;*
;* MACRO NAME    = missing_code
;*
;* DESCRIPTION   = 
;*
;*          missing_code is a macro which will display a message on the screen
;*          at assembly time.  It is used to flag code sequences which have not
;*          been completed.
;*
;*          usage
;*
;*                missing_code    <text>
;*
;*                 Registers Destroyed:
;*                       NONE
;*                 Registers Preserved:                                    
;*                       ALL
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

missing_code    macro   x
        if1
        ??_out  <&! Missing Code &!  x>
        endif
        endm

;/***************************************************************************                   
;*                                                                                              
;* MACRO NAME    = check                                                                        
;*                                                                                              
;* DESCRIPTION   =                                                                              
;*                                                                                              
;*           checks whether the given function has the correct parameters                       
;*                                                                                              
;*          usage:                                                                              
;*                                                                                              
;*           check  FunctionName,<parm1,parm2,parm3>                                            
;*                                                                                              
;* INPUT         = as per above                                                                 
;* OUTPUT        = as per above                                                                 
;*                                                                                              
;* RETURN-NORMAL = NONE                                                                         
;* RETURN-ERROR  = NONE                                                                         
;*                                                                                              
;**************************************************************************/                    

check   macro   funcname,parms
        inner_check     %prm_&funcname,<parms>
        endm

inner_check macro string1,string2
        .errdif <string1>,<string2>
        endm

;/*
;** The following macros pertain to firewall code
;*/


ifdef FIREWALLS
        externFP perform_rip
SEIOptions = SEI_REGISTERS+SEI_STACKTRACE
endif


;/***************************************************************************
;*
;* MACRO NAME    = rip
;*
;* DESCRIPTION   = 
;*
;*         rip is the macro which invokes the error processor to perform the
;*         call to WinSetErrorInfo to abort the process.
;*
;*      Usage:
;*            rip     arg1,arg2
;*      Where:
;*            if arg1 == text, arg2 contains the text of error message
;*            otherwise, arg1 is the name of the message it will be referenced by
;*
;* INPUT         = as per above
;* OUTPUT        = as per above
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

rip     macro   arg1,arg2
        local   msg_offset
ifdef FIREWALLS
ifidni <arg1>,<text>
.286P
_FIRESEG        segment WORD PUBLIC 'code'
msg_offset      equ     this byte
        db      '&arg2',0
_FIRESEG        ends
        CPUMode reset
        cCall   perform_rip,<OFFSET msg_offset>
else
        ifnb    <arg2>
                .err
        endif
.286P
_FIRESEG        segment WORD PUBLIC 'code'
        extrn   msg_&arg1:byte
_FIRESEG        ends
        CPUMode reset
        cCall   perform_rip,<OFFSET msg_&arg1>
endif
endif
endm


data_check      macro   reg
        local   all_cool
ifdef FIREWALLS
        cmp     reg:[data_ident],DS_IDENT
        jz      all_cool
        rip     BadDataSegment
all_cool:
endif
        endm

;/***************************************************************************
;*
;* MACRO NAME    = puts
;*
;* DESCRIPTION   = If FIREWALLS is nonzero, outputs a string to the        
;*                 debugging output screen.
;*
;*      Usage:
;*            rip     arg1,arg2
;*      Where:
;*            if arg1 == text, arg2 contains the text of error message
;*            otherwise, arg1 is the name of the message it will be referenced by
;*
;*            Registers Preserved:
;*                  all
;*            Registers Destroyed:
;*                  none
;*
;* INPUT         = String   = string to output
;*
;*                 Example:
;*                       puts    <*** StretchBlt: creating shadow bitmap>
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

puts    macro   string
        local   message

ifdef FIREWALLS
ifndef DebugOutput
        externFP    DebugOutput
endif

_FIRESEG        segment WORD PUBLIC 'code'
message db      "&string",13,10,0
_FIRESEG        ends

        push    ax
        push    bx
        push    cx
        push    dx
        farPtr  lpMsg,_FIRESEG,<OFFSET message>
        cCall   DebugOutput,<lpMsg>
        pop     dx
        pop     cx
        pop     bx
        pop     ax
endif   ;FIREWALLS
        endm

;/***************************************************************************
;*
;* MACRO NAME    = ddc?
;*
;* DESCRIPTION   = ddc validation. 
;*
;*       A call is generated to the subroutine which performes a massive
;*       FIREWALL check of the given ddc.  Parameters are allowed which
;*       control how much checking is actually performed.
;*
;*       Usage:
;*             ddc?    hddc,<cmds>
;*
;*       Where:
;*             hddc    The handle to the ddc.  If it isn't a register, it is
;*                     assumed to be a dword parameter on the frame.  If it
;*                     is a register, HDDC_IDENT will be pushed on the stack
;*                     along with the register to fake an hddc.
;*
;*             cmds    Commands, which control extra ddc checking:
;*
;*                     MEMORYDDC  Must be a memory ddc
;*
;*                     LEVELS     Validate all levels of the ddc.  If not
;*                                given, validation is performed only on
;*                                the topmost level.
;*
;*                     SURFACE    The surface selected into the ddc is
;*                                checked.
;*
;*       Destroys:
;*             30 bytes or so of stack space
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ifdef FIREWALLS
  ifndef DDC_VALIDATE_DEFINED
    externFP ddc_validate
  endif
  .xcref
  .xcref ddc?_flags,DDC?MEMORYDDC,DDC?SURFACE,DDC?LEVELS
  DDC?MEMORYDDC equ     00000001b
  DDC?SURFACE   equ     00000010b
  DDC?LEVELS    equ     00000100b
  ddc?_flags    =       0
  .cref
endif

ddc?    macro   thehddc,commands
  ifdef FIREWALLS
    ddc?_flags=0
    ifnb <commands>
      irp x,<commands>
        ddc?_flags = ddc?_flags or DDC?&&x
      endm
    endif
    if (.type thehddc) eq 30h
        farPtr  ??thehddc,<HDDC_IDENT>,<thehddc>
        cCall   ddc_validate,<??thehddc,ddc?_flags>
    else
        cCall   ddc_validate,<thehddc,ddc?_flags>
    endif
  endif
endm

rddc?   macro   seg,reg
  local here
  ifdef FIREWALLS
    cmp     seg:[reg].rddc_usId,RDDC_IDENT
    jz      short here
    rip     text,<Bad RDDC>
    here:
  endif
endm

;/***************************************************************************
;*
;* MACRO NAME    = fw_zero
;*
;* DESCRIPTION   = 
;*
;*       fw_zero is a firewall macro which zeros the registers in the given
;*       list.  It doesn't try to be smart about it.
;*
;*       Usage:
;*             fw_zero <list>
;*       Where:
;*             list - the register to be zeroed
;*
;*       Restrictions:
;*             16-bit and 8-bit registers cannot be mixed in the same fw_zero.
;*             This is because of the optimization of moving between registers
;*             when possible.
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

fw_zero macro   list
  ifdef FIREWALLS
    .xcref
    .xcref ?fw_zero
    .cref
    ?fw_zero=1
    irp x,<list>
      ifdifi <x>,<es>
        ifdifi <x>,<ds>
        ?fw_zero=0
        mov     x,0                     ;;Don't alter 'Z'
        irp y,<list>
          ifdifi <y>,<x>
        mov     y,x
          endif
        endm
        exitm
        endif
      endif
    endm
    if ?fw_zero
      irp x,<list>
        push    0
        pop     x
      endm
    endif
  endif
endm


;/***************************************************************************
;*
;* MACRO NAME    = errcode
;*
;* DESCRIPTION   = 
;*
;*      errcode is a simple macro to define a symbol as being an absolute
;*      external value, which we can resolve at link time.
;*
;*      Usage:
;*            errcode <list>
;*      Where:
;*            list - the error codes to be defined.  ERROR_ is prepended
;*                   to the error name
;*      Restrictions:
;*            None
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

errcode macro   list
        irp     x,<list>
        externA PMERR_&&x
        endm
        endm


;/***************************************************************************
;*
;* MACRO NAME    = access
;*
;* DESCRIPTION   = 
;*
;*      access is a simple macro to check that we have access rights to the
;*      given selector.  If we do not, gain_access_to_selector is called.
;*
;*      Usage:
;*            access  reg,selector
;*      Where:
;*            reg      - A work register
;*            selector - The selector we want access to.  Must not be the
;*                       same as reg
;*      Restrictions:
;*            Uses AX if access is needed
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ifndef DINCL_GAIN_ACCESS_DEFINED
        externFP gain_access_to_selector
endif

access  macro   reg,selector
        local   xyzzy
ifidni <reg>,<selector>
        .err
endif
        cmp     selector,INVALID_SEL    ;Don't gain access to bogus selectors
        je      xyzzy
        lar     reg,selector
        jz      xyzzy
        cCall   gain_access_to_selector,<selector>
xyzzy:
        endm


;/***************************************************************************
;*
;* MACRO NAME    = pubabs
;*
;* DESCRIPTION   = 
;*
;*       pubabs is a simple macro to make an absolute value public
;*
;*       Usage:
;*             pubabs  name,val
;*       Where:
;*             name     - name of the equate
;*             val      - value it is to have
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

pubabs  macro   name,val
        public  name
name    equ     val
        endm

ifdef   INCL_DDICOMFLAGS

;/***************************************************************************
;*
;* MACRO NAME    = no_path_area
;*
;* DESCRIPTION   = 
;*
;*    no_path_area
;*
;*    this macro checks to make sure we are NOT in a path and/or an area.
;*    if we are in what we shouldn't be, then we return an "invalid operation
;*    in path" (or "in area", as appropriate) error and jump to the label
;*    passed in.
;*
;*    to indicate which checking is to be done, the macro is passed a
;*    keyword as the second argument:  'area' for area only
;*                                     'path' for path only
;*                                     'both' for both area and path
;*
;*    the third parameter:
;*          if error handling exists in the routine, then
;*    pass in 'error' as the third parameter.  the label passed in should
;*    be where the error handling is done.
;*          if a 'cwd' is needed because one does not conveniently exist,
;*    pass in 'cwd' and one will be inserted after error handling.
;*
;*                 Registers Destroyed:
;*                       None.
;*
;* INPUT         = FunN (on stack, at routine entry time)
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = AX = 0. 
;*
;**************************************************************************/

        .errnz  HIGH COM_PATH
        .errnz  HIGH COM_AREA

no_path_area    macro   jumplabel,patharea,ret_type
        local   nothing_here,its_a_path,save_the_error

ifidni  <patharea>,<path>               ;; disallow path only
        test    byte ptr FunN.hi,COM_PATH
        jz      nothing_here
        mov     ax,PMERR_INV_IN_PATH
else

ifidni  <patharea>,<area>               ;; disallow area only
        test    byte ptr FunN.hi,COM_AREA
        jz      nothing_here
        mov     ax,PMERR_INV_IN_AREA
else

ifidni  <patharea>,<both>               ;; disallow path and area
        test    byte ptr FunN.hi,COM_PATH OR COM_AREA
        jz      nothing_here
        test    byte ptr FunN.hi,COM_PATH ;; which error do we have?
        jnz     its_a_path
        mov     ax,PMERR_INV_IN_AREA
        jmp     short save_the_error

its_a_path:
        mov     ax,PMERR_INV_IN_PATH
save_the_error:
else
        .err
endif           ;; both
endif           ;; area
endif           ;; path

ifdifi  <ret_type>,<error>      ;; if not an easy error return...
        save_error_code
        xor     ax,ax
ifidni  <ret_type>,<cwd>
        cwd                     ;; a cwd is needed for return value
else
        ifnb    <ret_type>
                .err
        endif   ;; ifnb
endif           ;; ifidni
endif           ;; ifdifi
        jmp     jumplabel

nothing_here:
endm

endif   ;ifdef INCL_DDICOMFLAGS


CPUMode 286


;/*
;** CellFont Structure                                                    
;**                                                                       
;** This structure defines an entry in the font cell table, adDevVioCells.
;*/

CellFont        struc
cf_width        dw      ?       ; The width of a character cell.
cf_height       dw      ?       ; The height of a character cell.
cf_ptr          dd      ?       ; Font definition address.
CellFont        ends


OFFSCR_VDD       equ  00000001b ; using VDD to alloc off-screen memory
OFFSCR_TRASHED   equ  00000010b ; off-screen memory has been trashed


;/*
;** Video VDD requests (WARNING: must be kept in sync with H\VVD.H)
;*/

SHADOW_DIRTYREGS        equ 01h ; video controller registers are dirty

VVDSYSREQ_SETDRQ        equ 11  ; Set display requirements
VVDSYSREQ_REQMEM        equ 12  ; Request off-screen video memory
VVDSYSREQ_FREEMEM       equ 13  ; Free off-screen video memory
VVDSYSREQ_REQCTRL       equ 14  ; Request video controller ownership
VVDSYSREQ_FREECTRL      equ 15  ; Free video controller ownership
VVDSYSREQ_SETOEMFLAG    equ 17  ; Set OEM Status Flag

vvreg_s struc                   ; Virtual Video Register entry
 vvr_port               dw  ?   ; port #
 vvr_indx               db  ?   ; register index #
 vvr_value              db  ?   ; last value written to register
vvreg_s ends

vvdrq_s struc                   ; structure for VVDSYSREQ_SETDRQ request
 vvd_pPhysVRAM          dd  ?   ; physical address of VRAM
 vvd_nbReserved         dd  ?   ; # of reserved bytes
 vvd_offLatchByte       dd  ?   ; offset of available latch storage
 vvd_pfbShadowFlags     dd  ?   ; pointer to flags (see SHADOW_* constants)
 vvd_pfControllerOwned  dd  ?   ; address of driver's fControllerOwned flag
 vvd_pfControllerNotify dd  ?   ; address of driver's fControllerNotify flag
 vvd_nShadowRegs        dd  ?   ; # of registers to shadow
 vvd_pShadowData        dd  ?   ; address of first vvreg_s entry (see above)
vvdrq_s ends


BM_AND                  equ        6
BM_SUBTRACT             equ        7
BM_MASKSRCNOT           equ        8
BM_ZERO                 equ        9
BM_NOTMERGESRC          equ       10
BM_NOTXORSRC            equ       11
BM_INVERT               equ       12
BM_MERGESRCNOT          equ       13
BM_NOTCOPYSRC           equ       14
BM_MERGENOTSRC          equ       15
BM_NOTMASKSRC           equ       16
BM_ONE                  equ       17


CAPS_BM_AND                       equ       32
CAPS_BM_GENERAL_BOOLEAN           equ       64

CAPS_EXTRA_AREA_BACKGROUND_MIX    equ       41
CAPS_EXTRA_LINE_BACKGROUND_MIX    equ       42

LBB_BACK_COLOR                      equ     0002h
LBB_BACK_MIX_MODE                   equ     0008h

;/*
;**        PALETTE TYPE FLAGS
;*/

DEFAULT_PALETTE     EQU 0
REALIZED_PALETTE    EQU 1

SVGAstruct          struc
SVGAadaptertype     dw  ?
SVGAchiptype        dw  ?
SVGAmemory          dd  ?
SVGAstruct          ends

VIDEO7_ADAPTER      EQU 1
TRIDENT_ADAPTER     EQU 2
TSENG_ADAPTER       EQU 3
WESTERNDIG_ADAPTER  EQU 4
ATI_ADAPTER         EQU 5

IFDEF   SEAMLESS
include seamless.inc
ENDIF   ;SEAMLESS

ifdef VGA
   include clisti.inc
endif
