;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DISPATCH.ASM
;*
;* DESCRIPTIVE NAME = Default function handler dispatch table.
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/12/88
;*
;* DESCRIPTION  
;*      This file contains the default function handler dispatch table.     
;*      The table initially contains the address of each function the       
;*      driver will hook.  Upon the very first enable call, the contents    
;*      of the table will be replaced with the default dispatch table       
;*      passed to us by the Engine, and any address in the table which is   
;*      non-null will be placed in the Engine's table.  All communications  
;*      between the engine and the driver will then take place through this 
;*      table.                                                              
;*
;*      Public Data:           apfnDefDispatch       
;*                             apfnOurDispatch       
;*                             DEV_DISPATCH_TBL_SIZE 
;*
;* FUNCTIONS    NONE
;*
;*
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/12/88                     Walt Moore [waltm] - Created
;*
;*****************************************************************************/

        .286p

        .xlist
        include cmacros.inc
INCL_GPIBITMAPS    equ     1        ; needed for palette structures
INCL_GREALL        equ     1
        include        pmgre.inc
        include driver.inc
        .list

        externFP    DisjointLines
        externFP    GetCurrentPosition
        externFP    SetCurrentPosition
        externFP    PolyLine
        externFP    DrawLinesInPath
        externFP    PolyShortLine
        externFP    PolyScanline
        externFP    DrawBits
        externFP    DeviceCreateBitmap
        externFP    DeviceDeleteBitmap
        externFP    DeviceSelectBitmap
        externFP    Bitblt
        externFP    GetPel
        externFP    SetPel
        externFP    ImageData
        externFP    SaveScreenBits
        externFP    RestoreScreenBits
        externFP    DrawBorder
        externFP    DeviceSetCursor
        externFP    GetBitmapBits
        externFP    SetBitmapBits
        externFP    SetColorCursor
        externFP    CharString
        externFP    CharStringPos
        externFP    PolyMarker
        externFP    CharRect
        externFP    CharStr
        externFP    ScrollRect
        externFP    UpdateCursor
        externFP    DeviceGetAttributes
        externFP    GetPairKerningTable
        externFP    DeviceSetAVIOFont2
        externFP    DeviceSetAttributes
        externFP    DeviceSetGlobalAttribute
        externFP    NotifyClipChange
        externFP    NotifyTransformChange
        externFP    RealizeFont
        externFP    ErasePS
        externFP    GetStyleRatio
        externFP    SetStyleRatio
        externFP    DeviceQueryFontAttributes
        externFP    DeviceQueryFonts
        externFP    DeviceInvalidateVisRegion
        externFP    GetPickWindow
        externFP    SetPickWindow
        externFP    ResetBounds
        externFP    GetBoundsData
        externFP    AccumulateBounds
        externFP    GetCodePage
        externFP    SetCodePage
        externFP    LockDevice
        externFP    UnlockDevice
        externFP    Death
        externFP    Resurrection
        externFP    GetDCOrigin
        externFP    DeviceSetDCOrigin
        externFP    GetLineOrigin
        externFP    SetLineOrigin
        externFP    QueryColorData
        externFP    QueryLogColorTable
        externFP    CreateLogColorTable
        externFP    RealizeColorTable
        externFP    UnrealizeColorTable
        externFP    QueryRealColors
        externFP    QueryNearestColor
        externFP    QueryColorIndex
        externFP    QueryRGBColor
        externFP    QueryDevResource2
        externFP    QueryDeviceBitmaps
        externFP    QueryDeviceCaps
        externFP    QueryHardcopyCaps
        externFP    Escape
;/*
;** The following macros are used to create the dispatch table, perform
;** error checking on entries' position within the table, and generate
;** a public label of the form pfnDefxxxx where xxxx is the function name.
;*/


table_start     macro   myname
        public  myname
myname  equ     this dword
?mystart = myname
        endm
;**
;**  !!! Since this macro is no longer invoked with DEFINE_LABELS == 1,
;**  !!! we can simplify it.  For now, the definition is not changed.
;*/

table_entry     macro   myname,realname
ifdif <myname>,<-1>
  ifnb <realname>
    ifdif <realname>,<OK>
        if DEFINE_LABELS
            .errnz  ($ - ?mystart)/4 - (off_&realname and 1FFh)
            public  pfnDef&realname
pfnDef&realname equ this dword
        endif
    endif
  else
    ifdif <myname>,<0>
        if DEFINE_LABELS
            public  pfnDef&myname
pfnDef&myname equ this dword
        .errnz  ($ - ?mystart)/4 - (off_&myname and 1FFh)
        endif
    endif
  endif
        dd        myname
else
        dd      0
endif
endm

table_end       macro   myname
        public  myname&_size
myname&_size        =        ($ - ?mystart)/4
        endm


;/*
;** The following defines the entries of the dispatch table
;*/

dispatch_of_death        macro        name
        table_start        name
        table_entry     0,GetArcParameters
        table_entry     0,SetArcParameters
        table_entry     0,Arc
        table_entry     0,PartialArc
        table_entry     0,FullArcInterior
        table_entry     0,FullArcBoundary
        table_entry     0,FullArcBoth
        table_entry     0,BoxInterior
        table_entry     0,BoxBoundary
        table_entry     0,BoxBoth
        table_entry     0,PolyFillet
        table_entry     0,PolyFilletSharp
        table_entry     0,PolySpline
        table_entry     0,DrawConicsInPath
        table_entry     0,CookWholePath
        table_entry     0,CookPathCurves
        table_entry        0,OK
        table_entry     0,RenderPath
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        DisjointLines
        table_entry        GetCurrentPosition
        table_entry        SetCurrentPosition
        table_entry        PolyLine
        table_entry        DrawLinesInPath
        table_entry        PolyShortLine
        table_entry        PolyScanline
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry     DrawBits
        table_entry        DeviceCreateBitmap
        table_entry        DeviceDeleteBitmap
        table_entry        DeviceSelectBitmap
        table_entry     Bitblt
        table_entry        GetPel
        table_entry        SetPel
        table_entry        ImageData
        table_entry        0,OK
        table_entry        0,OK
        table_entry        SaveScreenBits
        table_entry        RestoreScreenBits
        table_entry        DrawBorder
        table_entry        DeviceSetCursor
        table_entry        GetBitmapBits
        table_entry        SetBitmapBits
        table_entry        SetColorCursor
        table_entry        0,OK
        table_entry        0,OK

        table_entry     CharString
        table_entry     CharStringPos
        table_entry        0,QueryTextBox
        table_entry     0,QueryCharPositions
        table_entry        0,QueryWidthTable
        table_entry        PolyMarker
        table_entry        CharRect
        table_entry        CharStr
        table_entry        ScrollRect
        table_entry        UpdateCursor
        table_entry     0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        0,BeginArea
        table_entry        0,EndArea
        table_entry        0,BeginPath
        table_entry        0,EndPath
        table_entry        0,CloseFigure
        table_entry        0,FillPath
        table_entry        0,OutlinePath
        table_entry        0,ModifyPath
        table_entry        0,StrokePath
        table_entry        0,SelectClipPath
        table_entry        0,SavePath
        table_entry        0,RestorePath
        table_entry        0,Clip1DPath
        table_entry        0,DrawRawPath
        table_entry        0,DrawCookedPath
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        0,GetRegionBox
        table_entry        0,GetRegionRects
        table_entry        0,OffsetRegion
        table_entry        0,PtInRegion
        table_entry        0,RectInRegion
        table_entry        0,CreateRectRegion
        table_entry        0,DestroyRegion
        table_entry        0,SetRectRegion
        table_entry        0,CombineRegion
        table_entry        0,CombineRectRegion
        table_entry        0,CombineShortLineRegion
        table_entry        0,EqualRegion
        table_entry        0,PaintRegion
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        0,GetClipBox
        table_entry        0,GetClipRects
        table_entry        0,OffsetClipRegion
        table_entry        0,PtVisible
        table_entry        0,RectVisible
        table_entry        0,QueryClipRegion
        table_entry        0,SelectClipRegion
        table_entry        0,IntersectClipRectangle
        table_entry        0,ExcludeClipRectangle
        table_entry        0,SetXformRect
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,SaveRegion
        table_entry        0,RestoreRegion
        table_entry        0,ClipPathCurves
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        0,GetPageUnits
        table_entry        0,SetPageUnits
        table_entry        0,GetModelXform
        table_entry        0,SetModelXform
        table_entry        0,GetWindowViewportXform
        table_entry        0,SetWindowViewportXform
        table_entry        0,GetGlobalViewingXform
        table_entry        0,SetGlobalViewingXform
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,GetPageViewport
        table_entry        0,SetPageViewport
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,GetGraphicsField
        table_entry        0,SetGraphicsField
        table_entry        0,GetViewingLimits
        table_entry        0,SetViewingLimits
        table_entry        0,QueryViewportSize
        table_entry        0,Convert
        table_entry        0,ConvertPath
        table_entry        0,SaveXform
        table_entry        0,RestoreXform
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        DeviceGetAttributes
        table_entry        DeviceSetAVIOFont2
        table_entry        0,OK
        table_entry        GetPairKerningTable
        table_entry        0,OK
        table_entry        DeviceSetAttributes
        table_entry        DeviceSetGlobalAttribute
        table_entry        NotifyClipChange
        table_entry        NotifyTransformChange
        table_entry        RealizeFont
        table_entry        ErasePS
        table_entry        SetStyleRatio
        table_entry        DeviceQueryFontAttributes
        table_entry        DeviceQueryFonts
        table_entry        DeviceInvalidateVisRegion
        table_entry     GetPickWindow
        table_entry     SetPickWindow

        table_entry        ResetBounds
        table_entry        GetBoundsData
        table_entry        AccumulateBounds
        table_entry        0,OK                        ;Was SetPatternOrigin
        table_entry        0,OK                        ;SetPatternOrigin
        table_entry        GetCodePage
        table_entry        SetCodePage
        table_entry        LockDevice
        table_entry        UnlockDevice
        table_entry        Death
        table_entry        Resurrection
        table_entry        0,OK
        table_entry        GetDCOrigin
        table_entry        DeviceSetDCOrigin
        table_entry        GetLineOrigin
        table_entry        SetLineOrigin
        table_entry        GetStyleRatio
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK

        table_entry        QueryColorData
        table_entry        QueryLogColorTable
        table_entry        CreateLogColorTable
        table_entry        RealizeColorTable
        table_entry        UnrealizeColorTable
        table_entry        QueryRealColors
        table_entry        QueryNearestColor
        table_entry        QueryColorIndex
        table_entry        QueryRGBColor
        table_entry        0,OK
        table_entry        0,OK
        table_entry     0,OK
        table_entry        0,OK

        table_entry        QueryDeviceBitmaps
        table_entry        QueryDeviceCaps
        table_entry        Escape
        table_entry        QueryHardcopyCaps
        table_entry     QueryDevResource2

        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_entry        0,OK
        table_end        name
        endm

;/*
;** The apfnDefDispatch table defines the set of default dispatch functions
;** that the display driver must call back to after processing a hooked
;** function.
;**
;** Each entry in the table is initialized with the index into the default
;** table of the function we want, which will be replaced with the appropriate
;** function address by Enable().
;*/

defdispatch_entry     macro   realname

public        pfnDef&realname
        pfnDef&realname equ this dword

        dd        ((off_&realname and 1FFh) * 4)
endm

sBegin        Data

public        apfnDefDispatch
        apfnDefDispatch equ this word

        defdispatch_entry Bitblt
        defdispatch_entry DrawBits
        defdispatch_entry Convert
        defdispatch_entry DisjointLines
        defdispatch_entry SetCurrentPosition
        defdispatch_entry PolyLine
        defdispatch_entry PolyMarker
        defdispatch_entry PtVisible
        defdispatch_entry RectVisible
        defdispatch_entry SelectClipRegion
        defdispatch_entry GetClipRects
        defdispatch_entry NotifyClipChange
        defdispatch_entry NotifyTransformChange
        defdispatch_entry GetPairKerningTable
        defdispatch_entry CharStringPos
        defdispatch_entry QueryTextBox
        defdispatch_entry QueryCharPositions
        defdispatch_entry GetVisRects

        public        DEF_DISPATCH_TBL_SIZE
DEF_DISPATCH_TBL_SIZE  = ($ - apfnDefDispatch) / 4; 

sEnd        Data

;/*
;** The following defines the dword label apfnOurDispatch, checks the
;** offsets of all the functions in the table, and defines the absolute
;** apfnDefDispatch_size, which is the count of the entries.
;**
;** This is the table where our handler's address will come from
;*/

DEFINE_LABELS        =        0

sBegin        InitSeg
        dispatch_of_death apfnOurDispatch

        public                DEV_DISPATCH_TBL_SIZE
DEV_DISPATCH_TBL_SIZE = apfnOurDispatch_size

sEnd        InitSeg


end
