;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = DATA.ASM
;*
;* DESCRIPTIVE NAME = data program
;*
;*
;* VERSION          = V2.0
;*
;* DATE             = 01/12/88
;*
;* DESCRIPTION      = This file contains variables statically allocated     
;*                    in the drivers Data segment.
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/12/88                     Walt Moore - Created
;*   08/01/88                     Lynn Cox IBM Hursley
;*                                  DCR 23987 - Implement 
;*                                  DEVESC_QUERYVIOCELLSIZES
;*   08/27/90                     rajivg Microsoft, Redmond
;*                                  Implemented new font cache changes.
;*   01/0189                      Data Connection
;*                                  AVIO Font Modifications - 
;*                                  Define new fonts
;*   05/11/89                     [JohnC] DDC_CORR_INV to ddc_fb so 
;*                                  rcsCorr is initialized
;*****************************************************************************/
        .xlist
        include cmacros.inc
INCL_GPIPRIMITIVES      equ     1
INCL_GPIBITMAPS         equ     1
INCL_DDIMISC            equ     1
INCL_DEV                equ     1
        include pmgre.inc
DINCL_ENABLE            equ     1
DINCL_VIO               equ     1
DINCL_ROPS              equ     1
DINCL_BITMAP            equ     1
DINCL_VIO               equ     1
DINCL_BB_ROPS           equ     1
DINCL_PAT_CACHE_DEFS    equ     1
        include driver.inc
        .list

        externA DEF_FMIX_IMAGE
        externA DEF_FB_IMAGE
        externA DEF_FMIX_PATTERN
        externA DEF_FB_PATTERN
        externA DEF_FMIX_LINE
        externA DEF_FB_LINE
        externA DEF_PATTERN_FS_FLAGS
        externA DEF_PATTERN_FB_FLAGS
        externA DEF_PATTERN_CODE_POINT
        externA DEF_LINE_TYPE
        externA DEF_LINE_ERROR
        externA DEF_LINE_MASK
        externA DEF_LINE_STEP_X
        externA DEF_LINE_STEP_Y
        externA DEF_FMIX_CHAR
        externA DEF_FB_CHAR
        externA DEF_FONT_FS_FLAGS
        externA DEF_LOG_FORE_CLR
        externA DEF_LOG_BACK_CLR
        externA DEF_IPC_FORE_CLR
        externA DEF_IPC_BACK_CLR
        externA DEF_FMIX_MARKER
        externA DEF_FB_MARKER
        externA DEF_MARKER_CODE_POINT
        externA DEF_MARKER_FS_FLAGS
        externA DEF_MARKER_FB_FLAGS
        externA SCREEN_SDFB
        externA SCREEN_CX
        externA SCREEN_CY
        externA SCREEN_CBSCAN
        externA SCREEN_DSCAN
        externA SCREEN_CYSEG
        externA IC_SDFB
        externA DEVCAPS_HORIZONTAL_RESOLUTION
        externA DEVCAPS_VERTICAL_RESOLUTION
        externA DEVCAPS_COLORS
        externA D15_00_DEVCAPS_PHYS_COLORS
        externA D31_16_DEVCAPS_PHYS_COLORS
        externA DEVCAPS_COLOR_INDEX

        externA DEVCAPS_WIDTH_IN_CHARS
        externA DEVCAPS_HEIGHT_IN_CHARS
        externA DEVCAPS_CHAR_WIDTH
        externA DEVCAPS_CHAR_HEIGHT
        externA DEVCAPS_SMALL_CHAR_WIDTH
        externA DEVCAPS_SMALL_CHAR_HEIGHT

        externA DEVCAPS_GRAPHICS_CHAR_WIDTH
        externA DEVCAPS_GRAPHICS_CHAR_HEIGHT
        externA DEVCAPS_HORIZONTAL_FONT_RES
        externA DEVCAPS_VERTICAL_FONT_RES

        externA DEF_BMIX_IMAGE
        externA DEF_BMIX_PATTERN
        externA DEF_BMIX_LINE
        externA DEF_BMIX_CHAR
        externA DEF_BMIX_MARKER

;/*
;**  If the driver supports color pointer, the following extern should
;**  be set to the value CAPS_COLOR_POINTER_SUPPORT in resolve.asm.
;*/

        externA DEVCAPS_COLOR_POINTER_SUPPORT

        externA DEFAULT_SELTEXTVRAM

        IFNDEF CGA      ;this is required for EGA/VGA drivers only
        IFNDEF PP8
sBegin  PtrData
        externA reserved_latches
        externB fbShadowFlags
        externB fControllerOwned
        externB fControllerNotify
        externA shadow_size
        externB shadow_data
sEnd    PtrData
        ENDIF ;!PP8
        ENDIF ;!CGA


sBegin  Data

        externD ctDefault

;/*
;**  fEnabled will be 1 if fill_log_dev_blk has never been called.
;** Once it is called, it will be set to 0
;*/

globalB fEnabled,1                      ;Not initialized yet
globalB fPhysEnabled,1                  ;Not initialized yet

;/*
;**  Global flag for the 8514 driver only. The default value of -1 means that
;**  fast screen switching (on Resurrection) is disabled. A value of 0 means
;**  enabled. A value of 0 will only be set if the string identified by
;**  "PM_IBMBGA" "FASTSS" in the user .INI file is set to "1"; The .INI file
;**  will only be read at boot time. Values other than 0 or 1 are undefined.
;*/

ifdef PP8  ; PP8 is true for 8514 only
globalW f8514FastSS,-1
endif

;/*
;**   Global flag for the 8514 driver only. The default value of 0 means use
;**   the default system font. The user setable value of 1 means use the
;**   alternate font. Ie, on an 8514 use the 8515 font; on an 8515 use the
;**   8514 font. Values other than 0 or 1 are undefined. This flag is read
;**   from the INI file by INIT.asm only at boot time.
;**   usSysFontRes is initialized to the default font.  It is used by
;**   QUERY.ASM as the id of the font to load.  It is set by resolve.asm.
;*/

ifdef PP8  ; PP8 is true for 8514 only
globalW fAltSysFont,0
globalW usSysFontRes,SFONT_RASTER
endif

;/*
;**  DAK 21/NOV/90
;**  Global variable for switchable screen width
;*/

ifdef VGA664
globalW wScreenWidth,SCREEN_CX
endif


;/*
;**  fGrimReaper will be 0 whenever the driver can write to the screen,
;**  and will be WE_BE_DEAD when we cannot write to the screen.  Death()
;**  will set this flag, and Ressurection() will clear it.
;*/

globalB fGrimReaper,WE_BE_DEAD        

;/*
;**  fRip will contain a non-zero value if we are to rip whenever an
;**  error is reported to WinSetErrorInfo.  This flag will have no
;**  effect if FIREWALLS are disabled.
;*/

globalB fbRip,0

        even

;/*
;**  fSysClrInit indicates whether system colors have been initialised.
;*/

globalB fSysClrInit,0

        even

;/*
;**  selTextVram is a selector to the memory we allocated on a Death()
;**  call for the saving of VRAM, which is later used on a Resurrection()
;**  call to restore VRAM if nothing beyond the amount saved was dirtied.
;**  see save_textvram and restore_textvram for more details.
;*/

globalW selTextVram,DEFAULT_SELTEXTVRAM         ; Found in RESOLVE.ASM

;/*
;**  selDeathToUse is the selector to the screen returned to us by the
;**  GetScreenSelector function.  Only three routines are allowed to use
;**  this selector.  one_time_init will place the return value from
;**  GetScreenSelector into this location.  physical_enable will transfer
;**  it into sdScreen.sd_pBits.sel and set it to INVALID_SEL.  physical_disable
;**  will copy sdScreen.sd_pBits.sel back into selDeathToUse and set
;**  sdScreen.sd_pBits.sel to INVALID_SEL.
;*/

globalW selDeathToUse,-1               ;-1 to cause GP-Fault


;/*
;**  FarHeap will contain the pointer returned by WinCreateFarHeap.
;**  This handle must be passed to all Winxxx memory management calls.
;*/

globalD FarHeap,-1                      ;-1 to cause GP-Fault?



;/*
;**  hLocalHeap will contain the handle returned by WinCreateHeap.
;**  This handle must be passed to all Winxxx memory management calls.
;*/


globalD hLocalHeap,-1                   ;-1 to cause GP-Fault?


;/*
;**   hModule is our module handle as passed to use by OS|2 at load time
;*/

globalW hModule,-1                      ;-1 to cause GP-Fault?


;/*
;**  cbHeap is the size of our heap as passed to use by OS|2 at load time
;*/

globalD cbHeap,0


;/*
;**  cBrush is the brush reference count.  It is incremented each time a
;**  brush is altered, and this number stored in ddc_pa.pa_idBrush.
;*/


globalD idBrush,PAT_CACHE_FIRST_ID      ;Initial brush id


;/*
;**  idBrushCache is the brush id for the brush currently stored in the
;**  cache.
;*/


globalD idBrushCache,PAT_CACHE_INVALID  ;Pattern cache is invalid  
                                        ;No brush will ever be 0


;/*
;**  adDevCapsData is the data returned by the QueryDeviceCaps function.
;**  Some fields will change at initialization time, depending on the
;**  specific driver being run and the fonts loaded.
;*/

DCAPS_FORE =    CAPS_MIX_OR or CAPS_MIX_COPY or CAPS_MIX_XOR or CAPS_MIX_AND
DCAPS_FORE =    DCAPS_FORE or CAPS_MIX_INVISIBLE or CAPS_MIX_OTHER
DCAPS_BACK =    CAPS_BACKMIX_COPY or CAPS_BACKMIX_INVISIBLE
DCAPS_BACK_AREA = CAPS_BM_OR or CAPS_BM_AND or CAPS_BM_XOR or CAPS_BM_GENERAL_BOOLEAN
DCAPS_BACK_LINE = CAPS_BM_OR or CAPS_BM_AND or CAPS_BM_XOR or CAPS_BM_GENERAL_BOOLEAN

        public  adDevCapsData
adDevCapsData   equ     this word

if CAPS_FAMILY
        dd      INVALID_ADDRESS         ;So we can accesss the table using the
        dd      OD_DIRECT               ;  CAPS_ names which are one based!
        .errnz  CAPS_FAMILY-1
else
        dd      OD_DIRECT
        .errnz  CAPS_FAMILY
endif

        dd      CAPS_IO_SUPPORTS_OP
        .errnz  CAPS_IO_CAPS-CAPS_FAMILY-1

        dd      CAPS_TECH_RASTER_DISPLAY
        .errnz  CAPS_TECHNOLOGY-CAPS_IO_CAPS-1

;/*
;**  Driver versions should be:
;**      1.2     0x00000120L
;**      2.0     0x00000200L
;**      2.1     0x00000210L
;*/

        dd      00000200h
        .errnz  CAPS_DRIVER_VERSION-CAPS_TECHNOLOGY-1

        dd      SCREEN_CX
        .errnz  CAPS_WIDTH-CAPS_DRIVER_VERSION-1

        dd      SCREEN_CY
        .errnz  CAPS_HEIGHT-CAPS_WIDTH-1

        dd      DEVCAPS_WIDTH_IN_CHARS
        .errnz  CAPS_WIDTH_IN_CHARS-CAPS_HEIGHT-1

        dd      DEVCAPS_HEIGHT_IN_CHARS
        .errnz  CAPS_HEIGHT_IN_CHARS-CAPS_WIDTH_IN_CHARS-1

        dd      DEVCAPS_HORIZONTAL_RESOLUTION
        .errnz  CAPS_HORIZONTAL_RESOLUTION-CAPS_HEIGHT_IN_CHARS-1

        dd      DEVCAPS_VERTICAL_RESOLUTION
        .errnz  CAPS_VERTICAL_RESOLUTION-CAPS_HORIZONTAL_RESOLUTION-1

        dd      DEVCAPS_CHAR_WIDTH
        .errnz  CAPS_CHAR_WIDTH-CAPS_VERTICAL_RESOLUTION-1

        dd      DEVCAPS_CHAR_HEIGHT
        .errnz  CAPS_CHAR_HEIGHT-CAPS_CHAR_WIDTH-1

        dd      DEVCAPS_SMALL_CHAR_WIDTH
        .errnz  CAPS_SMALL_CHAR_WIDTH-CAPS_CHAR_HEIGHT-1

        dd      DEVCAPS_SMALL_CHAR_HEIGHT
        .errnz  CAPS_SMALL_CHAR_HEIGHT-CAPS_SMALL_CHAR_WIDTH-1

        dd      DEVCAPS_COLORS
        .errnz  CAPS_COLORS-CAPS_SMALL_CHAR_HEIGHT-1

        dd      1
        .errnz  CAPS_COLOR_PLANES-CAPS_COLORS-1

        dd      BITS_PEL
        .errnz  CAPS_COLOR_BITCOUNT-CAPS_COLOR_PLANES-1

        dd      0
        .errnz  CAPS_COLOR_TABLE_SUPPORT-CAPS_COLOR_BITCOUNT-1

        dd      0
        .errnz  CAPS_MOUSE_BUTTONS-CAPS_COLOR_TABLE_SUPPORT-1

        dd      DCAPS_FORE
        .errnz  CAPS_FOREGROUND_MIX_SUPPORT-CAPS_MOUSE_BUTTONS-1

        dd      DCAPS_BACK
        .errnz  CAPS_BACKGROUND_MIX_SUPPORT-CAPS_FOREGROUND_MIX_SUPPORT-1

        dd      0
        .errnz  CAPS_VIO_LOADABLE_FONTS-CAPS_BACKGROUND_MIX_SUPPORT-1

        dd      CAPS_BYTE_ALIGN_REQUIRED
        .errnz  CAPS_WINDOW_BYTE_ALIGNMENT-CAPS_VIO_LOADABLE_FONTS-1

        dd      2
        .errnz  CAPS_BITMAP_FORMATS-CAPS_WINDOW_BYTE_ALIGNMENT-1

        dd      CAPS_RASTER_BITBLT or CAPS_RASTER_SET_PEL or CAPS_RASTER_FONTS or CAPS_RASTER_FLOOD_FILL
        .errnz  CAPS_RASTER_CAPS-CAPS_BITMAP_FORMATS-1

        dd      -1                      ;Needs run-time fix-up
        .errnz  CAPS_MARKER_HEIGHT-CAPS_RASTER_CAPS-1

        dd      -1                      ;Needs run-time fix-up
        .errnz  CAPS_MARKER_WIDTH-CAPS_MARKER_HEIGHT-1

        dd      0
        .errnz  CAPS_DEVICE_FONTS-CAPS_MARKER_WIDTH-1

        dd      0
        .errnz  CAPS_GRAPHICS_SUBSET-CAPS_DEVICE_FONTS-1

        dd      0
        .errnz  CAPS_GRAPHICS_VERSION-CAPS_GRAPHICS_SUBSET-1

        dd      0
        .errnz  CAPS_GRAPHICS_VECTOR_SUBSET-CAPS_GRAPHICS_VERSION-1

        dd      0
        .errnz  CAPS_DEVICE_WINDOWING-CAPS_GRAPHICS_VECTOR_SUBSET-1

        IFDEF PP8
        dd      CAPS_FONT_IMAGE_DEFAULT + CAPS_FONT_IMAGE_MANAGE + DEVCAPS_COLOR_POINTER_SUPPORT
        ELSE
 ;/*
;**  CAPS_VDD_DDB_TRANSFER is only supported by CGA/EGA/VGA display drivers
;**  See bmc_eti.asm, or me, for more details on this support (jeffpar 1/29/90)
;*/

        dd      CAPS_FONT_IMAGE_DEFAULT + CAPS_FONT_IMAGE_MANAGE + DEVCAPS_COLOR_POINTER_SUPPORT + CAPS_VDD_DDB_TRANSFER
        ENDIF
        .errnz  CAPS_ADDITIONAL_GRAPHICS-CAPS_DEVICE_WINDOWING-1

        dw      D15_00_DEVCAPS_PHYS_COLORS
        dw      D31_16_DEVCAPS_PHYS_COLORS
        .errnz  CAPS_PHYS_COLORS-CAPS_ADDITIONAL_GRAPHICS-1

        dd      DEVCAPS_COLOR_INDEX
        .errnz  CAPS_COLOR_INDEX-CAPS_PHYS_COLORS-1

        dd      DEVCAPS_GRAPHICS_CHAR_WIDTH
        .errnz  CAPS_GRAPHICS_CHAR_WIDTH-CAPS_COLOR_INDEX-1

        dd      DEVCAPS_GRAPHICS_CHAR_HEIGHT
        .errnz  CAPS_GRAPHICS_CHAR_HEIGHT-CAPS_GRAPHICS_CHAR_WIDTH-1

        dd      DEVCAPS_HORIZONTAL_FONT_RES
        .errnz  CAPS_HORIZONTAL_FONT_RES-CAPS_GRAPHICS_CHAR_HEIGHT-1

        dd      DEVCAPS_VERTICAL_FONT_RES
        .errnz  CAPS_VERTICAL_FONT_RES-CAPS_HORIZONTAL_FONT_RES-1

        dd      0
        .errnz  CAPS_DEVICE_FONT_SIM-CAPS_VERTICAL_FONT_RES-1

        dd      0
        .errnz  CAPS_LINEWIDTH_THICK-CAPS_DEVICE_FONT_SIM-1

        dd      DCAPS_BACK_AREA
        .errnz  CAPS_EXTRA_AREA_BACKGROUND_MIX-CAPS_LINEWIDTH_THICK-1

        dd      DCAPS_BACK_LINE
        .errnz  CAPS_EXTRA_LINE_BACKGROUND_MIX-CAPS_EXTRA_AREA_BACKGROUND_MIX-1

        public  COUNT_DEV_CAPS_DATA
COUNT_DEV_CAPS_DATA  equ ($-adDevCapsData)/4 - CAPS_FAMILY


;/*
;**   adDevVioCells is the table containing the font sizes of the VIO cell   
;**   sizes available from this driver, also a selector to each font         
;**   definition.                                                            
;**   The cell size values are returned in DEVESC_QUERYVIOCELLSIZES.         
;**                                                                          
;**   cDevVioCells is the number of cell sizes in the table, and is          
;**   currently set to eight for the 8514 display.                           
;**                                                                          
;**   pDefVioFont is address of the default vio font information             
;**                                                                          
;**   Note that the table below is sorted by height within width!!           
;**   This is assumed in the code!!                                          
;*/                                                                          
                                                                             
        public  adDevVioCells                                                
        public  pDefVioFont

ifdef PP8      ; set for 8514/A only

;/*
;**  DAK 13-May-91 Make font sizes match that used by XGA.
;*/

adDevVioCells   label   qword
 Cell6x10        CellFont        < 6,10,INVALID_ADDRESS>
 Cell6x14        CellFont        < 6,14,INVALID_ADDRESS>
 Cell7x15        CellFont        < 7,15,INVALID_ADDRESS>
 Cell7x25        CellFont        < 7,25,INVALID_ADDRESS>
 Cell8x8         CellFont        < 8, 8,INVALID_ADDRESS>
 Cell8x10        CellFont        < 8,10,INVALID_ADDRESS>
 Cell8x12        CellFont        < 8,12,INVALID_ADDRESS>
 Cell8x14        CellFont        < 8,14,INVALID_ADDRESS>
 Cell8x16        CellFont        < 8,16,INVALID_ADDRESS>
pDefVioFont     label   qword
 Cell8x18        CellFont        < 8,18,INVALID_ADDRESS>
 Cell10x18       CellFont        <10,18,INVALID_ADDRESS>
 Cell12x16       CellFont        <12,16,INVALID_ADDRESS>
 Cell12x20       CellFont        <12,20,INVALID_ADDRESS>
 Cell12x22       CellFont        <12,22,INVALID_ADDRESS>
 Cell12x30       CellFont        <12,30,INVALID_ADDRESS>

else ; not a 8514/A
ifdef VGA

adDevVioCells   label   qword
 Cell5x12        CellFont        < 5,12,INVALID_ADDRESS>
 Cell5x16        CellFont        < 5,16,INVALID_ADDRESS>
 Cell6x10        CellFont        < 6,10,INVALID_ADDRESS>
 Cell6x14        CellFont        < 6,14,INVALID_ADDRESS>
 Cell8x8         CellFont        < 8, 8,INVALID_ADDRESS>
 Cell8x10        CellFont        < 8,10,INVALID_ADDRESS>
pDefVioFont     label   qword
 Cell8x12        CellFont        < 8,12,INVALID_ADDRESS>
 Cell8x14        CellFont        < 8,14,INVALID_ADDRESS>
 Cell8x16        CellFont        < 8,16,INVALID_ADDRESS>
 Cell8x18        CellFont        < 8,18,INVALID_ADDRESS>

else                                ; not a VGA or 8514/A
ifdef CGA

adDevVioCells   label   qword
pDefVioFont     label   qword
 Cell8x8         CellFont        < 8, 8,INVALID_ADDRESS>
 Cell8x10        CellFont        < 8,10,INVALID_ADDRESS>

else                                ; not a CGA, VGA or 8514/A, assume EGA

adDevVioCells   label   qword
 Cell8x8         CellFont        < 8, 8,INVALID_ADDRESS>
pDefVioFont     label   qword
 Cell8x10        CellFont        < 8,10,INVALID_ADDRESS>
 Cell8x12        CellFont        < 8,12,INVALID_ADDRESS>
 Cell8x14        CellFont        < 8,14,INVALID_ADDRESS>
 Cell8x16        CellFont        < 8,16,INVALID_ADDRESS>

endif ; CGA
endif ; VGA
endif ; PP8

        public  cDevVioCells
cDevVioCells    equ     ($-adDevVioCells)/(SIZE CellFont)

;/*
;**  padBitmapFormats is the pointer to the table of dwords for the
;**  QueryDeviceBitmaps function.  The number of entries in the table
;**  is specified by CAPS_BITMAP_FORMATS in adDevCapsData.
;*/

globalD padBitmapFormats,-1             ;-1 to cause GP fault


;/*
;**  Define what is currently the only semaphore used in the driver.
;*/

        public  semDriver
semDriver       FSRSEM  <,,0,0,0,0,-1,0>


;/*
;**  ddcInit is the ddc structure copied into all allocated ddcs by both
;**  the EnableDC and ResetDC subfunction of Enable.  The default ddc is
;**  initialized to be a screen ddc.
;** 
;**  We allocate the default ddc in the data segment so that it can be
;**  changed at initialization time based on the characteristics of the
;**  particular adapter installed in the machine.  This minimizes the
;**  number of drivers which must be maintained.
;** 
;**  Values determined at initialization time, such as screen selector and
;**  pointers to the font resources are written into the default ddc as
;**  they are determined. Appropriate defaults are also written into the
;**  default ddc, and will be retrieved from here when needed.
;** 
;**  Fields which have no value at assembly time are given values which
;**  will hopefully cause a GP fault if used.
;** 
;**  I've changed the semantics a little on the table.  The .errnz
;**  preceeds the value being defined.
; */


        even
        public  ddcInit
ddcInit equ     this byte

;/*
;**  General stuff stored in the ddc
;*/

        .errnz  ddc_usId
        dw      DDC_IDENT

        .errnz  ddc_npsd-ddc_usId-2
        dw      sdScreen

        .errnz  ddc_hdc-ddc_npsd-2
        dd     INVALID_ADDRESS

        .errnz  ddc_crcsClip-ddc_hdc-4
        dw      1

        .errnz  ddc_fb-ddc_crcsClip-2
        db      DDC_PRESENT+DDC_DEVICE+DDC_UNIT_XFORM+DDC_VISIBLE+DDC_CLIP_NOTIFY+DDC_FIRST_PEL+DDC_CORR_INV

        .errnz  ddc_fbAbove-ddc_fb-1
        db      0

        .errnz  ddc_prddc-ddc_fbAbove-1
        dd      INVALID_ADDRESS

;/*
;** ------------------ reset_ddc_state initializes only below -----------------
;*/

;/*
;**  Start of image attributes
;*/

        .errnz  ddc_ia-ddc_prddc-4
        .errnz  ia_ba
        .errnz  ba_clr
        dd      DEF_LOG_FORE_CLR

        .errnz  ba_clrBack-ba_clr-4
        dd      DEF_LOG_BACK_CLR

        .errnz  ba_ipc-ba_clrBack-4
        dw      DEF_IPC_FORE_CLR                ;The extern is a WORD

        .errnz  ba_ipcBack-ba_ipc-2
        dw      DEF_IPC_BACK_CLR                ;The extern is a WORD

        .errnz  ba_bReserved-ba_ipcBack-2
        db      0

        .errnz  ba_fb-ba_bReserved-1
        db      DEF_FB_IMAGE

        .errnz  ba_bmix-ba_fb-1
        db      DEF_FMIX_IMAGE

        .errnz  ba_bkmix-ba_bmix-1
        db      DEF_BMIX_IMAGE

;/*
;**  Start of pattern attributes
;*/

        .errnz  ddc_pa-ddc_ia.ba_bkmix-1
        .errnz  pa_ba
        .errnz  ba_clr
        dd      DEF_LOG_FORE_CLR

        .errnz  ba_clrBack-ba_clr-4
        dd      DEF_LOG_BACK_CLR

        .errnz  ba_ipc-ba_clrBack-4
        dw      DEF_IPC_FORE_CLR                ;The extern is a WORD

        .errnz  ba_ipcBack-ba_ipc-2
        dw      DEF_IPC_BACK_CLR                ;The extern is a WORD

        .errnz  ba_bReserved-ba_ipcBack-2
        db      0

        .errnz  ba_fb-ba_bReserved-1
        db      DEF_FB_PATTERN

        .errnz  ba_bmix-ba_fb-1
        db      DEF_FMIX_PATTERN

        .errnz  ba_bkmix-ba_bmix-1
        db      DEF_BMIX_PATTERN

        .errnz  pa_pFont-pa_ba.ba_bkmix-1
        dd      INVALID_ADDRESS                 ;To cause GP fault

        .errnz  pa_paus-pa_pFont-4
        dd      INVALID_ADDRESS

        .errnz  pa_fs-pa_paus-4
        dw      DEF_PATTERN_FS_FLAGS

        .errnz  pa_ch-pa_fs-2
        db      DEF_PATTERN_CODE_POINT

        .errnz  pa_fb-pa_ch-1
        db      DEF_PATTERN_FB_FLAGS

        .errnz  pa_ptlOrg-pa_fb-1
        db      (size POINTL) dup (0)

        .errnz  pa_ptsOrg-pa_ptlOrg-(size POINTL)
        db      (size POINTS) dup (0)

        .errnz  pa_cRcr-pa_ptsOrg-(size POINTS)
        db      0

        .errnz  pa_cxFill-pa_cRcr-1
        db      0

        .errnz  pa_cyFill-pa_cxFill-1
        db      0
        db      0                               ;Reserved

        .errnz  pa_idBrush-pa_cyFill-2
        dd      PAT_CACHE_FIRST_ID

        .errnz  pa_ipcFore-pa_idBrush-4
        dw      DEF_IPC_FORE_CLR

        .errnz  pa_ipcBack-pa_ipcFore-2
        dw      DEF_IPC_BACK_CLR

        .errnz  pa_abColor-pa_ipcBack-2
        db      (BITS_PEL * SIZE_PATTERN) dup (0)

        .errnz  pa_abMono-pa_abColor-(BITS_PEL * SIZE_PATTERN)
        db      SIZE_PATTERN dup (0h)

        .errnz  pa_abMask-pa_abMono-(SIZE_PATTERN)
        db      SIZE_PATTERN dup (0FFh)

;/*
;**  Start of line attributes
;*/

        .errnz  ddc_la-ddc_pa.pa_abMask-(SIZE_PATTERN)
        .errnz  la_ba
        .errnz  ba_clr
        dd      DEF_LOG_FORE_CLR

        .errnz  ba_clrBack-ba_clr-4
        dd      DEF_LOG_BACK_CLR

        .errnz  ba_ipc-ba_clrBack-4
        dw      DEF_IPC_FORE_CLR

        .errnz  ba_ipcBack-ba_ipc-2
        dw      DEF_IPC_BACK_CLR

        .errnz  ba_bReserved-ba_ipcBack-2
        db      0

        .errnz  ba_fb-ba_bReserved-1
        db      DEF_FB_LINE

        .errnz  ba_bmix-ba_fb-1
        db      DEF_FMIX_LINE

        .errnz  ba_bkmix-ba_bmix-1
        db      DEF_BMIX_LINE

        .errnz  la_usType-la_ba.ba_bkmix-1
        dw      DEF_LINE_TYPE

        .errnz  la_bError-la_usType-2
        db      DEF_LINE_ERROR

        .errnz  la_bMask-la_bError-1
        db      DEF_LINE_MASK

        .errnz  la_bStepX-la_bMask-1
        db      DEF_LINE_STEP_X

        .errnz  la_bStepY-la_bStepX-1
        db      DEF_LINE_STEP_Y

        .errnz  la_sWidth-la_bStepY-1
        dw      LINEWIDTH_DEFAULT

;/*
;**  Start of character attributes
;*/

        .errnz  ddc_ca-ddc_la.la_sWidth-2
        .errnz  ca_ba
        .errnz  ba_clr
        dd      DEF_LOG_FORE_CLR

        .errnz  ba_clrBack-ba_clr-4
        dd      DEF_LOG_BACK_CLR

        .errnz  ba_ipc-ba_clrBack-4
        dw      DEF_IPC_FORE_CLR

        .errnz  ba_ipcBack-ba_ipc-2
        dw      DEF_IPC_BACK_CLR

        .errnz  ba_bReserved-ba_ipcBack-2
        db      0

        .errnz  ba_fb-ba_bReserved-1
        db      DEF_FB_CHAR

        .errnz  ba_bmix-ba_fb-1
        db      DEF_FMIX_CHAR

        .errnz  ba_bkmix-ba_bmix-1
        db      DEF_BMIX_CHAR

        .errnz  ca_pFont-ca_ba.ba_bkmix-1
        dd      INVALID_ADDRESS                 ;To cause GP fault

        .errnz  ca_paus-ca_pFont-4
        dd      INVALID_ADDRESS

        .errnz  ca_fs-ca_paus-4
        dw      DEF_FONT_FS_FLAGS

        .errnz  ca_cExtraPels-ca_fs-2
        dw      0

        .errnz  ca_idCodePage-ca_cExtraPels-2
        dw      DEFAULTVIOCODEPAGE

        .errnz  ca_usTextAlign-ca_idCodePage-2
        dw      101h

        .errnz  ca_fxExtra-ca_usTextAlign-2
        dd      0

        .errnz  ca_fxBreakExtra-ca_fxExtra-4
        dd      0

;/*
;**  Start of marker attributes
;*/

        .errnz  ddc_ma-ddc_ca.ca_fxBreakExtra-4
        .errnz  ma_ba
        .errnz  ba_clr
        dd      DEF_LOG_FORE_CLR

        .errnz  ba_clrBack-ba_clr-4
        dd      DEF_LOG_BACK_CLR

        .errnz  ba_ipc-ba_clrBack-4
        dw      DEF_IPC_FORE_CLR

        .errnz  ba_ipcBack-ba_ipc-2
        dw      DEF_IPC_BACK_CLR

        .errnz  ba_bReserved-ba_ipcBack-2
        db      0

        .errnz  ba_fb-ba_bReserved-1
        db      DEF_FB_MARKER

        .errnz  ba_bmix-ba_fb-1
        db      DEF_FMIX_MARKER

        .errnz  ba_bkmix-ba_bmix-1
        db      DEF_BMIX_MARKER

        .errnz  ma_pFont-ma_ba.ba_bkmix-1
        dd      INVALID_ADDRESS                 ;To cause GP fault

        .errnz  ma_paus-ma_pFont-4
        dd      INVALID_ADDRESS

        .errnz  ma_fs-ma_paus-4
        dw      DEF_MARKER_FS_FLAGS

        .errnz  ma_ch-ma_fs-2
        db      DEF_MARKER_CODE_POINT

        .errnz  ma_fb-ma_ch-1
        db      DEF_MARKER_FB_FLAGS

;/*
;**  end of the attributes
;*/

        .errnz  ddc_fbBelow-ddc_ma.ma_fb-1
        db      0

        .errnz  ddc_fbClrTbl-ddc_fbBelow-1
        db      DDC_DITHER

        .errnz  ddc_iSysClr-ddc_fbClrTbl-1
        dw      0                       ;Altered as system colors change

        .errnz  ddc_npddcPrev-ddc_iSysClr-2
        dw      INVALID_ADDRESS

        .errnz  ddc_cLevel-ddc_npddcPrev-2
        dw      1

        .errnz  ddc_pClrTbl-ddc_cLevel-2
        dd      ctDefault

ifdef PALMGR
        .errnz  ddc_npdevpal-ddc_pClrTbl-4
        dw      0

        .errnz  (size DDC)-ddc_npdevpal-2
else
        .errnz  (size DDC)-ddc_pClrTbl-4
endif

        even
        public  rddcInit
rddcInit equ    this byte

        .errnz  rddc_usId
        dw      RDDC_IDENT

        .errnz  rddc_npddc-rddc_usId-2
        dw      INVALID_ADDRESS

        .errnz  rddc_ptsOrg-rddc_npddc-2
        db      (size POINTS) dup (0)

        .errnz  rddc_arcsClip-rddc_ptsOrg-(size POINTS)
        dw      0,0,SCREEN_CX,SCREEN_CY
        .errnz  size RECTS - 8
        db      ((NUM_CLIP_RECTS-1) * (size RECTS)) dup (0)

        .errnz  rddc_rcsUsrBound-rddc_arcsClip-(NUM_CLIP_RECTS * (size RECTS))
        .errnz  rcs_pts1.pts_x
        dw      MAXSHORT
        .errnz  rcs_pts1.pts_y-rcs_pts1.pts_x-2
        dw      MAXSHORT
        .errnz  rcs_pts2.pts_x-rcs_pts1.pts_y-2
        dw      MINSHORT
        .errnz  rcs_pts2.pts_y-rcs_pts2.pts_x-2
        dw      MINSHORT

        .errnz  rddc_ptlWorldPos-rddc_rcsUsrBound-(size RECTS)
        db      (size POINTL) dup (0)

        .errnz  rddc_ptsCurPos-rddc_ptlWorldPos-(size POINTL)
        db      (size POINTS) dup (0)

        .errnz  rddc_rclGpiBound-rddc_ptsCurPos-(size POINTS)
        .errnz  rcl_xLeft
        dd      MAX_COORDINATE
        .errnz  rcl_yBottom-4
        dd      MAX_COORDINATE
        .errnz  rcl_xRight-8
        dd      MIN_COORDINATE
        .errnz  rcl_yTop-12
        dd      MIN_COORDINATE

        .errnz  rddc_rclPick-rddc_rclGpiBound-(size RECTL)
        db      (size RECTL) dup (0)

        .errnz  rddc_rcsCorr-rddc_rclPick-(size RECTL)
        db      (size RECTS) dup (0)

        .errnz  (size RDDC)-rddc_rcsCorr-(size RECTS)

 ;/*
; ** sdScreen is the definition for the display adapter's surface.  The
;**  fields of the surface definition may change at initialization time
;**  based on the display adapter attached.
;*/

        even
         public sdScreen
sdScreen equ    this byte

        .errnz  sd_usId
        .errnz  ddc_usId
        dw      SURFACE_IDENT

        .errnz  sd_npsd-sd_usId-2
        .errnz  sd_npsd-ddc_npsd
        dw      sdScreen

        .errnz  sd_fb-sd_npsd-2
        db      SCREEN_SDFB

        .errnz  sd_fbAccel-sd_fb-1
        db      0

        .errnz  sd_cx-sd_fbAccel-1
        dw      SCREEN_CX

        .errnz  sd_cy-sd_cx-2
        dw      SCREEN_CY

        .errnz  sd_cbScan-sd_cy-2
        dw      SCREEN_CBSCAN

        .errnz  sd_dScan-sd_cbScan-2
        dw      SCREEN_DSCAN

        .errnz  sd_cbFill-sd_dScan-2
        dw      0

        .errnz  sd_cySeg-sd_cbFill-2
        dw      0

        .errnz  sd_selIncr-sd_cySeg-2
        dw      010h                    ;!!! Magic distance between GDT
                                        ;!!! selectors

        .errnz  sd_pBits-sd_selIncr-2
        dw      0,INVALID_SEL

        .errnz  (size SURFACE)-sd_pBits-4


;/*
;**  sdIC is the definition for the display adapter's surface when an IC
;**  fis created.  The dimensions, color attributes and such really don't
;**  matter for an info context.
;**
;**  IC's now have a non-zero sd_cx, sd_cy for correlation in bitblt
;*/


        even
        public  sdIC
sdIC    equ     this byte

        .errnz  sd_usId
        .errnz  sd_usId-ddc_usId
        dw      SURFACE_IDENT

        .errnz  sd_npsd-sd_usId-2
        .errnz  sd_npsd-ddc_npsd
        dw      sdIC

        .errnz  sd_fb-sd_npsd-2
        db      IC_SDFB

        .errnz  sd_fbAccel-sd_fb-1
        db      0

        .errnz  sd_cx-sd_fbAccel-1
        dw      SCREEN_CX

        .errnz  sd_cy-sd_cx-2
        dw      SCREEN_CY

        .errnz  sd_cbScan-sd_cy-2
        dw      0

        .errnz  sd_dScan-sd_cbScan-2
        dw      0

        .errnz  sd_cbFill-sd_dScan-2
        dw      0

        .errnz  sd_cySeg-sd_cbFill-2
        dw      0

        .errnz  sd_selIncr-sd_cySeg-2
        dw      0

        .errnz  sd_pBits-sd_selIncr-2
        dw      0,INVALID_SEL

        .errnz  (size SURFACE)-sd_pBits-4


;/*
;**  Define the GetScreenSelector parameter block.  The device specific
;**  initialization must fill this structure in.  The structure size will
;**  be set to zero to show no selector needed.  This will force the
;**  drivers which need a selector to initialize gsspScreen
;*/

                public  gsspScreen
gsspScreen      GSSP    <0,,,>          ;Get Screen Selector Parameters

;/*
;**   Define the pointers to the BMC structures used by CreateBitmap.
;**   They may change at initialization time if the device chooses.  The
;**   segment portion of the pointers must be _TEXT.
;**  
;**   The default values of these pointers will be for an EGA\VGA.
;**  
;**   The VioSetMode call also uses the cBitCount field for the number
;**   of color bits, taken from npbmcDev.
;*/

        even
ifdef PP8
globalW npbmcDev,bmc8Pixel1Plane        ;Device's bitmap format
globalW npbmcMono,bmc1Pixel1Plane       ;Mono     bitmap format
globalW npbmcColor,bmc8Pixel1Plane      ;Color    bitmap format
else
globalW npbmcDev,bmc1Pixel4Plane        ;Device's bitmap format
globalW npbmcMono,bmc1Pixel1Plane       ;Mono     bitmap format
globalW npbmcColor,bmc1Pixel4Plane      ;Color    bitmap format
endif ;PP8

;/*
;**    Define the DosGetResource parameters for the default marker and font.
;**    The may be changed at load time if a different resolution or .ini
;**    entry specifies a different font.
;**   
;**    The fr_hModule field must be initialized at load time.  It will be
;**    set to -1 here to hopefully cause an error.
;**   
;**    The defaults will be set for the lower resolution font and marker,
;**    which should also be correct if only one font is available.
;*/

        even
globalW cResource,cResources
        errnz    $-cResource-2          ;Must follow the resource count!

        public  defFontChar,defFontMarker

defFontChar     equ     this byte
        FONT_RES <ddcInit.ddc_ca.ca_pFont,-1,RT_OUR_FONT,RES_ID_LOWER>

defFontMarker   equ     this byte
        FONT_RES <ddcInit.ddc_ma.ma_pFont,-1,RT_OUR_MARKER,RES_ID_LOWER>


ifdef PP8      ; set for 8514/A only
;/*
;*/
        FONT_RES <Cell6x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+11>
        FONT_RES <Cell6x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+13>
        FONT_RES <Cell7x15.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+15>
        FONT_RES <Cell7x25.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+25>
        FONT_RES <Cell8x8.cf_ptr, -1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+8>
        FONT_RES <Cell8x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+10>
        FONT_RES <Cell8x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+12>
        FONT_RES <Cell8x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+14>
        FONT_RES <Cell8x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+17>
        FONT_RES <Cell8x18.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+18>
        FONT_RES <Cell10x18.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+19>
        FONT_RES <Cell12x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+16>
        FONT_RES <Cell12x20.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+20>
        FONT_RES <Cell12x22.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+22>
        FONT_RES <Cell12x30.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+30>

else ; not a 8514/A
ifdef VGA

        FONT_RES <Cell5x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+13>
        FONT_RES <Cell5x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+17>
        FONT_RES <Cell6x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+11>
        FONT_RES <Cell6x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+15>
        FONT_RES <Cell8x8.cf_ptr, -1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+8>
        FONT_RES <Cell8x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+10>
        FONT_RES <Cell8x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+12>
        FONT_RES <Cell8x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+14>
        FONT_RES <Cell8x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+16>
        FONT_RES <Cell8x18.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+18>

else                      ; not a VGA or 8514/A
ifdef CGA

        FONT_RES <Cell8x8.cf_ptr, -1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+8>
        FONT_RES <Cell8x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+10>

else                      ; not a CGA, VGA or 8514/A, assume EGA

        FONT_RES <Cell8x8.cf_ptr, -1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+8>
        FONT_RES <Cell8x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+10>
        FONT_RES <Cell8x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+12>
        FONT_RES <Cell8x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+14>
        FONT_RES <Cell8x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+16>

endif     ; CGA
endif     ; VGA
endif     ; PP8

cResources      equ     ($-cResource-2) / size FONT_RES

;/*
;**  Define the pointers to the mix mode mapping tables.  These tables will
;**  be used to map incoming mix modes into the mix modes (or indicies) for
;**  the particular attribute.
;** 
;**  Most of the pointers will point to the same table, under the assumption
;**  that the mix modes supported will be consistant across all attributes.
;**  If this isn't the case, the pointer to the tables can be changed to
;**  point elsewhere into the DS.  No extra tables will be reserved in the
;**  DS since we don't expect the default to change dynamically.
;*/

        even

        public  anpabForeMix
anpabForeMix    label   word
        dw      abMixMapLine
        .errnz  PRIM_LINE-1
        dw      abMixMapChar
        .errnz  PRIM_CHAR-2
        dw      abMixMapMarker
        .errnz  PRIM_MARKER-3
        dw      abMixMapPattern
        .errnz  PRIM_AREA-4
        dw      abMixMapImage
        .errnz  PRIM_IMAGE-5

        public  anpabBackMix
anpabBackMix    label   word
        dw      abBackMixMapLine
        .errnz  PRIM_LINE-1
        dw      abBackMixMapChar
        .errnz  PRIM_CHAR-2
        dw      abBackMixMapMarker
        .errnz  PRIM_MARKER-3
        dw      abBackMixMapPattern
        .errnz  PRIM_AREA-4
        dw      abBackMixMapImage
        .errnz  PRIM_IMAGE-5


;/*
;** Mix mode mapping table.  The mix modes will be mapped into the old
;** ndows Rop2 indicies.  There are some nice properties of the rops in
;** is ordering, including the fact that the second half of the rop table
;**  the inverse of the first half.
;*/

        public  abMixMapPattern
abMixMapPattern equ     this byte
abMixMapLine      equ     this byte

        db      ROP_DPO                 ;OR
        .errnz  FM_OR-1
        db      ROP_P                   ;Overpaint
        .errnz  FM_OVERPAINT-2
        db      ROP_D                   ;Underpaint
        .errnz  3-3
        db      ROP_DPX                 ;XOR
        .errnz  FM_XOR-4
        db      ROP_D                   ;Leave Alone
        .errnz  FM_LEAVEALONE-5
        db      ROP_DPA                 ;AND
        .errnz  FM_AND-6
        db      ROP_DPNA                ;(NOT source) AND dest
        .errnz  FM_SUBTRACT-7
        db      ROP_PDNA                ;source AND (NOT dest)
        .errnz  FM_MASKSRCNOT-8
        db      ROP_DDX                 ;All Zeros
        .errnz  FM_ZERO-9
        db      ROP_DPON                ;NOT (source OR dest)
        .errnz  FM_NOTMERGESRC-10
        db      ROP_DPXN                ;NOT (source XOR dest)
        .errnz  FM_NOTXORSRC-11
        db      ROP_DN                  ;NOT dest
        .errnz  FM_INVERT-12
        db      ROP_PDNO                ;source OR (NOT dest)
        .errnz  FM_MERGESRCNOT-13
        db      ROP_PN                  ;NOT source
        .errnz  FM_NOTCOPYSRC-14
        db      ROP_DPNO                ;(NOT source) OR dest
        .errnz  FM_MERGENOTSRC-15
        db      ROP_DPAN                ;NOT (source AND dest)
        .errnz  FM_NOTMASKSRC-16
        db      ROP_DDXN                ;All Ones
        .errnz  FM_ONE-17


;/*
;**  Image Mix mode mapping table.  The mix modes will be mapped into the
;**  equivalent bitblt mixes.  These will then be used by ImageData to call
;**  bitblt.
;*/

abMixMapImage   equ     this byte

        db      BB_ROP_DSo              ; OR
        .errnz  FM_OR-1
        db      BB_ROP_S                ; Overpaint
        .errnz  FM_OVERPAINT-2
        db      BB_ROP_S                ; Underpaint
        .errnz  3-3
        db      BB_ROP_DSx              ; XOR
        .errnz  FM_XOR-4
        db      BB_ROP_D                ; Leave Alone
        .errnz  FM_LEAVEALONE-5
        db      BB_ROP_DSa              ; AND
        .errnz  FM_AND-6
        db      BB_ROP_DSna             ; (NOT source) AND dest
        .errnz  FM_SUBTRACT-7
        db      BB_ROP_SDna             ; source AND (NOT dest)
        .errnz  FM_MASKSRCNOT-8
        db      BB_ROP_DDx              ; All Zeros
        .errnz  FM_ZERO-9
        db      BB_ROP_DSon             ; NOT (source OR dest)
        .errnz  FM_NOTMERGESRC-10
        db      BB_ROP_DSxn             ; NOT (source XOR dest)
        .errnz  FM_NOTXORSRC-11
        db      BB_ROP_Dn               ; NOT dest
        .errnz  FM_INVERT-12
        db      BB_ROP_SDno             ; source OR (NOT dest)
        .errnz  FM_MERGESRCNOT-13
        db      BB_ROP_Sn               ; NOT source
        .errnz  FM_NOTCOPYSRC-14
        db      BB_ROP_DSno             ; (NOT source) OR dest
        .errnz  FM_MERGENOTSRC-15
        db      BB_ROP_DSan             ; NOT (source AND dest)
        .errnz  FM_NOTMASKSRC-16
        db      BB_ROP_DDxn             ; All Ones
        .errnz  FM_ONE-17

        public  abAdjMixMapImage
abAdjMixMapImage        equ     this byte

        db      -1                      ; 
        db      BB_ROP_SDna             ; ROP_DSon <-> ROP_SDna
        db      BB_ROP_DSa              ; ROP_DSna <-> ROP_DSa
        db      BB_ROP_S                ; ROP_Sn   <-> ROP_S
        db      BB_ROP_DSon             ; ROP_SDna <-> ROP_DSon
        db      -1                      ; 
        db      BB_ROP_DSxn             ; ROP_DSx  <-> ROP_DSxn
        db      BB_ROP_SDno             ; ROP_DSan <-> ROP_SDno
        db      BB_ROP_DSna             ; ROP_DSa  <-> ROP_DSna
        db      BB_ROP_DSx              ; ROP_DSxn <-> ROP_DSx
        db      -1                      ; 
        db      BB_ROP_DSo              ; ROP_DSon <-> ROP_SDna
        db      BB_ROP_Sn               ; ROP_S    <-> ROP_Sn
        db      BB_ROP_DSan             ; ROP_SDno <-> ROP_DSan
        db      BB_ROP_DSno             ; ROP_DSno <-> ROP_DSo


;/*
;**  A Mix mode mapping table.  The mix modes will be mapped into the
;**  minimal mix modes required of the display driver for characters.


abMixMapChar    equ     this byte
abMixMapMarker  equ     this byte

        db      CHAR_ROP_DPO            ;OR
        .errnz  FM_OR-1
        db      CHAR_ROP_P              ;Overpaint
        .errnz  FM_OVERPAINT-2
        db      CHAR_ROP_P              ;Underpaint
        .errnz  3-3
        db      CHAR_ROP_DPX            ;XOR
        .errnz  FM_XOR-4
        db      CHAR_ROP_D              ;Leave Alone
        .errnz  FM_LEAVEALONE-5
        db      CHAR_ROP_P              ;AND
        .errnz  FM_AND-6
        db      CHAR_ROP_P              ;(NOT source) AND dest
        .errnz  FM_SUBTRACT-7
        db      CHAR_ROP_P              ;source AND (NOT dest)
        .errnz  FM_MASKSRCNOT-8
        db      CHAR_ROP_P              ;All Zeros
        .errnz  FM_ZERO-9
        db      CHAR_ROP_P              ;NOT (source OR dest)
        .errnz  FM_NOTMERGESRC-10
        db      CHAR_ROP_P              ;NOT (source XOR dest)
        .errnz  FM_NOTXORSRC-11
        db      CHAR_ROP_P              ;NOT dest
        .errnz  FM_INVERT-12
        db      CHAR_ROP_P              ;source OR (NOT dest)
        .errnz  FM_MERGESRCNOT-13
        db      CHAR_ROP_P              ;NOT source
        .errnz  FM_NOTCOPYSRC-14
        db      CHAR_ROP_P              ;(NOT source) OR dest
        .errnz  FM_MERGENOTSRC-15
        db      CHAR_ROP_P              ;NOT (source AND dest)
        .errnz  FM_NOTMASKSRC-16
        db      CHAR_ROP_P              ;All Ones
        .errnz  FM_ONE-17


;/*
;**  A Background mix mode mapping table.  The background mix modes will be
;**  mapped into the old         Rop2 indicies.  There are some nice
;**  properties of the rops in this ordering, including the fact that the
;**  second half of the rop table is the inverse of the first half.
;*/

        public  abMixMapPattern
abBackMixMapPattern     equ     this byte
abBackMixMapLine        equ     this byte

        db      ROP_DPO                 ;OR
        .errnz  BM_OR-1
        db      ROP_P                   ;Overpaint
        .errnz  BM_OVERPAINT-2
        db      ROP_D                   ;Underpaint
        .errnz  3-3
        db      ROP_DPX                 ;XOR
        .errnz  BM_XOR-4
        db      ROP_D                   ;Leave Alone
        .errnz  BM_LEAVEALONE-5
        db      ROP_DPA                 ;AND
        .errnz  BM_AND-6
        db      ROP_DPNA                ;(NOT source) AND dest
        .errnz  BM_SUBTRACT-7
        db      ROP_PDNA                ;source AND (NOT dest)
        .errnz  BM_MASKSRCNOT-8
        db      ROP_DDX                 ;All Zeros
        .errnz  BM_ZERO-9
        db      ROP_DPON                ;NOT (source OR dest)
        .errnz  BM_NOTMERGESRC-10
        db      ROP_DPXN                ;NOT (source XOR dest)
        .errnz  BM_NOTXORSRC-11
        db      ROP_DN                  ;NOT dest
        .errnz  BM_INVERT-12
        db      ROP_PDNO                ;source OR (NOT dest)
        .errnz  BM_MERGESRCNOT-13
        db      ROP_PN                  ;NOT source
        .errnz  BM_NOTCOPYSRC-14
        db      ROP_DPNO                ;(NOT source) OR dest
        .errnz  BM_MERGENOTSRC-15
        db      ROP_DPAN                ;NOT (source AND dest)
        .errnz  BM_NOTMASKSRC-16
        db      ROP_DDXN                ;All Ones
        .errnz  BM_ONE-17


abBackMixMapImage       equ     this byte
abBackMixMapChar        equ     this byte
abBackMixMapMarker      equ     this byte

        db      BA_IS_XPARENT           ;OR
        .errnz  BM_OR-1
        db      BA_IS_OPAQUE            ;Overpaint
        .errnz  BM_OVERPAINT-2
        db      BA_IS_XPARENT           ;Reserved (Underpaint)
        .errnz  3-3
        db      BA_IS_XPARENT           ;Transparent
        .errnz  BM_XOR-4
        db      BA_IS_XPARENT           ;Leave alone
        .errnz  BM_LEAVEALONE-5
        db      BA_IS_XPARENT           ;AND
        .errnz  BM_AND-6
        db      BA_IS_XPARENT           ;(NOT source) AND dest
        .errnz  BM_SUBTRACT-7
        db      BA_IS_XPARENT           ;source AND (NOT dest)
        .errnz  BM_MASKSRCNOT-8
        db      BA_IS_XPARENT           ;All Zeros
        .errnz  BM_ZERO-9
        db      BA_IS_XPARENT           ;NOT (source OR dest)
        .errnz  BM_NOTMERGESRC-10
        db      BA_IS_XPARENT           ;NOT (source XOR dest)
        .errnz  BM_NOTXORSRC-11
        db      BA_IS_XPARENT           ;NOT dest
        .errnz  BM_INVERT-12
        db      BA_IS_XPARENT           ;source OR (NOT dest)
        .errnz  BM_MERGESRCNOT-13
        db      BA_IS_XPARENT           ;NOT source
        .errnz  BM_NOTCOPYSRC-14
        db      BA_IS_XPARENT           ;(NOT source) OR dest
        .errnz  BM_MERGENOTSRC-15
        db      BA_IS_XPARENT           ;NOT (source AND dest)
        .errnz  BM_NOTMASKSRC-16
        db      BA_IS_XPARENT           ;All Ones
        .errnz  BM_ONE-17


;/*
;**  The display and adapter types are filled in by VioGetConfig in
;**  one_time_init
;**  bVGAtype will be VGA_EXPRESSWAY only if it is an EXPRESSWAY adapter
;**  which in a few cases is not fully compatible
;*/

globalW wAdapter,0
globalW wDisplay,0
globalW wSVGAtype,0

globalB bVGAtype,0

;/*
;**    The following is data added to support sharing of off-screen memory
;**    and the video controller between the PM display driver and the video
;**    driver for MVDM.
;**   
;**    fControllerOwned and fControllerNotify are flags managed jointly by
;**    display driver and video driver;  fControllerMine, on the other hand,
;**    is set only when fControllerOwned has been set by the display driver.
;**   
;**    fbOffScreen contains bits describing availability and use of off-
;**    screen memory.  If the video driver is loaded, we rely on it for
;**    allocation/deallocation of off-screen memory;  otherwise, we are on
;**    our own (just like in the good ol' days of 1.1 and 1.2).
;**   
;**    pOffScreenUsed holds the address of off-screen memory currently
;**    in use, and nbOffScreenUsed is the size of that memory (in number of
;**    contiguous bytes).  If the display driver ever supports multiple clients
;**    of off-screen memory, then it can link blocks of off-screen memory
;**    together either with a separate linked list, or by storing links and
;**    owner IDs in the blocks themselves.
;**   
;**    The address kept in pOffScreenUsed is actually an offset from the top
;**    of physical VRAM, and must be combined with an appropriate physical
;**    VRAM selector/alias before it can be dereferenced.
;**   
;**    lnbTotalScreenSize is a dword count of the total number of bytes of memory
;**    installed on the adapter, divided by the maximum number of planes, to
;**    yield the total amount of multi-plane memory available.  For a 256k EGA
;**    or VGA, this would be 64k (65536D aka 10000h).
;*/

        align 4
globalD hVideoVDD,0
globalB fbOffScreen,0
globalD lnbTotalScreenSize,0

        IFNDEF  PP8
globalB fControllerMine,0
globalD pOffScreenUsed,0
globalD pOffScreenScan,0
globalW yOffScreenScan,0
globalW nbOffScreenUsed,0
        ELSE
reserved_latches    equ 0
fbShadowFlags       equ 0
fControllerOwned    equ 0
fControllerNotify   equ 0
shadow_size         equ 0
shadow_data         equ 0
        ENDIF   ;!PP8

        IFNDEF  CGA     ;this is required for EGA/VGA/8514 drivers only
        public   drqVideo
        drqVideo vvdrq_s <0A0000h,\
                          0FFFFFFFFh,\
                          reserved_latches,\
                          fbShadowFlags,\
                          fControllerOwned,\
                          fControllerNotify,\
                          shadow_size,\
                          shadow_data>
        ENDIF ;!CGA

;ifdef BITMAP_LIMIT
globalW usNumBitmapHeaders ,0
globalW fsEngineWarned,0
;endif

sEnd    Data

;/*
;**  Cache data segment
;*/

sBegin  Cache
Filler  DW  0
sEnd


;/*
;**  Each code segment will have a word in it which is the selector for
;**  DataBASE.  The name of the word will be of the form LogicalName&Data
;**  where logical name is the logical name given to the segment when it
;**  was created with the createSeg macro.
;*/

sBegin  Code
globalW CodeData,DataBASE
globalW MyPtrCodeData,PtrDataBASE
globalW MyCmplCodeData,CompileCodeDataBASE
globalW CacheData,CacheBASE
sEnd    Code

sBegin  BitBlt
globalW BitBltData,DataBASE
globalW MyPtrBitBltData,PtrDataBASE
globalW MyCmplBitBltData,CompileCodeDataBASE
sEnd    BitBlt

sBegin  FarCode
globalW FarCodeData,DataBASE
sEnd    FarCode

sBegin  BlueMoon

ifdef POINTERDATA
globalW MyPtrBlueMoonData,PtrDataBASE
endif ;POINTERDATA

globalW BlueMoonData,DataBASE
sEnd    BlueMoon

sBegin  Bitmap
ifdef POINTERDATA
globalW MyPtrBitmapData,PtrDataBASE
endif ;POINTERDATA

globalW BitmapData,DataBASE
sEnd    Bitmap

sBegin  VioSeg
globalW MyPtrVioSegData,PtrDataBASE
globalW VioSegData,DataBASE
sEnd    VioSeg

ifdef PALMGR
sBegin  PalSeg
globalW PalSegData,DataBASE
globalW MyPtrPalSegData,PtrDataBASE
globalW MyCmplPalSegData,CompileCodeDataBASE
sEnd    PalSeg
endif ;PALMGR

sBegin  Code

;/*
;**  Define the BMC structures which will be used by the expected
;**  variations of drivers built from these sources.  The structures
;**  are accessed with the npbmc pointers above.
;**
;**  The VioSetMode call also uses the cBitCount field for the number
;**  of color bits.
;*/

        public  bmc1Pixel1Plane
ifdef PP8
else
        public  bmc1Pixel4Plane
endif ;PP8
        public  bmc4Pixel1Plane
        public  bmc8Pixel1Plane

bmc1Pixel1Plane BMC     <((SIZE BITMAPINFOHEADER2)+(  2*(size RGB2))),1,32-1,3,1,0>
ifdef PP8
else
bmc1Pixel4Plane BMC     <((SIZE BITMAPINFOHEADER2)+( 16*(size RGB2))),4,32-1,3,4,SD_COLOR>
endif ;PP8
bmc4Pixel1Plane BMC     <((SIZE BITMAPINFOHEADER2)+( 16*(size RGB2))),4, 8-1,1,1,SD_COLOR>
bmc8Pixel1Plane BMC     <((SIZE BITMAPINFOHEADER2)+(256*(size RGB2))),8, 4-1,0,1,SD_COLOR>

        even


sEnd    Code

end
