;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CURSORS.INC
;*
;* DESCRIPTIVE NAME = defines for CURSORS.ASM and CURSORSC.ASM
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/22/88
;*
;* DESCRIPTION  Common symbols and structures for CURSORS.ASM and CURSORSC.ASM
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/22/88                     Robert J. Carragher [t-robc]  Created
;*****************************************************************************/


        .xlist
        include cmacros.inc
INCL_GRE_BITMAPS        equ                      1
INCL_WINPOINTERS        equ                      1
        include pmgre.inc
DINCL_BITMAP            equ                      1
        include driver.inc
ifdef TIMER_CURSORS
        include tefti.mac
endif
        .list
        .286p

        ??_out  Cursors

        errcode <INV_COORDINATE,INV_CURSOR_BITMAP>

        externA PTR_ROUND_LEFT                    ;Used to round left  exclude X down
        externA PTR_ROUND_RIGHT                   ;Used to round right exclude X up
        externA PTR_HEIGHT                        ;Height we expect pointer to be
        externA PTR_WIDTH_BITS                    ;Width we expect pointer to be

        externNP enter_driver                     ;Screen driver semaphore operations
        externNP leave_driver

        externNP pointer_off                      ;Remove pointer from the screen
        externNP move_pointers                    ;Move pointer data structure
        externNP draw_pointer                     ;Draw the pointer

ifdef TIMER_CURSORS

        ebuf    struc
        eb_x    dw      ?
        eb_y    dw      ?
        eb_cms  dw      ?
        ebuf    ends

        CCEB    equ     800
endif

;/*
;** The next 2 symbols are used with "ptr_flags", defined in CURSORSC.ASM
;*/

PTR_OFF         equ     10000000b                ;Null pointer has been specified
PTR_EXCLUDED    equ     01000000b                ;Pointer has been excluded
PTR_REDRAW      equ     00100000b                ;Pointer needs to be updated
                                                 ;  but may not be currently excluded

;/*
;** The next 2 symbols are used with "exclude_count", defined in CURSORSC.ASM
;*/

RECT_PRES       equ     1                         ;  Exclusion rectangle set
RECT_NOT_PRES   equ     0                         ;  No exclusion rectangle set


PTRI_ANIMATE    equ     2                         ;Pointer is to be animated
