;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
         page        ,132
;/****************************************************************************
;*
;* SOURCE FILE NAME = CMPLCODE.ASM
;*
;* DESCRIPTIVE NAME = Contains the definition of the compile code data segment. 
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/23/87
;*
;* DESCRIPTION  The driver has the need to maintain per process information        
;*              such as a Screen Selector, CS Alias, and a shared segment          
;*              where bitblt can compile code into and execute from.  Other        
;*              information, as determined may also be needed on a per
;*              process basis.
;*              This file and CMPLCODE.INC must be kept synchronized!              
;*
;* FUNCTIONS    Public: proc_stack_area
;*                      proc_initial_sp             
;*                      proc_old_stack 
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/23/87                     Walt Moore [waltm] - Created
;*   08/14/90                     Viroon Touranachun [viroont]
;*                                  Switched from Instance Data Segment 
;*                                  to Compile Code segment.
;*****************************************************************************/

.286p

        .xlist
        include cmacros.inc
INCL_DEV        equ        1
        include        pmgre.inc
DINCL_VIO        equ        1
        include driver.inc
        .list

        ??_out  cmplcode

        public        selCompileData
        public        selCompileCode

        public  asDDARun

        IFNDEF CGA        ;this is required for EGA/VGA drivers only
        IFNDEF PP8
        public  asPlaneBuff
        ENDIF ;!PP8
        ENDIF ;!CGA

        public        proc_stack_area
        public        proc_initial_sp
        public        proc_old_stack
        public        INSTANCE_STACK_WORDS
        public        INSTANCE_GROW_SIZE

;/*
;**      INITIAL_STACK_SIZE is the amount of space required as long as
;**      we're not compiling onto the stack.
;**      CBLT_STACK_SIZE is the amount of space required for the largest
;**      generated bitblt, plus any working stack space
;**      !!! Eventually INITIAL_STACK_SIZE should be 256, and
;**      INITIAL_STACK_SIZE  256 !!!
;*/

INITIAL_STACK_SIZE      equ        1024
CBLT_STACK_SIZE         equ        1024

INSTANCE_STACK_WORDS    equ        CBLT_STACK_SIZE/2

sBegin  CompileCodeData

;/*
;**     asDDARun is a static array of word-size number that records the
;**     horizontal DDA runlength when a stretch/compressBlt is performed
;**     in the display driver level
;*/
 
        IFDEF  PP8
SCREEN_WIDTH    equ     1024                    ; 8514's screen width (in pels)
        ELSE
SCREEN_WIDTH    equ     640                     ; other screen width (in pels)
        ENDIF ;PP8

asDDARun        dw      SCREEN_WIDTH    dup (?)

;/*
;**     asPlaneBuff is three array of bytes to record the plane 1,2 and 3
;**     of the stretched/compressed bitmap. This is required for EGA/VGA
;**     drivers only.
;*/
   

        IFNDEF CGA
        IFNDEF PP8
asPlaneBuff     dw      SCREEN_WIDTH/8*3    dup (?); 3*screen width (in bytes)
        ENDIF ;!PP8
        ENDIF ;!CGA

;/*
;**      proc_stack_area is where bitblt will compile it's code into.
;**      The area must be big enough for the largest generated bitblt,
;**      plus all frame variables.  Room must also be left for the
;**      return address and any pushes which may occur.
;**      !!! This stack is used by StrBlt and CBlt. Currently both assume
;**      that the stack is at the BEGINNING of the segment, but if we're
;**      going to realloc it, then it must be at the end. !!!
;*/


proc_stack_area db        INITIAL_STACK_SIZE dup (?)
proc_initial_sp equ this word

;/*
;**  Define the segment id.  This would normally be in the ident.asm
;**  file, but since we want the define the entire segment in one place,
;**  we'll define it here. We also don't want to overwrite it at some point
;**  with stack data, so it must go beyound the stack area.
;*/

          db        'DISPLAY:_COMPILECODE'
          even

;/*
;**  We have to save the old SS:SP somewhere.  This seems like the best
;**  place to me!
;*/

proc_old_stack        dd        ?

;/*
;** Size to realloc selector to, should we need extra space for CBLT or STRBLT
;** !!! Not yet implemented
;*/

INSTANCE_GROW_SIZE  equ ($ - INITIAL_STACK_SIZE + CBLT_STACK_SIZE)

COMPLCODE_SEG_SIZE  equ $

sEnd    CompileCodeData

sBegin  Data

        selCompileData        dw        _COMPLCODE        ;sel CompileData seg
                        dw      COMPLCODE_SEG_SIZE
        selCompileCode        dw        -1                ;CS alias for CompileData seg

sEnd        Data

end
