;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = TYPEDEFS.INC
;*
;* DESCRIPTIVE NAME = Type Definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/07/91
;*
;* DESCRIPTION  OS/2 Common Definitions file 
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/07/91                     Written by KEZ
;*****************************************************************************/

IFNDEF   OS2DEF_DEFD    ; Don't include if already included

OS2DEF_DEFD EQU 1       ; Indicate it has been included

OS2DEF_INCLUDED EQU 1

;/*
;**  This #ifdef brackets the rest of this entire file.  It is used to include
;**  either the 32-bit or 16-bit base definitions.  No definitions (other than
;**  16/32-bit determination) must be placed above this.
;*/

EXPENTRY TEXTEQU <SYSCALL>
APIENTRY TEXTEQU <SYSCALL>

INCLUDE OS2STD.INC

;/*
;**  XLATON
;*/

SHANDLE TYPEDEF DWORD
LHANDLE TYPEDEF PTR

;/*
;**  XLATOFF
;*/

CHAR    TYPEDEF SBYTE
LONG    TYPEDEF SDWORD

IFNDEF INCL_SAADEFS

endif ; !INCL_SAADEFS

;/*
;**  XLATON
;*/

UCHAR   TYPEDEF BYTE    ; uch
USHORT  TYPEDEF WORD    ; us
ULONG   TYPEDEF DWORD   ; ul
FIXED   TYPEDEF SDWORD

IFNDEF INCL_SAADEFS

UINT    TYPEDEF WORD    ; ui

ENDIF ; !INCL_SAADEFS

PSZ     TYPEDEF PTR BYTE
NPSZ    TYPEDEF PTR BYTE
PCH     TYPEDEF PTR BYTE
NPCH    TYPEDEF PTR BYTE
PFN     TYPEDEF PTR
NPFN    TYPEDEF PTR
PBYTE   TYPEDEF PTR BYTE
NPBYTE  TYPEDEF PTR BYTE
PCHAR   TYPEDEF PTR SBYTE
PSHORT  TYPEDEF PTR SWORD
PLONG   TYPEDEF PTR SDWORD

IFNDEF INCL_SAADEFS

PINT    TYPEDEF PTR SWORD

ENDIF ; !INCL_SAADEFS

PUCHAR  TYPEDEF PTR UCHAR
PUSHORT TYPEDEF PTR USHORT
PULONG  TYPEDEF PTR ULONG

IFNDEF INCL_SAADEFS

PUINT   TYPEDEF PTR UINT

ENDIF ; !INCL_SAADEFS

PVOID   TYPEDEF PTR
PPVOID  TYPEDEF PTR PVOID
;BOOL   TYPEDEF WORD    ; f
BOOL16  TYPEDEF WORD    ; f
BOOL    TYPEDEF DWORD   ; f32
PBOOL   TYPEDEF PTR BOOL
BOOL32  TYPEDEF DWORD   ; f32
PBOOL32 TYPEDEF PTR BOOL32

;/*
;**  Quad-word
;*/

_QWORD2 STRUCT 2t ; qword
   ulLo ULONG  ?
   ulHi ULONG  ?
_QWORD2 ENDS

QWORD2  TYPEDEF _QWORD2
PQWORD2 TYPEDEF PTR QWORD2

;/*
;**  XLATON
;*/

IFNDEF INCL_SAADEFS

SEL     TYPEDEF WORD    ; sel
PSEL    TYPEDEF PTR SEL

ENDIF;  !INCL_SAADEFS

;/*
;** ** Useful Helper Macros
;**  Create untyped far pointer from selector and offset
;**  Extract selector or offset from far pointer
;**  !INCL_SAADEFS
;**  Cast any variable to an instance of the specified type.
;**  Calculate the byte offset of a field in a structure of type type.
;**  Combine l & h to form a 32 bit quantity.
;**  Combine l & h to form a 16 bit quantity.
;**  Extract high and low order parts of 16 and 32 bit quantity
;** ** Common Error definitions ***
;*/

ERRORID  TYPEDEF ULONG       ; errid
PERRORID TYPEDEF PTR ERRORID

;/*
;**  Combine severity and error code to produce ERRORID
;**  Extract error number from an errorid
;**  Extract severity from an errorid
;**  Severity codes
;*/

SEVERITY_NOERROR       EQU 000000000h
SEVERITY_WARNING       EQU 000000004h
SEVERITY_ERROR         EQU 000000008h
SEVERITY_SEVERE        EQU 00000000ch
SEVERITY_UNRECOVERABLE EQU 000000010h

;/*
;**  Base component error values
;*/

WINERR_BASE EQU 000001000h ; Window Manager
GPIERR_BASE EQU 000002000h ; Graphics Presentation Interface
DEVERR_BASE EQU 000003000h ; Device Manager
SPLERR_BASE EQU 000004000h ; Spooler

;/*
;** Common types used across components
;** Common DOS types
;*/


HMODULE TYPEDEF SHANDLE ; hmod
PID     TYPEDEF SHANDLE ; pid
TID     TYPEDEF SHANDLE ; tid

SGID    TYPEDEF USHORT  ; sgid

PHMODULE TYPEDEF PTR HMODULE
PPID     TYPEDEF PTR PID
PTID     TYPEDEF PTR TID

IFNDEF INCL_SAADEFS

HSEM    TYPEDEF PTR      ; hsem
PHSEM   TYPEDEF PTR HSEM

ENDIF  ; !INCL_SAADEFS

;/*
;** Common SUP types
;*/


HAB     TYPEDEF LHANDLE ; hab
PHAB    TYPEDEF PTR HAB

;/*
;** Common GPI/DEV types
;*/


HPS      TYPEDEF LHANDLE     ; hps
PHPS     TYPEDEF PTR HPS
HDC      TYPEDEF LHANDLE     ; hdc
PHDC     TYPEDEF PTR HDC
HRGN     TYPEDEF LHANDLE     ; hrgn
PHRGN    TYPEDEF PTR HRGN
HBITMAP  TYPEDEF LHANDLE     ; hbm
PHBITMAP TYPEDEF PTR HBITMAP
HMF      TYPEDEF LHANDLE     ; hmf
PHMF     TYPEDEF PTR HMF
HPAL     TYPEDEF LHANDLE     ; hpal
PHPAL    TYPEDEF PTR HPAL
COLOR    TYPEDEF SDWORD      ; clr
PCOLOR   TYPEDEF PTR COLOR

_POINTL STRUCT 2t ; ptl
ptl_x   SDWORD ?
ptl_y   SDWORD ?
_POINTL ENDS

PPOINTL  TYPEDEF PTR POINTL
NPPOINTL TYPEDEF PTR POINTL

;/*
;** As we are no longer using the actual POINTS
;** structure as shorts, These are now
;** longs.
;** PLEASE don't change these without talking to me
;** first. ScottL 11-1-91
;*/

_POINTS  STRUCT 2t ; pts
   ptl_x SDWORD ?
   ptl_y SDWORD ?
_POINTS  ENDS

PPOINTS TYPEDEF PTR POINTS

PRECTL  TYPEDEF PTR RECTL
NPRECTL TYPEDEF PTR RECTL
STR8    TYPEDEF SBYTE     ; str8
PSTR8   TYPEDEF PTR STR8

;/*
;**  FDATE and FTIME definitions moved to bsedos.h
;**  FILEFINDBUF definitions moved to bsedos.h
;** common DEV/SPL types
;**  structure for Device Driver data
;*/

_DRIVDATA        STRUCT 2t          ; driv
   cb            SDWORD ?
   lVersion      SDWORD ?
   szDeviceName  SBYTE  32t DUP (?)
   abGeneralData SBYTE  1t DUP (?)
_DRIVDATA        ENDS

PDRIVDATA TYPEDEF PTR DRIVDATA

;/*
;**  array indices for array parameter for DevOpenDC, SplQmOpen or SplQpOpen
;*/

ADDRESS EQU     0t

IFNDEF INCL_SAADEFS

DRIVER_NAME    EQU 1t
DRIVER_DATA    EQU 2t
DATA_TYPE      EQU 3t
COMMENT        EQU 4t
PROC_NAME      EQU 5t
PROC_PARAMS    EQU 6t
SPL_PARAMS     EQU 7t
NETWORK_PARAMS EQU 8t

;/*
;**  structure definition as an alternative of the array parameter
;*/

_DEVOPENSTRUC         STRUCT    2t ; dop
   pszLogAddress      PSZ       ?
   pszDriverName      PSZ       ?
   pdriv              PDRIVDATA ?
   pszDataType        PSZ       ?
   pszComment         PSZ       ?
   pszQueueProcName   PSZ       ?
   pszQueueProcParams PSZ       ?
   pszSpoolerParams   PSZ       ?
   pszNetworkParams   PSZ       ?
_DEVOPENSTRUC         ENDS

PDEVOPENSTRUC TYPEDEF   PTR DEVOPENSTRUC

ENDIF  ;  !INCL_SAADEFS

;/*
;** common AVIO/GPI types
;*/

;/*
;**  values of fsSelection field of FATTRS structure
;*/

FATTR_SEL_ITALIC            EQU 000000001h
FATTR_SEL_UNDERSCORE        EQU 000000002h
FATTR_SEL_OUTLINE           EQU 000000008h
FATTR_SEL_STRIKEOUT         EQU 000000010h
FATTR_SEL_BOLD              EQU 000000020h

;/*
;**  values of fsType field of FATTRS structure
;*/

FATTR_TYPE_KERNING          EQU 000000004h
FATTR_TYPE_MBCS             EQU 000000008h
FATTR_TYPE_DBCS             EQU 000000010h
FATTR_TYPE_ANTIALIASED      EQU 000000020h

;/*
;**  values of fsFontUse field of FATTRS structure
;*/

FATTR_FONTUSE_NOMIX         EQU 000000002h
FATTR_FONTUSE_OUTLINE       EQU 000000004h
FATTR_FONTUSE_TRANSFORMABLE EQU 000000008h

;/*
;**  size for fields in the font structures
;*/

FACESIZE                    EQU 32t

;/*
;**  font struct for Vio/GpiCreateLogFont
;*/

_FATTRS            STRUCT 2t          ; fat
   usRecordLength  USHORT ?
   fsSelection     USHORT ?
   lMatch          SDWORD ?
   szFacename      SBYTE  32t DUP (?)
   idRegistry      USHORT ?
   usCodePage      USHORT ?
   lMaxBaselineExt SDWORD ?
   lAveCharWidth   SDWORD ?
   fsType          USHORT ?
   fsFontUse       USHORT ?
_FATTRS            ENDS

PFATTRS TYPEDEF PTR FATTRS

;/*
;**  values of fsType field of FONTMETRICS structure
;*/

FM_TYPE_FIXED     EQU 000000001h
FM_TYPE_LICENSED  EQU 000000002h
FM_TYPE_KERNING   EQU 000000004h
FM_TYPE_DBCS      EQU 000000010h
FM_TYPE_MBCS      EQU 000000018h
FM_TYPE_64K       EQU 000008000h

;/*
;**  values of fsDefn field of FONTMETRICS structure
;*/

FM_DEFN_OUTLINE   EQU 000000001h
FM_DEFN_IFI       EQU 000000002h
FM_DEFN_WIN       EQU 000000004h
FM_DEFN_GENERIC   EQU 000008000h

;/*
;**  values of fsSelection field of FONTMETRICS structure
;*/

FM_SEL_ITALIC     EQU 000000001h
FM_SEL_UNDERSCORE EQU 000000002h
FM_SEL_NEGATIVE   EQU 000000004h

;/*
;**  Hollow Outline Font
;*/

FM_SEL_OUTLINE    EQU 000000008h
FM_SEL_STRIKEOUT  EQU 000000010h
FM_SEL_BOLD       EQU 000000020h

;/*
;**  values of fsCapabilities field of FONTMETRICS structure
;*/

FM_CAP_NOMIX      EQU 000000001h

;/*
;**  font metrics returned by GpiQueryFonts and others
;*/

_PANOSE          STRUCT 2t         ; panose
bFamilyType      BYTE   ?
bSerifStyle      BYTE   ?
bWeight          BYTE   ?
bProportion      BYTE   ?
bContrast        BYTE   ?
bStrokeVariation BYTE   ?
bArmStyle        BYTE   ?
bLetterform      BYTE   ?
bMidline         BYTE   ?
bXHeight         BYTE   ?
abReserved       BYTE   2t DUP (?)
_PANOSE          ENDS


_FONTMETRICS           STRUCT  2t          ; fm
   szFamilyname        SBYTE   32t DUP (?)
   szFacename          SBYTE   32t DUP (?)
   idRegistry          USHORT  ?
   usCodePage          USHORT  ?
   lEmHeight           SDWORD  ?
   lXHeight            SDWORD  ?
   lMaxAscender        SDWORD  ?
   lMaxDescender       SDWORD  ?
   lLowerCaseAscent    SDWORD  ?
   lLowerCaseDescent   SDWORD  ?
   lInternalLeading    SDWORD  ?
   lExternalLeading    SDWORD  ?
   lAveCharWidth       SDWORD  ?
   lMaxCharInc         SDWORD  ?
   lEmInc              SDWORD  ?
   lMaxBaselineExt     SDWORD  ?
   sCharSlope          SWORD   ?
   sInlineDir          SWORD   ?
   sCharRot            SWORD   ?
   usWeightClass       USHORT  ?
   usWidthClass        USHORT  ?
   sXDeviceRes         SWORD   ?
   sYDeviceRes         SWORD   ?
   sFirstChar          SWORD   ?
   sLastChar           SWORD   ?
   sDefaultChar        SWORD   ?
   sBreakChar          SWORD   ?
   sNominalPointSize   SWORD   ?
   sMinimumPointSize   SWORD   ?
   sMaximumPointSize   SWORD   ?
   fsType              USHORT  ?
   fsDefn              USHORT  ?
   fsSelection         USHORT  ?
   fsCapabilities      USHORT  ?
   lSubscriptXSize     SDWORD  ?
   lSubscriptYSize     SDWORD  ?
   lSubscriptXOffset   SDWORD  ?
   lSubscriptYOffset   SDWORD  ?
   lSuperscriptXSize   SDWORD  ?
   lSuperscriptYSize   SDWORD  ?
   lSuperscriptXOffset SDWORD  ?
   lSuperscriptYOffset SDWORD  ?
   lUnderscoreSize     SDWORD  ?
   lUnderscorePosition SDWORD  ?
   lStrikeoutSize      SDWORD  ?
   lStrikeoutPosition  SDWORD  ?
   sKerningPairs       SWORD   ?
   sFamilyClass        SWORD   ?
   lMatch              SDWORD  ?

IFNDEF PM12
IFNDEF PM20

   panose              _PANOSE <?>

ENDIF ; !PM20

ENDIF ; !PM12

_FONTMETRICS           ENDS

PFONTMETRICS TYPEDEF PTR FONTMETRICS

;/*
;** Common WIN types
;*/

HWND    TYPEDEF LHANDLE ; hwnd
PHWND   TYPEDEF PTR HWND

_WRECT     STRUCT 2t ; wrc
   xLeft   SWORD  ?
   dummy1  SWORD  ?
   yBottom SWORD  ?
   dummy2  SWORD  ?
   xRight  SWORD  ?
   dummy3  SWORD  ?
   yTop    SWORD  ?
   dummy4  SWORD  ?
_WRECT     ENDS

WRECT   TYPEDEF _WRECT
PWRECT  TYPEDEF PTR WRECT
NPWRECT TYPEDEF PTR WRECT

_WPOINT   STRUCT 2t ; wpt
   x      SWORD  ?
   dummy1 SWORD  ?
   y      SWORD  ?
   dummy2 SWORD  ?
_WPOINT   ENDS

WPOINT   TYPEDEF _WPOINT
PWPOINT  TYPEDEF PTR WPOINT
NPWPOINT TYPEDEF PTR WPOINT

;/*
;**  The following #else/#ENDIF corresponds to a #if near the top of this
;**  file.  The next three lines include the 16-bit version of this file,
;**  hence these lines MUST be the last lines in this include file.
;**  not INCL_32
;** End of file e:\toolkt20\c\os2h\os2def.h
;*/

ENDIF ; !OS2DEF_DEFD

;/*
;**  exported Engine DDI functions 
;*/

@SetDriverInfo  TYPEDEF PROTO SYSCALL :ULONG, :LHANDLE, :ULONG, :HDC
SetDriverInfo   PROTO   @SetDriverInfo

@GetDriverInfo  TYPEDEF PROTO SYSCALL :LHANDLE, :ULONG, :HDC
GetDriverInfo   PROTO   @GetDriverInfo

@PostDeviceModes        TYPEDEF PROTO SYSCALL :PDRIVDATA, :PSZ, :PSZ, :PSZ, :ULONG
PostDeviceModes PROTO   @PostDeviceModes

@GreInitialize  TYPEDEF PROTO SYSCALL
GreInitialize   PROTO   @GreInitialize


@Gre32Entry2 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry2  PROTO   @Gre32Entry2

@Gre32Entry3 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry3  PROTO   @Gre32Entry3

@Gre32Entry4 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry4  PROTO   @Gre32Entry4

@Gre32Entry5 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry5  PROTO   @Gre32Entry5

@Gre32Entry6 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry6  PROTO   @Gre32Entry6

@Gre32Entry7 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry7  PROTO   @Gre32Entry7

@Gre32Entry8 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry8  PROTO   @Gre32Entry8

@Gre32Entry9 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry9  PROTO   @Gre32Entry9

@Gre32Entry10 TYPEDEF PROTO SYSCALL :HDC, :VARARG
Gre32Entry10  PROTO   @Gre32Entry10

;/*
;** Memory management
;*/

@proto_60               TYPEDEF         PROTO SYSCALL :PPVOID, :ULONG, :ULONG
DosAllocMem             PROTO           @proto_60

@proto_61               TYPEDEF         PROTO SYSCALL :PVOID
DosFreeMem              PROTO           @proto_61


@proto_64               TYPEDEF         PROTO SYSCALL :PVOID, :ULONG
DosGetSharedMem         PROTO           @proto_64


@proto_66               TYPEDEF         PROTO SYSCALL :PPVOID, :PSZ, :ULONG, :ULONG
DosAllocSharedMem               PROTO           @proto_66


@proto_68               TYPEDEF         PROTO SYSCALL :PVOID, :PPVOID, :ULONG
DosSubAllocMem          PROTO           @proto_68

@proto_69               TYPEDEF         PROTO SYSCALL :PVOID, :PVOID, :ULONG
DosSubFreeMem           PROTO           @proto_69


@proto_70               TYPEDEF         PROTO SYSCALL :PVOID, :ULONG, :ULONG
DosSubSetMem            PROTO           @proto_70


@proto_111              TYPEDEF         PROTO SYSCALL :ULONG, :PULONG, :PULONG
DosQueryCp              PROTO           @proto_111


HVDD            TYPEDEF         LHANDLE

;/*
;**  hvdd
;*/

PHVDD           TYPEDEF         PTR HVDD

;/*
;**  phvdd
;*/

@proto_167              TYPEDEF         PROTO SYSCALL :PSZ, :PHVDD
DosOpenVDD              PROTO           @proto_167

@proto_168              TYPEDEF         PROTO SYSCALL :HVDD, :ULONG, :ULONG, :ULONG, :PVOID, :ULONG, :PVOID
DosRequestVDD           PROTO           @proto_168

@proto_169              TYPEDEF         PROTO SYSCALL :HVDD
DosCloseVDD             PROTO           @proto_169

DosGetResource2 TEXTEQU         <DosGetResource>

;/*
;**  XLATON
;*/

@proto_104              TYPEDEF         PROTO SYSCALL :HMODULE, :ULONG, :ULONG, :PPVOID
DosGetResource          PROTO           @proto_104


@proto_98               TYPEDEF         PROTO SYSCALL :HMODULE
DosFreeModule           PROTO           @proto_98

@proto_97               TYPEDEF         PROTO SYSCALL :PSZ, :ULONG, :PSZ, :PHMODULE
DosLoadModule           PROTO           @proto_97

PCOUNTRYCODE            TYPEDEF         PTR COUNTRYCODE

PCOUNTRYINFO            TYPEDEF         PTR COUNTRYINFO

DosGetCtryInfo          TEXTEQU         <DosQueryCtryInfo>

@proto_107              TYPEDEF         PROTO SYSCALL :ULONG, :PCOUNTRYCODE, :PCOUNTRYINFO, :PULONG
DosQueryCtryInfo                PROTO           @proto_107

PHFILE          TYPEDEF         PTR HFILE

PEAOP2          TYPEDEF         PTR EAOP2

@proto_20               TYPEDEF         PROTO SYSCALL :PSZ, :PHFILE, :PULONG, :ULONG, :ULONG, :ULONG, :ULONG, :DWORD
DosOpen         PROTO           @proto_20

@proto_21               TYPEDEF         PROTO SYSCALL :DWORD
DosClose                PROTO           @proto_21


@proto_6                TYPEDEF         PROTO SYSCALL :PTR PTIB, :PTR PPIB
DosGetInfoBlocks        PROTO           @proto_6

@proto_148              TYPEDEF         PROTO SYSCALL :DWORD, :ULONG, :ULONG, :PVOID, :ULONG, :PULONG, :PVOID, :ULONG, :PULONG
DosDevIOCtl             PROTO           @proto_148

@DosDevConfig           TYPEDEF         PROTO SYSCALL :PVOID, :ULONG
DosDevConfig            PROTO           @DosDevConfig

@PrfQueryProfileInt     TYPEDEF         PROTO SYSCALL :ULONG, :PSZ, :PSZ, :ULONG
PrfQueryProfileInt      PROTO           @PrfQueryProfileInt

@DosQueryProcAddr       TYPEDEF         PROTO SYSCALL :ULONG, :ULONG, :PSZ, :ULONG
DosQueryProcAddr        PROTO           @DosQueryProcAddr

