;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = STRBLT.INC
;*
;* DESCRIPTIVE NAME = STRBLT Definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/13/91
;*
;* DESCRIPTION  Common include information in STRBLT.INC.  This module contains the     
;*              definition of strblt's frame, flag definitions, and anything else 
;*              common to all the separate modules which make up the strblt function.
;*
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/13/91                     Written by KEZ
;*****************************************************************************/


IFNDEF STRBLT_DEFD      ; Don't include if already included

STRBLT_DEFD EQU 1       ; Indicate it has been included

;/*
;**  Definitions for the "accel" flag
;*/


IS_OPAQUE       EQU 00000001b                    ; Background mode is opaque
IS_XOR_TEXT     EQU 00000010b                    ; XOR'd text
IS_OR_TEXT      EQU 00000100b                    ; OR'd text
ABC_FONT        EQU 00001000b                    ; Font is an ABC font
HAVE_CHAR_EXTRA EQU 00010000b                    ; Char extra is present
HAVE_WIDTH_VECT EQU 00100000b                    ; Have a width vector
WIDTH_IS_8      EQU 01000000b                    ; Font is 8 pixels per character
FIXED_PITCH     EQU 10000000b                    ; Font is fixed pitch

;/*
;**  Definitions for the "excel" flag
;*/


OPAQUE_RECT     EQU 00000001b                    ; Opaquing rectangle is present
TEXT_VISIBLE    EQU 00000010b                    ; Some part of the text is visible
BOUNDED_IN_Y    EQU 00000100b                    ; Text fits within opaque rectangle in Y
IS_DEVICE       EQU 00001000b                    ; Destination is our device
FIRST_IN_PREV   EQU 00010000b                    ; First char starts in previous BYTE
RES_EGA_INNER   EQU 00100000b                    ; Restore EGA for opaque inner loop
CLIPPED_RIGHT   EQU 01000000b                    ; Overhanging right side of clip rect
CLIPPED_LEFT    EQU 10000000b                    ; Overhanging left  side of clip rect

;/*
;**       Definitions for the "wc_flags"
;*/

WC_OLD_OPAQUE   EQU 00000001b                    ; Shadow of IS_OPAQUE
WC_SET_LR       EQU 00000010b                    ; Set left/right into text bbox
WC_FIRST        EQU 00000100b                    ; First substring being output
STEPPED_BACK    EQU 00001000b                    ; Stepped backwards at somepoint
ROP_IS_NOP      EQU 00010000b                    ; fore and back mixes both LeaveAlone

;/*
;** FONT_ENTRIES is the format of the individual character records in
;** a fixed or proportional font.
;*/

FONT_ENTRIES STRUCT
   fe_dBits DWORD ?
   fe_width WORD  ?
FONT_ENTRIES ENDS

;/*
;** ABC_FONT_ENTRIES is the format of the individual character records in
;** an ABC spaced font.
;*/

ABC_FONT_ENTRIES STRUCT
   abc_fe_dBits DWORD ?
   abc_a_space  WORD  ?
   abc_b_space  WORD  ?
   abc_c_space  WORD  ?
ABC_FONT_ENTRIES ENDS


STACK_SLOP EQU 200      ; # of bytes of stack space we cannot
                        ;  use when building up a string

;/*
;**       Definitions for the eto_options parameters
;*/

ETO_OPAQUE_FILL EQU 00000010b                    ; Fill opaque rect with background color
ETO_OPAQUE_CLIP EQU 00000100b                    ; Clip to opaque rectangle



;/*
;**       Index for foreground and background colors stored
;**       in the frame variable "colors"
;*/

FOREGROUND EQU 0
BACKGROUND EQU 1

;/*
;**       frame_data is the definition of the data which is pushed
;**       into the stack for each character (where a character
;**       should be defined as a pattern of 8 bits or less).
;*/

frame_data        STRUCT
   fd_width       BYTE    ?                      ; Width of the character
   fd_phase       BYTE    ?                      ; X location mod 8
                  WORD    ?      
   fd_bits_offset DWORD   ?                      ; Offset to the bits
frame_data        ENDS

;/*
;**       The local font structure has information copied from the
;**       font structure passed to strblt.  Having the data in a
;**       structure makes it a little more efficient when copying
;**       the data to the frame.
;*/

local_font_def  STRUCT
   font_width   WORD    0                        ; Width field for the font
   font_height  WORD    0                        ; Height field for the font
   first_char   WORD    0                        ; First character in the font
   last_char    WORD    0                        ; Last character in the font (mapped)
   default_char WORD    0                        ; Default character for out of range
local_font_def  ENDS

;/*
;**---------------------------------Macro--------------------------------------
;** define_frame                                                               
;**                                                                            
;** Macro for defining the frame for strblt functions                          
;**                                                                            
;** This file allows the frame definiton to be shared by all the modules which 
;** make up the strblt function.                                               
;**                                                                            
;** NOTE: This macro generates the call frame and local variables for          
;** functions that, apparently, will be fleshed out by the writer of the       
;** module that uses it.  As the old macro merely built the cProc statement    
;** and not the cBegin and cEnd statements, the new macro builds the PROC      
;** statement only.  The user of the macro will be responsible for including   
;** a corresponding ENDP statement.                                            
;**                                                                            
;** Calls:                                                                     
;**       none                                                                 
;*/
 

define_frame macro name

name PROC SYSCALL, lp_DDC        :DWORD,
          x             :DWORD,
          y             :DWORD,
          lp_clip_rect  :DWORD,
          lp_string     :DWORD,
          count         :DWORD,
          npAttrs       :DWORD,
          lp_dx         :DWORD,
          lp_opaque_rect:DWORD,
          eto_options   :DWORD 
        LOCAL   accel           :BYTE            
        LOCAL   excel           :BYTE            
        LOCAL   wc_flags        :BYTE            
        LOCAL   fbTranslate     :BYTE            
        LOCAL   colors          :DWORD           
        LOCAL   char_extra      :DWORD           
        LOCAL   num_null_pixels :DWORD           
        LOCAL   null_char_offset:DWORD           
        LOCAL   lhs             :DWORD           
        LOCAL   rhs             :DWORD           
        LOCAL   concat          :DWORD           
        LOCAL   pFont           :DWORD           
        LOCAL   lfd             :local_font_def
        LOCAL   clip            :RECTL
        LOCAL   text_bbox       :RECTL
        LOCAL   o_rect          :RECTL
        LOCAL   smart_flags            :BYTE
        LOCAL   special_bm_opaque_color:BYTE     
        LOCAL   num_planes             :BYTE     
        LOCAL   left_clip_mask         :BYTE     
        LOCAL   right_clip_mask        :BYTE     
        LOCAL   cell_adjust            :DWORD    
        LOCAL   buffer                 :DWORD    
        LOCAL   fix_total_bytes        :DWORD    
        LOCAL   next_scan              :DWORD    
        LOCAL   next_plane             :DWORD    
        LOCAL   next_scan_xor          :DWORD    
        LOCAL   opaque_routine         :DWORD    
        LOCAL   opaque_height          :DWORD    
        LOCAL   lp_surface             :DWORD    
        LOCAL   temp_off_lp_bits       :DWORD    
        LOCAL   scan_start             :DWORD    
        LOCAL   clipped_font_height    :DWORD    
        LOCAL   amt_clipped_on_top     :DWORD    
        LOCAL   clear_stack            :DWORD    
        LOCAL   min_stack              :DWORD    
        LOCAL   build_proc             :DWORD    
        LOCAL   phase                  :DWORD
        LOCAL   x2                     :DWORD
        LOCAL   inner_loop             :DWORD
        LOCAL   clipped_table          :DWORD    
        LOCAL   non_clipped_table      :DWORD    
        LOCAL   inner_byte_count       :DWORD    
        LOCAL   current_lhs            :DWORD    
        LOCAL   current_rhs            :DWORD    
        LOCAL   wc_opaque_lhs          :DWORD    
        LOCAL   wc_opaque_rhs          :DWORD    
        LOCAL   string_start_bias      :DWORD    
        LOCAL   ret_addr               :DWORD    
        LOCAL   unrolled_entry_point   :DWORD    
        LOCAL   vect_one_in_first      :DWORD    
        LOCAL   vect_two_in_first      :DWORD
        LOCAL   vect_one_in_middle     :DWORD
        LOCAL   vect_two_in_middle     :DWORD
        LOCAL   vect_one_in_last       :DWORD
        LOCAL   vect_two_in_last       :DWORD
        LOCAL   ret_addr_2             :DWORD
        LOCAL   ega_oc_saved_data      :DWORD

        endm

ENDIF ; STRBLT_DEFD

