;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = POLYSTYL.ASM
;*
;* DESCRIPTIVE NAME = Polyline styled line drawing device driver.
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/30/87
;*
;* DESCRIPTION
;*
;*   This module contains all of the routines called by POLYLINE.ASM to draw
;*   styled polylines in memory bitmaps or the EGA.  The routines are basically
;*   broken into six different cases.  Lines are categorized as x major,
;*   y major or diagonal.  They are also broken down into simple and
;*   non-simple, or standard, cases; where simple means horizontal, vertical
;*   or on a diagonal.  These simple cases can be drawn much faster than
;*   the standard cases, and are therefore broken out from the rest.
;*
;*   There are similar routines in PLYSOLID.ASM for solid lines to the EGA,
;*   and POLYBITM.ASM for solid lines to memory bitmaps.  While these
;*   routines are all quite similar, they are separated purely for speed
;*   considerations.  POLYLINE.ASM is the dispatching module for all of
;*   these routines, and the run length slice algorithm DDA, which all of
;*   these routines are based on, is explained in that module.
;*
;*   At the end of this module are the *_pixel output routines:
;*   styled_dev_pixel draws the line portions of styled lines to the EGA
;*   styled_bm_pixel act similarly with bitmaps
;*   As needed, the address of one of these routines is loaded
;*   into StyledProc which is called to output each pixel.
;*
;*
;*
;* FUNCTIONS    setup_poly_frame_2
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/



        .386

        .xlist

INCL_DDIPATHS           equ     1
DINCL_ENABLE            equ     1
DINCL_BITMAP            equ     1

        .list

        include pmgre.inc
        include driver.inc
        include display.inc
        include polyline.inc
        include extern.inc
        include protos.inc

Update_Bank     PROTO SYSCALL

        .list

        .MODEL FLAT

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

EXTERNDEF       Origin_bank:BYTE

Styled_Rop_Table        equ                      this DWORD
        DWORD   styled_black
        DWORD   styled_ornot
        DWORD   styled_notand
        DWORD   styled_notpen
        DWORD   styled_andnot
        DWORD   styled_notdst
        DWORD   styled_xor
        DWORD   styled_dpan
        DWORD   styled_dpa
        DWORD   styled_dpxn
        DWORD   styled_d
        DWORD   styled_dpno
        DWORD   styled_p
        DWORD   styled_pdno
        DWORD   styled_dpo
        DWORD   styled_white

CHANGE_SEGMENT_OFFSET   equ                      10000h

        .CODE

        OPTION PROLOGUE:None

        OPTION EPILOGUE:None

;/***************************************************************************
;*
;* FUNCTION NAME = setup_poly_frame_2
;*
;* DESCRIPTION   = This function just encapsulates the following public
;*                 labels:
;*
;*                            dev_styled_horizontal
;*                            dev_styled_vertical
;*                            dev_styled_diagonal
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

setup_poly_frame_2   PROC SYSCALL

  LOCAL   returnvalue:DWORD,
          dwStyleCounter:DWORD,
          Flags:DWORD,
          Count:DWORD,
          Points:DWORD
  LOCAL   npddc:DWORD,
          dwStyleMask:DWORD,
          npfnUnSetup:DWORD,
          CurLineColor:DWORD,
          DrawModeIndex:DWORD,
          cPlanes:DWORD
  LOCAL   cbNextPlane:DWORD,
          dwBitmapROP:DWORD,
          dwStyleStepHorz:DWORD,
          dwStyleStepVert:DWORD,
          dwStyleStepDiag:DWORD
  LOCAL   dwStyleStepHorzTmp:DWORD,
          dwStyleStepVertTmp:DWORD,
          offNextLine:DWORD,
          cbScanSize:DWORD,
          cbHugeScanWrap:DWORD,
          cySurface:DWORD
  LOCAL   cScansPerSegment:DWORD,
          pSurfaceStart:DWORD,
          anpfnRunRoutines:DWORD,
          LineStyle:DWORD,
          npfnPassSetup:DWORD,
          cPasses:DWORD,
          lsg:LINESEGMENT
  LOCAL   dwStyleStepRun:DWORD,
          dwStyleStepSide:DWORD,
          dwActiveStyleCounter:DWORD,
          dwActiveStyleMask:DWORD,
          yA:DWORD,
          cScans:DWORD,
          cA:DWORD,
          cB:DWORD,
          cm:DWORD
  LOCAL   npfnRunRoutine:DWORD,
          iWhichDDA:DWORD,
          dwError:DWORD,
          dwFracS:DWORD,
          dwRotBitMask:DWORD,
          cbScanAddressDelta:DWORD,
          cbSideStepAddressDelta:DWORD,
          cbHugeScanDelta:DWORD,
          selHugeDelta:DWORD,
          dwScan:DWORD
  LOCAL   pSurfaceAddress:DWORD,
          cTmpScans:DWORD,
          dwTmpError:DWORD,
          dwTmpScan:DWORD,
          dwTmpRotBitMask:DWORD,
          dwTmpActiveStyleCounter:DWORD,
          dwTmpActiveStyleMask:DWORD,
          cTmpPasses:DWORD,
          TmpCurLineColor:DWORD
  LOCAL                    Destination_device:byte
  LOCAL                    PreviousAddress:DWORD

        public  dev_styled_horizontal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_horizontal
;*
;* DESCRIPTION   = Draws a styled horizontal line on the EGA.
;*
;*                 Registers Destroyed:
;*                       AX,CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


dev_styled_horizontal::


        mov     dl,BYTE PTR dwActiveStyleCounter ;style error
        mov     ah,BYTE PTR dwActiveStyleMask  ; AH = style mask
        mov     esi,dwStyleStepHorz              ; SI = style step

        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Styled_Rop_Table[ebx*4]
        jecxz   styh_line_done
styh_output_loop:
        or      ah,ah
        jns     @F
        call    ebx
@@:
;/*
;** advance the style mask
;*/

        movzx   edx,dl
        add     edx,esi
        xchg    cl,dh
        rol     ah,cl
        mov     cl,dh

        dec     ecx
        jecxz   styh_line_done
        inc     edi
        jmp     styh_output_loop
styh_line_done:
        mov     BYTE PTR dwActiveStyleCounter,dl
        mov     BYTE PTR dwActiveStyleMask,ah
        pop     ebx
        ret

        public  dev_styled_vertical

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_vertical
;*
;* DESCRIPTION   = Draws a stlyed vertical line on the EGA.
;*
;*                 Registers Destroyed:
;*                       CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

dev_styled_vertical::


        mov     dl,BYTE PTR dwActiveStyleCounter ; style error
        mov     ah,BYTE PTR dwActiveStyleMask  ; AH = style mask
        mov     esi,cbScanAddressDelta           ; SI = scan delta

        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Styled_Rop_Table[ebx*4]

        jecxz   styv_line_done
styv_output_loop:
        or      ah,ah
        jns     styv_blank
        call    ebx
styv_blank:

;/*
;** advance the style mask
;*/

        movzx   edx,dl
        add     edx,dwStyleStepVert
        xchg    cl,dh
        rol     ah,cl
        mov     cl,dh

        dec     ecx
        jecxz   styv_line_done
        push    eax
        mov     eax,esi
        call    Update_Bank
        pop     eax

        jmp     styv_output_loop
styv_line_done:
        mov     BYTE PTR dwActiveStyleCounter,dl
        mov     BYTE PTR dwActiveStyleMask,ah
        pop     ebx
        ret

        public  dev_styled_diagonal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_styled_diagonal
;*
;* DESCRIPTION   = Draws a stlyed diagonal line on the EGA.
;*
;*                 Registers Destroyed:
;*                       CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


dev_styled_diagonal::


        mov     dl,BYTE PTR dwActiveStyleCounter ; style error
        mov     ah,BYTE PTR dwActiveStyleMask  ; AH = style mask
        mov     esi,cbScanAddressDelta           ; SI = scan delta

        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Styled_Rop_Table[ebx*4]
        jecxz   styd_line_done
styd_output_loop:
        or      ah,ah
        jns     no_diag_pixel
        call    ebx
no_diag_pixel:

;/*
;** advance the style mask
;*/

        movzx   edx,dl
        add     edx,dwStyleStepDiag
        xchg    cl,dh
        rol     ah,cl
        mov     cl,dh

        dec     ecx
        jecxz   styd_line_done
        push    eax
        mov     eax,esi
        inc     eax
        call    Update_Bank
        pop     eax

        jmp     styd_output_loop
styd_line_done:
        mov     BYTE PTR dwActiveStyleCounter,dl
        mov     BYTE PTR dwActiveStyleMask,ah
        pop     ebx
        ret


styled_black::
        mov     byte ptr [edi],0h
        ret

styled_white::
        mov     byte ptr [edi],0ffh
        ret

styled_ornot::
        or      byte ptr [edi],al
        not     byte ptr [edi]
        ret

styled_notand::
        push    dx
        mov     dl,al
        not     dl
        and     byte ptr [edi],dl
        pop     dx
        ret

styled_notpen::
        push    dx
        mov     dl,al
        not     dl
        mov     byte ptr [edi],dl
        pop     dx
        ret

styled_andnot::
        not     byte ptr [edi]
        and     byte ptr [edi],al
        ret

styled_notdst::
        not     byte ptr [edi]
        ret

styled_xor::
        xor     byte ptr [edi],al
        ret

styled_dpan::
        and     byte ptr [edi],al
        not     byte ptr [edi]
        ret

styled_dpa::
        and     byte ptr [edi],al
        ret

styled_dpxn::
        xor     byte ptr [edi],al
        not     byte ptr [edi]
        ret

styled_d::
        ret

styled_dpno::
        push    dx
        mov     dl,al
        not     dl
        or      byte ptr [edi],al
        pop     dx
        ret

styled_p::
        mov     byte ptr [edi],al
        ret

styled_pdno::
        not     byte ptr [edi]
        or      byte ptr [edi],al
        ret

styled_dpo::
        or      byte ptr [edi],al
        ret

setup_poly_frame_2   ENDP

        end
