;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PLYSOLID.ASM
;*
;* DESCRIPTIVE NAME = Polyline solid line drawing device driver.
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/30/87
;*
;* DESCRIPTION  This module contains all of the routines called by
;*              POLYLINE.ASM to draw solid polylines in EGA memory.  The
;*              routines are basically broken into six different cases.
;*              Lines are categorized as x major, y major or diagonal.
;*              They are also broken down into simple and non-simple, or
;*              standard, cases; where simple means horizontal, vertical or
;*              on a diagonal.  These simple cases can be drawn much faster
;*              than the standard cases, and are therefore broken out from
;*              the rest.  There are similar routines in POLYBITM.ASM for
;*              solid lines to bitmaps, and POLYSTYL.ASM for styled lines
;*              to EGA.  While these routines are all quite similar, they
;*              are separated purely for speed considerations.
;*              POLYLINE.ASM is the dispatching module for all of these
;*              routines, and the run length slice algorithm DDA, which all
;*              of these routines are based on, is explained in that
;*              module.
;*
;* FUNCTIONS    setup_poly_frame_3
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        .386

        .xlist

INCL_DDIPATHS           equ     1
DINCL_ENABLE            equ     1
DINCL_BITMAP            equ     1

        .list

        include pmgre.inc
        include driver.inc
        include display.inc
        include polyline.inc
        include extern.inc
        include protos.inc

Update_Bank     PROTO SYSCALL

        .list

        .MODEL FLAT

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

EXTERNDEF       Origin_bank:BYTE

Solid_Rop_Table equ     this DWORD
        DWORD   solid_black
        DWORD   solid_ornot
        DWORD   solid_notand
        DWORD   solid_notpen
        DWORD   solid_andnot
        DWORD   solid_notdst
        DWORD   solid_xor
        DWORD   solid_dpan
        DWORD   solid_dpa
        DWORD   solid_dpxn
        DWORD   solid_d
        DWORD   solid_dpno
        DWORD   solid_p
        DWORD   solid_pdno
        DWORD   solid_dpo
        DWORD   solid_white

        .CODE

        OPTION PROLOGUE:None

        OPTION EPILOGUE:None

;/***************************************************************************
;*
;* FUNCTION NAME = setup_poly_frame_3
;*
;* DESCRIPTION   = A grouping of the public labels:
;*
;*                 dev_solid_horizontal
;*                 dev_solid_vertical
;*                 dev_solid_diagonal
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

setup_poly_frame_3   PROC SYSCALL
 LOCAL   returnvalue:DWORD,
         dwStyleCounter:DWORD,
         Flags:DWORD,
         Count:DWORD,
         Points:DWORD
 LOCAL   npddc:DWORD,
         dwStyleMask:DWORD,
         npfnUnSetup:DWORD,
         CurLineColor:DWORD,
         DrawModeIndex:DWORD,
         cPlanes:DWORD
 LOCAL   cbNextPlane:DWORD,
         dwBitmapROP:DWORD,
         dwStyleStepHorz:DWORD,
         dwStyleStepVert:DWORD,
         dwStyleStepDiag:DWORD
 LOCAL   dwStyleStepHorzTmp:DWORD,
         dwStyleStepVertTmp:DWORD,
         offNextLine:DWORD,
         cbScanSize:DWORD,
         cbHugeScanWrap:DWORD,
         cySurface:DWORD
 LOCAL   cScansPerSegment:DWORD,
         pSurfaceStart:DWORD,
         anpfnRunRoutines:DWORD,
         LineStyle:DWORD,
         npfnPassSetup:DWORD,
         cPasses:DWORD,
         lsg:LINESEGMENT
 LOCAL   dwStyleStepRun:DWORD,
         dwStyleStepSide:DWORD,
         dwActiveStyleCounter:DWORD,
         dwActiveStyleMask:DWORD,
         yA:DWORD,
         cScans:DWORD,
         cA:DWORD,
         cB:DWORD,
         cm:DWORD
 LOCAL   npfnRunRoutine:DWORD,
         iWhichDDA:DWORD,
         dwError:DWORD,
         dwFracS:DWORD,
         dwRotBitMask:DWORD,
         cbScanAddressDelta:DWORD,
         cbSideStepAddressDelta:DWORD,
         cbHugeScanDelta:DWORD,
         selHugeDelta:DWORD,
         dwScan:DWORD
 LOCAL   pSurfaceAddress:DWORD,
         cTmpScans:DWORD,
         dwTmpError:DWORD,
         dwTmpScan:DWORD,
         dwTmpRotBitMask:DWORD,
         dwTmpActiveStyleCounter:DWORD,
         dwTmpActiveStyleMask:DWORD,
         cTmpPasses:DWORD,
         TmpCurLineColor:DWORD
 LOCAL                    Destination_device:byte
 LOCAL                    PreviousAddress:DWORD

        public  dev_solid_horizontal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_solid_horizontal
;*
;* DESCRIPTION   = Draws a solid horizontal line on the EGA.
;*
;*                 Registers Destroyed:
;*                       CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/


dev_solid_horizontal::

        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Solid_Rop_Table[ebx*4]
        jecxz   sh_line_done
sh_output_loop:
        call    ebx
        dec     ecx
        jecxz   sh_line_done
        inc     edi
        jmp     sh_output_loop
sh_line_done:
        pop     ebx
        ret

        public  dev_solid_vertical

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_solid_vertical
;*
;* DESCRIPTION   = Draws a solid vertical line on the EGA.
;*
;*                 Registers Destroyed:
;*                       CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;* dev_solid_vertical
;* {
;*    // this routine outputs BitCount vertical bits.  therefore, the
;*    // rotating bit mask is contant for all bytes output.
;*
;*    while (BitCount--)
;*    {
;*        output byte to EGA memory;
;*        DI += AddVertStep;                       // jump to next scan line.
;*    }
;*                                                 // return with BL = rotating bitmask.
;*    return();                                    // DS:DI => current destination byte.
;* }
;*
;**************************************************************************/


dev_solid_vertical::

        mov     esi,cbScanAddressDelta
        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Solid_Rop_Table[ebx*4]
        jecxz   sv_line_done
sv_output_loop:
        call    ebx
        dec     ecx
        jecxz   sv_line_done
        push    eax
        mov     eax,esi
        call    Update_Bank
        pop     eax
        jmp     sv_output_loop
sv_line_done:
        pop     ebx
        ret

        public  dev_solid_diagonal

;/***************************************************************************
;*
;* PUBLIC ROUTINE  dev_solid_diagonal
;*
;* DESCRIPTION   = Draws a solid diagonal line on the EGA.
;*
;*                 Registers Destroyed:
;*                       CX,SI
;*                 Registers Preserved:
;*                       DX,BP,ES
;*
;* INPUT         = DS:DI = EGA address
;*                 BL = rotating bit mask
;*                 CX = number of bits to draw
;*                 DX = EGA_BASE + GRAF_DATA
;*
;* OUTPUT        = DS:DI = new EGA address
;*                 BL = new rotating bit mask
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;* dev_solid_diagonal
;* {
;*    // this routine draws BitCount diagonal bits.  since we are drawing
;*    // a diagonal segment, x and y coordinates will change with each
;*    // bit drawn.
;*
;*    while (BitCount--)
;*    {
;*        output byte to EGA memory;
;*        rotate bit mask;
;*        increment DI if done with byte;
;*        DI += AddVertStep;                       // jump to next scan line.
;*    }
;*
;*    BL = rotating bit mask;
;*                                                 // return with BL = rotating bitmask,
;*    return();                                    // DS:DI => current destination byte.
;* }
;*
;**************************************************************************/


dev_solid_diagonal::

        mov     esi,cbScanAddressDelta

        push    ebx
        mov     al,byte ptr CurLineColor         ;set line color
        xor     ebx,ebx
        mov     ebx,DrawModeIndex
        mov     ebx,Solid_Rop_Table[ebx*4]
        jecxz   sd_line_done
sd_output_loop:
        call    ebx

diag_same_line:
        dec     ecx
        jecxz   sd_line_done
        push    eax
        mov     eax,esi
        inc     eax
        call    Update_Bank
        pop     eax
        jmp     sd_output_loop
sd_line_done:
        pop     ebx
        ret



solid_black::
        mov     byte ptr ds:[edi],0h
        ret

solid_white::
        mov     byte ptr ds:[edi],0ffh
        ret

solid_ornot::
        or      byte ptr ds:[edi],al
        not     byte ptr ds:[edi]
        ret

solid_notand::
        mov     dl,al
        not     dl
        and     byte ptr ds:[edi],dl
        ret

solid_notpen::
        mov     dl,al
        not     dl
        mov     byte ptr ds:[edi],dl
        ret

solid_andnot::
        not     byte ptr ds:[edi]
        and     byte ptr ds:[edi],al
        ret

solid_notdst::
        not     byte ptr ds:[edi]
        ret

solid_xor::
        xor     byte ptr ds:[edi],al
        ret

solid_dpan::
        and     byte ptr ds:[edi],al
        not     byte ptr ds:[edi]
        ret

solid_dpa::
        and     byte ptr ds:[edi],al
        ret

solid_dpxn::
        xor     byte ptr ds:[edi],al
        not     byte ptr ds:[edi]
        ret

solid_d::
        ret

solid_dpno::
        mov     dl,al
        not     dl
        or      byte ptr ds:[edi],al
        ret

solid_p::
        mov     byte ptr ds:[edi],al
        ret

solid_pdno::
        not     byte ptr ds:[edi]
        or      byte ptr ds:[edi],al
        ret

solid_dpo::
        or      byte ptr ds:[edi],al
        ret


setup_poly_frame_3   ENDP

        end
