;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    Get/Set Pixel
        SUBTITLE Header

;/*****************************************************************************
;*
;* SOURCE FILE NAME = PIXEL.ASM
;*
;* DESCRIPTIVE NAME = Set/Get Pixel routine.
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/25/91
;*
;* DESCRIPTION  Pixel is used to either set a pixel to a given color with
;*              the current binary raster operation, or to return the color
;*              of the the pixel at the given location.
;*
;* FUNCTIONS    Pixel
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/25/91                     KEZ  Original
;*
;*****************************************************************************/


        .386P
        .MODEL FLAT,SYSCALL

;/*
;** Included files
;*/

ifdef PALMGR2
INCL_GRE_PALETTE        equ     1
INCL_WINPALETTE         equ     1
INCL_GPI_BITMAPS        equ     1
INCL_GRE_COLORTABLE     equ     1
INCL_GPILOGCOLORTABLE   equ     1
endif
INCL_NOBASEAPI     EQU 1
INCL_GPIPRIMITIVES EQU 1
INCL_SAADEFS       EQU 1
OS2_NOPMAPI        EQU 1
        INCLUDE PMGRE.INC

DINCL_BITMAP       EQU 1
DINCL_ENABLE       EQU 1
        INCLUDE DRIVER.INC
        INCLUDE EXTERN.INC
        INCLUDE PROTOS.INC


        INCLUDE DISPLAY.INC
        INCLUDE EGAFAM.INC

ifdef PALMGR2
        include palette.inc
        include assert.mac
endif

;/*
;** Equates
;*/

;/*
;** Define the type flags used to determine which type of scan needs to be
;** performed (color or mono).
;*/

COLOR_OP EQU 00000010b
MONO_OP  EQU MONO_BIT
END_OP   EQU MONO_BIT shl 1 + (1 shl (BITS_PEL))

;/*
;** Macros
;*/

;/*
;** MakeROP - Make a ROP For Pixel
;**
;** MakeROP makes a raster operation for the pixel routine.  The raster
;** operation generated is based on the following table which shows the ROP
;** broken down into the boolean result for each plane based on what the pen
;** color is for the plane.
;**
;**       Color     Result                           Color   Result
;**
;** DDx     0         0                             DPa   0     0
;**         1         0                                1    dest
;**
;** DPon    0       ~dest                           DPxn   0   ~dest
;**         1         0                                1    dest
;**
;** DPna    0        dest                           D   0    dest
;**         1         0                                1    dest
;**
;** Pn      0         1                             DPno   0     1
;**         1         0                                1    dest
;**
;** PDna    0         0                             P   0     0
;**         1       ~dest                              1     1
;**
;** Dn      0       ~dest                           PDno   0   ~dest
;**         1       ~dest                              1     1
;**
;** DPx     0        dest                           DPo   0    dest
;**         1       ~dest                              1     1
;**
;** DPan    0         1                             DDxn   0     1
;**         1       ~dest                              1     1
;*/


MakeROP MACRO   l,ops

IRP x,<ops>
IFIDN   <x>,<0>
        BYTE    Pixel_is_0-Pixel_base_address

ENDIF

IFIDN   <x>,<1>
        BYTE    Pixel_is_1-Pixel_base_address

ENDIF

IFIDN   <x>,<~dest>
        BYTE    Pixel_is_inverted-Pixel_base_address

ENDIF

IFIDN   <x>,<dest>
        BYTE    Pixel_is_dest-Pixel_base_address

ENDIF

ENDM

ENDM ; MakeROP

;/*
;** Data
;*/

        .DATA

BitmapROPIndexes LABEL BYTE
        MakeROP DDx,<0,0>
        MakeROP DPon,<~dest,0>
        MakeROP DPna,<dest,0>
        MakeROP Pn,<1,0>
        MakeROP PDna,<0,~dest>
        MakeROP Dn,<~dest,~dest>
        MakeROP DPx,<dest,~dest>
        MakeROP DPan,<1,~dest>
         MakeROP DPa,<0,dest>
        MakeROP DPxn,<~dest,dest>
        MakeROP D,<dest,dest>
        MakeROP DPno,<1,dest>
        MakeROP P,<0,1>
        MakeROP PDno,<~dest,1>
        MakeROP DPo,<dest,1>
        MakeROP DDxn,<1,1>

RotBitTbl LABEL BYTE
        BYTE    10000000b
        BYTE    01000000b
        BYTE    00100000b
        BYTE    00010000b
        BYTE    00001000b
        BYTE    00000100b
        BYTE    00000010b
        BYTE    00000001b



ZERO_PEN        equ     00000h          ;AND with 00000000b, XOR with 00000000b
PEN             equ     000FFh          ;AND with 11111111b, XOR with 00000000b
ONE_PEN         equ     0FF00h          ;AND with 00000000b, XOR with 11111111b
NOT_PEN         equ     0FFFFh          ;AND with 11111111b, XOR with 11111111b


INVERT          equ     0FFh            ;INVERT color before using as plane mask
NO_INVERT       equ     000h            ;Use the color directly as plane mask
SET_TO_1S       equ     0FFh            ;For the Set, use 1's
SET_TO_0S       equ     000h            ;For the Set, use 0's

SINGLE_OK       equ    00000001b        ;Single pass ok



DR_SET          equ     00000000b
DR_AND          equ     00001000b
DR_OR           equ     00010000b
DR_XOR          equ     00011000b


rop_data_r       label byte
                db      DR_SET          ;DDx
                db      DR_SET          ;DPon   ;Two operations required
                db      DR_AND          ;DPna
                db      DR_SET          ;Pn
                db      DR_SET          ;PDna   ;Two operations required
                db      DR_XOR          ;Dn
                db      DR_XOR          ;DPx
                db      DR_SET          ;DPan   ;Two operations required
                db      DR_AND          ;DPa
                db      DR_XOR          ;DPxn
                db      DR_OR           ;D
                db      DR_OR           ;DPno
                db      DR_SET          ;P
                db      DR_SET          ;PDno   ;Two operations required
                db      DR_OR           ;DPo
                db      DR_SET          ;DDxn

rop_flags        label   byte
                db      SINGLE_OK       ;DDx
                db      0               ;DPon   ;Two operations required
                db      SINGLE_OK       ;DPna
                db      SINGLE_OK       ;Pn
                db      0               ;PDna   ;Two operations required
                db      SINGLE_OK       ;Dn
                db      SINGLE_OK       ;DPx
                db      0               ;DPan   ;Two operations required
                db      SINGLE_OK       ;DPa
                db      SINGLE_OK       ;DPxn
                db      SINGLE_OK       ;D
                db      SINGLE_OK       ;DPno
                db      SINGLE_OK       ;P
                db      0               ;PDno   ;Two operations required
                db      SINGLE_OK       ;DPo
                db      SINGLE_OK       ;DDxn

rop_pen_and      label   byte
                db      LOW ZERO_PEN    ;DDx
                db      LOW SET_TO_0S   ;DPon   ;Two operations required
                db      LOW NOT_PEN     ;DPna
                db      LOW NOT_PEN     ;Pn
                db      LOW SET_TO_0S   ;PDna   ;Two operations required
                db      LOW ONE_PEN     ;Dn
                db      LOW PEN         ;DPx
                db      LOW SET_TO_1S   ;DPan   ;Two operations required
                db      LOW PEN         ;DPa
                db      LOW NOT_PEN     ;DPxn
                db      LOW ZERO_PEN    ;D
                db      LOW NOT_PEN     ;DPno
                db      LOW PEN         ;P
                db      LOW SET_TO_1S   ;PDno   ;Two operations required
                db      LOW PEN         ;DPo
                db      LOW ONE_PEN     ;DDxn

rop_pen_xor      label   byte
                db      HIGH ZERO_PEN   ;DDx
                db           NO_INVERT  ;DPon   ;Two operations required
                db      HIGH NOT_PEN    ;DPna
                db      HIGH NOT_PEN    ;Pn
                db           INVERT     ;PDna   ;Two operations required
                db      HIGH ONE_PEN    ;Dn
                db      HIGH PEN        ;DPx
                db           INVERT     ;DPan   ;Two operations required
                db      HIGH PEN        ;DPa
                db      HIGH NOT_PEN    ;DPxn
                db      HIGH ZERO_PEN   ;D
                db      HIGH NOT_PEN    ;DPno
                db      HIGH PEN        ;P
                db           NO_INVERT  ;PDno   ;Two operations required
                db      HIGH PEN        ;DPo
                db      HIGH ONE_PEN    ;DDxn

;/*
;** Public functions
;*/

        .CODE


        SUBTITLE Pixel
        PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = Pixel
;*
;* DESCRIPTION   = Set or Get a Given Pixel.  The given pixel is set to the
;*                 given color or the given pixel's physical color is
;*                 returned.  The physical device may be the screen, a
;*                 monochrome bitmap, or a bitmap in our color format.  There
;*                 will be no error checking to see if the bitmap is in our
;*                 color format.  If it isn't, then we'll treat the bitmap as
;*                 if it was monochrome.  If mix_mode is -1, then the
;*                 physical color of the pixel is returned.  If mix_mode
;*                 isn't -1, then the pixel will be set to the physical color
;*                 passed in, combined with the pixel already at that
;*                 location according to the raster-op in mix_mode.  Pixel
;*                 doesn't pay attention to the background mode.  No clipping
;*                 of the input value is required.  GDI clips the coordinate
;*                 before it is passed in, for both Set and Get.
;*
;*                 Registers Preserved:
;*                       SI,DI,DS,BP
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*
;* INPUT         = C Prototype:
;*                   LONG _syscall Pixel (LONG lX, LONG lY, LONG lPhysColor,
;*                                        LONG lMixMode);
;*
;*                    where:
;*                       ESI = Handle to DDC
;*                       EGA registers in default state
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = IPC if GetPixel
;*                 Positive if SetPixel
;* RETURN-ERROR  = 080000000H if error occured
;*
;**************************************************************************/

Pixel PROC SYSCALL PUBLIC USES edi esi,
                lX        :LONG,                 ; X coordinate of pixel
                lY        :LONG,                 ; Y coordinate of pixel
                lPhysColor2:DWORD,               ; Physical color to set pixel to
                lMixMode  :LONG                  ; Drawing mode to use, or -1 if Get
LOCAL lPhysColor:IPC
ifdef PALMGR2
LOCAL   hddc:PDDC

        mov     hddc,esi
endif


        mov     eax,lPhysColor2
        mov     lPhysColor,ax
        DebugMsg <PIX>

        ddc?    ESI,<SURFACE>
        MOV     ESI,[ESI].DDC.ddc_npsd           ; Get surface definition from DDC
        TEST    [ESI].SURFACE.sd_fb,SD_DEVICE
        JZ      Memory_bitmap

;/*
;** This is the device.  The cursor must be excluded from the pixel that will be
;** processed.  The innerloop mask for the device will be set for color.  The
;** width of a plane will be set to 1 to flag to the loop code that this is the
;** EGA (odd widths are illegal).
;*/


        PUSH    ESI                             ; Save surface pointer
        MOV     ECX,lX                          ; Set left
        MOV     EDX,lY                          ;    top
        MOV     ESI,ECX                         ;    right
        MOV     EDI,EDX                         ;    bottom
        CALL    far_exclude                                      ; Exclude the area
        POP     ESI                             ; Restore surface pointer
        MOV     ESI,[ESI].SURFACE.sd_pBits       ; ESI --> the bits
        MOV     EAX,SCREEN_CBSCAN                        ; Compute starting address of

;/*
;** use mul dx so bank number will shown in dx register
;*/

        mov     edx,lY
        mul     dx

;/*
;** now bank number should be in dl
;*/

        ADD     ESI,EAX                         ; ESI is offset of the scan
        ADD     ESI,lX                           ;now esi point to exact pixel


        CALL    set_bank_select
        MOV     CL,COLOR_OP                                      ; Show color in case this is
                                                ; GetPixel
        MOV     EDI,1                           ; Next scan index = 1
                                                ; indicates display
        JMP     short Pixel_76

;/*
;** The device is a memory bitmap.
;*/

Memory_bitmap:
        MOV     EAX,lY                          ; Need Y coord a few times
        MOV     EDI,[ESI].SURFACE.sd_cbScan      ; Get index to next plane

        MOV     CL,MONO_OP                                       ; Assume mono loop
        TEST    [ESI].SURFACE.sd_fb,SD_COLOR
        JZ      Pixel_60
        MOV     CL,COLOR_OP                                      ; Show color loop

Pixel_60:
        MOV     EBX,[ESI].SURFACE.sd_dScan       ; Get index to next scan
        MOV     ESI,[ESI].SURFACE.sd_pBits       ; Get offset of the bits
        MUL     EBX                             ; Compute start of scan
        ADD     ESI,EAX                         ; ESI --> Start of scanline
                                                ;         byte is in

        CMP     CL,COLOR_OP
        JNE     Pixel_70
        ADD     ESI,lX
        JMP     short Pixel_76

;/*
;** Currently:
;**       ESI --> The bitmap, start of the correct scan
;**       EDI = Index to next plane of the scan
;**             1 if the display (odd with illegal)
;**       CL  = Looping flag
;*/

Pixel_70:
        MOV     EAX,lX                          ; Get X coordinate
        MOV     EBX,EAX
        SHR     EAX,3                           ; Compute byte offset from
                                                ; start of scan
        ADD     ESI,EAX                         ; ESI --> Byte of pixel

Pixel_75:
        AND     EBX,00000111B                                    ; Get bit mask for bit
        MOV     CH,RotBitTbl[EBX]
        MOV     EDX,EDI                         ; Need index to next plane
                                                ; here

Pixel_76:
        MOV     EBX,lMixMode                                     ; Display code enters here
                                                   ; Get pel if -1
        OR      EBX,EBX
        JNS     Pixel_100                                        ; Given, operation is set
                                                ; pixel
        JMP     Get_the_pixel                                    ; Not given, return pixel
                                                ; color

Pixel_90:
        JMP     Pixel_130

;/*
;** The operation to be performed is SetPixel.  Currently:
;**
;**       CH   =  Bit mask
;**       ESI --> Byte bit is to be set in
;**       EBX  =  Mix mode
;**       CL   =  Loop mask
;**       EDX  =  Index to next plane
;**                 1 if the display
;*/


Pixel_100:

        CMP     CL,MONO_OP                       ; Mono Bitmap?
        JE      Pixel_90                         ; Yes, go do it

        MOV     CL,BYTE ptr lPhysColor.ipc_bClr  ; Get color for the pixel
        TEST    rop_flags[EBX],SINGLE_OK          ; Can the ROP occur in one
                                                ; operation?
        JZ      Pixel_110                                        ; Must do two operations

        AND     CL,rop_pen_and[EBX]              ; Set correct color for the
        XOR     CL,rop_pen_xor[EBX]      ; ROP

        xor     eax,eax
        mov     ah,rop_data_r[ebx]
        shr     ah,3
        or      ah,ah
        jne     dr_more1
        mov     byte ptr [esi],cl
        jmp     dr_morex
dr_more1:
        dec     ah
        jne     dr_more2
        and     byte ptr [esi],cl
        jmp     dr_morex
dr_more2:
        dec     ah
        jne     dr_more3
        or      byte ptr [esi],cl
        jmp     short dr_morex
dr_more3:
        xor     byte ptr [esi],cl
dr_morex:
        jmp     Pixel_160                                        ; All done


Pixel_110:
        xor     cl,rop_pen_xor[EBX]
        mov     ch,cl
        not     ch
        mov     ax,cx
        and     cl,rop_pen_and[EBX]
        and     ch,byte ptr [esi]
        or      cl,ch

        mov     ch,cl
        not     ch
        and     ch,ah
        and     cl,al
        or      cl,ch
        mov     byte ptr [esi],cl
        jmp     Pixel_160



;/*
;** The SetPixel operation is to be performed on a mono memory bitmap.
;**
;** The loop will use the following registers:
;**
;**     AH        Inverse of the bitmask
;**     AL        The bitmask
;**     EBX       Work
;**     CH        Pen Color
;**     CL        Loop mask
;**     EDX       Index to next plane, or 1 if EGA
;**     ESI       destination pointer
;**     EDI       ROP table address for the rop
;*/

Pixel_130:
        ADD     EBX,EBX                         ; Set BitmapROPIndexes table
        LEA     EDI,BitmapROPIndexes[EBX]        ; address for the given rop
        MOV     AX,CX                           ; Get mask for bit being
        MOV     AL,AH                           ; altered and also create a
        NOT     AH                              ; mask for ANDing
        MOV     CH,BYTE ptr lPhysColor.ipc_bClr  ; Get color for the pixel

Pixel_140:
        MOVZX   EBX,CH                  ; Get pen color
        AND     BL,CL                   ; Mask color for current plane
        CMP     BL,1                    ; 'C' if pen is a 0 for this plane
        SBB     EBX,EBX                 ; EBX = -1 if black,0 if white
        INC     EBX                     ; EBX = 0  if black, 1 if white
        MOVZX   EBX,BYTE ptr [EDI][EBX]          ; Get delta to the drawing function
        ADD     EBX,Pixel_base_address
        JMP     EBX                     ; Invoke the function

Pixel_base_address::                    ; Deltas are computed from here

Pixel_is_0::
        AND     [ESI],AH                         ; Set pixel to a 0
        jmpnext

Pixel_is_inverted::
        XOR     [ESI],AL                         ; Invert destination
        jmpnext

Pixel_is_1::
        OR      [ESI],AL                         ; Set pixel to a 1
        jmpnext stop

Pixel_is_dest::

Pixel_160:
        XOR     EAX,EAX         ; Set EAX = 0
        cwd
        JMP     Pixel_300                        ; Return 0 to show success

;/*
;** The operation to be performed is get pixel.  The IPC of the pixel will be
;** returned.
;**
;** If this is a monochrome bitmap, then the IPC will simply be black or white.
;**
;** Currently:
;**
;**       CH   =   Bit mask
;**       CL   =   Loop mask
;**       EDX  =   Index to next plane
;**                1 if physical device
;**       ESI --> Byte bit is to be set in
;*/

;/*
;**;;==========================================================================
;**;; WHITE EQU  MM_ALL OR ((MONO_BIT+ONES_OR_ZEROS) SHL 8)
;**;; BLACK EQU ONES_OR_ZEROS SHL 8
;**;;
;**;; If we are dealing with a monochrome bitmap, we will simply determine
;**;; if the current bit is on or not.  If so, we will return CLR_BLACK (-1)
;**;; Otherwise, we return CLR_BACKGROUND (0).  Previously, we were struggling
;**;; with the generic code at Pixel_300 which is not necessary for this case.
;**;;==========================================================================
;*/

Get_the_pixel:
        CMP     CL,MONO_OP                       ; Is this for a mono bitmap?
        JNE     Pixel_210                        ; No, it's for color
        XOR     EDX,EDX
        MOV     EAX,CLR_BACKGROUND
        TEST    [ESI],CH                         ; Is pixel black?

        JZ      pixel_exit                       ; No, return the background color

        MOV     EAX,CLR_BLACK   ; It is, return color in EAX

        JMP     pixel_exit

Pixel_210:

        xor     eax,eax                           ; clear out ax
        lodsb                                     ; grab the pixel

Pixel_300:
        CALL    far_unexclude                    ; Clear any exclude rectangle

ifdef PALMGR2
        cmp     lMixMode,-1     ;get pel
        jne     pixel_exit

        assert  eax,BE,0ffh
        mov     esi,hddc
        ASSUME  esi:PDDC

;/*
;**    if (pdc->DCIColFormat == LCOLF_RGB)
;**    {
;*/

       test    [esi].ddc_fbClrTbl,DDC_RGB_MODE
       jz      not_rgb_mode

;/*
;**        /**************************************************************/
;**        /* At 1bpp the possible RGB values are black and white        */
;**        /**************************************************************/
;**        if (pdc->DCISelListEntry->Info.BitCount == 1)
;**        {
;**            if (ulPhyIndex == 0)
;**            {
;**                ulLogIndex = 0x00000000;
;**            }
;**            else
;**            {
;**                ulLogIndex = 0x00ffffff;
;**            }
;**        }
;**        else if (pdc->DCISelListEntry->Info.BitCount == 16)
;**        {
;**            /**********************************************************/
;**            /* At 16 bpp we expand the 16bpp RGB value into a full    */
;**            /* RGB value in a ULONG                                   */
;**            /**********************************************************/
;**            ulLogIndex = (((ULONG)ulPhyIndex << 8) & 0x00F80000) |
;**                         (((ULONG)ulPhyIndex << 5) & 0x0000FC00) |
;**                         (((ULONG)ulPhyIndex << 3) & 0x000000F8);
;**        }
;**        /**************************************************************/
;**        /* We are currently in RGB mode and therefore have to return  */
;**        /* an RGB value. If the current LCT is realizable and can     */
;**        /* produce the physical index then use the RGB value in the   */
;**        /* LCT, otherwise use the RGB value in the default physical   */
;**        /* palette.                                                   */
;**        /**************************************************************/
;**        else if (fRealizeSupported &&
;**                 (pdc->DCIColStatus & LCOL_REALIZABLE) &&
;**                 (ulPhyIndex >= pdc->DCILowIndex) &&
;**                 (ulPhyIndex <= pdc->DCIHighIndex) &&
;**                 (pdc->DCIColorTable[ulPhyIndex].PhyIndex !=
;**                                                        CLR_NOPHYINDEX))
;*/

        test    [esi].ddc_fbClrTbl,DDC_REALIZABLE
        jz      not_color_table
        cmp     eax,[esi].ddc_ctMin
        jb      not_color_table
        cmp     eax,[esi].ddc_ctMax
        ja      not_color_table
        ASSUME  ebx:NOTHING
        mov     ebx,[esi].ddc_pClrTbl
        .errnz  sizeof COLORTABLETYPE-8
        cmp     [ebx+(eax * 8)].COLORTABLETYPE.PhyIndex,CLR_NOPHYINDEX
        je      not_color_table

;/*
;**        {
;**            /**********************************************************/
;**            /* Color table is realizable and entry is valid so use    */
;**            /* the RGB value.                                         */
;**            /**********************************************************/
;**            ulLogIndex = URGB(pdc->DCIColorTable[ulPhyIndex].LogRGB);
;*/

        .errnz  sizeof COLORTABLETYPE-8
                mov     eax,[ebx+(eax*8)].COLORTABLETYPE.LogRGB
                jmp     pixel_exit

;/*
;**        }
;**        else
;*/

not_color_table:

;/*
;**        {
;**            /**********************************************************/
;**            /* If we are a memory DC then use the RGB value from the  */
;**            /* device default physical palette. If we are a direct    */
;**            /* (screen) DC then use the RGB value in the HW palette.  */
;**            /**********************************************************/
;**            if (pdc->DCIDCType == OD_DIRECT)
;*/

        test    [esi].ddc_fb,DDC_DEVICE
        jz      its_memory

;/*
;**            {
;**                ulLogIndex = (((PULONG)HWPalette)[ulPhyIndex] & RGB_MASK);
;*/

        mov     eax,HWPalette[eax*sizeof RGB2]
        and     eax,RGB_MASK

        jmp     pixel_exit

;/*
;**            {
;**            else
;*/

its_memory:

;/*
;**            {
;**                ulLogIndex = (MemoryDeviceDefaultULONG(ulPhyIndex) & RGB_MASK);
;*/

        cmp     eax,SizeOfHWPalette
        jae     check_for_mono
;PRK        mov     eax,MemoryDeviceDefaultPalette[eax*sizeof RGB2]
        mov     edx,MemoryDeviceDefaultPalette  ;PRK
        mov     eax,[edx+eax*sizeof RGB2]       ;PRK
        and     eax,RGB_MASK
        jmp     pixel_exit

check_for_mono:

;/*
;** Before we declare that the ipc index is too big, check to see
;** if the monochrome bitmap flag is set.  If so, strip it off and
;** return either the 0 or 1 that existed in the monochrome bitmap.
;*/

        test    eax,MONO_BIT SHL 8
        jz      too_big
        and     eax,0000ffffh
        jmp     pixel_exit

too_big:
        mov     eax,0
        jmp     pixel_exit

;/*
;**            }
;**        }
;**    }
;**    else /* index LCT or palette format */
;*/

not_rgb_mode:

;/*
;**    {
;**        /**************************************************************/
;**        /* Mode is index in LCT or palette so we need to convert our  */
;**        /* physical index back into a logical index.                  */
;**        /**************************************************************/
;**        ulLogIndex = PhyToLogIndex(ulPhyIndex);
;*/

        INVOKE  PhyToLogIndex,
                esi,
                eax

;/*
;**    }
;*/


pixel_exit:
endif   ;PALMGR2

        RET

Pixel ENDP

        END
