;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PALTYPES.H
;*
;* DESCRIPTIVE NAME = Palette manager types and structures
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;*
;*
;*
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/19/93              74744  RGB_PLUS_MASK is       in the XGA code.
;*
;*****************************************************************************/

MaxLogColorIndex        EQU     LOGICAL_COLOR_TABLE_SIZE-1
DFLT_LOG_COL_TABLE_SIZE EQU     DEFAULT_COLOR_TABLE_SIZE
HW_PAL_SIZE     EQU     256
LARGEST_PAL     EQU     HW_PAL_SIZE
AVIO_PALETTE_SIZE       equ                      16


;/*
;** The following masks are used when considering RGB2 values as ULONGS
;*/

RED_MASK        EQU     000FF0000h
GREEN_MASK      EQU     00000FF00h
BLUE_MASK       EQU     0000000FFh
RGB_MASK        EQU     (RED_MASK + GREEN_MASK + BLUE_MASK)

;/*
;** keep just the bits the engine knows about
;*/

;           RGB_PLUS_MASK   EQU     (RGB_MASK + PC_RESERVED + PC_EXPLICIT + PC_NOCOLLAPSE)

;/*
;** this next mask is used in realize palette to test if we need to
;** reload a hw palette entry
;*/

RGB_TEST_MASK   EQU     (RGB_MASK + PC_RESERVED)

;/*
;** FREE_FLAGS is the value we place in the fcOptions of an RGB2
;** value in the HWPalette structure when that HW slot is unused (free)
;*/

FREE_FLAGS      EQU     0


ITE_STRUCT struct
        ite_Flags               BYTE    0
        ite_ExtColorCount       DWORD   0
        ite_IntColorCount       DWORD   0
        ite_pbConvertTable      DWORD   0
        ite_RgbIncrement        DWORD   0
ITE_STRUCT ENDS

;/*
;** ite_Flags:
;*/

ITE_COLOR       EQU     00000001b
ITE_BCE         EQU     00000010b

PALENTRY struct
        rgb         RGB2        <>      ;/* b,g,r,options              */
        bCurrent    BYTE        ?       ;/* current h/w index          */
        bPrevious   BYTE        ?       ;/* previous h/w index         */

;/*
;** this next field is to make palette entries 8 bytes long
;** which aids debugging
;*/

        padding     USHORT      ?       ;/* may find a use for this    */
PALENTRY ENDS

PPALENTRY typedef PTR PALENTRY

DEVPAL struct
        Identifier      ULONG  ?    ; 
        cUsage          ULONG  ?    ;/* usage count */

;/*
;** minimum is always 0 so need not be stored
;*/

        usMax           ULONG  ?    ;/* max index defined (no limit*/

;/*
;** flags holds both user supplied flags (PURECOLOR etc) and
;** driver internal flags
;*/


        usFlags         ULONG  ?        ;/* palette flags              */
        usLocalOptimizeID ULONG ?        ;/* stops unnecessary realizes */
        usCountStored   ULONG  ?        ;/* no of stored entries (<=256)*/

;/*
;** 8514 maintains list of available memory slots for palettes
;** by chaining them together. May do this later.
;**
;** entries must be the last field in this structure because
;** that allows us to store only the number of entries
;** actually defined if that is actually what we want to do
;** (for example the DeviceDefaultPalette has 16 entries only)
;*/

        entries PALENTRY LARGEST_PAL DUP (<>) ;/* actual data        */
DEVPAL  ENDS

;/*
;** HDEVPAL is already defined as a ULONG so we define a PDEVPAL as
;** a pointer to a DEVPAL
;** whenever the engine wants a HDEVPAL from us we return them a
;** PDEVPAL value
;*/

PDEVPAL typedef PTR DEVPAL

;/*
;** flags entry in DEVPAL needs to hold the following user flags
;**     LCOL_PURECOLOR and LCOL_OVERRIDE_DEFAULT_COLORS
;** driver level flags are
;**   PAL_CHANGED        palette has changed since it was last realized
;**   PAL_PREVIOUS_OK    palette previous entries are valid
;**   PAL_CURRENT_OK     palette current entries are valid
;*/

PAL_CHANGED             EQU     00008000h
PAL_PREVIOUS_OK         EQU     00004000h
PAL_CURRENT_OK          EQU     00002000h

;/*
;** we piggy back extra bits into the fcOptions byte of the RGB2 entry
;** start at the top end of the byte because the system defined values
;** start at the bottom (see PC_ flags in pmgpi.h)
;**
;** Notes:
;** The PC_NEW is used only on logical palette entries, and PC_DEFAULT
;** and PC_OLD are used only on HW palette entries.  Their valuse
;** could be overlapped if necessary in the future.
;**
;** The PC_DEFAULT value is hardcoded into the default device palettes
;** so do not change it!  (Unless you change all the palette
;** definitions in edddata.c too).
;*/

PC_DEFAULT      EQU     080h
PC_USED         EQU     040h
PC_NEW          EQU     020h
PC_OLD          EQU     010h

;/*
;** Type definitions for Color Tables
;*/

COLORTABLETYPE struct   ;/* ctt */
        LogRGB          RGB2    <>  ;/* Logical RGB value           */
        PhyIndex        ULONG   ?   ;/* Physical index into the current */
COLORTABLETYPE ENDS                 ;/* palette of the nearest color  */

PCOLORTABLE typedef PTR COLORTABLETYPE

;/*
;** This should be in 32pmddi.h
;*/

RP_DEFAULTSCHANGED      EQU     2

;/*
;** Constant giving the size of the SpecialColorTable.
;** Special colours are -1 to -9, but we also need an entry for 0!
;** In addition the table stores the system colors, the number of
;** which is given by SYSCLR_CSYSCOLORS.
;*/

SPECIAL_COL_TAB_SIZE    EQU     (SYSCLR_CSYSCOLORS + 10)

;/*
;** Physical indices are (currently) up to 16 bits.
;** We always store them in a ULONG value in order to allow for other
;** special values, notably error values to be kept.
;** These special values are defined below.
;*/

CLR_NOPHYINDEX          EQU     0FFFFFFFFh
MODE_WAS_RGB            EQU     0FFFFFFFEh

;/*
;**----------------------- EQUATES ------------------------------------
;*/

NRECTS          equ     NUM_CLIP_RECTS+1         ;Must be bigger than NUM_CLIP_RECTS
ERROR_NEG       equ     -1
OK              equ     1
ERROR_ZERO      equ     0
NUM_VIS_RECTS   equ     4

;/*
;**----------------------- PROTOTYPES ------------------------------------
;*/

TableIntToPM PROTO SYSCALL

SetExternalColorTable PROTO SYSCALL

FudgePalettesAndGenerateTables PROTO SYSCALL

rgb2_diff                               PROTO SYSCALL,
        rgb1            :RGB2,
        rgb2            :RGB2

LoadPaletteEntries PROTO SYSCALL,
        start           :ULONG,
        count           :ULONG,
        pPaletteEntries :DWORD

InnerSearchRealizedLCTPalette PROTO SYSCALL,
        RGBColor        :RGB2

;/*
;**----------------------- PROTOTYPES ------------------------------------
;*/

InitDefaultColorTables PROTO SYSCALL

LogToPhyIndex PROTO SYSCALL,
        pddc           :PDDC,
        LogIndex        :LONG

NearestDefaultPaletteIndex256 PROTO SYSCALL,
        RGBColor       :DWORD

NearestDefaultPaletteIndex128 PROTO SYSCALL,
        RGBColor       :DWORD

NearestDefaultPaletteIndex64 PROTO SYSCALL,
        RGBColor       :DWORD

NearestDefaultPhysicalColor PROTO SYSCALL,
        pddc           :PDDC,
        RGBColor       :RGB2

InnerNearestDefaultPhysicalIndex PROTO SYSCALL,
        RGBColor                       :RGB2,
        DeviceDefaultPalette            :DWORD,
        ulDeviceDefaultPaletteSize      :ULONG

NearestDirectDefaultPhysicalIndex PROTO SYSCALL,
        RGBColor        :RGB2

NearestMemoryDefaultPhysicalIndex PROTO SYSCALL,
        RGBColor        :RGB2

NearestDefaultPhysicalIndex PROTO SYSCALL,
        pddc           :PDDC,
        RGBColor        :RGB2

NearestRealizableIndex PROTO SYSCALL,
        pddc            :PDDC,
        RGBColor        :RGB2

NearestLogicalColor PROTO SYSCALL,
        pddc            :PDDC,
        Options         :ULONG,
        RGBColor        :RGB2

SearchRealizedLCTPalette PROTO SYSCALL,
        RGBColor        :RGB2

PhyToLogIndex PROTO SYSCALL,
        pddc            :PDDC,
        ulPhyIndex      :ULONG

ExactDefaultPhysicalIndex PROTO SYSCALL,
        pddc            :PDDC,
        RGBColor        :ULONG

ChangedColorTable                       PROTO SYSCALL,
        pColorTable     :PCOLORTABLE

;/*
;** Extern Data
;*/

EXTERNDEF       ColorTableRealized              :HDC              ; 
EXTERNDEF       cPhysicalColors                 :ULONG
EXTERNDEF       fRealizeSupported               :BOOL
EXTERNDEF       CurrentSourcePalette            :PVOID            ; 
EXTERNDEF       CurrentDestPalette              :PVOID            ; 
EXTERNDEF       CurrentMappingValid             :BOOL             ; 
EXTERNDEF       DefaultDirectLogicalColorTable  :PCOLORTABLE      ; 
EXTERNDEF       DefaultFourBppTable             :COLORTABLETYPE
EXTERNDEF       DefaultEightBppTable256         :COLORTABLETYPE   ; 
EXTERNDEF       DefaultEightBppTable128         :COLORTABLETYPE   ; 
EXTERNDEF       DefaultEightBppTable64          :COLORTABLETYPE   ; 
EXTERNDEF       DefaultEightBppTable32          :COLORTABLETYPE   ; 
EXTERNDEF       DefaultEightBppTable16          :COLORTABLETYPE   ; 
EXTERNDEF       DefaultMemoryLogicalColorTable  :PCOLORTABLE      ; 
EXTERNDEF       DirectSpecialColorTable         :COLORTABLETYPE   ; 
EXTERNDEF       DirectDeviceDefaultPalette      :DWORD            ; 
EXTERNDEF       fForeGroundOverwrote            :ULONG
EXTERNDEF       FullSizeDeviceDefaultPalette    :RGB2             ; 
EXTERNDEF       GlobalPalCount                  :ULONG
EXTERNDEF       hForeGroundPal                  :PDEVPAL
EXTERNDEF       HWPalette                       :RGB2
EXTERNDEF       ulLastSearched                  :ULONG
EXTERNDEF       ulIndexLastSearched             :ULONG
EXTERNDEF       MemorySpecialColorTable         :COLORTABLETYPE   ; 
EXTERNDEF       MemoryDeviceDefaultPalette      :DWORD
EXTERNDEF       pfnDefGetVisRects               :DWORD
EXTERNDEF       RealizedBlackIndex              :ULONG
EXTERNDEF       RealizedLCTPalette              :RGB2
EXTERNDEF       RealizedWhiteIndex              :ULONG
EXTERNDEF       Reduced128DeviceDefaultPalette  :RGB2             ; 
EXTERNDEF       Reduced64DeviceDefaultPalette   :RGB2             ; 
EXTERNDEF       Reduced32DeviceDefaultPalette   :RGB2             ; 
EXTERNDEF       Reduced16DeviceDefaultPalette   :RGB2             ; 
EXTERNDEF       RGB2NULL                        :RGB2
EXTERNDEF       RGBWhite                        :RGB2
EXTERNDEF       RGBBlack                        :RGB2
EXTERNDEF       SizeOfHWPalette                 :ULONG            ; 
EXTERNDEF       UCMapping                       :BYTE
EXTERNDEF       ulDirectDeviceDefaultPaletteSize:ULONG            ; 
EXTERNDEF       usGlobalOptimizeID              :ULONG
EXTERNDEF       WindowsDefaultSysColors         :RGB2
EXTERNDEF       PaletteFudgeTable256            :BYTE
EXTERNDEF       PaletteFudgeTable128            :BYTE
EXTERNDEF       PaletteFudgeTable64             :BYTE
EXTERNDEF       PaletteFudgeTable32             :BYTE
EXTERNDEF       PaletteFudgeTable16             :BYTE

CalculateColorTablePhysicalIndices PROTO SYSCALL,
        pddc    :PDDC

DeviceCreatePalette                     PROTO SYSCALL,
        hdc             :HDC,
        ppalinfo        :DWORD,
        hdevpal         :PDEVPAL,
        hddc            :PDDC,
        FunN            :ULONG

DeviceDeletePalette                     PROTO SYSCALL,
        hdc             :HDC,
        hdevpal         :PDEVPAL,
        hddc            :PDDC,
        FunN            :ULONG

DeviceSetPaletteEntries                 PROTO SYSCALL,
        hdc             :HDC,
        hdevpal         :PDEVPAL,
        ulFormat        :ULONG,
        ulStart         :ULONG,
        cclr            :ULONG,
        pclr            :PULONG,
        hddc            :PDDC,
        FunN            :ULONG

DeviceAnimatePalette                    PROTO SYSCALL,
        hdc             :HDC,
        hdevpal         :PDEVPAL,
        ulFormat        :ULONG,
        ulStart         :ULONG,
        cclr            :ULONG,
        pclr            :PULONG,
        hddc            :PDDC,
        FunN            :ULONG
                                                  ;  so enum loop will terminate
DeviceResizePalette                     PROTO SYSCALL,
        hdc             :HDC,
        hdevpal         :PDEVPAL,
        ulSize          :ULONG,
        hddc            :PDDC,
        FunN            :ULONG

RealizePalette PROTO SYSCALL,
        hdc             :HDC,
        pflType         :PULONG,
        pcSlotsChanged  :PULONG,
        hddc            :PDDC,
        FunN            :ULONG

QueryHWPaletteInfo                      PROTO SYSCALL,
        hdc             :HDC,
        ulStart         :ULONG,
        cclr            :ULONG,
        pclr            :PULONG,
        hddc            :PDDC,
        FunN            :ULONG,

UpdateColors                            PROTO SYSCALL,
        hdc             :HDC,
        hddc            :PDDC,
        FunN            :ULONG

QueryPaletteRealization                 PROTO SYSCALL,
        hdc             :HDC,
        ulStart         :ULONG,
        cclr            :ULONG,
        pclr            :PULONG,
        hddc            :PDDC,
        FunN            :ULONG


eddc_PropagateSysColorChanges PROTO SYSCALL,
        pddc    :PDDC

NearestPaletteIndex                     PROTO SYSCALL,
        hddc            :PDDC,
        RGBColor        :RGB2

ExactHWPaletteMatch PROTO SYSCALL,
        rgb    :RGB2

ClosestHWPaletteMatch PROTO SYSCALL,
        rgb    :RGB2

;/*
;** Constant giving the size of the SpecialColorTable.
;** Special colours are -1 to -9, but we also need an entry for 0!
;** In addition the table stores the system colors, the number of
;** which is given by SYSCLR_CSYSCOLORS.
;*/

SPECIAL_COL_TAB_SIZE EQU (SYSCLR_CSYSCOLORS + 10)

;/*
;** Value above which the least squares colour comparison will map to
;** white.
;*/

WHITE_THRESHOLD equ     0180h

;/*
;** Macro to return an RGB16 value when given a pointer to an RGB2 one.
;*/

RGB16FromPRGB2 MACRO rgb2:REQ
.ERRNZ  RGB2.bBlue     - 0
.ERRNZ  RGB2.bGreen    - 1
.ERRNZ  RGB2.bRed      - 2
.ERRNZ  RGB2.fcOptions - 3
        mov     eax,rgb2
                        ;xxxxxxxx|RRRRRRRR|GGGGGGGG|BBBBBBBB
        shr     eax,3   ;xxxxxxxx|xxxRRRRR|RRRGGGGG|GGGBBBBB
        ror     eax,5   ;BBBBBxxx|xxxxxxxx|RRRRRRRR|GGGGGGGG
        shr     ax,2    ;BBBBBxxx|xxxxxxxx|xxRRRRRR|RRGGGGGG
        ror     eax,6   ;GGGGGGBB|BBBxxxxx|xxxxxxxx|RRRRRRRR
        shr     ax,3    ;GGGGGGBB|BBBxxxxx|xxxxxxxx|xxxRRRRR
        rol     eax,11  ;xxxxxxxx|xxxxxxxx|RRRRRGGG|GGGBBBBB
ENDM

;/*
;** MapRGBToMono
;** Returns 1 if prgb is closer to white, 0 if closer to black.
;*/

MapRGBToMono MACRO rgb2:REQ,fTrashEDX
.ERRNZ  RGB2.rgb2_bBlue    -0
.ERRNZ  RGB2.rgb2_bGreen   -1
.ERRNZ  RGB2.rgb2_bRed     -2
.ERRNZ  RGB2.rgb2_fcOptions-3
ifdifi <fTrashEDX>,<TRASHEDX>
        push    edx
endif
ifdifi <rgb2>,<eax>
        mov     eax,rgb2
endif
                        ;eax= |xxxxxxxx|RRRRRRRR|GGGGGGGG|BBBBBBBB
        mov     edx,0
        mov     dl,al   ;edx =  bBlue
        shr     ax,8    ;eax= |xxxxxxxx|RRRRRRRR|00000000|GGGGGGGG

        add     dx,ax   ;edx += bGreen
        shr     eax,8   ;eax= |00000000|xxxxxxxx|RRRRRRRR|00000000

        xchg    ah,al   ;eax= |00000000|xxxxxxxx|00000000|RRRRRRRR

        add     dx,ax   ;edx += bRed

        mov     eax,0
        cmp     edx,WHITE_THRESHOLD
        seta    al
ifdifi <fTrashEDX>,<TRASHEDX>
        pop     edx
endif
ENDM


MemoryDeviceDefaultRGB2 MACRO i:REQ,Dest:REQ
LOCAL too_big,done
ifidni <i>,<Dest>
        .ERR    <i and Dest must not be the same !! >
endif
        cmp     i,SizeOfHWPalette
        jae     too_big
        mov     Dest,MemoryDeviceDefaultPalette
        mov     Dest,[Dest+i*sizeof RGB2]
        jmp     done
too_big:
        mov     Dest,RGB2NULL
done:
ENDM
