;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EDDCQTAB
;*
;* DESCRIPTIVE NAME = Color table query functions
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Returns information about the current logical
;*              color table.
;*
;* FUNCTIONS    eddc_QueryColorData
;*              eddc_QueryLogColorTable
;*              device_enter_driver
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/11/93              63287  Adjusted complex IF statement to match XGA code.
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist

INCL_GPILOGCOLORTABLE   equ                      1
INCL_DDIMISC            equ                      1
INCL_GRE_BITMAPS        equ                      1
INCL_GPIBITMAPS         equ                      1
INCL_GPILOGCOLORTABLE   equ                      1
INCL_GRE_PALETTE        equ                      1
INCL_GRE_COLORTABLE     equ                      1
INCL_DEV                equ                      1
INCL_DDICOMFLAGS        equ                      1
INCL_WINPALETTE         equ                      1
INCL_WINSYS             equ                      1
INCL_GPIERRORS          equ                      1
        include pmgre.inc
DINCL_ENABLE            equ                      1
DINCL_BITMAP            equ                      1
DINCL_CLR_TBL           equ                      1
        include driver.inc
        include extern.inc
        include protos.inc
        include assert.mac
        include palette.inc
        .list

.CODE

TFUNC   TEXTEQU <eddc_QueryColorData>

;/***************************************************************************
;*
;* FUNCTION NAME = eddc_QueryColorData
;*
;* DESCRIPTION   = QueryColorData returns information about the current logical
;*                 color table. The routine loads ArgArray with the following
;*                 details about the current logical color table.
;*
;*                 Format:     LCOLF_DEFAULT, _INDRGB, _RGB, or _PALETTE
;*                 LowIndex:   Smallest color index loaded (always zero)
;*                 HighIndex:  Highest color index loaded
;*                 Options:    color table (or palette) options
;*
;*                 Information is only returned for the number of elements
;*                 supplied (given in ArgCount). Any extra elements supplied
;*                 that are not overwritten with results must be zeroed.
;*
;* INPUT         = hdc      :HDC
;*                 ArgCount :ULONG
;*                 ArgArray :PULONG
;*                 hddc     :PDDC
;*                 FunN     :ULONG
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

eddc_QueryColorData PROC SYSCALL USES EBX EDI,
    hdc         :HDC,
    ArgCount    :ULONG,
    ArgArray    :PULONG,
    hddc        :PDDC,
    FunN        :ULONG

;/*
;**    /******************************************************************/
;**    /* Local variables                                                */
;**    /******************************************************************/
;**    ULONG        i;                   /* Loop variable                */
;**
;**    /******************************************************************/
;**    /* Get driver semaphore and perform entry checks                  */
;**    /******************************************************************/
;**    EnterDriver(hddc, FunN, EDF_STANDARD);
;*/

        cld
        ddc?    hddc

        mov     edx,hddc
        INVOKE  enter_driver

        mov     eax,ERROR_ZERO
        jc      qcd_exit_no_lock                 ;error logged

;/*
;**
;**    PROFILE_ENTER(31);
;**
;**
;**    /******************************************************************/
;**    /* This might be a silly value, but in flat model it's quite      */
;**    /* legal!                                                         */
;**    /******************************************************************/
;**    /******************************************************************/
;**    /* Return an error if ArgCount contains a silly value ( >64K ).   */
;**    /******************************************************************/
;**    if (ArgCount & 0xFFFF0000)
;**    {
;**        LOGERR(TFUNC, "ArgCount too big", &ArgCount, 1,
;**                                             PMERR_INV_LENGTH_OR_COUNT);
;**        goto QRYCOLORDATA_ERR_EXIT;
;**    }
;**
;**
;**    /******************************************************************/
;**    /* Return each item that there is room for.                       */
;**    /******************************************************************/
;**    if (ArgCount > 0)
;*/

        mov     ecx,ArgCount
        cmp     ecx,010000h
        jb      @F
        DebugMsg2       <ArgCount too big>
        mov     eax,PMERR_INV_LENGTH_OR_COUNT
        save_error_code
        jmp     qcd_exit
@@:
        or      ecx,ecx
        jz      qcd_exit

;/*
;**    {
;**        /**************************************************************/
;**        /* there is room for the format - this is common for both     */
;**        /* color tables and palettes                                  */
;**        /**************************************************************/
;**        ArgArray[0] = pdc->DCIColFormat;
;** LCOLF_PALETTE
;** LCOLF_RGB
;** LCOLF_INDRGB
;** LCOLF_DEFAULT
;*/

        MOV     EDI,ArgArray                                     ; EDI --> destination array

        MOV     BL,[EDX].DDC.ddc_fbClrTbl        ; BL = Color table flags
        MOV     EAX,LCOLF_RGB                                    ; Assume RGB mode
        TEST    BL,DDC_RGB_MODE
        JNZ     Return_color_mode                        ; Mode is RGB

        MOV     EAX,LCOLF_PALETTE               ; Assume RGB mode
        TEST    BL,DDC_PALETTE
        JNZ     Return_color_mode                        ; Mode is Palette

        MOV     EAX,LCOLF_DEFAULT
        TEST    BL,DDC_LOG_CLR_TBL
        JZ      Return_color_mode                        ; Mode is default color table
        MOV     EAX,LCOLF_INDRGB                         ; AH was trashed by the LAR!

;/*
;** EAX has the current mode (format)
;*/


Return_color_mode:
                                                ; Return current color table
                                                ; format
        STOSD
        .ERRNZ  QCD_LCT_FORMAT                  ; First DWORD
        mov     ebx,[edx].DDC.ddc_npdevpal


;/*
;** Currently:
;**       ecx = ArgCount
;**       edi -> ArgArray[1]
;**       edx = pddc
;**       ebx = ddc_npdevpal
;**
;**
;**        if (ArgCount > 1)
;*/

        dec     ecx
        jz      qcd_exit

;/*
;**        {
;**            /**********************************************************/
;**            /* there is room for the Min value                        */
;**            /* this is stored in the pdc for color tables          */
;**            /* and is always 0 for palettes                           */
;**            /**********************************************************/
;**
;**            if (pdc->DCIColFormat == LCOLF_PALETTE)
;*/

                test    [edx].DDC.ddc_fbClrTbl,DDC_PALETTE
                jz      else_1

;/*
;**            {
;**                ArgArray[1] = 0;
;*/

                mov     eax,0
                jmp     end_if1

;/*
;**            }
;**            else
;*/

else_1:
;/*
;**            {
;**
;**                ArgArray[1] = pdc->DCILowIndex;
;*/

                mov     eax,[edx].DDC.ddc_ctMin


end_if1:
                STOSD

;/*
;**            }
;**
;**
;** Currently:
;**       ecx = ArgCount-1
;**       edi -> ArgArray[2]
;**       edx = pddc
;**       ebx = ddc_npdevpal
;**
;**            if (ArgCount > 2)
;*/

        dec     ecx
        jz      qcd_exit

;/*
;**            {
;**                /******************************************************/
;**                /* there is room for the Max value                    */
;**                /* this is stored in the DCIData for color tables     */
;**                /* and in the palette structure for palettes          */
;**                /******************************************************/
;**
;**                if (pdc->DCIColFormat == LCOLF_PALETTE)
;*/

                test    [edx].DDC.ddc_fbClrTbl,DDC_PALETTE
                jz      else_2

;/*
;**                {
;**                    ArgArray[2] = pdc->Palette->usMax;
;*/

                        mov     eax,[ebx].DEVPAL.usMax
                        jmp     end_if2

;/*
;**                }
;**                else
;*/

else_2:
;/*
;**                {
;**
;**                    ArgArray[2] = pdc->DCIHighIndex;
;*/

                mov     eax,[edx].DDC.ddc_ctMax
end_if2:
                STOSD

;/*
;**
;**                }
;**
;**
;**----------------------------------------------------------------------
;**  Currently:
;**       ecx = ArgCount-2
;**       edi -> ArgArray[3]
;**       edx = pddc
;**       ebx = ddc_npdevpal
;**----------------------------------------------------------------------
;**                if (ArgCount > 3)
;*/

        dec     ecx
        jz      qcd_exit

;/*
;**                {
;**                    /**************************************************/
;**                    /* there is room for the flags                    */
;**                    /* for color tables these come from the pdc       */
;**                    /* for palettes they come from the palette data   */
;**                    /**************************************************/
;**
;**                    if (pdc->DCIColFormat == LCOLF_PALETTE)
;*/

                test    [edx].DDC.ddc_fbClrTbl,DDC_PALETTE
                jz      else_3

;/*
;**                    {
;**                        /**********************************************/
;**                        /* we may store additional internal flags in  */
;**                        /* the palette structure so make sure that we */
;**                        /* mask to return just the user flags         */
;**                        /**********************************************/
;**                        ArgArray[3] = pdc->Palette->usFlags &
;**                                      (LCOL_PURECOLOR |
;**                                       LCOL_OVERRIDE_DEFAULT_COLORS);
;*/

                        mov     eax,[ebx].DEVPAL.usFlags
                        and     eax,LCOL_PURECOLOR + LCOL_OVERRIDE_DEFAULT_COLORS
                        STOSD
                        jmp     end_if3

;/*
;**                    }
;**                    else
;*/

else_3:
;/*
;**                    {
;**
;**                        ArgArray[3] = pdc->DCIColStatus;
;** ddc_fbClrTbl       DCIColStatus
;** --------------------------------
;** !DDC_DITHER     -> LCOL_PURECOLOR
;** DDC_REALIZABLE -> LCOL_REALIZABLE
;*/

                        mov     eax,0
                        mov     bl,[edx].DDC.ddc_fbClrTbl
                        test    bl,DDC_DITHER
                        jnz     @F
                        or      eax,LCOL_PURECOLOR
@@:
                        test    bl,DDC_REALIZABLE
                        jz      @F
                        or      eax,LCOL_REALIZABLE
@@:
                        STOSD

;/*
;**
;*/

end_if3:
;/*
;**                    }
;**----------------------------------------------------------------------
;** Currently:
;**       ecx = ArgCount-3
;**       edi -> ArgArray[4]
;**       edx = pddc
;**----------------------------------------------------------------------
;**
;**
;**                    /**************************************************/
;**                    /* Zero any array elements that are not been used */
;**                    /**************************************************/
;**                    for (i = 4; i < ArgCount; i++)
;*/

                        dec     ecx
                        mov     eax,0
                        REP     stosd

;/*
;**                    {
;**                        ArgArray[i] = 0;
;**                    }
;**                }
;**
;**                /******************************************************/
;**                /* Zero any array elements that have not been used.   */
;**                /******************************************************/
;**                for (i = 3; i < ArgCount; i++)
;**                {
;**                    ArgArray[i] = 0;
;**                }
;**
;**            }
;**        }
;**    }
;**
;**    /******************************************************************/
;**    /* Release driver semaphore                                       */
;**    /******************************************************************/
;**    ExitDriver(hddc, FunN, EDF_STANDARD);
;**
;**    PROFILE_EXIT(31);
;**    return(OK);
;**
;**
;** /**********************************************************************/
;** /* omitted because we cant now have an error in this function!        */
;** /**********************************************************************/
;** QRYCOLORDATA_ERR_EXIT:
;**    /******************************************************************/
;**    /* Release driver semaphore                                       */
;**    /******************************************************************/
;**    ExitDriver(hddc, FunN, EDF_STANDARD);
;**
;**    PROFILE_EXIT(31);
;**
;**    return(ERROR_ZERO);
;**
;*/

qcd_exit:
    mov     eax,OK
        INVOKE  leave_driver
qcd_exit_no_lock:
    ret
eddc_QueryColorData ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = eddc_QueryLogColorTable
;*
;* DESCRIPTION   = Returns the values stored in the current logical color
;*                 table.  The only valid option is:
;*
;*                 LCOLOPT_INDEX   - The routine must return the index for each
;*                                   RGB value.
;*
;* INPUT         = hdc        :HDC
;*                 ArgOptions :ULONG
;*                 ArgStart   :ULONG
;*                 ArgCount   :ULONG
;*                 ArgArray   :PULONG
;*                 hddc       :PDDC
;*                 FunN       :ULONG
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
eddc_QueryLogColorTable PROC SYSCALL USES ESI EBX EDI,
        hdc             :HDC   ,
        ArgOptions      :ULONG ,
        ArgStart        :ULONG ,
        ArgCount        :ULONG ,
        ArgArray        :PULONG,
        hddc            :PDDC  ,
        FunN            :ULONG

;/*
;**    ULONG          i;            /* Loop count                        */
;**    ULONG          Index;        /* Index into ArgArray               */
;**    ULONG          Result;       /* Value returned                    */
;**
;**
;**    /******************************************************************/
;**    /* Get driver semaphore and perform entry checks                  */
;**    /******************************************************************/
;**    EnterDriver(hddc, FunN, EDF_STANDARD);
;*/

        cld
        ddc?    hddc

        mov     edx,hddc
        INVOKE  enter_driver

        mov     eax,ERROR_ZERO
        jc      qlct_exit_no_lock                ;error logged

        ASSUME  ESI:PDDC

        mov     esi,edx

;/*
;**    PROFILE_ENTER(32);
;**
;**
;**    /******************************************************************/
;**    /* this call cannot be used if there is a palette selected into   */
;**    /* this DC                                                        */
;**    /******************************************************************/
;**    if (pdc->DCIColFormat == LCOLF_PALETTE)
;*/

        mov     eax,PMERR_PALETTE_SELECTED
        test    [esi].ddc_fbClrTbl,DDC_PALETTE
        jnz     qlct_error

;/*
;**    {
;**        LOGERR(TFUNC, "palette error", 0L, 0 ,PMERR_PALETTE_SELECTED);
;**        goto QRYLOGCOLTABLE_ERR_EXIT;
;**    }
;**
;**
;**    /******************************************************************/
;**    /* Check whether start index is valid                             */
;**    /******************************************************************/
;**    if (ArgStart > pdc->DCIHighIndex)
;*/

        mov     eax,ArgStart
        cmp     eax,[esi].ddc_ctMax
        mov     eax,PMERR_INV_COLOR_START_INDEX
        ja      qlct_error

;/*
;**    {
;**        LOGERR(TFUNC, "Invalid start index", &ArgStart, 1,
;**                                           PMERR_INV_COLOR_START_INDEX);
;**        goto QRYLOGCOLTABLE_ERR_EXIT;
;**    }
;**
;**    /******************************************************************/
;**    /* Check whether the count is a reasonable value                  */
;**    /******************************************************************/
;**    if (ArgCount & 0xFFFF0000)
;*/

        mov     eax,PMERR_INV_LENGTH_OR_COUNT
        test    ArgCount,0ffff0000h
        jnz     qlct_error

;/*
;**    {
;**        LOGERR(TFUNC, "Invalid count", &ArgCount, 1,
;**                                             PMERR_INV_LENGTH_OR_COUNT);
;**        goto QRYLOGCOLTABLE_ERR_EXIT;
;**    }
;**
;**    /******************************************************************/
;**    /* Check whether the options are valid. The only acceptable       */
;**    /* option is LCOLOPT_INDEX                                        */
;**    /******************************************************************/
;**    if (ArgOptions & ~(ULONG)LCOLOPT_INDEX)
;*/

        mov     eax,PMERR_INV_COLOR_OPTIONS
        test    ArgOptions,NOT LCOLOPT_INDEX
        jnz     qlct_error

;/*
;**    {
;**        LOGERR(TFUNC, "Invalid options", &ArgOptions, 1,
;**                                               PMERR_INV_COLOR_OPTIONS);
;**        goto QRYLOGCOLTABLE_ERR_EXIT;
;**    }
;**
;**    /******************************************************************/
;**    /* If current mode is RGB mode then no elements are returned.     */
;**    /******************************************************************/
;**    if (pdc->DCIColFormat == LCOLF_RGB)
;*/

        mov     EAX,QLCT_RGB
        test    [esi].ddc_fbClrTbl,DDC_RGB_MODE
        jnz     qlct_exit_ok

;/*
;**    {
;**        Result = QLCT_RGB;
;**        goto QRYLOGCOLTABLE_OK_EXIT;
;**    }
;**
;**    if (ArgOptions & LCOLOPT_INDEX)
;**    {
;*/

        test    ArgOptions,LCOLOPT_INDEX
        jz      not_index

;/*
;**        /**************************************************************/
;**        /* ArgCount must be even, as we are returning pairs of values */
;**        /**************************************************************/
;**        ArgCount &= 0xFFFFFFFE;
;*/

        and     ArgCount,0FFFFFFFEh
not_index:
;/*
;**    }
;**
;**    /******************************************************************/
;**    /* Reset index into results array                                 */
;**    /******************************************************************/
;**    Index = 0;
;*/

        mov     edx,0


;/*
;**    /******************************************************************/
;**    /* Enter loop which writes values into results array              */
;**    /******************************************************************/
;**    for (i = ArgStart;
;**         (Index < ArgCount) && (i <= pdc->DCIHighIndex);
;**         i++)
;*/

        mov     edi,ArgArray
        ASSUME  EDI:PULONG

        mov     ebx,[esi].ddc_pClrTbl
        mov     ecx,ArgStart
        jmp     enter_loop
loop_top:

;/*
;**    {
;**        if (pdc->DCIColorTable[i].PhyIndex != CLR_NOPHYINDEX)
;*/

        .ERRNZ  sizeof COLORTABLETYPE - 8
        cmp     [ebx+ecx*8].COLORTABLETYPE.PhyIndex,CLR_NOPHYINDEX
        je      else_1

;/*
;**        {
;**            /**********************************************************/
;**            /* Entry in logical color table is valid                  */
;**            /**********************************************************/
;**            if (ArgOptions & LCOLOPT_INDEX)
;*/

        test    ArgOptions,LCOLOPT_INDEX
        jz      end_index

;/*
;**            {
;**                /******************************************************/
;**                /* Write index                                        */
;**                /******************************************************/
;**                ArgArray[Index++] = i;
;*/

        mov     [edi+edx*sizeof ULONG],ecx
        inc     edx
end_index:

;/*
;**            }
;**            /**********************************************************/
;**            /* Write RGB value                                        */
;**            /**********************************************************/
;**            ArgArray[Index++] = URGB(pdc->DCIColorTable[i].LogRGB);
;*/

        .ERRNZ  sizeof COLORTABLETYPE - 8
        mov     eax,[ebx+ecx*8].COLORTABLETYPE.LogRGB
        mov     [edi+edx*sizeof ULONG],eax
        inc     edx
        jmp     endif_1

;/*
;**        }
;**        else
;*/

else_1:

;/*
;**        {
;**            /**********************************************************/
;**            /* The entry in the logical color table is invalid. If    */
;**            /* LCOLOPT_INDEX is set then skip the entry.              */
;**            /**********************************************************/
;**            if ( !(ArgOptions & LCOLOPT_INDEX) )
;*/

        test    ArgOptions,LCOLOPT_INDEX
        jnz     skip_entry

;/*
;**            {
;**                /******************************************************/
;**                /* Write a value to indicate that the current RGB     */
;**                /* value is invalid.                                  */
;**                /******************************************************/
;**                ArgArray[Index++] = QLCT_NOTLOADED;
;*/

        mov     [edi+edx*sizeof ULONG],QLCT_NOTLOADED
        inc     edx

;/*
;**            }
;*/

skip_entry:

;/*
;**        }
;*/

endif_1:

;/*
;**    }
;*/

        ;edx = Index
        ;ecx = i
        inc     ecx

enter_loop:
        cmp     edx,ArgCount
        jae     exit_loop
        cmp     ecx,[esi].ddc_ctMax
        jbe     loop_top

exit_loop:
;/*
;**
;**    /******************************************************************/
;**    /* Return the number of values written to results array           */
;**    /******************************************************************/
;**    Result = Index;
;*/

        mov     eax,edx
        jmp     qlct_exit_ok

;/*
;**
;** QRYLOGCOLTABLE_OK_EXIT:
;**    /******************************************************************/
;**    /* Release driver semaphore                                       */
;**    /******************************************************************/
;**    ExitDriver(hddc, FunN, EDF_STANDARD);
;**
;**    PROFILE_EXIT(32);
;**    return(Result);
;**
;**
;** QRYLOGCOLTABLE_ERR_EXIT:
;**    /******************************************************************/
;**    /* Release driver semaphore                                       */
;**    /******************************************************************/
;**    ExitDriver(hddc, FunN, EDF_STANDARD);
;**
;**    PROFILE_EXIT(32);
;**
;**    return(QLCT_ERROR);
;** }
;** #undef TFUNC
;*/

qlct_error:
        save_error_code
        mov     eax,QLCT_ERROR
qlct_exit_ok:
        INVOKE  leave_driver
qlct_exit_no_lock:
        ret
eddc_QueryLogColorTable ENDP

;/***************************************************************************
;*
;* FUNCTION NAME = device_enter_driver
;*
;* DESCRIPTION   = If we are an OD_DIRECT DC using a LCT then we must check
;*                 that the indexes in the color table are upto date.  (ie the
;*                 device default palette for the screen may have changed
;*                 since the indexes were calculated).  Note that we have to
;*                 check to see if we actually have a DC because we often get
;*                 delete bitmap calls without a DC.
;*
;*
;* INPUT         = ebx -> pddc
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

device_enter_driver PROC SYSCALL

        ASSUME  EBX:PDDC

;/*
;**    if (   (pdc != NULL)
;**        && (pdc->DCIDCType == OD_DIRECT)
;;;**        && (pdc->DCIColFormat != LCOLF_RGB)        ;           - Deleted 
;**        && (pdc->DCIColFormat != LCOLF_PALETTE)
;**        && (pdc->DCIDeviceDefaultPalette != DirectDeviceDefaultPalette) )
;*/

        cmp     ebx,0
        jz      ded_exit
        test    [ebx].ddc_fb,DDC_DEVICE
        jz      no_check
;;        test    [ebx].ddc_fbClrTbl,DDC_RGB_MODE       ;           - Deleted
;;        jnz     no_check                              ;           - Deleted 
        test    [ebx].ddc_fbClrTbl,DDC_PALETTE
        jnz     no_check
        mov     eax,[ebx].ddc_pDefPal
        cmp     eax,DirectDeviceDefaultPalette
        je      no_check

;/*
;**    {
;**        /**************************************************************/
;**        /* If we are using the default logical color table then we    */
;**        /* must point to the one that is now being used.  (It will    */
;**        /* contain the same RGBs but different physical indexes       */
;**        /* because the device default palette has changed).           */
;**        /* Otherwise we must recalculate our physical indexes.        */
;**        /**************************************************************/
;**        if (pdc->DCIColFormat == LCOLF_DEFAULT)
;*/

        test    [ebx].ddc_fbClrTbl,DDC_RGB_MODE+DDC_LOG_CLR_TBL+DDC_PALETTE
        jnz     not_default

;/*
;**        {
;**            pdc->DCIColorTable = DefaultDirectLogicalColorTable;
;*/

        mov     eax,DefaultDirectLogicalColorTable
        mov     [ebx].ddc_pClrTbl,eax

;/*
;**            pdc->DCIDeviceDefaultPalette = DirectDeviceDefaultPalette;
;*/


        mov     eax,DirectDeviceDefaultPalette
        mov     [ebx].ddc_pDefPal,eax
        jmp     no_check
not_default:

;/*
;**        else
;**        {
;**            /**********************************************************/
;**            /* This function will recalculte the physical indexes     */
;**            /* into the current device default palette and set        */
;**            /* DCIDeviceDefaultPalette.                               */
;**            /**********************************************************/
;**            CalculateColorTablePhysicalIndices();
;*/

        INVOKE  CalculateColorTablePhysicalIndices,
                ebx

;/*
;**        }
;**    }
;*/

no_check:

;/*
;**    /******************************************************************/
;**    /* Check whether the system colors have changed since this DC     */
;**    /* last entered the driver.                                       */
;**    /******************************************************************/
;**    if (   !(fEnterOptions & EDF_DC_NULL)
;**        && (pdc->DCISysColState != CurrentSysColState) )
;*/

        mov     eax,[ebx].ddc_iSysClr
        cmp     eax,ddcInit.ddc_iSysClr
        je      ded_exit

;/*
;**    {
;**        /**************************************************************/
;**        /* System colors have changed, so we need to propagate the    */
;**        /* changes through the LCT and the attribute bundles.         */
;**        /**************************************************************/
;**        eddc_PropagateSysColorChanges();
;*/

        INVOKE  eddc_PropagateSysColorChanges,
                ebx

;/*
;**    }
;*/

ded_exit:
        ret
device_enter_driver ENDP

        END
