;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CURSTRC.INC
;*
;* DESCRIPTIVE NAME = Cursor related structures
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Cursor related structures
;*
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;** Equates
;*/

LEFT           equ     1
RIGHT          equ     2
PD_CLIP_BOTTOM EQU 10000000b
PD_CLIP_TOP    EQU 01000000b
PD_CLIP_RIGHT  EQU 00100000b
PD_CLIP_LEFT   EQU 00010000b
PD_VALID       EQU 00001000b

PD_CLIPPED EQU PD_CLIP_BOTTOM OR PD_CLIP_TOP OR PD_CLIP_RIGHT OR PD_CLIP_LEFT

PTRI_ANIMATE EQU 2      ; Indicates pointer is animated.

FBPTR_COLOR EQU 00000001b
FB_OLD_PTR   EQU 10000000b
FB_NEW_PTR   EQU 01000000b
FB_FLUSH_X   EQU 00100000b
FB_FLUSH_Y   EQU 00010000b
FB_OVERLAP   EQU 00001000b
FB_READ_X    EQU 00000100b
FB_READ_Y    EQU 00000010b
FB_WORK_RECT EQU 00000001b

;/*
;** Structures
;*/

;/*
;** POINTB is used for points with a range of -128..+127.
;*/

POINTB  STRUC
   ptb_x db     0
   ptb_y db     0
POINTB  ENDS

;/*
;** SIZEB is used for extents with a range of -128..+127.
;*/

SIZEB   STRUC
   sizb_cx db   0
   sizb_cy db   0
SIZEB   ENDS

;/*
;** SIZES is used for extents with a range of +/- 32K.
;*/

SIZES   STRUC
   sizs_cx dw   0
   sizs_cy dw   0
SIZES   ENDS


;/*
;** POINTB is used for points with a range of -128..+127.
;*/

POINTB  STRUCT
   ptb_x BYTE 0
   ptb_y BYTE 0
POINTB  ENDS

POINTW  STRUCT
   ptw_x BYTE 0
   ptw_y BYTE 0
POINTW  ENDS

        .ERRNZ  sizeof POINTB AND 1
;/*
;** The RECT_DATA structure is used for describing the rectangles which will
;** be manipulated by this code.  The fields are:
;**
;** ptbSave     This is the (X,Y) origin of the given rectangle in the save
;**                area.
;**
;** ptlScreen   This is the (X,Y) origin of the given rectangle on the screen.
;**
;** sizb        This is the extents of the rectangle.
;**
;** ptbWork     This is the (X,Y) origin of the given rectangle in the work
;**                area.
;*/

RECT_DATA STRUCT 1
   ptlScreen POINTL <0,0>
   ptwSave   POINTW <0,0>
   ptsDelta  POINTW <0,0>
   sizs      SIZES  <0,0>
RECT_DATA ENDS

        .ERRNZ  sizeof RECT_DATA AND 1

;/*
;** The POINTER_DATA structure is used for describing the actual pointer's
;** rectangle.  It also contains clipping information and control flags.  The
;** fields are:
;**
;** rd               RECT_DATA structure as defined above
;**
;** fb            Flags as follows:
;**
;** PD_VALID         1 The rectangle contains valid data.
;**                  0 The rectangle data is invalid.
;**
;** PD_CLIP_BOTTOM   1 Clip the bottom
;**                  0 No bottom clipping needed
;**
;** PD_CLIP_TOP      1 Clip the top
;**                  0 No top clipping needed
;**
;** PD_CLIP_LEFT     1 Clip the lhs
;**                  0 No lhs clipping needed
;**
;** PD_CLIP_RIGHT    1 Clip the rhs
;**                  0 No rhs clipping needed
;*/

POINTER_DATA STRUCT 1
   rd   RECT_DATA <>
   fb   BYTE      0
   x_clip   BYTE      0
POINTER_DATA ENDS

CURSORSTRUCT STRUCT 4

;/*
;** cxPointer is the width of the pointer in bits.  The size must be a correct
;** multiple for the PTR_ROUND_* values given above (e.g. if rounding to byte
;** boundaries, then this must be a multiple of 8.
;**
;** cyPointer is the height of the pointer in scans.
;**
;** These values are returned from the move_pointers routine.
;*/

cxPointer DWORD PTR_WIDTH_BITS
cyPointer DWORD PTR_HEIGHT

;/*
;** (cxCell,cyCell) is the location of the pointer on the screen.  These
;** locations are only updated whenever a pointer is drawn.
;**
;** (cxReal,cyReal) is the location of the pointer as specified by the user.
;** These locations are always kept current.
;**
;** These cells may not be the same if the pointer drawing takes a lot of time
;** and the mouse is moving quickly.  Therefore, after a pointer has been
;** drawn, a check must be made to see if the pointer has moved, and if so,
;** the pointer must be drawn again.
;*/

cxCell  DWORD   INIT_POINTER_X                   ; X cell of last drawn pointer
cyCell  DWORD   INIT_POINTER_Y                   ; Y cell of last drawn pointer
cxReal  DWORD   INIT_POINTER_X                   ; Real x location of pointer
cyReal  DWORD   INIT_POINTER_Y                   ; Real x location of pointer

;/*
;** cxHot and cyHot contain the hot spot adjustment for the pointer.
;**
;** These locations should be zeroed whenever a pointer is changing or has
;** been turned off, and should be set once a pointer has been defined.  When
;** the pointer is turned off, the hot spot adjustment should be added back to
;** the real pointer coordinates (cxReal, cyReal).  When a pointer is set,
;** they should be subtracted off.  This will keep the pointer based at the
;** hot spot during a change instead of the upper left corner.
;*/

cxHot   DWORD   0       ;X hot spot adjustment
cyHot   DWORD   0       ;Y hot spot adjustment

;/*
;** The following structure contains the bounding rectangle wherein the
;** pointer is not allowed to be displayed.  The values for left and right
;** will always be rounded to contain the entire byte (or word or dword if
;** working to those boundaries).
;**
;** These values will only be valid if exclude_count is non-zero.
;**
;** NOTE: Only one rectangle at a time may be set.
;*/

ExcludeRect RECTL <0,0,0,0>

fwPrevFlags WORD  0

ExcludeCt   BYTE  RECT_NOT_PRES ; Set non-zero if rectangle is valid

;/*
;**       screen_busy is a flag used for critical section code to
;**       indicate that the screen is busy.  Since pointer operations
;**       take a very long time (e.g. drawing a pointer), the screen_busy
;**       flag is set to 0 to show that the screen is busy, and then
;**       interrupts are enabled to allow other interrupts.  The basic
;**       operation for the semephore is:
;**
;**               xor     cx,cx
;**               xchg    screen_busy,cx
;**               jecxz   operation_in_progress
;*/

screen_busy             BYTE                     NOT_BUSY ;Show screen not busy

;/*
;** fbPtrFlags contains control flags indicating the pointer status.  Flags
;** are defined for the pointer being off, and the pointer being excluded.
;*/

fbPtrFlags BYTE PTR_OFF ;Pointer status, initially hidden

;/*
;** ppdOld is the pointer to the old pointer's POINTER_DATA structure.
;*/

;/*
;** ppdNew is the pointer to the new pointer's POINTER_DATA structure.
;*/

;/*
;** These are used as indices now
;*/

ppdOld  DWORD   0
ppdNew  DWORD   SIZEOF POINTER_DATA

;/*
;** pAndXor is the pointer to which AND/XOR mask is to be used.  It is based
;** on the 3 least significant bits of the pointer's X coordinate.  pColor is
;** the pointer to which COLOR mask is to be used.
;*/

pAndXor DWORD   INVALID_ADDRESS
pColor  DWORD   INVALID_ADDRESS

;/*
;** The following are the masks which make up the pointer image.  There will
;** be one AND/XOR/COLOR mask trio for each possible alignment.  On
;** move_pointers call, all the alignments will be generated to save time
;** processing the interrupt.
;*/

BaseAndMasks   BYTE (MASK_LENGTH)     dup (?)
BaseXorMasks   BYTE (MASK_LENGTH)     dup (?)
BaseColorMasks BYTE (PTR_WIDTH * 8 * PTR_HEIGHT) dup (?)

;/*
;** These are used as indices now
;*/

pdPtr0    POINTER_DATA <>       ; Old/New pointer's data
pdPtr1    POINTER_DATA <>       ; Old/New pointer's data

;/*
;** The following flags and flag bytes are used to control which rectangles
;** are used for what.
;**
;** fbFlush controls which rectangles are to be copied from the save area to
;** the screen.  Valid flags are:
;**
;**   FB_OLD_PTR, FB_FLUSH_X, FB_FLUSH_Y
;**
;**   FB_OLD_PTR is mutually exclusive of all other flags
;**
;** fbAndRead controls which rectangles are to be ANDed into the work area
;** from the screen or save area, and which rectangles are to be copied from
;** the screen to the save area.  Valid flags are:
;**
;**   FB_NEW_PTR, FB_OVERLAP, FB_READ_X, FB_READ_Y, FB_WORK_RECT,
;**
;**   FB_NEW_PTR and FB_WORK_RECT are mutually exclusive of all other flags.
;**   Note that FB_OVERLAP doesn't apply when coping into the save area.
;**
;** fbXor describes which rectangle is to be XORed from the work area into the
;** screen.  Valid flags are:
;**
;**   FB_NEW_PTR, FB_WORK_RECT
;**
;**   FB_NEW_PTR and FB_WORK_RECT are mutually exclusive
;*/

fbFlush   BYTE  0


;/*
;** fbPointer tells us if the pointer is color.
;*/

fbPointer BYTE  0
selScreenPtr    DWORD INVALID_ADDRESS
pVRAMRing0      DWORD INVALID_ADDRESS

PtrXorMask SIZES <PTR_WIDTH,PTR_HEIGHT>
PtrAndMask SIZES <PTR_WIDTH,PTR_HEIGHT>
PtrColorMask SIZES <PTR_WIDTH*8,PTR_HEIGHT>
PtrSizeBytes SIZES <PTR_WIDTH*8,PTR_HEIGHT>

AndSumArray     db          PTR_HEIGHT dup(0)
XorSumArray     db          PTR_HEIGHT dup(0)
PtrWidthBytes   dw          0
PtrHeightBytes  dw          0

clipped_and_mask    db  MASK_LENGTH dup (?)
clipped_xor_mask    db  MASK_LENGTH dup (?)
clipped_color_mask  db  PTR_WIDTH * 8 * PTR_HEIGHT dup (?)

and_mask            dd  0
xor_mask            dd  0
color_mask          dd  0

SaveBufferShift     db      0

PtrSaveArea     dw  ((PTR_WIDTH_BITS * PTR_HEIGHT)/2) dup (0)
PtrWorkArea     dw  ((PTR_WIDTH_BITS * PTR_HEIGHT)/2) dup (0)
curbank         dw  0
scan_per_bank   dw  0
dst_scan_line_left dw   0

hw_state        db  22 dup(0)
board_type      db  0

bank_reg        dw 0

curs_bank_switch_rtn    dd      offset _PtrCode32:null_curs_bank_switch
curs_save_hw_state_rtn  dd      offset _PtrCode32:null_save_hw_state_rtn
curs_restore_hw_state_rtn dd    offset _PtrCode32:null_restore_hw_state_rtn

ring_flag               db      0

CURSORSTRUCT ENDS

PCURSORSTRUCT typedef PTR CURSORSTRUCT

