;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SEM.INC
;*
;* DESCRIPTIVE NAME = Fast safe RAM semaphore data structure.
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/21/87
;*
;* DESCRIPTION  
;*
;*      The following information is contained in the fast safe semaphore data
;*      structure:
;*      
;*          - 16 bit length field that specifies the length of the semaphore
;*            data structure, in bytes.
;*      
;*          - 32 bit process/thread ID that uniquely identifies the thread of
;*            execution that owns the semaphore.  If this field is zero then the
;*            semaphore is unowned.
;*      
;*          - 16 bit client field that is not interpreted by the functions in this
;*            module.  Instead it is a field provided to the caller as a means for
;*            identifying which resource is currently owned by the owner of the
;*            semaphore.  It is initialized to zero when a semaphore is first
;*            acquired, and thereafter the value of the field is under the control of
;*            the caller, until the semaphore is released.  It is useful to a
;*            DosExitList handler in figuring out the appropriate cleanup action.
;*      
;*          - 16 bit usage count.  This count is incremented each time the current
;*            owner acquires the semaphore and decrement each time the current owner
;*            releases the semaphore.  The current owner does not actually release
;*            its ownership until the count decrements to zero.
;*      
;*          - a 32 bit CPDOS RAM semaphore.  This RAM semaphore is manipulated by
;*            the functions in this module in the same manner as the the ring 3
;*            semaphore code in CPDOS (e.g. DOSSEMREQUEST and DOSSEMCLEAR).
;*      
;*          - a 32 bit time out value to use when waiting on the CPDOS RAM semaphore.
;*              
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/21/87                     Written by Steve Wo
;*
;*****************************************************************************/

;/*
;** Fast safe RAM semaphore structure
;*/

FastSafeRamSemStruc     struc
        fs_Length       dw  ?                     ; #bytes in this data structure
        fs_Padding      dw  ?                     ; padding for 32 bit alignment
        fs_ProcID       dw  ?                     ; Process ID of owner or zero
        fs_ThrdID       dw  ?                     ; Thread ID of owner or zero
        fs_Usage        dw  ?                     ; reference count
        fs_Client       dw  ?                     ; 16 bit field for use by owner
        fs_Timeout      dd  ?                     ; Timeout value
        fs_RAMSem       dd  ?                     ; CPDOS RAM Semaphore
FastSafeRamSemStruc     ends
