;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = RESOLVEC.ASM
;*
;* DESCRIPTIVE NAME = Resolve Undefined externals
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/18/88
;*
;* DESCRIPTION  Extracted routines from RESOLVE.ASM which are common to all drivers
;*
;*
;* FUNCTIONS    SetCharFont
;*              SetMarkerFont
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/18/88                     Written by Robert J. Carragher [t-robc]
;*
;*****************************************************************************/

        .386

        .xlist

        OPTION  OLDSTRUCTS

INCL_DDIBUNDLES     equ     1
INCL_DEV            equ     1
INCL_FONTFILEFORMAT equ     1
INCL_GRE_FONTS      equ     1
INCL_GPIERRORS      equ     1

        include pmgre.inc

DINCL_ENABLE    equ     1
DINCL_ROPS      equ     1
DINCL_BB_ROPS   equ     1
DINCL_SAVE_SCREEN_BITS  equ   1
DINCL_VIO       equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP    equ     1

        include driver.inc
        include fontseg.inc
        include extern.inc
        include protos.inc
        include tune.inc
        .list

        .MODEL FLAT

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

ALIGN 4
        pubabs  DEF_LOG_FORE_CLR,7
        pubabs  DEF_LOG_BACK_CLR,0

        pubabs  DEF_FB_LINE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_LINE,%(ROP_P)
        pubabs  DEF_BMIX_LINE,%(ROP_D)
        pubabs  DEF_LINE_TYPE,%(LINETYPE_SOLID-1)
        pubabs  DEF_LINE_ERROR,0
        pubabs  DEF_LINE_MASK,0

        pubabs  DEF_FB_MARKER,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_MARKER,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_MARKER,%(BA_IS_XPARENT)
        pubabs  DEF_MARKER_FB_FLAGS,0
        pubabs  DEF_MARKER_FS_FLAGS,0
        pubabs  DEF_MARKER_CODE_POINT,%(MARKSYM_CROSS)

        pubabs  DEF_FB_CHAR,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_CHAR,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_CHAR,%(BA_IS_XPARENT)
        pubabs  DEF_FONT_FS_FLAGS,0

        pubabs  DEF_FB_PATTERN,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_PATTERN,%(ROP_P)
        pubabs  DEF_BMIX_PATTERN,%(ROP_D)
        pubabs  DEF_PATTERN_FB_FLAGS,(PA_SINGLE_CLR)
        pubabs  DEF_PATTERN_FS_FLAGS,0
        pubabs  DEF_PATTERN_CODE_POINT,%(PATSYM_SOLID)

        pubabs  DEF_FB_IMAGE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_IMAGE,%(FM_OVERPAINT-1)
        pubabs  DEF_BMIX_IMAGE,%(BA_IS_XPARENT)

FD_VECTOR       equ    0000000000000001B

        .CODE
_TUNE SEGMENT DWORD FLAT PUBLIC 'CODE'
;/***************************************************************************
;*
;* FUNCTION NAME = SetCharFont
;*
;* DESCRIPTION   = Invoke the routine which deals with font selection.
;*                 We expect this routine to set BA_REREALIZE if it is appropriate.
;*                 We can ignore the offset to the font because we FIREWALLed
;*                 it to be zero, and all our code would fall apart if it wasn't.
;*                 We don't need to worry about writing into the ddc and then
;*                 detecting an error because DeviceSetAttributes saved the
;*                 contents of the bundle for error recovery.
;*
;*
;* INPUT         = EBX --> ddc
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters
;*                 CX     =  ca_fs, most flags cleared
;*                 ES:SI --> attribute bundle
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = EAX = 1
;* RETURN-ERROR  = EAX = 0
;*
;**************************************************************************/

ALIGN 4
SetCharFont     PROC SYSCALL USES esi edi

        DebugMsg <SetCharFont, resolvec, CLIFFL>

        ASSUME  ebx:PTR DDC

ifdef FIREWALLS


        mov     [ebx].ddc_ca.ca_paus,INVALID_ADDRESS
endif

;/*
;** Get all the data from the defs bundle while we still have it's pointer
;** If this is a user supplied font, the code page will be in the defs
;** bundle.  If it is the default, the code page is in ddc_ca.ca_idCodePage
;*/

        ASSUME  esi:PTR DCHARBUNDLE

        mov     eax,[esi].dcbnd_cdef.cdef_charSpacing
        movzx   eax,al                            ;Cheat - Keep small for now
        mov     [ebx].ddc_ca.ca_cExtraPels,eax
        neg     eax                               ;'C' if non-zero
        sbb     eax,eax                           ;FFFF if non-zero char extra
        and     eax,CA_CHAR_EXTRA
        or      ecx,eax

        mov     eax,[esi].dcbnd_cdef.cdef_CodePage
        or      cx,cx
        js      scf_have_desired_code_page

        .errnz  CA_USER_FONT-8000h

        mov     eax,[ebx].ddc_ca.ca_idCodePage

scf_have_desired_code_page:

        mov     esi,eax                           ;Save desired code page in SI

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.
;*/

        ASSUME  edx:PTR FOCAFONT

        mov     edx,[ebx].ddc_ca.ca_pFont
        xor     eax,eax

        or      ecx,CA_VECTOR
        test    [edx].ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jne     scf_all_done                     
        and     ecx,not CA_VECTOR                ;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     scf_log_huge_error;Font is huge, don't accept it

        cmp     [edx].ff_fdDefinitions.fdh_xCellWidth,8
        jne     @F
        or      ecx,CA_WIDTH_IS_8
@@:
        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      ecx,CA_FIXED_PITCH
@@:
        cmp     [edx].ff_fdDefinitions.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      ecx,CA_ABC_SPACE
@@:

;/*
;** If the font is not in the default code page (850), then no mapping
;** is possible.If the font is the default code page and a different
;** code page is to be used, get the mapping array.  If getting the
;** mapping array fails, return an error.
;*/

        cmp     [edx].ff_fmMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     scf_all_done
        cmp     esi,DEFAULTVIOCODEPAGE
        je      scf_all_done
        or      esi,esi                           ;0 = use the default in the font
        je      scf_all_done

;/*
;** Get the mapping vector for this code page.  Don't bother to get access
;** now since the access test has to be made at output time.
;*/

        push    ebx
        push    ecx

        INVOKE  Gre32Entry3, esi, 0, NGreQueryCodePageVector

        pop     ecx
        pop     ebx
        mov     [ebx].ddc_ca.ca_paus,eax
        or      eax,eax
        jz      scf_exit                         ;Error, return 0
        or      ecx,CA_MUST_MAP

scf_all_done:

        or      [ebx].ddc_ca.ca_ba.ba_fb,BA_REREALIZE
        mov     eax,1

scf_exit:

        RET

scf_log_huge_error:

        mov     eax,PMERR_HUGE_FONTS_NOT_SUPPORTED

        save_error_code

        xor     eax,eax

        jmp     scf_exit

SetCharFont     ENDP
_TUNE ENDS
_TUNE2 SEGMENT DWORD FLAT PUBLIC 'CODE'
;/***************************************************************************
;*
;* FUNCTION NAME =
;*
;* DESCRIPTION   = Invoke the routine which deals with marker selection.
;*                 We expect this routine to set BA_REREALIZE if it is appropriate.
;*
;*                 We can ignore the offset to the font because we firewalled it to
;*                 be zero, and all our code would fall apart if it wasn't.
;*
;*                 We don't need to worry about writing into the ddc and then
;*                 detecting an error because DeviceSetAttributes saved the
;*                 contents of the bundle for error recovery.
;*
;* INPUT         = DS:BX --> ddc
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters
;*                 CX     =  pa_fs
;*                 ES:SI --> attribute bundle
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = EAX = 1
;* RETURN-ERROR  = EAX = 0
;*
;**************************************************************************/

ALIGN 4
SetMarkerFont   PROC SYSCALL USES edi

        DebugMsg <SetMarkerFont, resolvec, CLIFFL>

ifdef FIREWALLS

        mov     [ebx].ddc_ma.ma_paus,INVALID_SEL

endif

;/*
;** Get all the data from the defs bundle while we still have it's pointer
;** If this is a user supplied font, the code page will be in the defs
;** bundle.  If it is the default, we want to set the default code page
;** so we don't try for the mapping vector.
;*/

        ASSUME  esi:PTR DMARKERBUNDLE

        mov     edx,[ebx].ddc_ma.ma_pFont

        ASSUME  edx:PTR FOCAFONT

        mov     esi,[esi].dmbnd_mdef.mdef_CodePage
        or      ecx,ecx
        js      @F

        .errnz  CA_USER_FONT-8000h

        mov     esi,DEFAULTVIOCODEPAGE
@@:

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.  It seems a little unusual
;** to execute this code even for the default marker, but someday we
;** might allow the font to be set at initialization time.
;*/

        xor     eax,eax

        or      ecx,CA_VECTOR
        test    [edx].ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jne     smf_all_done                     
        and     ecx,not CA_VECTOR;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     smf_log_huge_error;Font is huge, don't accept it

        cmp     [edx].ff_fdDefinitions.fdh_xCellWidth,8
        jne     @F
        or      ecx,CA_WIDTH_IS_8
@@:
        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      ecx,CA_FIXED_PITCH
@@:
        cmp     [edx].ff_fdDefinitions.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      ecx,CA_ABC_SPACE
@@:

;/*
;** If the font is not in the default code page (850), then no mapping
;** is possible.If the font is the default code page and a different
;** code page is to be used, get the mapping array.  If getting the
;** mapping array fails, return an error.
;*/

        cmp     [edx].ff_fmMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     smf_all_done
        cmp     esi,DEFAULTVIOCODEPAGE
        je      smf_all_done
        or      esi,esi                           ;0 = use the default in the font
        je      smf_all_done

;/*
;** Get the mapping vector for this code page.  Don't bother to get access
;** now since the access test has to be made at output time.
;*/

        INVOKE  Gre32Entry3, esi, 0, NGreQueryCodePageVector

        mov     [ebx].ddc_ma.ma_paus,eax
        or      eax,eax
        jz      smf_exit                         ;Error, return 0
        or      ecx,CA_MUST_MAP

smf_all_done:

        or      [ebx].ddc_ma.ma_ba.ba_fb,BA_REREALIZE
        mov     eax,1

smf_exit:

        RET

smf_log_huge_error:

        mov     eax,PMERR_HUGE_FONTS_NOT_SUPPORTED

        save_error_code

        xor     eax,eax

        jmp     smf_exit

SetMarkerFont   ENDP
_TUNE2 ENDS
end
