;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = QUERY.ASM
;*
;* DESCRIPTIVE NAME = Device Query Routines
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/16/87
;*
;* DESCRIPTION  This file contains the routines which handle device queries
;*
;* FUNCTIONS    QueryDeviceBitmaps
;*              QueryDeviceCaps
;*              QueryHardcopyCaps
;*              QueryDevResource2
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   05/06/87                     Hock Lee [hockl] Wrote it.
;*   07/17/87                     Hock Lee [hockl] Modified for new DDI.
;*   01/07/88                     Bob Grudem [bobgru] Changed OutDataLength
;*                                parameter to be Count as per DCR 23633.
;*   01/26/88                     Wes Rupel [wesleyr] Finished implementing DCR
;*                                23633
;*   01/27/88                     Walt Moore [waltm] The big rewrite.
;*   02/12/88                     Charles Whitmer [chuckwh] The small rewrite.
;*                                Maximal paranoia about argument checking.
;*   12/6/92              SM12669 DAK  separate fonts into different HMODULE
;*   11/02/92              56549  Changes needed to work with 256-color SVGA
;*   11/26/92                     John Batty. Added DCAF changes.
;*   02/18/93              62409  Changes done by 56549 (above) introduced
;*                                a regression. It makes me mad!
;*   02/26/93              62900  Defect 62409 hammerd all 1024x768 fonts.
;*
;*****************************************************************************/

.386
.MODEL FLAT
ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT
        .xlist
INCL_DEV                equ     1
INCL_DOSRESOURCES       equ     1
INCL_WINPOINTERS        equ     1
        include pmgre.inc
DINCL_VIO               equ     1
DINCL_BITMAP            equ     1
DINCL_ENABLE            equ     1
        include driver.inc
        include protos.inc
        include extern.inc
        include assert.mac
        include tune.inc
        .list
.CODE
page

;/***************************************************************************
;*
;* FUNCTION NAME = QueryDeviceBitmaps
;*
;* DESCRIPTION   = This function returns a list of bitmap formats supported by
;*                 the device. The number of formats supported can be found
;*                 using the QueryDeviceCaps function.  Each value in the list
;*                 is of the form: (u32_Planes, u32_BitsPerPixel).
;*                 Zero fills the unused buffer space.
;*
;*                 Registers Preserved:
;*                       SI,DI,BP,DS
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*
;* INPUT         = hdc             :DWORD
;*                 lpOutData       :DWORD
;*                 Count           :DWORD
;*                 hddc            :DWORD
;*                 FunN            :DWORD
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = DX:AX = 1
;* RETURN-ERROR  = DX:AX = 0
;*                 Error logge
;**************************************************************************/

ALIGN 4
QueryDeviceBitmaps  PROC SYSCALL USES EBX ESI EDI,
        hdc             :DWORD,
        lpOutData       :DWORD,
        Count           :DWORD,         ;# of elements in array lpOutData
        hddc            :DWORD,
        FunN            :DWORD

        DebugMsg <QueryDeviceBitmaps>
        mov     edx,Count
        shr     edx,1                   ; DX = #DWORD PAIRS we may return
        jnc     qdb_valid               ; ie (cPlanes,cBitsPerPel)
qdb_error:
        mov     eax,PMERR_INV_LENGTH_OR_COUNT
qdb_error_ret:
        save_error_code
        mov     eax,0
        jmp     qdb_exit
ALIGN 4
qdb_valid:

;/*
;** return the minimum of what we have and what fits
;*/

        mov     ecx,adDevCapsData[CAPS_BITMAP_FORMATS*4] ;#DWORD PAIRS

        cmp     ecx,edx
        jb      have_the_min
        mov     ecx,edx                 ; CX = types to return
have_the_min:
        sub     edx,ecx                 ; DX = how much zero fill
        jc      qdb_error
        jecxz   qdb_exit_ok
        mov     esi,padBitmapFormats    ;Pointer to bitmap formats
        mov     edi,lpOutData           ;--> where we're to return the formats
        cld
        add     ecx,ecx                 ; b/c we're moving DWORD PAIRS
        rep     movsd

        mov     ecx,edx
        add     ecx,ecx                 ; b/c we're moving DWORD PAIRS
        mov     eax,0
        rep     stosd
qdb_exit_ok:
        mov     eax,1
qdb_exit:
        ret
QueryDeviceBitmaps  ENDP
page
_TUNE SEGMENT DWORD FLAT PUBLIC 'CODE'
;/***************************************************************************
;*
;* FUNCTION NAME = QueryDeviceCaps(hdc,Index,lpOutData,Count,hddc,FunN)
;*
;* DESCRIPTION   = The desired value is returned from the devcaps_table block.
;*
;*                 Registers Preserved:
;*                       SI,DI,BP,DS
;*                 Registers Destroyed:
;*                       AX,BX,CX,DX,ES,FLAGS
;*
;* INPUT         = hdc             :DWORD
;*                 Index           :DWORD
;*                 lpOutData       :DWORD
;*                 Count           :DWORD
;*                 hddc            :DWORD
;*                 FunN            :DWORD
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = DX:AX = 1
;* RETURN-ERROR  = DX:AX = 0
;*                 Error logged
;**************************************************************************/

ALIGN 4
QueryDeviceCaps PROC SYSCALL USES edi esi ebx,
        hdc             :DWORD,
        Index           :DWORD,
        lpOutData       :DWORD,
        Count           :DWORD,
        hddc            :DWORD,
        FunN            :DWORD

        DebugMsg <QueryDeviceCaps>
ifdef DCAF                                                           ;          
        ddc?    hddc                    ;Check that the ddc is valid ;          
endif ; DCAF                                                         ;          
        cld
        mov     ecx,Count
        cmp     ecx,0
        jne     qdc_good_count
        mov     eax,PMERR_INV_LENGTH_OR_COUNT
        save_error_code
        mov     eax,0
        jmp     qdc_error_return
ALIGN 4
qdc_good_count:
        mov     eax,4000h               ;16K dwords per 64K segemnt
        cmp     ecx,eax
        ja      qdc_have_count
        xchg    eax,ecx                 ;Give them what they asked for
qdc_have_count:                         ;EAX = number of dwords to write
        mov     edi,lpOutData
        mov     esi,Index
        .errnz  CAPS_FAMILY             ;Must be zero based
                                                                     ;          
ifdef DCAF                                                           ;          
        ; ** Fix for VGA     - always returns OD_DIRECT as DC type **;          
        ; **                 - should return current DC type       **;          
        ; We do this by adjusting the DC type stored in the          ;          
        ; CAPS_FAMILY entry of the table.                            ;          
        ; Skip past this code if CAPS_FAMILY is not being queried.   ;          
        .errnz  CAPS_FAMILY                                          ;          
        or      esi,esi                                              ;          
        jnz     caps_family_not_queried                              ;          
                                                                     ;          
        mov     ebx,hddc                                             ;          
        ASSUME  ebx:PTR DDC                                          ;          
        test    [ebx].ddc_fb,DDC_DEVICE                              ;          
        jz      not_direct_dc                                        ;          
        mov     ebx,OD_DIRECT                                        ;          
        jmp     short store_dc_type                                  ;          
                                                                     ;          
not_direct_dc:                                                       ;          
        test    [ebx].ddc_fbAbove,DDC_INFO_DC                        ;          
        jz      not_info_dc                                          ;          
        mov     ebx,OD_INFO                                          ;          
        jmp     short store_dc_type                                  ;          
                                                                     ;          
not_info_dc:                                                         ;          
        mov     ebx,OD_MEMORY                                        ;          
                                                                     ;          
store_dc_type:                                                       ;          
        mov     adDevCapsData[CAPS_FAMILY*SIZE_DWORD],ebx            ;          
                                                                     ;          
caps_family_not_queried:                                             ;          
endif ; DCAF                                                         ;          
                                                                     ;          
        mov     ecx,COUNT_DEV_CAPS_DATA ;Max index + 1
        cmp     esi,ecx
        jae     qdc_xfered_caps         ;No dev caps to xfer

;/*
;** We will have to transfer some number of device caps to the caller's
;** buffer.
;*/

        sub     ecx,esi                 ;CX = number dev caps remaining
        sub     eax,ecx                 ;AX = number to zero fill
        jnc     @F                      ;Return to end, and zero fill
        add     ecx,eax                 ;Number of dev caps to xfer
        mov     eax,0                   ;Nothing to zero fill
@@:
        shl     esi,2                   ;SI = start index * 4
        .errnz  SIZE_DWORD-4
        add     esi,OFFSET adDevCapsData[CAPS_FAMILY*SIZE_DWORD]

        rep     movsd

qdc_xfered_caps:
        jz      qdc_all_done            ;Nothing to fill with
        mov     ecx,eax
        mov     eax,0
        rep     stosd

qdc_all_done:
        mov     eax,1
qdc_error_return:
        fw_zero <ecx>
        ret
QueryDeviceCaps ENDP
_TUNE ENDS
page

;/***************************************************************************
;*
;* FUNCTION NAME = QueryHardcopyCaps(hdc,Start,Count,lpInfo,hddc,FunN)
;*
;* DESCRIPTION   = Returns zero forms.
;*
;*                 Registers Preserved:
;*                       SI,DI,BP,DS
;*                 Registers Destroyed:
;*                       none
;*
;* INPUT         = hdc     :DWORD
;*                 Start   :DWORD
;*                 Count   :DWORD
;*                 lpInfo  :DWORD
;*                 hddc    :DWORD
;*                 FunN    :DWORD
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = DX:AX = 0
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ALIGN 4
QueryHardcopyCaps  PROC SYSCALL USES EBX,
        hdc     :DWORD,
        Start   :DWORD,
        Count   :DWORD,
        lpInfo  :DWORD,
        hddc    :DWORD,
        FunN    :DWORD

        DebugMsg <QueryHardcopyCaps>
        xor     eax,eax
        ret
QueryHardcopyCaps  ENDP
page
_TUNE SEGMENT DWORD FLAT PUBLIC 'CODE'
;/***************************************************************************
;*
;* FUNCTION NAME = QueryDevResource2(hdc,resType,id,hddc,FunN)
;*
;* DESCRIPTION   = This function returns the selectors and offsets to resources to
;*                 the graphics engine and the user interface component. Since this
;*                 driver has only one set of resources this is        easy
;*                 Warning:
;*                   The 8514 now has two default fonts; one for the 8514 and one
;*                   for 8515. We must return the appropriate font by recognizing
;*                   the display.
;*
;* INPUT         = DWORD  hdc;
;*                 DWORD  resType;
;*                 DWORD  id;
;*                 DWORD  hddc;
;*                 DWORD  FunN;
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = DX = selector to the resource
;*                 AX = offset to the resource
;*                 DX:AX = 0 if resource doesn't exist (that never happens to us).
;* RETURN-ERROR  = DX:AX = -1
;*
;**************************************************************************/

ALIGN 4
QueryDevResource2 PROC SYSCALL USES edi esi ebx ecx,
        hdc             :DWORD,
        resType         :DWORD,
        id              :DWORD,
        hddc            :DWORD,
        FunN            :DWORD

        LOCAL pResource :DWORD

        DebugMsg <QueryDevResource2 SEL DISPATCH query.asm>

        mov     ecx,_hModuleDev

        mov     ebx,id
        mov     eax,lCursorSize
        cmp     eax,1
        je      qdr2_plasma                    ; force use of larger pointers
        cmp     eax,2
        je      qdr2_push_id                   ; force use of smaller pointers
                                               ; otherwise base it on display test.
        cmp     wDisplay,DISPLAY_PLASMA        ; bigger pointers on LCD and Plasma
        jne     qdr2_push_id                   ; if not, don't mess with it

qdr2_plasma:
        cmp     resType, RT_POINTER            ; is it a pointer type?
        jne     qdr2_push_id                   ; if not, don't mess with it

        cmp     ebx,SPTR_ARROW
        je      qdr2_arw                       ;           
        cmp     ebx,WPTR_ARROW                 ;           
        je      qdr2_arw                       ;           
        cmp     ebx,SPTR_TEXT
        je      qdr2_txt                       ;           
        cmp     ebx,WPTR_IBEAM                 ;           
        jne     qdr2_get_res
qdr2_txt:                                      ;           
        mov     ebx,292                        ;            NOTE: - see VGA.RC/EGA.RC
        jmp     qdr2_get_res                   ; go get it
qdr2_arw:                                      ;           
        mov     ebx,291                        ;            NOTE: - see VGA.RC/EGA.RC
        jmp     qdr2_get_res                   ; go get it
                                               ; and continue
ALIGN 4
qdr2_push_id:
        cmp     resType,RT_OUR_FONT
;       je      qdr2_fnt_type                   ;          
        jne     not_our_default                 ;          
        cmp     ebx,0100                        ;           Only do font switch for
        jne     qdr2_fnt_type                   ;           SFONT_RASTER
        lea     esi,cResource                   ;           get the id of the default
        add     esi,sizeof cResource            ;           font we are using
        mov     ebx,[esi].FONT_RES.fr_usId      ;          
        jmp     short qdr2_fnt_type             ;          
not_our_default:                                ;          
        cmp     resType,RT_FONTDIR
        jne     qdr2_get_res
qdr2_fnt_type:
        mov     ecx,_hModuleFnt

qdr2_get_res:
        INVOKE  DosGetResource2,
                ecx,
                resType,
                ebx,
                ADDR pResource
;           - comment out this error logging because it is very likely that
;             there will be errors during system boot intentionally because
;             of an algorithm in PMWIN which tries to load bitmaps from
;             the display driver which may not be in the driver.
;             or      eax,eax
;             jz      qdr2_ok
;                     
;             mov     ebx,eax                 ;error code in ebx
;             mov     eax,PMERR_BASE_ERROR    ;
;             save_error_code
;             xor     eax,eax                 ;eax=0
;             jmp     qdr2_exit
;           - new stuff:

        or      eax,eax
        jz      qdr2_ok
        xor     eax,eax                  ;eax=0
        jmp     qdr2_exit
ALIGN 4
qdr2_ok:
        mov     eax,pResource
qdr2_exit:
        ret
QueryDevResource2 ENDP
_TUNE ENDS
end
