;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    Make Valid
        SUBTITLE Header

;/*****************************************************************************
;*
;* SOURCE FILE NAME = MKVALID2.ASM
;*
;* DESCRIPTIVE NAME =  Color and brush validation routines.
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/12/91
;*
;* DESCRIPTION  Color and brush validation routines.
;*
;* FUNCTIONS    xform_pattern_origin
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/12/91                     KEZ  Original
;*
;*****************************************************************************/

        .386P
        .MODEL FLAT,SYSCALL

;/*
;** Included files
;*/

INCL_DDIFONTSTRUCS EQU 1
INCL_DDIMISC       EQU 1
INCL_GPIPRIMITIVES EQU 1
INCL_GPITRANSFORMS EQU 1
INCL_GRE_XFORMS    EQU 1
INCL_NOBASEAPI     EQU 1
INCL_NOCOMMON      EQU 1
INCL_SAADEFS       EQU 1
OS2_NOPMAPI        EQU 1

        OPTION  OLDSTRUCTS

        INCLUDE PMGRE.INC

DINCL_BITMAP       EQU 1
DINCL_CLR_TBL      EQU 1
DINCL_ENABLE       EQU 1
        include fontmap.inc
        INCLUDE DRIVER.INC
        INCLUDE EXTERN.INC
        INCLUDE PROTOS.INC
        INCLUDE ASSERT.MAC
        INCLUDE STRBLT.INC
        include tune.inc
.CODE
_TUNE SEGMENT DWORD FLAT PUBLIC 'CODE'
        SUBTITLE xform_pattern_origin
        PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = xform_pattern_origin
;*
;* DESCRIPTION   = The pattern reference point is transformed into device
;*                 coordinates. If overflow occurs, an error is returned, else the
;*                 reference point is stored in the DDC with the dc origin added in.
;*
;*                 Registers Preserved:
;*                        SI,DI,DS,BP
;*                 Registers Destroyed:
;*                        AX,BX,CX,DX,ES,Flags
;*
;* INPUT         = ESI --> DDC
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = EAX = 1 if OK
;* RETURN-ERROR  = EAX = 0 if error, error logged
;*
;**************************************************************************/

ALIGN 4
xform_pattern_origin PROC SYSCALL PUBLIC

        DebugMsg <xform_pattern_origin KEZ, mkvalid.asm>

        PUSH        [ESI].DDC.ddc_pa.pa_ptlOrg.ptl_y
        PUSH        [ESI].DDC.ddc_pa.pa_ptlOrg.ptl_x
        MOV        ECX,ESP
        XOR        EAX,EAX
        INVOKE  PFNDefConvert PTR pfnDefConvert,
                        [ESI].DDC.ddc_hdc,
                        CVTC_WORLD,
                        CVTC_DEVICE,
                        ECX,
                        1,
                        0,
                        NGreConvert
        OR        EAX,EAX
        JNZ        XPO_Valid_origin
        ADD        ESP,sizeof POINTL                ; Remove POINTL from stack
        MOV        EAX,PMERR_INV_PATTERN_REF_PT_ATTR
        save_error_code
        XOR        EAX,EAX
        JMP        XPO_Exit
ALIGN 4

;/*
;** We don't care about overflow from adding in the dc origin since we'll
;** be taking the entire mess MOD SIZE_PATTERN-1
;*/

XPO_Valid_origin:
        POP        EAX
        MOV        EBX,[ESI].DDC.ddc_prddc                        ; EBX = RDDC
        rddc?        EBX
        ADD        EAX,[EBX].RDDC.rddc_ptsOrg.ptl_x
        MOV        [ESI].DDC.ddc_pa.pa_ptsOrg.ptl_x,EAX
        POP        EAX
        ADD        EAX,[EBX].RDDC.rddc_ptsOrg.ptl_y
        MOV        [ESI].DDC.ddc_pa.pa_ptsOrg.ptl_y,EAX
        MOV        EAX,1

XPO_Exit:
        RET

xform_pattern_origin ENDP
_TUNE ENDS
        END
