;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page        ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = GETCLIP.ASM
;*
;* DESCRIPTIVE NAME = Get clipping rectangles
;*
;*
;* VERSION      V2.0
;*
;* DATE         05/12/87
;*
;* DESCRIPTION  
;*
;* The Application can select into the DC two distinct clip areas:
;* The clip region and the clip path.
;* In addition the Window manager keeps another clip region known
;* as the vis-region.  This is the part of the Window that is visible
;* on the screen -- not overlapped by other windows.
;*
;* The "region" structures are a bunch of rects, while the
;* clip path is defined by linked ShortLine structures.  The Engine
;* intersects the two regions so that all we see in the Driver is
;* the "rao region" -- the actual region where we are allowed to draw.
;* So at this level we just have to clip to the rao region and
;* the clip path.  Some driver functions are pre-cliped by the Engine
;* and PolyScanline is pre-clipped to the clip path, but not the rao region:
;* 
;* 
;*                         Driver Drawing Operations
;*                         -------------------------
;* 
;*      no clipping             Clip to                clip to both region
;*        needed                   region only                  and clip path
;*    --------------         ----------------       -------------------
;* 
;*   DrawLinesInPath          PolyScanLine                StrBlt
;*   PolyShortLine                                 BitBlt
;*   (DrawConicsInPath?                                ImageData (Calls Bitblt)
;*   probably simulation)                        SetPel
;*                                                 PolyLine
;*
;* Even though PolyScanline appears to have different clipping needs,
;* it is in fact the same as Strblt and Bitblt because a linked list
;* of ShortLines (ScansData) is passed to PolyScanline as the target.
;* Therefore the following subroutine is designed to be called by 
;* PolyScanline, Strblt, and Bitblt.
;*             
;*
;* FUNCTIONS    get_clip_rects
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        .386

        .xlist

INCL_GPIREGIONS equ        1
INCL_GRE_CLIP        equ        1
DINCL_BITMAP    equ     1
DINCL_ENABLE    equ     1
DINCL_EXTENDEDCONTROL equ 1

        include        pmgre.inc
        include driver.inc
        include extern.inc
        include protos.inc

        .list

NRECTS        equ        5

        .MODEL FLAT
    
        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

        .CODE

;/***************************************************************************
;*
;* FUNCTION NAME = get_clip_rects
;*
;* DESCRIPTION   = Returns the rectangles in the clipping region of the DC. 
;*                
;*                 Registers Destroyed:
;*                         EAX,EBX,ECX,EDX
;*
;* INPUT         = lpRectBound  A far pointer to a bounding rectangle.  Only 
;*                      rectangles intersecting this bounding rectangle 
;*                      will be returned. If this pointer is NULL, all 
;*                      rectangles in the region will be enumerated.
;*             
;*                      A "NULL" bounding rectangle is assumed to be 
;*                      one whose selector is 0.
;*             
;*                 lpRectBuffer (aka RectList)
;*                      A far pointer to a buffer where the list of rectangles 
;*                      is to be returned.
;*             
;*                 lpControl
;*                      A far pointer to a structure containing the following 
;*                      elements:
;*             
;*                      wStart
;*                          The rectangle number to start enumerating at.  Set 
;*                          this to zero to start from the beginning.
;*             
;*                      wBufsize
;*                          The number of rectangles that will fit into the buffer.
;*                          Must be at least 1.
;*             
;*                      wNumWritten
;*                          A returned value indicating how many rectangles were
;*                          written into the buffer. A value below U16_BUFSIZE 
;*                          means there are no more rectangles to enumerate.
;*             
;*                      wDirection
;*                          Indicates the direction the rectangles are listed.
;*
;*                 ESI =        ddc                     
;*                 EBP =        extended control buffer 
;*
;* OUTPUT        =
;*
;* RETURN-NORMAL = EAX = 0
;* RETURN-ERROR  = EAX = non-zero
;*
;*                       Pseudo-Code
;*{
;*      The driver can handle this call without calling the engine IF
;*      (there is only 1 clip rect) OR
;*      ((the number of clip rects is less or equal to NUM_CLIP_RECTS)
;*      AND (the direction is 4))
;*
;*       if ( we can handle it )
;*               copy the clip rects stored in the DDC into RectBuffer
;*               trimming them to RectBound as we do it.
;*       else
;*               call engine ( GetClipRects )
;*}
;*
;**************************************************************************/

ALIGN 4
get_clip_rects  PROC    SYSCALL USES edi


        DebugMsg <get_clip_rects, getclip, CLIFFL>


        ddc?        esi

;/*
;**  If the clip rects change while were looping back to get more.
;**  We will need some sort of sema4
;*/

        ASSUME  esi:PTR DDC, ebp:PTR EXTENDED_CONTROL

        mov        ecx,[esi].ddc_crcsClip
        cmp        ecx,1
        jz        we_can_do_it
        cmp        ecx,NUM_CLIP_RECTS
        ja        must_call_engine

we_can_do_it:


must_call_engine:

        .errnz        EXTENDED_CONTROL.ec_control

        lea        ebx,[ebp].ec_buffer

        lea        edi,[ebp].ec_rect_bound

        INVOKE  PFNDefGetClipRects PTR pfnDefGetClipRects,
                [esi].ddc_hdc,
                edi,
                ebp,
                ebx,
                0,
                NGreGetClipRects 

ifdef FIREWALLS                        ;make this an assert

        or        eax,eax
        jnz        result_ok
        rip        text,<GetClipRects returns error>

result_ok:

endif


gcr_exit:

                RET

get_clip_rects  ENDP

end
