;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    Exit Routines
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EXIT.ASM
;*
;* DESCRIPTIVE NAME = Exit Routine
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/11/91
;*
;* DESCRIPTION  Contains exit routine for process termination.
;*
;* FUNCTIONS    exit_list_proc
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/11/91                     KEZ  Original
;*   12/06/92		  SM12669 DAK  separate fonts into different HMODULE
;*   12/03/92              57589  32-Bit Semaphore Support
;*
;*****************************************************************************/

;/*
;** Model and processor selection                                         
;*/

        .386P

        .MODEL FLAT,SYSCALL

        .CODE

;/*
;** Included files                                                         
;*/

INCL_DOSPROCESS         EQU 1
INCL_DOSERRORS          EQU 1
INCL_DOSSEMAPHORES      EQU 1
INCL_DOSMODULEMGR       EQU 1
INCL_DOSMVDM            EQU 1
INCL_AVIOP              EQU 1

        INCLUDE PMGRE.INC

DINCL_SKIP_DDC     EQU 1

        INCLUDE DRIVER.INC
        INCLUDE EXTERN.INC
        include protos.inc

        SUBTITLE real_exit_list_proc
        PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = exit_list_proc 
;*
;* DESCRIPTION   = This procedure cleans up all allocated resources or clears 
;*                 flags and semaphores that might be owned by the dying process.
;*                 When done, passes control to another address on the exit
;*                 list by calling DosExitList.
;*
;*                 It is critical that this exit routine be as short and
;*                 fail-safe as possible.
;*
;*                 Registers Destroyed:
;*                       All
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

;/*
;** Code 
;*/

        ALIGN 4

exit_list_proc PROC PUBLIC,
        ulTermCode:DWORD

;/*
;** If any thread of the dying process owns the semaphore, force the
;** screen to be not busy, just in case it was busy when the fault happened.
;*/

        INVOKE  check_sem

        or      eax,eax
        jnz     driver_sem_is_ok        ;result zero if our process owns sem

        INVOKE  SetScreenBusy,NOT_BUSY

@@:
        RELEASE_SEM

        cmp     [semDriver].fsrs_Usage,0
        jne     @B

driver_sem_is_ok:

close_the_sem:

        INVOKE  DosFreeModule,
                ADDR _hModuleFnt

        INVOKE  DosFreeModule,
                ADDR _hModuleDev

        ret

exit_list_proc ENDP

        END


