/**************************************************************************
 *
 * File Name    DBGDATA.CMD
 *
 * Descriptive Name  Debug Data Viewer
 *
 * Description  This REXX cmd file allows for easy viewing of the debug
 *              data gathered by the debug version of IBMVGA32.DLL.  To
 *              use it, the debug data must be dumped via the debugger and
 *              stored in a separate file.  The debug command to obtain
 *              the data is:
 *
 *                          dd debugdataarea l288
 *
 *              This data must be stored in a file with no leading or
 *              trailing blank lines and with the memory addresses intact,
 *              e.g.,
 *                      %1aea0020 00230231 01000000 01203312 01235123
 *                      %1aea0030 47685765 00000000 45654859 00010031
 *
 * Parameters   filename - name of file containing data, will prompt for if
 *                         missing
 *
 * Notes
 *
 *
 * Change Activity =
 *   Date      Flag        APAR   Change Description
 *   --------  ----------  -----  --------------------------------------
 *   11/17/93  jdn         75466  Created
 *
 ***********************************************************************/
arg fn

caller.  = 'Unknown'
caller.1 = 'Entering req_controller'
caller.2 = 'Leaving  req_controller'
caller.3 = 'Entering free_controller'
caller.4 = 'Leaving  free_controller'

call Get_Fn

call Get_Data

call Print_Data

exit


/************* routines *****************/


Get_Fn:

if fn = '' then do
   say 'Enter the file name containing the debug info:'
   pull fn
   if fn = '' then exit
end
fn = strip(fn)

return


Get_Data:

new_line = linein(fn)
parse var new_line addr count wrap .
count = x2d(count)
wrap = x2d(wrap)
new_line = linein(fn)
if new_line = '' then do
    say 'No data from file' fn
    exit 1
end

eof = 0
i = 0
first_half = ''
line. = ''
do while eof = 0
   new_line = linein(fn)
   if new_line = '' then eof = 1
   else do
      parse var new_line addr b1 b2 b3 b4
      if first_half = ''
         then do
            first_half = b1 || b2 || b3 || b4
         end
         else do
           i = i + 1
           line.i = first_half || b1 || b2 || b3 || b4
           first_half = ''
         end
   end
end
num_lines = i

return


Print_Data:

indent = 15

say ' '
say '                              pid/tid  fbOffScreen  fCtlMine/VDMMine fCtlNotify'
say '                                               fGrimReaper  fCntlerOwned'

if wrap = 0
then do
   Call Print_Range 1 num_lines
   say num_lines 'lines of debug data'
end
else do
    call Print_Range count+1 num_lines
    call Print_Range 1 count
    say num_lines 'lines of debug data, wrapped' wrap 'time(s)'
end


return


Print_Range:
arg start finish

do i = start to finish
   parse value line.i with 1 callerid 9 pid 17 tid 25 . 31 offscr 33 . ,
      39 grim 41 . 47 mine 49 . 51 vdmmine 53 . 55 owned 57 . 63 notify 65 .

   callerid = strip(callerid,'B','0')
   pid = strip(pid,'L','0')
   if pid = '' then pid = '??'
   tid = strip(tid,'L','0')
   if tid = '' then tid = '??'

   say right(i,3)':'left(caller.callerid,27) right(pid,2)'/'left(tid,2) ,
      '      ' offscr '   ' grim '   ' mine'/'vdmmine '' owned '   ' notify
end

return
