;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    DATA
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DATA.ASM
;*
;* DESCRIPTIVE NAME = Static data for the driver.
;*
;*
;* VERSION      V2.0
;*
;* DATE         9/25/91
;*
;* DESCRIPTION  This file defines the variables statically allocated in the driver's
;*              Data segment.
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/25/91                     KEZ  Original
;*   12/06/91                     DAK  SM12669 separate fonts into different HMODULE
;*   07/06/92                     DAK  41616 model/submodel for nectarine and
;*                                     cursor type
;*   08/18/92              DCR37  Added needed changes for DCR 37
;*   11/17/93  Changeteam  75466  Added a debug data area for the debug
;*                                version only.  See the DBGDATA.CMD file for
;*                                info on how to view the debug data.
;*
;*****************************************************************************/


           .386
           .MODEL FLAT,SYSCALL

;/*
;** Include files
;*/

INCL_GPIPRIMITIVES   EQU 1
INCL_GPIBITMAPS      EQU 1
INCL_DDIMISC         EQU 1
INCL_DEV             EQU 1
OS2_NOBASEAPI        EQU 1
        INCLUDE PMGRE.INC

DINCL_ENABLE         EQU 1
DINCL_VIO            EQU 1
DINCL_ROPS           EQU 1
DINCL_BITMAP         EQU 1
DINCL_VIO            EQU 1
DINCL_BB_ROPS        EQU 1
DINCL_PAT_CACHE_DEFS EQU 1
        INCLUDE DRIVER.INC

        INCLUDE EXTRAS.INC

;/*
;** External references
;*/

        INCLUDE EXTERN.INC
;/*
;** Data declarations
;*/

.DATA

ALIGN 4

;/*
;** Instance Data declarations                                                          *
;*/


pVRAMInstance   dd      0

pdcGlobal    DWORD   0


;/*
;** fEnabled will be 1 if fill_log_dev_blk has never been called.  Once it is
;** called, it will be set to 0.
;*/

fEnabled     BYTE   1            ; Not initialized yet
fPhysEnabled BYTE   1            ; Not initialized yet

;/*
;** fGrimReaper will be 0 whenever the driver can write to the screen, and
;** will be WE_BE_DEAD when we cannot write to the screen.  Death() will set
;** this flag, and Ressurection() will clear it.
;*/

fGrimReaper BYTE   WE_BE_DEAD  ; Did you see "The Meaning of Life"?

;/*
;** fRip will contain a non-zero value if we are to rip whenever an error is
;** reported to WinSetErrorInfo.  This flag will have no effect if FIREWALLS
;** are disabled.
;*/

fbRip   BYTE    0       ; this is normal

;/*
;** selDeathToUse is the selector to the screen returned to us by the
;** GetScreenSelector function.  Only three routines are allowed to use this
;** selector.  one_time_init will place the return value from
;** GetScreenSelector into this location.  physical_enable will transfer it
;** into sdScreen.sd_pBits.sel and set it to INVALID_SEL.  physical_disable
;** will copy sdScreen.sd_pBits.sel back into selDeathToUse and set
;** sdScreen.sd_pBits.sel to INVALID_SEL.
;**
;** Anyone else caught using it will be severly punished.
;** THIS IS NOW A 32 bit FLAT PTR
;*/

ALIGN 4
selDeathToUse  DWORD  -1            ; -1 to cause GP-Fault

;/*
;** hModuleFnt is the module handle of the DLL that contains the font resource
;** hModuleDev is the module handle of the device specific DLL and contains
;**            non-font resources (pointers bitmaps)
;*/

_hModuleFnt DWORD  -1      ; -1 to cause GP-Fault?
_hModuleDev DWORD  -1      ; -1 to cause GP-Fault?

;/*
;** cBrush is the brush reference count.  It is incremented each time a brush
;** is altered, and this number stored in ddc_pa.pa_idBrush.
;*/


;/*
;** idBrushCache is the brush id for the brush currently stored in the cache.
;*/

idBrushCache DWORD  PAT_CACHE_INVALID ; Pattern cache is invalid
                                      ; No brush will ever be 0


;/*
;** Define the pointers to the mix mode mapping tables.  These tables will be
;** used to map incoming mix modes into the mix modes (or indicies) for the
;** particular attribute.
;**
;** Most of the pointers will point to the same table, under the assumption
;** that the mix modes supported will be consistant across all attributes.  If
;** this isn't the case, the pointer to the tables can be changed to point
;** elsewhere into the DS.  No extra tables will be reserved in the DS since
;** we don't expect the default to change dynamically.
;*/

             ALIGN  4

anpabForeMix LABEL  DWORD
             DWORD  abMixMapLine
             .ERRNZ PRIM_LINE-1
             DWORD  abMixMapChar
             .ERRNZ PRIM_CHAR-2
             DWORD  abMixMapMarker
             .ERRNZ PRIM_MARKER-3
             DWORD  abMixMapPattern
             .ERRNZ PRIM_AREA-4
             DWORD  abMixMapImage
             .ERRNZ PRIM_IMAGE-5

anpabBackMix LABEL  DWORD
             DWORD  abBackMixMapLine
             .ERRNZ PRIM_LINE-1
             DWORD  abBackMixMapChar
             .ERRNZ PRIM_CHAR-2
             DWORD  abBackMixMapMarker
             .ERRNZ PRIM_MARKER-3
             DWORD  abBackMixMapPattern
             .ERRNZ PRIM_AREA-4
             DWORD  abBackMixMapImage
             .ERRNZ PRIM_IMAGE-5

;/*
;** A Mix mode mapping table.  The mix modes will be mapped into the old
;** PM Rop2 indicies.  There are some nice properties of the rops in this
;** ordering, including the fact that the second half of the rop table is the
;** inverse of the first half.
;*/

abMixMapPattern LABEL BYTE
abMixMapLine    EQU    this byte

                BYTE   ROP_DPO           ; OR
                .ERRNZ FM_OR-1
                BYTE   ROP_P             ; Overpaint
                .ERRNZ FM_OVERPAINT-2
                BYTE   ROP_D             ; Underpaint
                .ERRNZ 3-3
                BYTE   ROP_DPX           ; XOR
                .ERRNZ FM_XOR-4
                BYTE   ROP_D             ; Leave Alone
                .ERRNZ FM_LEAVEALONE-5
                BYTE   ROP_DPA           ; AND
                .ERRNZ FM_AND-6
                BYTE   ROP_DPNA          ; (NOT source) AND dest
                .ERRNZ FM_SUBTRACT-7
                BYTE   ROP_PDNA          ; source AND (NOT dest)
                .ERRNZ FM_MASKSRCNOT-8
                BYTE   ROP_DDX           ; All Zeros
                .ERRNZ FM_ZERO-9
                BYTE   ROP_DPON          ; NOT (source OR dest)
                .ERRNZ FM_NOTMERGESRC-10
                BYTE   ROP_DPXN          ; NOT (source XOR dest)
                .ERRNZ FM_NOTXORSRC-11
                BYTE   ROP_DN            ; NOT dest
                .ERRNZ FM_INVERT-12
                BYTE   ROP_PDNO          ; source OR (NOT dest)
                .ERRNZ FM_MERGESRCNOT-13
                BYTE   ROP_PN            ; NOT source
                .ERRNZ FM_NOTCOPYSRC-14
                BYTE   ROP_DPNO          ; (NOT source) OR dest
                .ERRNZ FM_MERGENOTSRC-15
                BYTE   ROP_DPAN          ; NOT (source AND dest)
                .ERRNZ FM_NOTMASKSRC-16
                BYTE   ROP_DDXN          ; All Ones
                .ERRNZ FM_ONE-17


;/*
;** Image Mix mode mapping table.  The mix modes will be mapped into the
;** equivalent bitblt mixes.  These will then be used by ImageData to call
;** bitblt.
;*/

abMixMapImage    EQU this byte

                 BYTE   BB_ROP_DSo        ; OR
                 .ERRNZ FM_OR-1
                 BYTE   BB_ROP_S          ; Overpaint
                 .ERRNZ FM_OVERPAINT-2
                 BYTE   BB_ROP_S          ; Underpaint
                 .ERRNZ 3-3
                 BYTE   BB_ROP_DSx        ; XOR
                 .ERRNZ FM_XOR-4
                 BYTE   BB_ROP_D          ; Leave Alone
                 .ERRNZ FM_LEAVEALONE-5
                 BYTE   BB_ROP_DSa        ; AND
                 .ERRNZ FM_AND-6
                 BYTE   BB_ROP_DSna       ; (NOT source) AND dest
                 .ERRNZ FM_SUBTRACT-7
                 BYTE   BB_ROP_SDna       ; source AND (NOT dest)
                 .ERRNZ FM_MASKSRCNOT-8
                 BYTE   BB_ROP_DDx        ; All Zeros
                 .ERRNZ FM_ZERO-9
                 BYTE   BB_ROP_DSon       ; NOT (source OR dest)
                 .ERRNZ FM_NOTMERGESRC-10
                 BYTE   BB_ROP_DSxn       ; NOT (source XOR dest)
                 .ERRNZ FM_NOTXORSRC-11
                 BYTE   BB_ROP_Dn         ; NOT dest
                 .ERRNZ FM_INVERT-12
                 BYTE   BB_ROP_SDno       ; source OR (NOT dest)
                 .ERRNZ FM_MERGESRCNOT-13
                 BYTE   BB_ROP_Sn         ; NOT source
                 .ERRNZ FM_NOTCOPYSRC-14
                 BYTE   BB_ROP_DSno       ; (NOT source) OR dest
                 .ERRNZ FM_MERGENOTSRC-15
                 BYTE   BB_ROP_DSan       ; NOT (source AND dest)
                 .ERRNZ FM_NOTMASKSRC-16
                 BYTE   BB_ROP_DDxn       ; All Ones
                 .ERRNZ FM_ONE-17

abAdjMixMapImage LABEL BYTE

                 BYTE -1          ; 
                 BYTE BB_ROP_SDna ; ROP_DSon <-> ROP_SDna
                 BYTE BB_ROP_DSa  ; ROP_DSna <-> ROP_DSa
                 BYTE BB_ROP_S    ; ROP_Sn   <-> ROP_S
                 BYTE BB_ROP_DSon ; ROP_SDna <-> ROP_DSon
                 BYTE -1          ; 
                 BYTE BB_ROP_DSxn ; ROP_DSx  <-> ROP_DSxn
                 BYTE BB_ROP_SDno ; ROP_DSan <-> ROP_SDno
                 BYTE BB_ROP_DSna ; ROP_DSa  <-> ROP_DSna
                 BYTE BB_ROP_DSx  ; ROP_DSxn <-> ROP_DSx
                 BYTE -1          ; 
                 BYTE BB_ROP_DSo  ; ROP_DSon <-> ROP_SDna
                 BYTE BB_ROP_Sn   ; ROP_S    <-> ROP_Sn
                 BYTE BB_ROP_DSan ; ROP_SDno <-> ROP_DSan
                 BYTE BB_ROP_DSno ; ROP_DSno <-> ROP_DSo

;/*
;** A Mix mode mapping table.  The mix modes will be mapped into the minimal
;** mix modes required of the display driver for characters.
;*/

abMixMapChar   EQU    this byte
abMixMapMarker EQU    this byte

               BYTE   CHAR_ROP_DPO      ; OR
               .ERRNZ FM_OR-1
               BYTE   CHAR_ROP_P        ; Overpaint
               .ERRNZ FM_OVERPAINT-2
               BYTE   CHAR_ROP_P        ; Underpaint
               .ERRNZ 3-3
               BYTE   CHAR_ROP_DPX      ; XOR
               .ERRNZ FM_XOR-4
               BYTE   CHAR_ROP_D        ; Leave Alone
               .ERRNZ FM_LEAVEALONE-5
               BYTE   CHAR_ROP_P        ; AND
               .ERRNZ FM_AND-6
               BYTE   CHAR_ROP_P        ; (NOT source) AND dest
               .ERRNZ FM_SUBTRACT-7
               BYTE   CHAR_ROP_P        ; source AND (NOT dest)
               .ERRNZ FM_MASKSRCNOT-8
               BYTE   CHAR_ROP_P        ; All Zeros
               .ERRNZ FM_ZERO-9
               BYTE   CHAR_ROP_P        ; NOT (source OR dest)
               .ERRNZ FM_NOTMERGESRC-10
               BYTE   CHAR_ROP_P        ; NOT (source XOR dest)
               .ERRNZ FM_NOTXORSRC-11
               BYTE   CHAR_ROP_P        ; NOT dest
               .ERRNZ FM_INVERT-12
               BYTE   CHAR_ROP_P        ; source OR (NOT dest)
               .ERRNZ FM_MERGESRCNOT-13
               BYTE   CHAR_ROP_P        ; NOT source
               .ERRNZ FM_NOTCOPYSRC-14
               BYTE   CHAR_ROP_P        ; (NOT source) OR dest
               .ERRNZ FM_MERGENOTSRC-15
               BYTE   CHAR_ROP_P        ; NOT (source AND dest)
               .ERRNZ FM_NOTMASKSRC-16
               BYTE   CHAR_ROP_P        ; All Ones
               .ERRNZ FM_ONE-17

;/*
;** A Background mix mode mapping table.  The background mix modes will be
;** mapped into the old         Rop2 indicies.  There are some nice properties
;** of the rops in this ordering, including the fact that the second half of
;** the rop table is the inverse of the first half.
;*/

abBackMixMapPattern EQU    this byte
abBackMixMapLine    EQU    this byte

                    BYTE   ROP_DPO           ; OR
                    .ERRNZ BM_OR-1
                    BYTE   ROP_P             ; Overpaint
                    .ERRNZ BM_OVERPAINT-2
                    BYTE   ROP_D             ; Underpaint
                    .ERRNZ 3-3
                    BYTE   ROP_DPX           ; XOR
                    .ERRNZ BM_XOR-4
                    BYTE   ROP_D             ; Leave Alone
                    .ERRNZ BM_LEAVEALONE-5
                    BYTE   ROP_DPA           ; AND
                    .ERRNZ BM_AND-6
                    BYTE   ROP_DPNA          ; (NOT source) AND dest
                    .ERRNZ BM_SUBTRACT-7
                    BYTE   ROP_PDNA          ; source AND (NOT dest)
                    .ERRNZ BM_MASKSRCNOT-8
                    BYTE   ROP_DDX           ; All Zeros
                    .ERRNZ BM_ZERO-9
                    BYTE   ROP_DPON          ; NOT (source OR dest)
                    .ERRNZ BM_NOTMERGESRC-10
                    BYTE   ROP_DPXN          ; NOT (source XOR dest)
                    .ERRNZ BM_NOTXORSRC-11
                    BYTE   ROP_DN            ; NOT dest
                    .ERRNZ BM_INVERT-12
                    BYTE   ROP_PDNO          ; source OR (NOT dest)
                    .ERRNZ BM_MERGESRCNOT-13
                    BYTE   ROP_PN            ; NOT source
                    .ERRNZ BM_NOTCOPYSRC-14
                    BYTE   ROP_DPNO          ; (NOT source) OR dest
                    .ERRNZ BM_MERGENOTSRC-15
                    BYTE   ROP_DPAN          ; NOT (source AND dest)
                    .ERRNZ BM_NOTMASKSRC-16
                    BYTE   ROP_DDXN          ; All Ones
                    .ERRNZ BM_ONE-17
                    BYTE   BM_SRCTRANSPARENT       ;           Source transparent
                    .ERRNZ BM_SRCTRANSPARENT - 18  ;          
                    BYTE   BM_DESTTRANSPARENT      ;           Destination transparent
                    .ERRNZ BM_DESTTRANSPARENT - 19 ;          

abBackMixMapImage   EQU    this byte
abBackMixMapChar    EQU    this byte
abBackMixMapMarker  EQU    this byte

                    BYTE   BA_IS_XPARENT     ; OR
                    .ERRNZ BM_OR-1
                    BYTE   BA_IS_OPAQUE      ; Overpaint
                    .ERRNZ BM_OVERPAINT-2
                    BYTE   BA_IS_XPARENT     ; Reserved (Underpaint)
                    .ERRNZ 3-3
                    BYTE   BA_IS_XPARENT     ; Transparent
                    .ERRNZ BM_XOR-4
                    BYTE   BA_IS_XPARENT     ; Leave alone
                    .ERRNZ BM_LEAVEALONE-5
                    BYTE   BA_IS_XPARENT     ; AND
                    .ERRNZ BM_AND-6
                    BYTE   BA_IS_XPARENT     ; (NOT source) AND dest
                    .ERRNZ BM_SUBTRACT-7
                    BYTE   BA_IS_XPARENT     ; source AND (NOT dest)
                    .ERRNZ BM_MASKSRCNOT-8
                    BYTE   BA_IS_XPARENT     ; All Zeros
                    .ERRNZ BM_ZERO-9
                    BYTE   BA_IS_XPARENT     ; NOT (source OR dest)
                    .ERRNZ BM_NOTMERGESRC-10
                    BYTE   BA_IS_XPARENT     ; NOT (source XOR dest)
                    .ERRNZ BM_NOTXORSRC-11
                    BYTE   BA_IS_XPARENT     ; NOT dest
                    .ERRNZ BM_INVERT-12
                    BYTE   BA_IS_XPARENT     ; source OR (NOT dest)
                    .ERRNZ BM_MERGESRCNOT-13
                    BYTE   BA_IS_XPARENT     ; NOT source
                    .ERRNZ BM_NOTCOPYSRC-14
                    BYTE   BA_IS_XPARENT     ; (NOT source) OR dest
                    .ERRNZ BM_MERGENOTSRC-15
                    BYTE   BA_IS_XPARENT     ; NOT (source AND dest)
                    .ERRNZ BM_NOTMASKSRC-16
                    BYTE   BA_IS_XPARENT     ; All Ones
                    .ERRNZ BM_ONE-17

;/*
;** The display and adapter types are filled in by VioGetConfig in
;** one_time_init bVGAtype will be VGA_EXPRESSWAY only if it is an EXPRESSWAY
;** adapter which in a few cases is not fully compatible.
;** Machine model and sub-model byts is filled in by DosDevConfig.
;*/

        ALIGN   4
wAdapter           WORD   0
wDisplay           WORD   0
bVGAtype           BYTE   0
bModel             BYTE   0
bSubModel          BYTE   0
wSVGAtype          WORD   0
        ALIGN   4
lCursorSize        DWORD  0

        ALIGN   4
hVideoVDD          DWORD   0
lnbTotalScreenSize DWORD   0
pOffScreenUsed     DWORD   0
pOffScreenScan     DWORD   0
yOffScreenScan     DWORD   0
nbOffScreenUsed    DWORD   0

        ALIGN   4

ss_height       DWORD   0       ;# of scans to output
ss_next_scan    DWORD   0       ;Delta to next scan of a bitmap
ss_draw         DWORD   0       ;Function to do output
ss_draw_clipped DWORD   0       ;Function to do clipped output
ss_phases       DWORD   0       ;Phases for 4 character case
ss_colors       DWORD   0       ;Foreground/background colors
ss_p_frame      DWORD   0       ;Link to stack frame
ss_column_width DWORD   0       ;Width of character data column output
ss_clip_mask    BYTE    0       ;Clipping mask
ss_num_chars    BYTE    0       ;Number characters for n char case


ifdef FIREWALLS                                                         ;75466
                                                                        ;75466
DEBUG_RECORDS   EQU     80      ; number of debug records               ;75466
numdebugrecords DWORD   DEBUG_RECORDS                                   ;75466
                                                                        ;75466
debugdataarea   DWORD   ( DEBUG_RECORDS + 1 ) * 8 dup (0)               ;75466
                     ; + 1 for the control record, 8 dwords / record    ;75466
                                                                        ;75466
endif                                                                   ;75466

END
