;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    resolve.asm
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME =  RESOLVE.ASM
;*
;* DESCRIPTIVE NAME =  Device Specific Initialization.
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/01/91
;*
;* DESCRIPTION  Device Specific Initialization.           
;*              
;*              
;* FUNCTIONS    device_specific_init
;*              device_specific_post_init
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/01/91                     Written by Scott Lawson
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

;/*
;** Included files                                                        
;*/

.xlist
OS2_NOBASEAPI           equ     1
INCL_DDIBUNDLES         equ     1
INCL_DEV                equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
        include pmgre.inc
DINCL_ENABLE            equ     1
DINCL_ROPS              equ     1
DINCL_BB_ROPS           equ     1
DINCL_SAVE_SCREEN_BITS  equ     1
DINCL_VIO               equ     1
DINCL_BITMAP            equ     1
        include driver.inc
        include extern.inc
        include protos.inc
        include ega.inc
        .list
.DATA

if SCAN_CNT eq 480
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2667
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,80*480
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,13
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,13
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_HEIGHT,14
endif
if SCAN_CNT eq 600
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2667
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,100*600/2
        pubabs  INIT_FSHADOW_MEM,0                ;Don't use it for VGA
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,10
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,16
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_HEIGHT,14
endif
if SCAN_CNT eq 768
        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2667
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,80*480/2
        pubabs  INIT_FSHADOW_MEM,0                ;Don't use it for VGA
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,10
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,16
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_HEIGHT,14
endif

        pubabs  COLOR_DONT_CARE,%((MM_ALL shl 8)+GRAF_CDC)
        pubabs  DEVCAPS_COLOR_INDEX,63

;/*
;** This driver supports color pointer
;*/

CAPS_COLOR_POINTER_SUPPORT      equ     128
        pubabs  DEVCAPS_COLOR_POINTER_SUPPORT,%(CAPS_COLOR_POINTER_SUPPORT)
        pubabs  DEVCAPS_COLORS,16
        pubabs  DEF_IPC_FORE_CLR,100000b        ; For ega
        pubabs  DEF_IPC_BACK_CLR,111111b        ; For ega
        pubabs  DEVCAPS_HEIGHT_IN_CHARS,24
        pubabs  DEVCAPS_WIDTH_IN_CHARS,80

        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8

        pubabs  IC_SDFB,<SD_DEVICE or SD_COLOR>
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL>


.CODE

;/*
;** Public functions                                                      
;*/

;/***************************************************************************
;*
;* FUNCTION NAME = device_specific_init 
;*
;* DESCRIPTION   = Device Specific Initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ALIGN 4
device_specific_init PROC SYSCALL

;/*
;** Initialize the GSSP structure for the EGA
;*/

        mov     gsspScreen.cb,10000h ;64k
        mov     gsspScreen.pPhysMem,0A0000h
        mov     gsspScreen.ulSize,sizeof GSSP

        mov     padBitmapFormats,OFFSET adBitmapFormats
        mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD],MAKEULONG(0,9)
        mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD],MAKEULONG(0,9)
        CALL    CursorInit
if SCAN_CNT EQ 768

;/*
;**insure that the cursor page gets loaded
;**We can remove this when Dave Schulten fixes the cursor
;**Ring0 Paging stuff...
;*/

        CALL    InnerCheckCursor
EXTERNDEF LoadMyPage:NEAR
        CALL    LoadMyPage

;/*
;**This must stay to enable the bank switching
;*/

endif
        mov     ecx,1
        ret
device_specific_init ENDP

;/***************************************************************************
;*
;* FUNCTION NAME =  device_specific_post_init
;*
;* DESCRIPTION   =  Post- initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ALIGN 4
device_specific_post_init PROC SYSCALL

ifdef SLITE
                                        ;Check for Starlight - Accelerated VGA
        mov     fStarlight,0            ;assume no Starlight

        cli                             ;Enter Crit
        mov     edx,EGA_BASE+GRAF_ADDR   ;save Set/Reset Plane Color reg
        mov     al,GRAF_SET_RESET
        out     dx,al
        xchg    ah,al
        inc     edx
        in      al,dx
        xchg    ah,al                   ;realign & save for later
        mov     ebx,eax                 ;restore

        dec     edx                     ;unlock Starlight
        mov     ax,GRAF_ESR+100h*ESR_UNLOCK
        out     dx,ax

        mov     al,GRAF_BBCR            ;enable Starlight extensions
        out     dx,al                   ;if present
        inc     edx
        in      al,dx
        or      al,BBCR_BBEN            ;set enable bit
        out     dx,al

        dec     edx                     ;get rotate register via std VGA
        mov     al,GRAF_DATA_ROT
        out     dx,al
        inc     edx
        in      al,dx
        mov     ah,al                   ;save it for later restore

        mov     edx,SL_BRot             ;get rotate reg via Starlight
        in      al,dx
        xor     al,07h                  ;and change it
        out     dx,al

        mov     edx,EGA_BASE+GRAF_ADDR  ;get rotate register via std VGA
        mov     al,GRAF_DATA_ROT
        out     dx,al
        inc     edx
        in      al,dx
        cmp     ah,al                   ;did it change ?
        je      not_Starlight           ;no--we're not on a Starlight
        inc     fStarlight              ;yes--we be on a Starlight
not_Starlight:
        mov     al,ah                   ;restore rotate reg
        out     dx,al

        dec     edx                     ;restore Set/Reset Plane Color reg
        mov     eax,ebx
        out     dx,ax

        mov     eax,GRAF_ESR+100h*ESR_LOCK       ;lock Starlight
        out     dx,ax
        sti                             ;Leave Crit
endif


        mov     eax,0                             ;Success
        ret
device_specific_post_init ENDP


HUGE_FONT       equ     8000h                     ;!!! define this in pmddi*
FD_VECTOR       equ     0000000000000001B

end
