;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = POINTER.INC
;*
;* DESCRIPTIVE NAME = Pointer shape definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/29/91
;*
;* DESCRIPTION  Constants are defined for the pointer drawing routine describing
;*              the size of the pointer shape.  Some of these constants are also
;*              required for memory allocation in EGA/VGA VRAM.                 
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/29/91                     KEZ  Original
;*****************************************************************************/

IFNDEF   POINTER_DEFD   ; Don't include if already included
POINTER_DEFD EQU 1      ; Indicate it has been included


;/*
;** The pointer parameters are the size of the pointer as received from
;** DeviceSetCursor.
;*/

IF SCAN_CNT EQ 480

PTR_HEIGHT EQU  32       

ENDIF
IF SCAN_CNT EQ 600

PTR_HEIGHT EQU  32       

ENDIF
IF SCAN_CNT EQ 768

PTR_HEIGHT EQU  32       

ENDIF

PTR_WIDTH      EQU 4                             ; Width in bytes of pointer
PTR_WIDTH_BITS EQU PTR_WIDTH*8                   ; Width in bits of pointer

;/*
;** The work width/height is the size of a pointer as manipulated by the
;** pointer drawing code.
;*/

WORK_WIDTH      EQU     PTR_WIDTH+1               ; Width of mask, work area
WORK_HEIGHT     EQU     PTR_HEIGHT+0              ; Height of mask, work area
MASK_LENGTH     EQU     WORK_WIDTH*WORK_HEIGHT    ; #bytes in mask, work area
CLR_MASK_LENGTH EQU     WORK_WIDTH*WORK_HEIGHT*BITS_PEL ; #bytes in color mask
        .ERRNZ  BITS_PEL-4

;/*
;** The save area parameters control the size of the buffer used for saving
;** the bits underneath the pointer image.  It should be a power of two to
;** allow for easy wrap calculations.
;*/

SAVE_BUFFER_WIDTH  EQU 8                         ; Width  of the save area
SAVE_BUFFER_HEIGHT EQU 32                        ; Height of the save area
        .ERRNZ  PTR_WIDTH  GT SAVE_BUFFER_WIDTH
        .ERRNZ  PTR_HEIGHT GT SAVE_BUFFER_HEIGHT

;/*
;** The following values allow us to set rounding for cursor exclusion.  These
;** values are applied as an AND mask (for rounding left) and as an OR mask
;** (for rounding right).
;*/

ROUNDING_SIZE   EQU 8                            ; Round to byte boundaries
        .ERRNZ  ROUNDING_SIZE and 111b           ; Must be at least byte boundary
PTR_ROUND_RIGHT EQU ROUNDING_SIZE-1               
PTR_ROUND_LEFT  EQU 0FFFFFFF8h                   ; -ROUNDING_SIZE

ENDIF ; POINTER_DEFD
