;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    DATA
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DATADEV.ASM
;*
;* DESCRIPTIVE NAME = Statically allocated data.
;*
;*
;* VERSION      V2.0
;*
;* DATE         09/25/91
;*
;* DESCRIPTION  This file defines the variables statically allocated in the
;*              driver's Data segment.
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/25/91                     KEZ  Original
;*   05/11/89                     DDC_CORR_INV to ddc_fb so rcsCorr is initialized
;*****************************************************************************/

           .386
           .MODEL FLAT,SYSCALL

;/*
;** Include files 
;*/

INCL_GRE_PALETTE     EQU 1
INCL_GRE_XFORMS      EQU 1
INCL_GRE_CLIP        EQU 1
INCL_GPIPRIMITIVES   EQU 1
INCL_GPIBITMAPS      EQU 1
INCL_DDIMISC         EQU 1
INCL_DEV             EQU 1
OS2_NOBASEAPI        EQU 1
        INCLUDE PMGRE.INC

DINCL_ENABLE         EQU 1
DINCL_VIO            EQU 1
DINCL_ROPS           EQU 1
DINCL_BITMAP         EQU 1
DINCL_VIO            EQU 1
DINCL_BB_ROPS        EQU 1
DINCL_PAT_CACHE_DEFS EQU 1
        INCLUDE DRIVER.INC
        INCLUDE EXTRAS.INC
        INCLUDE POINTER.INC
;/*
;** External references
;*/
         INCLUDE EXTERN.INC
;/*
;** Data declarations
;*/
        .DATA
;/*
;** The following equates define certain constants relating to the VGA display
;** that are used during driver initialization.
;*/

public  SCREEN_CY
public  SCREEN_CX
public  SCREEN_CBSCAN
public  SCREEN_DSCAN
public  INIT_POINTER_X
public  INIT_POINTER_Y
public  PATTERN_SCAN_UPDATE        ;          

if SCAN_CNT EQ 480
ifdef VGA132    
SCREEN_CX      EQU 664          ;Screen width in pixels
SCREEN_CBSCAN  EQU 84           ;# bytes in one scanline
SCREEN_DSCAN   EQU 84           ;Delta to next scanline
else
SCREEN_CX      EQU 640          ; Screen width in pixels
SCREEN_CBSCAN  EQU 80           ; # bytes in one scanline
SCREEN_DSCAN   EQU 80           ; Delta to next scanline
endif
endif
if SCAN_CNT EQ 600
SCREEN_CX      EQU 800          ; Screen width in pixels
SCREEN_CBSCAN  EQU 100          ; # bytes in one scanline
SCREEN_DSCAN   EQU 100          ; Delta to next scanline
endif
if SCAN_CNT EQ 768
SCREEN_CX      EQU 1024         ; Screen width in pixels
SCREEN_CBSCAN  EQU 128          ; # bytes in one scanline
SCREEN_DSCAN   EQU 128          ; Delta to next scanline
public  SCREEN_LPB
SCREEN_LPB     EQU 512
endif

SCREEN_CY      EQU SCAN_CNT     ; Screen height in scans
INIT_POINTER_X EQU SCREEN_CX/2  ; Initial pointer x
INIT_POINTER_Y EQU SCREEN_CY/2  ; Initial pointer x
PATTERN_SCAN_UPDATE EQU (SIZE_PATTERN-1) * SCREEN_CBSCAN  

;PUBLIC  abScreenImage
;PUBLIC  abPointerSave
PUBLIC  abPointerWork
PUBLIC  current_brush
PUBLIC  known_word
PUBLIC  saved_latches
PUBLIC  reserved_latches
PUBLIC  plane_index
PUBLIC  enable_test
PUBLIC  tonys_bar_n_grill

abScreenImage     EQU 0
if SCAN_CNT EQ 768

;/*
;** Put this at the VERY top of bank 1
;*/

abPointerSave     EQU abScreenImage + (SCREEN_CBSCAN*(SCREEN_LPB - 4))
else
abPointerSave     EQU abScreenImage + (SCREEN_CBSCAN*SCREEN_CY)
endif

abPointerWork     = abPointerSave + (SAVE_BUFFER_WIDTH*SAVE_BUFFER_HEIGHT)
current_brush     = abPointerWork + MASK_LENGTH
known_word        = current_brush + 8
saved_latches     = known_word    + 2
reserved_latches  = saved_latches + 1
plane_index       = reserved_latches + 1
enable_test       = plane_index   + 1
tonys_bar_n_grill = enable_test   + 1
shadowed_mode     = tonys_bar_n_grill + 1
SCREEN_CBRESERVED = shadowed_mode + 1

;/*
;** Temporary Cursor stuff
;*/

INIT_POINTER_X  EQU     SCREEN_CX/2     ;Initial pointer x
INIT_POINTER_Y  EQU     SCREEN_CY/2     ;Initial pointer y


;/*
;** The following items are used to determine the sizes of all allowable
;** pointers.  The cPtrSizes is a count of the number of allowable cursor
;** sizes for the driver.  For each allowable cursor size, a width and height
;** must be defined.  It is necessary for the sizes to be contiguous to to
;** follow cPtrSizes immediately.
;*/

ALIGN 4
cPtrSizes DWORD 1                               ; This driver has only 1
                                                ; valid pointer size.
PtrSizes  PTRSIZE <PTR_WIDTH_BITS,PTR_HEIGHT>   ; Size of first pointer
        .ERRNZ  PtrSizes-cPtrSizes-(sizeof cPtrSizes),<PtrSizes not contiguous with cPtrSizes>

;/*
;** selTextVram is a selector to the memory we allocated on a Death() call for
;** the saving of VRAM, which is later used on a Resurrection() call to
;** restore VRAM if nothing beyond the amount saved was dirtied.  See
;** save_textvram and restore_textvram for more details.
;*/

ALIGN 4
selTextVram     DWORD 0         ; 

;/*
;** adDevCapsData is the data returned by the QueryDeviceCaps function.  Some
;** fields will change at initialization time, depending on the specific
;** driver being run and the fonts loaded.
;*/

DCAPS_FORE      = CAPS_MIX_OR or CAPS_MIX_COPY or CAPS_MIX_XOR
DCAPS_FORE      = DCAPS_FORE or CAPS_MIX_AND or CAPS_MIX_INVISIBLE
DCAPS_FORE      = DCAPS_FORE or CAPS_MIX_OTHER
DCAPS_BACK      = CAPS_BACKMIX_COPY or CAPS_BACKMIX_INVISIBLE
DCAPS_BACK_AREA = CAPS_BM_OR or CAPS_BM_AND or CAPS_BM_XOR
DCAPS_BACK_AREA = DCAPS_BACK_AREA or CAPS_BM_GENERAL_BOOLEAN
DCAPS_BACK_LINE = CAPS_BM_OR or CAPS_BM_AND or CAPS_BM_XOR
DCAPS_BACK_LINE = DCAPS_BACK_LINE or CAPS_BM_GENERAL_BOOLEAN

        ALIGN   4
adDevCapsData LABEL DWORD

IF CAPS_FAMILY
        DWORD   INVALID_ADDRESS ; So we can accesss the table using the
        DWORD   OD_DIRECT       ;  CAPS_ names which are one based!
        .ERRNZ  CAPS_FAMILY-1
ELSE
        DWORD   OD_DIRECT
        .ERRNZ  CAPS_FAMILY
ENDIF

        DWORD   CAPS_IO_SUPPORTS_OP
        .ERRNZ  CAPS_IO_CAPS-CAPS_FAMILY-1

        DWORD   CAPS_TECH_RASTER_DISPLAY
        .ERRNZ  CAPS_TECHNOLOGY-CAPS_IO_CAPS-1

;/*
;** Driver versions should be:
;**     1.2     0x00000120L
;**     2.0     0x00000200L
;**     2.1     0x00000210L
;*/

        DWORD   00000200h
        .ERRNZ  CAPS_DRIVER_VERSION-CAPS_TECHNOLOGY-1

        DWORD   SCREEN_CX
        .ERRNZ  CAPS_WIDTH-CAPS_DRIVER_VERSION-1

        DWORD   SCREEN_CY
        .ERRNZ  CAPS_HEIGHT-CAPS_WIDTH-1

        DWORD   DEVCAPS_WIDTH_IN_CHARS
        .ERRNZ  CAPS_WIDTH_IN_CHARS-CAPS_HEIGHT-1

        DWORD   DEVCAPS_HEIGHT_IN_CHARS
        .ERRNZ  CAPS_HEIGHT_IN_CHARS-CAPS_WIDTH_IN_CHARS-1

        DWORD   DEVCAPS_HORIZONTAL_RESOLUTION
        .ERRNZ  CAPS_HORIZONTAL_RESOLUTION-CAPS_HEIGHT_IN_CHARS-1

        DWORD   DEVCAPS_VERTICAL_RESOLUTION
        .ERRNZ  CAPS_VERTICAL_RESOLUTION-CAPS_HORIZONTAL_RESOLUTION-1

        DWORD   DEVCAPS_CHAR_WIDTH
        .ERRNZ  CAPS_CHAR_WIDTH-CAPS_VERTICAL_RESOLUTION-1

        DWORD   DEVCAPS_CHAR_HEIGHT
        .ERRNZ  CAPS_CHAR_HEIGHT-CAPS_CHAR_WIDTH-1

        DWORD   DEVCAPS_SMALL_CHAR_WIDTH
        .ERRNZ  CAPS_SMALL_CHAR_WIDTH-CAPS_CHAR_HEIGHT-1

        DWORD   DEVCAPS_SMALL_CHAR_HEIGHT
        .ERRNZ  CAPS_SMALL_CHAR_HEIGHT-CAPS_SMALL_CHAR_WIDTH-1

        DWORD   DEVCAPS_COLORS
        .ERRNZ  CAPS_COLORS-CAPS_SMALL_CHAR_HEIGHT-1

        DWORD   1
        .ERRNZ  CAPS_COLOR_PLANES-CAPS_COLORS-1

        DWORD   BITS_PEL
        .ERRNZ  CAPS_COLOR_BITCOUNT-CAPS_COLOR_PLANES-1

        DWORD   0
        .ERRNZ  CAPS_COLOR_TABLE_SUPPORT-CAPS_COLOR_BITCOUNT-1

        DWORD   0
        .ERRNZ  CAPS_MOUSE_BUTTONS-CAPS_COLOR_TABLE_SUPPORT-1

        DWORD   DCAPS_FORE
        .ERRNZ  CAPS_FOREGROUND_MIX_SUPPORT-CAPS_MOUSE_BUTTONS-1

        DWORD   DCAPS_BACK
        .ERRNZ  CAPS_BACKGROUND_MIX_SUPPORT-CAPS_FOREGROUND_MIX_SUPPORT-1

        DWORD   0
        .ERRNZ  CAPS_VIO_LOADABLE_FONTS-CAPS_BACKGROUND_MIX_SUPPORT-1

        DWORD   CAPS_BYTE_ALIGN_REQUIRED
        .ERRNZ  CAPS_WINDOW_BYTE_ALIGNMENT-CAPS_VIO_LOADABLE_FONTS-1

        DWORD   2
        .ERRNZ  CAPS_BITMAP_FORMATS-CAPS_WINDOW_BYTE_ALIGNMENT-1

        DWORD   CAPS_RASTER_BITBLT or CAPS_RASTER_SET_PEL or CAPS_RASTER_FONTS or CAPS_RASTER_FLOOD_FILL
        .ERRNZ  CAPS_RASTER_CAPS-CAPS_BITMAP_FORMATS-1

        DWORD   -1      ; Needs run-time fix-up
        .ERRNZ  CAPS_MARKER_HEIGHT-CAPS_RASTER_CAPS-1

        DWORD   -1      ; Needs run-time fix-up
        .ERRNZ  CAPS_MARKER_WIDTH-CAPS_MARKER_HEIGHT-1

        DWORD   0
        .ERRNZ  CAPS_DEVICE_FONTS-CAPS_MARKER_WIDTH-1

        DWORD   0
        .ERRNZ  CAPS_GRAPHICS_SUBSET-CAPS_DEVICE_FONTS-1

        DWORD   0
        .ERRNZ  CAPS_GRAPHICS_VERSION-CAPS_GRAPHICS_SUBSET-1

        DWORD   0
        .ERRNZ  CAPS_GRAPHICS_VECTOR_SUBSET-CAPS_GRAPHICS_VERSION-1

        DWORD   0
        .ERRNZ  CAPS_DEVICE_WINDOWING-CAPS_GRAPHICS_VECTOR_SUBSET-1

;/*
;** CAPS_VDD_DDB_TRANSFER is only supported by CGA/EGA/VGA display drivers
;** See bmc_eti.asm, or me, for more details on this support (jeffpar 1/29/90)
;*/

        DWORD   CAPS_FONT_IMAGE_DEFAULT + CAPS_FONT_IMAGE_MANAGE + DEVCAPS_COLOR_POINTER_SUPPORT + CAPS_VDD_DDB_TRANSFER + CAPS_CLIP_FILLS
        .ERRNZ  CAPS_ADDITIONAL_GRAPHICS-CAPS_DEVICE_WINDOWING-1


        WORD    D15_00_DEVCAPS_PHYS_COLORS
        WORD    D31_16_DEVCAPS_PHYS_COLORS
        .ERRNZ  CAPS_PHYS_COLORS-CAPS_ADDITIONAL_GRAPHICS-1

        DWORD   DEVCAPS_COLOR_INDEX
        .ERRNZ  CAPS_COLOR_INDEX-CAPS_PHYS_COLORS-1

        DWORD   DEVCAPS_GRAPHICS_CHAR_WIDTH
        .ERRNZ  CAPS_GRAPHICS_CHAR_WIDTH-CAPS_COLOR_INDEX-1

        DWORD   DEVCAPS_GRAPHICS_CHAR_HEIGHT
        .ERRNZ  CAPS_GRAPHICS_CHAR_HEIGHT-CAPS_GRAPHICS_CHAR_WIDTH-1

        DWORD   DEVCAPS_HORIZONTAL_FONT_RES
        .ERRNZ  CAPS_HORIZONTAL_FONT_RES-CAPS_GRAPHICS_CHAR_HEIGHT-1

        DWORD   DEVCAPS_VERTICAL_FONT_RES
        .ERRNZ  CAPS_VERTICAL_FONT_RES-CAPS_HORIZONTAL_FONT_RES-1

        DWORD        0
        .ERRNZ  CAPS_DEVICE_FONT_SIM-CAPS_VERTICAL_FONT_RES-1

        DWORD        0
        .ERRNZ  CAPS_LINEWIDTH_THICK-CAPS_DEVICE_FONT_SIM-1

        DWORD        DCAPS_BACK_AREA
        .ERRNZ  CAPS_EXTRA_AREA_BACKGROUND_MIX-CAPS_LINEWIDTH_THICK-1

        DWORD        DCAPS_BACK_LINE
        .ERRNZ  CAPS_EXTRA_LINE_BACKGROUND_MIX-CAPS_EXTRA_AREA_BACKGROUND_MIX-1

COUNT_DEV_CAPS_DATA  EQU ($-adDevCapsData)/4 - CAPS_FAMILY

;/*
;** adDevVioCells is the table containing the font sizes of the VIO cell sizes
;** available from this driver, also a selector to each font definition.  The
;** cell size values are returned in DEVESC_QUERYVIOCELLSIZES.
;**
;** cDevVioCells is the number of cell sizes in the table, and is currently
;** set to eight for the 8514 display.
;**
;** pDefVioFont is address of the default vio font information.
;**
;** Note that the table below is sorted by height within width!!
;** This is assumed in the code!!
;*/

ALIGN 4
adDevVioCells LABEL CellFont
 Cell5x12        CellFont        < 5,12,INVALID_ADDRESS>
 Cell5x16        CellFont        < 5,16,INVALID_ADDRESS>
 Cell6x10        CellFont        < 6,10,INVALID_ADDRESS>
 Cell6x14        CellFont        < 6,14,INVALID_ADDRESS>
 Cell8x8         CellFont        < 8, 8,INVALID_ADDRESS>
 Cell8x10        CellFont        < 8,10,INVALID_ADDRESS>

pDefVioFont LABEL CellFont
 Cell8x12        CellFont        < 8,12,INVALID_ADDRESS>
 Cell8x14        CellFont        < 8,14,INVALID_ADDRESS>
 Cell8x16        CellFont        < 8,16,INVALID_ADDRESS>
 Cell8x18        CellFont        < 8,18,INVALID_ADDRESS>

cDevVioCells EQU ($-adDevVioCells)/(sizeof CellFont)

;/*
;** padBitmapFormats is the pointer to the table of dwords for the
;** QueryDeviceBitmaps function.  The number of entries in the table is
;** specified by CAPS_BITMAP_FORMATS in adDevCapsData.
;*/

        ALIGN   4
padBitmapFormats DWORD  -1                       ; -1 to cause GP fault

ALIGN 4
adBitmapFormats LABEL DWORD
        DWORD   1,4                              ;1 plane, 4 pel
        DWORD   1,1                              ;1 plane, 1 pel

;/*
;** ddcInit is the ddc structure copied into all allocated ddcs by both the
;** EnableDC and ResetDC subfunction of Enable.  The default ddc is
;** initialized to be a screen ddc.
;**
;** We allocate the default ddc in the data segment so that it can be changed
;** at initialization time based on the characteristics of the particular
;** adapter installed in the machine.  This minimizes the number of drivers
;** which must be maintained.
;**
;** Valuse determined at initialization time, such as screen selector and
;** pointers to the font resources are written into the default ddc as they
;** are determined. Appropriate defaults are also written into the default
;** ddc, and will be retrieved from here when needed.
;**
;** Fields which have no value at assembly time are given values which will
;** hopefully cause a GP fault if used.
;**
;** I've changed the semantics a little on the table.  The .errnz preceeds the
;** value being defined.
;**
;*/

        ALIGN   4
ddcInit  DDC    <>

        ALIGN   4
rddcInit RDDC   <>

;/*
;** sdScreen is the definition for the display adapter's surface.  The fields
;** of the surface definition may change at initialization time based on the
;** display adapter attached.
;**
;**
;** initialize to:
;**   sd_usId    DWORD  SURFACE_IDENT
;**   sd_npsd    DWORD  sdScreen
;**   sd_fb      BYTE   SCREEN_SDFB
;**   sd_fbAccel BYTE   0
;**   sd_cx      DWORD  SCREEN_CX
;**   sd_cy      DWORD  SCREEN_CY
;**   sd_cbScan  DWORD  SCREEN_CBSCAN
;**   sd_dScan   DWORD  SCREEN_DSCAN
;**   sd_cbFill  DWORD  0
;**   sd_cySeg   DWORD  0
;**   sd_selIncr DWORD  010h
;**   sd_pBits   DWORD  INVALID_ADDRESS
;*/

         ALIGN  4
sdScreen SURFACE <SURFACE_IDENT,\
                  sdScreen,     \
                  SCREEN_SDFB,  \
                  0,            \
                  SCREEN_CX,    \
                  SCREEN_CY,    \
                  SCREEN_CBSCAN,\
                  SCREEN_DSCAN, \
                  0,            \
                  0,            \
                  010h,         \
                  INVALID_ADDRESS>

;/*
;** sdIC is the definition for the display adapter's surface when an IC fis
;** created.  The dimensions, color attributes and such really don't matter
;** for an info context.
;**
;** IC's now have a non-zero sd_cx, sd_cy for correlation in bitblt
;**
;** IC_SDFB = SD_DEVICE or SD_COLOR
;** IC_SDFB has been replaced with SD_DEVICE or SD_COLOR due to a bug
;** in the assembler 
;*/

        ALIGN   4
sdIC    SURFACE <SURFACE_IDENT, \
                sdIC,           \
                SD_DEVICE or SD_COLOR,\
                0,              \
                SCREEN_CX,      \
                SCREEN_CY,      \
                0,              \
                0,              \
                0,              \
                0,              \
                0,              \
                INVALID_ADDRESS>

;/*
;** Define the GetScreenSelector parameter block.  The device specific
;** initialization must fill this structure in.  The structure size will be
;** set to zero to show no selector needed.  This will force the drivers which
;** need a selector to initialize gsspScreen
;*/

        ALIGN   4
gsspScreen GSSP   <0,,>     ; Get Screen Selector Parameters

;/*
;** Define the pointers to the BMC structures used by CreateBitmap.  They may
;** change at initialization time if the device chooses.  The segment portion
;** of the pointers must be _TEXT.
;**
;** The default values of these pointers will be for an EGA\VGA.
;**
;** The VioSetMode call also uses the cBitCount field for the number of color
;** bits, taken from pbmcDev.
;*/

          ALIGN  4


pbmcDev   DWORD  bmc1Pixel4Plane ; Device's bitmap format
pbmcMono  DWORD  bmc1Pixel1Plane ; Mono bitmap format
pbmcColor DWORD  bmc1Pixel4Plane ; Color bitmap format


;/*
;** Define the DosGetResource parameters for the default marker and font.  The
;** may be changed at load time if a different resolution or .ini entry
;** specifies a different font.
;**
;** The fr_hModule field must be initialized at load time.  It will be set to
;** -1 here to hopefully cause an error.
;**
;** The defaults will be set for the lower resolution font and marker, which
;** should also be correct if only one font is available.
;*/

              ALIGN    4
cResource     DWORD    cResources
              .ERRNZ   defFontChar-cResource-4  ; Must follow the resource count!

ALIGN 4
defFontChar FONT_RES <(ddcInit.ddc_ca.ca_pFont),-1,RT_OUR_FONT,RES_ID_LOWER>

defFontMarker FONT_RES <ddcInit.ddc_ma.ma_pFont,-1,RT_OUR_MARKER,RES_ID_LOWER>
        FONT_RES <Cell5x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+1>
        FONT_RES <Cell5x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+2>
        FONT_RES <Cell6x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+3>
        FONT_RES <Cell6x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+4>
        FONT_RES <Cell8x8.cf_ptr, -1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+7>
        FONT_RES <Cell8x10.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+8>
        FONT_RES <Cell8x12.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+9>
        FONT_RES <Cell8x14.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+10>
        FONT_RES <Cell8x16.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+11>
        FONT_RES <Cell8x18.cf_ptr,-1,RT_OUR_FONT,RES_ID_VIO_FONT_BASE+12>
cResources    EQU      ($-cResource-4) / size FONT_RES



;/*
;** Define the BMC structures which will be used by the expected variations of
;** drivers built from these sources.  The structures are accessed with the
;** pbmc pointers above.
;**
;** The VioSetMode call also uses the cBitCount field for the number of color
;** bits.
;*/

        ALIGN   4
bmc1Pixel1Plane BMC    <((SIZE BITMAPINFOHEADER2)+(  2*(size RGB2))),\
                        1,\
                        32-1,\
                        3,\
                        1,\
                        0>


ALIGN 4
bmc1Pixel4Plane BMC    <((SIZE BITMAPINFOHEADER2)+( 16*(size RGB2))),\
                        4,\
                        32-1,\
                        3,\
                        4,\
                        SD_COLOR>

ALIGN 4
bmc4Pixel1Plane BMC    <((SIZE BITMAPINFOHEADER2)+( 16*(size RGB2))),\
                        4,\
                        8-1,\
                        1,\
                        1,\
                        SD_COLOR>
ALIGN 4
bmc8Pixel1Plane BMC    <((SIZE BITMAPINFOHEADER2)+(256*(size RGB2))),\
                        8,\
                        4-1,\
                        0,\
                        1,\
                        SD_COLOR>

;/*
;** The apfnDevDefDispatch table defines the set of default dispatch functions
;** that the display driver must call back to after processing a hooked
;** function.
;**
;** Each entry in the table is initialized with the index into the default
;** table of the function we want, which will be replaced with the appropriate
;** function address by Enable().
;*/

defdispatch_entry     macro   realname

public  pfnDef&realname

;/*
;** LOOK IN PMDDIM.INC for NGre????? stuff
;*/

        pfnDef&realname DWORD   ((NGre&realname and 1ffh) * 4)
endm

deftbl_entry     macro   realname

;/*
;** LOOK IN PMDDIM.INC for NGre????? stuff
;*/

        DWORD   ((NGre&realname and 1ffh) * 4)  ;Index
        DWORD   OFFSET realname                 ;pfn
endm

        public  apfnDevDefDispatch
        ALIGN   4
apfnDevDefDispatch DWORD   DEF_DISPATCH_TBL_SIZE   ;Count goes first
        defdispatch_entry Convert
        defdispatch_entry PtVisible
        public  DEF_DISPATCH_TBL_SIZE
DEF_DISPATCH_TBL_SIZE  = ($ - (apfnDevDefDispatch + 4)) / 4; 


        public  tblDevHooks
        ALIGN   4
tblDevHooks DWORD   HOOK_TBL_COUNT   ;Count goes first

        public  HOOK_TBL_COUNT
HOOK_TBL_COUNT  = ($ - (tblDevHooks + 4)) / 8; 


;/*
;** cBrush is the brush reference count.  It is incremented each time a brush
;** is altered, and this number stored in ddc_pa.pa_idBrush.
;*/

idBrush DWORD   PAT_CACHE_FIRST_ID ; Initial brush id


END
