;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    58,132
        TITLE   WDHSUBS.ASM -- Windowable and Advanced VIO Subroutines

;/*****************************************************************************
;*
;* SOURCE FILE NAME = WDHSUBS.ASM
;*
;* DESCRIPTIVE NAME = Windowable and Advanced VIO Subroutines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Interface routines to the Shield and Graphics
;*              Engine.
;*
;* FUNCTIONS    CheckAvio
;*              SecureSema4
;*              ReleaseSema4
;*              ClearGreDat
;*              UpdateCharRect
;*              EngineCharRect
;*              CharStr
;*              WinScroll
;*              ShieldInit
;*              ShieldTerm
;*              QueryConsole
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*             @T14       P3711   TPL, Preserve AX in ReleaseSema4,
;*             @@TB8      HM00451 TLB, Leave filler cell selector and offset
;*             @@TB8      HM00451 set null.  PTR
;*             @B18       B705274 WKB, Pass graphics engine correct scroll parm
;*                                (DSS).
;*   11/02/89  @D549      D549    CJJ, Seltable changes due to rangeless
;*                                sessions,
;*   01/22/90  @T52       D704    TPL  DCR 704 work
;*   07/06/90  @T71       B714347 TPL, Allow Shell to make AVIO calls, Hursley
;*                                DCR 25177,
;*   SL02298T                     TPL, Pass full 32-bit values to PMGRE scroll routine
;*   04/11/91  D1348      D1348   NAKADA, Enable DBCS support in Vio-Window
;*             SM04393            WKB, Correct parm passing to PMGRE scroll routine
;*   02/06/92  @T80       B732479 TPL, Don't use the reserved register FS
;*   05/11/93  @TK1       A64278  TAK, Console creation serialization
;*   09/14/94  @95837             WKB, pmwinp.inc -> pmwinx.inc
;****************************************************************************/

        .xlist
        include pmwinx.inc              ;@95837
        include pmaviop.inc
        include wdhequ.inc
        include wdhgdata.inc            ;BVH global data externals      ;@T52
        include bvscb.inc
        include bvsparms.inc
        include error2.inc
        include struc.inc
        include infoseg.inc
        .list

        .386p                   ;@D549

        EXTRN   DOSALLOCSEG:FAR
        EXTRN   DOSFREESEG:FAR
        EXTRN   DOSSEMSETWAIT:FAR                                       ;@TK1
        EXTRN   DOSSEMCLEAR:FAR                                         ;@TK1

        EXTRN   bvh_instance:DWORD                                      ;@T52
        EXTRN   WININITIALIZE:FAR                                       ;@T52
        EXTRN   WINCREATECONSOLE:FAR                                    ;@T52
        EXTRN   WINDESTROYCONSOLE:FAR                                   ;@T52
        EXTRN   LOCKVIOPS:FAR                                           ;@T52
        EXTRN   UNLOCKVIOPS:FAR                                         ;@T52
        EXTRN   GREENTRY5:FAR                                           ;@T52

        extrn   RegSav2:NEAR
        extrn   RegRest:NEAR

WDHGSEG SEGMENT PARA PUBLIC 'DATA' USE16 ;Global data segment for WDH    @D549
WDHGSEG ENDS

R2CSEG  SEGMENT PARA PUBLIC 'CODE' USE16                                ;@D549
        ASSUME  CS:R2CSEG

;/****************************************************************************
;*
;* FUNCTION NAME = CheckAvio
;*
;* DESCRIPTION   = Set NZ flag if an Avio session
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

CheckAvio PROC  NEAR
        public  CheckAvio

        push    ds
        push    ax

        push    WDHGSEG
        pop     ds
        mov     ds,ds:wdh_LISsel                                        ;@T52

        sub     ax,ax                   ;Preset non-AVIO session        ;@T71
        .if     <[bx].LIS_ProcType eq LIS_PT_PRESMGR> or          ;@D549,@T71
        .if     <[bx].LIS_CurScrnGrp eq 1>                              ;@T71
            inc     ax                  ;Set AVIO session               ;@T71
        .endif
        or      ax,ax                   ;Update the Zero flag           ;@T71

;@T71   pop     cx
        pop     ax
        pop     ds
        ret
CheckAvio ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = SecureSema4
;*
;* DESCRIPTION   = Secure the PS Semaphore
;*                 No registers modified.  Calls LockVioPS in SHIELD.DLL
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

SecureSema4 PROC NEAR
        public  SecureSema4
        Call    RegSav2

        push    WDHGSEG
        pop     ds                      ;DS = Global data segment
        mov     gs,ds:wdh_LISsel        ;DS = Local Info segment        ;@T80
        mov     di,gs:[LIS_CurThrdID]   ;Get thread ID to get index and ;@T80
        dec     di                      ;Thread 1 should use bit 0

        mov     cx,di                   ;bit mask
        shr     di,3                    ;Divide by 8 to get index
        and     cx,7                    ;Remainder
        mov     al,1                    ;Remainder to create bit mask
        shl     al,cl

        lgs     bx,ds:bvh_instance      ;load instance data             ;@T80
        push    gs:[bx].wdhi_pssel                                      ;@T80
        push    viops_PresentationSpaceLock ;Semaphore addr for Shield Lock

        mov     gs:[bx].wdhi_sema4,1    ;Set semaphore flag             ;@T80
        test    gs:[bx][di].wdhi_wininits,al                            ;@T80
        .if     <z>                     ;Wininitialize not yet called

            or      gs:[bx][di].wdhi_wininits,al ;Indicate thread called;@T80
            push    di                  ;Prepare thread to use WINXXXX
            call    WININITIALIZE                                       ;@T52

        .endif

        call    LOCKVIOPS               ;Secure semaphore               ;@T52
                                        ;  with parms pushed above      ;@T52
        Call    RegRest
        ret
SecureSema4 ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = ReleaseSema4
;*
;* DESCRIPTION   = Release the PS Semaphore
;*                 No registers modified.  Calls UnLockVioPS in SHIELD.DLL
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

ReleaseSema4 PROC NEAR
        public  ReleaseSema4
        push    ax                      ;                               @T14
        Call    RegSav2

        push    WDHGSEG                                                 ;@T52
        pop     ds
        lgs     si,ds:bvh_instance      ;load instance data             ;@T80
        mov     gs:[si].wdhi_sema4,bx   ;clear semaphore flag (set to 0);@T80
        push    gs:[si].wdhi_pssel      ;PS selector                    ;@T80
        push    viops_PresentationSpaceLock ;Addr of Semaphore

        call    UNLOCKVIOPS             ;Release semaphore              ;@T52

        Call    RegRest
        pop     ax                      ;                               @T14
        ret
ReleaseSema4 ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = ClearGreDat
;*
;* DESCRIPTION   = Clears the Engine parm block
;*                 No registers modified, except AX=0.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

ClearGreDat PROC NEAR
        public  ClearGreDat

        push    di                      ;initialize...
        push    cx                      ;...the....
        push    es

        push    WDHGSEG                                                 ;@T52
        pop     es
        les     di,es:bvh_instance                                      ;@T52
        mov     cx,(size GreStruc)/4    ;...engine...                   ;@T71
        add     di,wdhi_GreDat          ;...parameter...                ;@T52
        sub     eax,eax                                                 ;@T71
        rep     stosd                   ;...block                       ;@T71

        pop     es
        pop     cx
        pop     di

        ret
ClearGreDat ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = UpdateCharRect
;*
;* DESCRIPTION   = Allows Engine to synch the PS changes with BufferUpdate
;*                 No registers modified, except AX = return code.
;*                 Calls ClearGreDat and EngineCharRect
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

UpdateCharRect PROC NEAR
        public  UpdateCharRect
        push    ds

        Call    ClearGreDat             ;set null parameter block

        push    WDHGSEG                                                 ;@T52
        pop     ds
        lgs     si,ds:bvh_instance                                      ;@T80
        mov     ax,es:[viops_BufferRowCount]                            ;@T52
        mov     gs:[si].wdhi_rect_height,ax                             ;@T80
        mov     ax,es:[viops_BufferColumnCount]                         ;@T52
        mov     gs:[si].wdhi_length_width,ax                            ;@T80

        Call    EngineCharRect          ;advise Engine of PS change

        pop     ds
        ret
UpdateCharRect ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = EngineCharRect
;*
;* DESCRIPTION   = Allows Engine to output a text rectangle from the LVB
;*                 Parameters already in GreDat.  Calls GreEntry5
;*                 No registers modified, except AX = return code.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

EngineCharRect PROC NEAR
        public  EngineCharRect
        Call    RegSav2
        sub     bx,bx                                                   ;@T52
        push    WDHGSEG                                                 ;@T52
        pop     ds                                                      ;@T52
        lgs     si,ds:bvh_instance      ;load instance data             ;@T80
;@T71   push    es:[bx].word ptr viops_hConsoleDisplayContext+2 ;DC handle pt. 1
        push    dword ptr es:[bx].viops_hConsoleDisplayContext ;DC handle pt. 2 ;@T71
        push    es                      ;PS selector
        push    bx                      ;PS offset
        push    gs                      ;param block selector           ;@T80
        lea     ax,gs:[si].wdhi_GreDat                                  ;@T80
        push    ax                      ;param block offset             ;@T52
;@T71   push    bx                      ;"cookie" parm pt. 1
        push    dword ptr 0             ;"cookie" parm pt. 2            ;@T71
;@T71   push    GreCharRectHi           ;Engine function pt. 1
        push    dword ptr GreCharRectLo ;Engine function pt. 2          ;@T71

        call    GREENTRY5                                               ;@T52
        Call    RegRest
        ret
EngineCharRect ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = CharStr
;*
;* DESCRIPTION   = Allows Engine to output a text string from the LVB
;*                 Parameters on stack from BVS at DS:SI.
;*                 Calls ClearGreDat and GreEntry5.
;*                 No registers modified, except AX = return code.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

CharStr PROC    NEAR
        public  CharStr
        Call    RegSav2

        call    ClearGreDat
        push    es                      ;Save PS selector
IFDEF D1348
        push    di
ENDIF ;D1348

        sub     bx,bx                                                   ;@T52
        mov     ax,es:[bx].viops_BufferRowCount ;get current row count
        sub     ax,[si].vp_startrow     ;convert to x,y row coordinate
        dec     ax                      ;normalize for 0 base

IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        mov     dx,es:[bx].env_dbcsstatus
ENDIF ;D1348

        push    WDHGSEG                                                 ;@T52
        pop     es
        lgs     di,es:bvh_instance                                      ;@T80
        mov     gs:[di].wdhi_start_row,ax                               ;@T80

        mov     ax,[si].vp_startcol
IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        .if     <bit dx and BisectDBCS_START>
            inc     [si].vp_repeatlength
            dec     ax
            .if     <s>
                inc     ax
                dec     [si].vp_repeatlength
            .endif
            mov     cx,[si].vp_repeatlength
            inc     cx
            pop     di
            pop     es
            .if     <cx a es:[di].mode_cols>
                dec     cx
            .endif
            push    es
            push    di
            mov     [si].vp_repeatlength,cx
            push    WDHGSEG                                             ;@T52
            pop     es                  ;restore es
            lgs     di,es:bvh_instance  ;restore gs,di                  ;@T80
        .endif
ENDIF ;D1348
        mov     gs:[di].wdhi_start_col,ax ;column                       ;@T80

        mov     ax,[si].vp_repeatlength
IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        .if     <bit dx and BisectDBCS_LAST>
            inc     ax
            mov     dx,gs:[di].wdhi_start_col                           ;@T80
            add     dx,ax
            mov     cx,gs:[di].wdhi_start_row                           ;@T80
            pop     di
            pop     es
            .if     <dx a es:[di].mode_cols> and
            .if     <cx ae es:[di].mode_rows>
                dec     ax
            .endif
            push    es
            push    di
            push    WDHGSEG                                             ;@T52
            pop     es                  ;restore es
            lgs     di,es:bvh_instance  ;restore gs,di                  ;@T80
        .endif
ENDIF ;D1348
        mov     gs:[di].wdhi_length_width,ax ;length                    ;@T80

IFDEF D1348
        pop     ax                      ;dummy(get garbage)
ENDIF ;D1348
        pop     ds                      ;Restore PS selector
        push    dword ptr [bx].viops_hConsoleDisplayContext ;DC handle pt. 2 ;@T71

        push    ds                      ;PS selector
        push    bx                      ;PS offset
        push    gs                      ;param block selector           ;@T80
        lea     ax,gs:[di].wdhi_GreDat                                  ;@T80
        push    ax                      ;param block offset             ;@T52
        push    dword ptr 0             ;"cookie" parm pt. 2            ;@T71
        push    dword ptr GreCharStrLo  ;Engine function pt. 2          ;@T71
        call    GREENTRY5                                               ;@T52

        Call    RegRest
        ret
CharStr ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = WinScroll
;*
;* DESCRIPTION   = Handles calls to Scroll the LVB Up, Down, Left, or Right
;*                 Parameters on stack from BVS at DS:SI.
;*                 Calls ClearGreDat and GreEntry5.
;*                 No registers modified, except AX = return code.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

WinScroll PROC  NEAR
        public  WinScroll
        Call    RegSav2

        Call    ClearGreDat
        push    es                      ;Save PS selector

        mov     ax,[si].vp_secondrow
        .if     <ax ae es:[di].mode_rows>
            mov     ax,es:[di].mode_rows
            dec     ax
        .endif
        sub     ax,[si].vp_startrow
        inc     ax                      ;Height

        mov     cx,[si].vp_secondcol
        .if     <cx ae es:[di].mode_cols>
            mov     cx,es:[di].mode_cols
            dec     cx
        .endif
        sub     cx,[si].vp_startcol
        inc     cx                      ;Width

        push    WDHGSEG                                                 ;@T52
        pop     es
        les     bx,es:bvh_instance                                      ;@T52
        mov     es:[bx].wdhi_rect_height,ax
        mov     es:[bx].wdhi_length_width,cx

        mov     ax,[si].vp_repeatlength ;Get # of lines to scroll
        mov     cx,[si].vp_index        ;Get direction

        .if     <ax eq -1>              ;Wild card repeat count?        ;B18
            pop     dx                  ;orig ds in di                  ;B18
            push    ds                  ;save curr ds                   ;B18
            mov     ds,dx               ;orig ds restored               ;B18
            .if     <cl eq sx_ScrollUp> or                              ;SL02298
            .if     <cl eq sx_ScrollDn>                                 ;SL02298
                mov     ax,ds:[viops_BufferRowCount] ;make start...     ;B18
            .else                                                       ;SL02298
                mov     ax,ds:[viops_BufferColumnCount]                 ;SL02298
            .endif                                                      ;SL02298
            pop     ds                  ;restore local ds               ;B18
            push    dx                  ;save orig ds                   ;B18
        .endif

        sub     dx,dx                   ;set default hi-order word      ;SL02298
        .if     <cl eq sx_ScrollUp> or  ;                               ;SL02298
        .if     <cl eq sx_ScrollLf>     ;                               ;SL02298
            neg     ax                  ;go negative direction on       ;SL02298
            mov     dx,-1               ; scroll-up or scroll-left      ;SL02298
        .endif                          ;                               ;SL02298

IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        push    di
ENDIF ;D1348

        .if     <cl eq sx_ScrollUp> or  ;                               ;SL02298
        .if     <cl eq sx_ScrollDn>     ;                               ;SL02298
         ;;;mov     di,wdhi_vert_count  ;                               ;SL02298
            lea     di,es:[bx].wdhi_vert_count                          ;SM04393
        .else                           ;                               ;SL02298
         ;;;mov     di,wdhi_horiz_count ;                               ;SL02298
            lea     di,es:[bx].wdhi_horiz_count                         ;SM04393
        .endif                          ;                               ;SL02298

        mov     word ptr es:[di],ax     ;                               ;SL02298
        mov     word ptr es:[di+2],dx   ;                               ;SL02298

        mov     ax,[si].vp_startcol
        mov     es:[bx].wdhi_start_col,ax ;start col

        mov     cx,[si].vp_startrow     ;raw start row

IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        pop     di
ENDIF ;D1348

        pop     ds                      ;Restore PS selector
        mov     ax,ds:[viops_BufferRowCount] ;make start...             ;@T52
        sub     ax,es:[bx].wdhi_rect_height  ;...row relative...
        sub     ax,cx                   ;...to bottom...
        mov     es:[bx].wdhi_start_row,ax ;...left of LVB

IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        push    ds
        push    es
        push    bx
ENDIF ;D1348

        push    dword ptr ds:[viops_hConsoleDisplayContext] ;DC handle pt. 2 ;@T52;;;;;;
        push    ds                      ;PS selector
        push    0                       ;PS offset                      ;@T52
        push    es                      ;param block selector
        lea     ax,es:[bx].wdhi_GreDat                                  ;@T52
        push    ax                      ;param block offset
        push    dword ptr 0             ;"cookie" parm pt. 2       ;@T52,@T71
        push    dword ptr GreScrollRectLo ;Engine function pt. 2        ;@T71

        call    GREENTRY5                                               ;@T52

IFDEF D1348 ;DBCS BufferUpdate (bisecting DBCS character status)
        pop     bx
        pop     es
        pop     ds

        mov     dx,es:[bx].wdhi_start_col
        add     dx,es:[bx].wdhi_length_width
        dec     dx
        push    dx                      ;end_col

        .if     <bit ds:[env_dbcsstatus] and BisectDBCS_LEFT>
            mov     dx,es:[bx].wdhi_start_col
            dec     dx
            .if     ge
                dec     es:[bx].wdhi_start_col
                mov     es:[bx].wdhi_length_width,3 ;Set 3 columns
            .else
                mov     es:[bx].wdhi_length_width,2 ;Set 2 columns
            .endif

            push    ds
            push    es
            push    bx
            push    di
                                            ;DBCS exception maintenance
                                            ;for a left side of the rectangle
            push    dword ptr ds:[viops_hConsoleDisplayContext] ;DC handle pt. 2
            push    ds                      ;PS selector
            push    0                       ;PS offset
            push    es                      ;param block selector
            lea     ax,es:[bx].wdhi_GreDat
            push    ax                      ;param block offset
            push    dword ptr 0             ;"cookie" parm pt. 2
            push    dword ptr GreCharRectLo ;Engine function pt. 2

            call    GREENTRY5                                               ;@T52

            pop     di
            pop     bx
            pop     es
            pop     ds
        .endif

        pop     dx                      ;end_col

        .if     <bit <ds:[env_dbcsstatus]> and BisectDBCS_RIGHT>
            inc     dx
            .if     <dx a ds:[di].mode_cols>
                dec     dx
                mov     es:[bx].wdhi_length_width,2
            .else
                mov     es:[bx].wdhi_length_width,3
            .endif
            dec     dx
            dec     dx
            mov     es:[bx].wdhi_start_col,dx

            push    ds
            push    bx

            push    dword ptr ds:[viops_hConsoleDisplayContext] ;DC handle pt. 2
            push    ds                      ;PS selector
            push    0                       ;PS offset
            push    es                      ;param block selector
            lea     ax,es:[bx].wdhi_GreDat
            push    ax                      ;param block offset
            push    dword ptr 0             ;"cookie" parm pt. 2
            push    dword ptr GreCharRectLo ;Engine function pt. 2

            call    GREENTRY5                                               ;@T52

            pop     bx
            pop     ds
        .endif
ENDIF ;D1348

        Call    RegRest
        ret
WinScroll ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = ShieldInit
;*
;* DESCRIPTION   = Creates a console handle through the Shield.
;*                 Session Id is in SI.  Calls WinCreateConsole.
;*                 No registers modified, except AX = return code.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

ShieldInit PROC NEAR
        public  ShieldInit
        Call    RegSav2

        push    WDHGSEG
        pop     ds

        push    es                      ;16-bit C functions like
                                        ;WinCreateConsole only save SI/DI/DS!

        push    si                      ;setup SGID parameter
        push    es
        push    bx                      ;Addr of PSCB
        push    ds
        push    offset wdh_keybufsize   ;Addr of KbdMouParameter segment;@T52
        push    es
        push    env_conhandle           ;Addr of returned Console Handle

        call    WINCREATECONSOLE                                        ;@T52
        pop     es                      ;restore ES

        .if     <zero ax>
            inc     es:env_processes    ;Update count of processes
        .endif

        ;-------------------------------------------------------------- ;@TK1
        ; Use a semaphore to locally serialize console creation and     ;@TK1
        ; avoid a premature result from query console.                  ;@TK1
        ;-------------------------------------------------------------- ;@TK1

        mov     es:env_consinit, 1                                      ;@TK1

        push    es                                                      ;@TK1
        push    env_consolesem                                          ;@TK1
        Call    DOSSEMCLEAR                                             ;@TK1

        Call    RegRest
        ret
ShieldInit ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = ShieldTerm
;*
;* DESCRIPTION   = Releases a console handle through the Shield.
;*                 Session Id is passed as the offset.  Calls WinDestroyConsole.
;*                 No registers modified, except AX = return code.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

ShieldTerm PROC NEAR
        public  ShieldTerm

        push    [si].vp_ev_session      ;setup SGID parameter

;@T52   push    WDHGSEG
;@T52   pop     ds
        call    WINDESTROYCONSOLE       ;release console instance       ;@T52

        ret
ShieldTerm ENDP

;/****************************************************************************
;*
;* FUNCTION NAME = QueryConsole
;*
;* DESCRIPTION   = Returns console information to BKSCALLS or BMSCALLS
;*                 Output is Console Handle, Mouse filter mask, and VioPS
;*                 selector. No routines called.  AX = 0 on return.
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

QueryConsole PROC NEAR
        public  QueryConsole

        ;-------------------------------------------------------------- ;@TK1
        ; Make sure we wait until a console has been created before     ;@TK1
        ; returning data about it.                                      ;@TK1
        ;-------------------------------------------------------------- ;@TK1

        .if     <es:env_consinit eq 0>                                  ;@TK1
            push    es                                                  ;@TK1
            push    env_consolesem                                      ;@TK1
            push    dword ptr -1                                        ;@TK1

            Call    DOSSEMSETWAIT                                       ;@TK1
        .endif                                                          ;@TK1


        mov     ax,es:[env_conhandle]   ;Shield Console Handle          ;@T52
        mov     dx,es                   ;VioPS Selector
        les     di,dword ptr [si].p_viohandle ;Return address

        Call    CheckAvio
        .if     <nz>
            sub     eax,eax             ;return NULL to caller          ;@T71
;@T71       stosw                       ;Console Handle
            stosd                       ;Mouse Filter Mask              ;@T71
            stosw                       ;VioPS Selector
        .else
            stosw                       ;Console Handle
            push    WDHGSEG
            pop     ds
            mov     ax,ds:wdh_mouevntmask                               ;@T52
            stosw                       ;Mouse Filter Mask
            mov     ax,dx
            stosw                       ;VioPS Selector
            sub     ax,ax
        .endif

        ret
QueryConsole ENDP

R2CSEG  ENDS
        END
