;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    58,132
        TITLE   WDHINFO.Asm -- Windowable Device Handler Info Routines

;/*****************************************************************************
;*
;* SOURCE FILE NAME = WDHINFO.Asm
;*
;* DESCRIPTIVE NAME = Windowable Device Handler Info Routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  This source file contains VDH entry points for setting
;*              and getting cursor and variable information.
;*
;* FUNCTIONS    GetState
;*              SetState
;*              GetCursorInfo
;*              SetCursorInfo
;*              GetVarInfo
;*              SetVarInfo
;*              GetDBCSInfo
;*              GetLVBInfo
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  RegSave, RegRest
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   12/29/88  @@A        P3344   TLB,CJJ In SetCursorInfo save the return code
;*                                before call to ReleaseSema4
;*   01/12/89  @T12       P3451   TPL, Return proper cursor type width &
;*                                attribute,
;*   02/06/89   @C3       3854    CJJ, Check for CodePage flag, everything else
;*                                is invalid and should return VIO_EXTENDED_SG
;*                                error
;*   03/06/89  @@S1       B700065 STJ, Shadow the cursor type,
;*   03/22/89  @T22       B700622 TPL, Return codepage of 0 if DEVINFO is wrong
;*   03/25/89  @P1        D132    TPL, DCR 132 changes
;*   04/27/89  @C18       B701438 CJJ, Check both start & end line parms are
;*                                valid,
;*   06/13/89  @C23       B703614 CJJ, Allow ForceCP call during
;*                                SetVariableInfo,
;*   06/15/89  @T35       B703689 TPL, Check start line properly for
;*                                SetCursorInfo,
;*   08/07/89  @C30       B706051 CJJ, For VioWindowable check for valid
;*                                codepage,
;*   10/24/89  @S38       B786295 STJ, Use 8-pel default size for non-25-line
;*                                modes,
;*   11/02/89  @D549      D549    CJJ, Seltable changes due to rangeless
;*                                sessions,
;*   11/30/89  D811       D811    MS,  DCR811
;*   02/02/90  @T52       D704    DCR  704 work
;*   07/06/90  @T71       B714347 TPL, Allow Shell to make AVIO calls, Hursley
;*                                DCR 25177
;*   04/11/91  D1348      D1348   NAKADA, Enable DBCS support in Vio-Window,
;*   06/05/91  @S38f      SM03642 WKB, Use 8-pel default size for > 25-line
;*                                modes,
;*   09/14/94  @95837             WKB, pmwinp.inc -> pmwinx.inc
;****************************************************************************/

        .xlist
        INCLUDE pmwinx.inc              ;@95837
        INCLUDE pmaviop.inc
        INCLUDE wdhequ.inc              ;Windowable Device Handler Equates
        INCLUDE wdhgdata.inc            ;BVH global data externals      ;@T52
        INCLUDE bvsparms.inc            ;BVS Parameter Equates
        INCLUDE error2.inc              ;CP/DOS Error Codes
        INCLUDE struc.inc               ;Structured Macros
        .list

        .386p                   ;@D549

        extrn   CheckAvio:NEAR
        extrn   SecureSema4:NEAR
        extrn   ReleaseSema4:NEAR
        extrn   UpdateCharRect:NEAR

        extrn   RegSave:NEAR
        extrn   RegRest:NEAR

        extrn   GREENTRY4:FAR                                           ;@T52

IFDEF D1348 ;reflesh dbcs env. at VioSetCp
        extrn   DOSGETDBCSEV:FAR        ; Get DBCS environment vectors
ENDIF ;D1348

WDHGSEG SEGMENT PARA PUBLIC 'DATA' USE16 ;Global data segment for WDH  @D549
WDHGSEG ENDS

R2CSEG  SEGMENT BYTE PUBLIC 'CODE' USE16        ;@D549
        ASSUME  CS:R2CSEG

;/****************************************************************************
;*
;*  SUBROUTINE NAME: GetState
;*
;*  DESCRIPTIVE NAME:  Get the requested video state
;*
;*  FUNCTION:
;*
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 280 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*             ULONG Function ( Call vector table entry = 280 )
;*
;*  EXIT-NORMAL: If OEM defines this function then
;*                 AX = 0
;*                 user defined information is returned
;*               Else
;*                 AX = ERROR_VIO_INVALID_PARMS
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  EFFECTS:  None
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: None
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES:  None
;*
;****************************************************************************/

Public   GetState                                                       ;D811
GetState Proc Far                                                       ;D811
        mov ax, ERROR_VIO_INVALID_PARMS                                 ;D811
        ret 12                                                          ;D811
GetState EndP                                                           ;D811

;/****************************************************************************
;*
;*  SUBROUTINE NAME: SetState
;*
;*  DESCRIPTIVE NAME:  Set the requested video state
;*
;*  FUNCTION:
;*
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 280 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*             ULONG Function ( Call vector table entry = 281 )
;*
;*  EXIT-NORMAL: If OEM defines this function then
;*                 AX = 0
;*                 user defined information is set
;*               Else
;*                 AX = ERROR_VIO_INVALID_PARMS
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  EFFECTS:
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES:
;*
;****************************************************************************/

Public   SetState                                                       ;D811
SetState Proc Far                                                       ;D811
        mov ax, ERROR_VIO_INVALID_PARMS                                 ;D811
        ret 12                                                          ;D811
SetState EndP                                                           ;D811

;/****************************************************************************
;*
;*  SUBROUTINE NAME: GetCursorInfo
;*
;*  DESCRIPTIVE NAME: Get cursor position and/or cursor type
;*
;*  FUNCTION: GetCursorInfo is called by BVS to return selected
;*            information about either the cursor position or the
;*            cursor type.  If the request specifies hardware and the
;*            hardware is readable, the actual hardware setting will
;*            be read and returned.  Otherwise the returned
;*            information will be taken from the environment buffer,
;*            if it has been passed.
;*
;*  ENTRY POINT: GetCursorInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 265 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     USHORT Row
;*                     USHORT Column
;*                     USHORT TopScanLine
;*                     USHORT BottomScanLine
;*                     USHORT Width
;*                     USHORT Attribute
;*             ULONG Function ( Call vector table entry = 265 )
;*
;*  EXIT-NORMAL: AX = 0
;*               Cursor information is returned.
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  EFFECTS: If hardware specified and hardware is readable, the
;*           environment buffer is updated, if passed.
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: RegSave, RegRest, SecureSema4, ReleaseSema4
;*
;****************************************************************************/

GetCursorInfo PROC FAR
        public  GetCursorInfo
        Call    RegSave

        mov     ax,ERROR_VIO_INVALID_PARMS
        test    [si].vp_flags,NOT (vp_f_physical+vp_f_curpos+vp_f_curtype) ;@@S1
        .if     <z> and near
        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength eq vp_c_attr+2> near
            Call    SecureSema4

            mov     ax,es:[viops_BufferRowCount] ;Get # of rows from PSCB ;@T52
            dec     ax                  ;Normalize to 0 base
            sub     ax,es:[viops_TextCursorRow]                         ;@T52
            mov     [si].vp_c_row,ax
            mov     ax,es:[viops_TextCursorColumn]                      ;@T52
            mov     [si].vp_c_col,ax

            Call    CheckAvio           ;Start of new code for B700065 ;@@S1
            .if     <nz>                ;AVIO screen group
                mov     ax,es:[viops_TextCursorStartLine]               ;@T52
                mov     [si].vp_c_startline,ax
                mov     ax,es:[viops_TextCursorEndLine]                 ;@T52
                mov     [si].vp_c_endline,ax
            .else
                mov     cx,8            ;Default character height ;@S38
                .if     <es:[env_rows] be 25> ;@S38;@S38f               ;@T52
                    add     cx,cx       ;Default for 25-line mode ;@S38
                .endif                  ;@S38

                mov     ax,es:[env_startline]                           ;@T52
                mov     [si].vp_c_startline,ax ;Copy from shadow
                mul     es:[viops_CellImageHeight] ;Scale the BVS value ;@T52
                div     cx
                .if     <ax ne es:[viops_TextCursorStartLine]> ;Shadow       ;@T52
                    mov     ax,es:[viops_TextCursorStartLine]           ;@T52
                    mul     cx
                    div     es:[viops_CellImageHeight] ;Compute new value ;@T52
                    mov     es:[env_startline],ax                       ;@T52
                    mov     [si].vp_c_startline,ax ;Use new value
                .endif

                mov     ax,es:[env_endline]                             ;@T52
                mov     [si].vp_c_endline,ax ;Copy from shadow
                mul     es:[viops_CellImageHeight] ;Scale the BVS value ;@T52
                div     cx
                .if     <ax ne es:[viops_TextCursorEndLine]> ;Shadow       ;@T52
                    mov     ax,es:[viops_TextCursorEndLine]             ;@T52
                    mul     cx
                    div     es:[viops_CellImageHeight] ;Compute new value ;@T52
                    mov     es:[env_endline],ax                         ;@T52
                    mov     [si].vp_c_endline,ax ;Use new value
                .endif
            .endif                      ;End of new code for B700065 ;@@S1

            mov     [si].vp_c_width,1   ;Always 1                       @T12
            mov     ax,es:[viops_TextCursorVisible]                     ;@T52
            dec     ax                  ;Revert Back                    @T12
            mov     [si].vp_c_attr,ax

            Call    ReleaseSema4
            sub     ax,ax               ;Set good return code
        .endif

        Call    RegRest
        ret     12
GetCursorInfo ENDP

;/****************************************************************************
;*
;*  SUBROUTINE NAME: SetCursorInfo
;*
;*  DESCRIPTIVE NAME: Set cursor position and/or cursor type
;*
;*  FUNCTION: SetCursorInfo is called by BVS to set selected
;*            information about either the cursor position or the
;*            cursor type.  If the request specifies hardware, the
;*            hardware and the environment buffer, if passed, will be
;*            updated.  Otherwise just the environment buffer, if
;*            passed, will be updated.
;*
;*  NOTES: This routine puts the PS cursor fields in synch with BVS.
;*         then advises the Engine of the changes.  Note that the
;*         PS cursor references the bottom left, rather than top left.
;*
;*  ENTRY POINT: SetCursorInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 266 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     USHORT Row
;*                     USHORT Column
;*                     USHORT TopScanLine
;*                     USHORT BottomScanLine
;*                     USHORT Width
;*                     USHORT Attribute
;*             ULONG Function ( Call vector table entry = 266 )
;*
;*  EXIT-NORMAL: AX = 0
;*               Cursor information is set
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: RegSave, RegRest, SecureSema4, ReleaseSema4, GreEntry4
;*
;****************************************************************************/

SetCursorInfo PROC FAR
        public  SetCursorInfo
        Call    RegSave

        mov     ax,ERROR_VIO_INVALID_PARMS
        test    [si].vp_flags,NOT (vp_f_physical+vp_f_curpos+vp_f_curtype)
        .if     <z> and near
        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength eq vp_c_attr+2> near
            Call    SecureSema4

            sub     eax,eax                                             ;@T71
            test    [si].vp_flags,vp_f_curpos
            .if     <nz>                ;Cursor position update
                mov     cx,[si].vp_c_col
                mov     ax,ERROR_VIO_COL
                .if     <cx b es:[env_cols]>                            ;@T52
                    mov     dx,[si].vp_c_row
                    mov     ax,ERROR_VIO_ROW
                    .if     <dx b es:[env_rows]>                        ;@T52
                        mov     ax,es:[viops_BufferRowCount] ;Get # of rows from PSCB
                        dec     ax      ;Normalize to 0 base
                        sub     ax,dx
                        mov     es:[viops_TextCursorRow],ax             ;@T52
                        mov     es:[viops_TextCursorColumn],cx ;@@S1    ;@T52
                        sub     eax,eax                                 ;@T71
                    .endif
                .endif
            .endif

            .if     <zero ax> AND
            test    [si].vp_flags,vp_f_curtype
            .if     <nz>                ;Cursor type update
                mov     ax,ERROR_VIO_WIDTH
                test    [si].vp_c_width,NOT 1
                .if     <z>             ;Valid width?
                    mov     cx,8        ;Default character height ;@S38
                    .if     <es:[env_rows] be 25> ;@S38;@S38f           ;@T52
                        add     cx,cx   ;Default for 25-line mode ;@S38
                    .endif              ;@S38
                    Call    CheckAvio
                    .if     <nz>        ;AVIO screen group?
                        mov     cx,es:[viops_CellImageHeight] ;Get cell size
                    .endif

                    mov     ax,ERROR_VIO_INVALID_PARMS
                    .if     <[si].vp_c_startline be cx> AND ;@T35 ;@C18
                    .if     <[si].vp_c_endline be 31>
                        Call    CheckAvio
                        .if     <nz>    ;AVIO screen group
                            mov     ax,[si].vp_c_startline
                            mov     es:[viops_TextCursorStartLine],ax   ;@T52
                            mov     ax,[si].vp_c_endline
                            mov     es:[viops_TextCursorEndLine],ax     ;@T52
                        .else
                            mov     ax,[si].vp_c_startline
                            mov     es:[env_startline],ax ;@@S1         ;@T52
                            mul     es:[viops_CellImageHeight] ;Scale the BVS value
                            div     cx  ;Scale it for virtual cursor
                            mov     es:[viops_TextCursorStartLine],ax   ;@T52

                            mov     ax,[si].vp_c_endline
                            mov     es:[env_endline],ax ;@@S1           ;@T52
                            mul     es:[viops_CellImageHeight] ;Scale the BVS value
                            div     cx  ;Scale it for virtual cursor
                            mov     es:[viops_TextCursorEndLine],ax     ;@T52
                        .endif

                        mov     ax,[si].vp_c_attr
                        inc     ax      ;engine expects 0 to mean invisible
                        mov     es:[viops_TextCursorVisible],ax         ;@T52
                        sub     eax,eax                                 ;@T71
                    .endif
                .endif
            .endif
            .if     <zero ax>
                push    dword ptr es:[viops_hConsoleDisplayContext] ;DC handle ;@T71
                push    es
                push    ax              ;Ptr to VioPS              ;@T52,@T71
                push    eax             ;"cookie" parm pt. 2       ;@T52,@T71
                push    dword ptr GreUpdateCursorLo ;Engine function pt. 2 ;@T71
                call    GREENTRY4                                       ;@T52
                sub     ax,ax           ;Set good return code
            .endif
            push    ax                  ;@@A
            Call    ReleaseSema4
            pop     cx                  ;@@A
            .if     <ncxz>              ;@@A                            ;@T71
                mov     ax,cx           ;@@A
            .endif                      ;@@A
        .endif

        Call    RegRest
        ret     12
SetCursorInfo ENDP

;/****************************************************************************
;*
;*  SUBROUTINE NAME: GetVarInfo
;*
;*  DESCRIPTIVE NAME: Get selected variable information
;*
;*  FUNCTION: GetVariableInfo is called by BVS to return selected
;*            information about video state - blink versus background
;*            intensity, overscan color, underscore scan line, video
;*            enable, 8514/A display mask, and the current codepage.
;*
;*  NOTES: Since only the codepage is actually returned for
;*         Windowable sessions, the semaphore is not taken to
;*         read only one word from the PSCB.
;*
;*  ENTRY POINT: GetVarInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 269 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     USHORT Blink
;*                     USHORT Overscan
;*                     USHORT Underscore
;*                     USHORT VideoEnable
;*                     ULONG  DisplayMask
;*             ULONG Function ( Call vector table entry = 269 )
;*
;*  EXIT-NORMAL: AX = 0
;*               Selected variable information is returned
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  EFFECTS: If hardware specified and hardware is readable, the
;*           environment buffer is updated, if passed.
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;****************************************************************************/

GetVarInfo PROC FAR
        public  GetVarInfo
        Call    RegSave

        mov     ax,ERROR_VIO_EXTENDED_SG ;@C3
        test    [si].vp_flags,NOT (vp_f_scrlrect+vp_f_physical+vp_f_codepage) ;@C3
        .if     <z> and
        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength ae vp_scrncols+2> ;@P1

            mov     [si].vp_blink,bx    ;Blink state
            mov     [si].vp_border,bx   ;Border color
            mov     [si].vp_underscore,bx ;Underscore line
            mov     [si].vp_dispmask1,bx ;Display mask (bits 0-15)
            mov     [si].vp_dispmask2,bx ;Display mask (bits 16-31)
            mov     ax,es:[viops_CodepageID]                            ;@T52
            mov     [si].vp_codepage,ax ;Codepage

            mov     ax,es:[di].env_scrlleft ;@P1
            mov     [si].vp_scrlleft,ax ;Scrollable Rectange of screen  ;@P1
            mov     ax,es:[di].env_scrltop ;@P1
            mov     [si].vp_scrltop,ax  ;Scrollable Rectange of screen  ;@P1
            mov     ax,es:[di].env_scrlright ;@P1
            mov     [si].vp_scrlright,ax ;Scrollable Rectange of screen  ;@P1
            mov     ax,es:[di].env_scrlbottom ;@P1
            mov     [si].vp_scrlbottom,ax ;Scrollable Rectange of screen ;@P1
            mov     ax,es:[di].env_rows ;@P1
            mov     [si].vp_scrnrows,ax ;Screen Dimensions              ;@P1
            mov     ax,es:[di].env_cols ;@P1
            mov     [si].vp_scrncols,ax ;Screen Dimensions              ;@P1

            sub     ax,ax               ;Set good return code
        .endif

        Call    RegRest
        ret     12
GetVarInfo ENDP

;/****************************************************************************
;*
;*  SUBROUTINE NAME: SetVarInfo
;*
;*  DESCRIPTIVE NAME: Set selected variable information
;*
;*  FUNCTION: SetVariableInfo is called by BVS to set selected
;*            information about video state - blink versus background
;*            intensity, overscan color, underscore scan line, video
;*            enable, or 8514/A display mask. If the request specifies
;*            hardware the hardware and the environment buffer, if
;*            passed, will be updated.  Otherwise just the environment
;*            buffer, if passed, will be updated.
;*
;*  ENTRY POINT: SetVarInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 270 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     USHORT Blink
;*                     USHORT Overscan
;*                     USHORT Underscore
;*                     USHORT VideoEnable
;*                     ULONG  DisplayMask
;*             ULONG Function ( Call vector table entry = 270 )
;*
;*  EXIT-NORMAL: AX = 0
;*               Selected variable information is set
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: AccessCursorBlink, AccessCursorOverscan
;*              AccessCursorUnderscore, AccessCursorVideoEnable
;*              AccessDisplayMask
;*
;****************************************************************************/

SetVarInfo PROC FAR
        public  SetVarInfo
        Call    RegSave

        mov     ax,ERROR_VIO_EXTENDED_SG ;@C3
        test    [si].vp_flags,NOT (vp_f_physical+vp_f_codepage+vp_f_forcecp) ;@C23
        .if     <z> and
        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength ae vp_codepage+2>

            sub     ax,ax               ;@C30
            mov     cx,[si].vp_codepage ;@T22
            call    CheckAvio           ;@C30
            .if     <z> and             ;and Vio windowable session ;@C30
            .if     <ncxz>              ;actual CP # specified       @C30
                push    WDHGSEG         ;then check for valid CP    ;@C30
                pop     ds              ;@C30
                mov     dx,cx           ;@C30
                mov     si,offset wdh_cpid1     ;@C30                   ;@T52
                mov     cx,ds:wdh_numcpids      ;@C30                   ;@T52
                .if     <ncxz>          ;@C30
                    .repeat             ;@C30
                        lodsw           ;@C30
                    .leave  <ax eq dx>  ;@C30
                    .loop               ;@C30
                .endif                  ;@C30
                .if     <ncxz>          ;@C30
                    mov     cx,dx       ;@C30
                    sub     ax,ax       ;@C30
                .else                   ;@C30
                    mov     ax,ERROR_VIO_BAD_CP ;@C30
                .endif                  ;@C30
            .endif                      ;@C30

            .if     <zero ax>           ;@C30
                mov     dx,es:[viops_CodepageID] ;Save original CP      ;@T52
                mov     es:[viops_CodepageID],cx ;@T22                  ;@T52
                Call    UpdateCharRect
                .if     <es:[viops_CodepageID] ne cx> ;CP not accepted  ;@T52
                    mov     es:[viops_CodepageID],dx ;Restore original CP ;@T52
                    Call    UpdateCharRect
                    mov     ax,ERROR_VIO_BAD_CP
                .else
                    sub     ax,ax       ;CP set ok
                .endif
            .endif                      ;@C30

IFDEF D1348
            .if     <zero ax>
                ;/Reflesh dbcs env. vectors in my environment.
                mov     word ptr es:[env_CtryCode],0
                mov     word ptr es:[env_CtryCode+2],dx  ;set new code page
                push    DBCSEvBufSiz
                push    es
                mov     ax,offset env_CtryCode
                push    ax
                push    es
                mov     ax,offset env_DBCSEvBuff
                push    ax
                call    DosGetDBCSEv
                                        ;Ignore the r/c
                                        ;If r/c !=0 ==> env_DBCSEvBuff
                                        ;is filled with zeros.
            .endif
ENDIF ;D1348

        .endif

        Call    RegRest
        Ret     12
SetVarInfo ENDP


;/****************************************************************************
;*
;*  SUBROUTINE NAME: GetDBCSInfo
;*
;*  DESCRIPTIVE NAME: Get DBCS character display width information
;*
;*  FUNCTION: GetDBCSInfo is called by BVS to get character display
;*            width information for use with WrtTTY.  The call should
;*            return the ranges of characters that require two cells
;*            for display.  On us adapters there are none.
;*
;*  ENTRY POINT: GetDBCSInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 261 )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     USHORT Table Length length of following table
;*                     USHORT Beginning of first range
;*                     USHORT End of first range
;*                             ...
;*                     USHORT Beginning of nth range
;*                     USHORT End of nth range
;*             ULONG Function ( Call vector table entry = 261 )
;*
;*  EXIT-NORMAL: AX = 0
;*               The table is returned (Table length = 0)
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*                   ERROR_VIO_INVALID_LENGTH
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;****************************************************************************/

GetDBCSInfo PROC FAR                    ;@P1 begin
        public  GetDBCSInfo
        Call    RegSave


        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength e 2> near
            xor     ax,ax
            mov     [si].vp_parmlength,(vp_di_tbllen + 2)
        .else
            .if     <[si].vp_parmlength ae 4> near
                mov     ax,ERROR_VIO_INVALID_PARMS
                cmp     [si].vp_flags,bx
                .if     <z> and
                mov     ax,ERROR_VIO_INVALID_LENGTH
                .if     <[si].vp_parmlength ae 6>
                    mov     [si].vp_di_tbllen,bx
                    sub     ax,ax       ; Set good return code
                .endif
            .endif
        .endif

        Call    RegRest
        ret     12
GetDBCSInfo ENDP                        ;@P1 end

;/****************************************************************************
;*
;*  SUBROUTINE NAME: GetLVBInfo
;*
;*  DESCRIPTIVE NAME: Return LVB size and default attribute information
;*
;*  FUNCTION: GetLVBInfo is called by BVS to determine the size of the
;*            LVB required for a given display size.  Based on the
;*            mode and its associated LVB format the allocation size
;*            of the LVB is returned.  Also a default attribute may
;*            be returned.
;*
;*  ENTRY POINT: GetLVBInfo
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 2xx )
;*
;*  INPUT: (Passed on stack)
;*             FAR *Environment ( Environment buffer for the session )
;*             FAR *ParmBlock
;*                     USHORT Length = length of this packet
;*                     USHORT Flags  = 0 - Environment buffer only
;*                                     1 - Hardware also
;*                     UCHAR  FormatId;
;*                     UCHAR  AttrCount;
;*                     USHORT LVBWidth;
;*                     USHORT LVBHeight;
;*                     ULONG  LVBSize;
;*                     USHORT AttrBufSize;
;*                     UCHAR far *AttrBufAddr;
;*             ULONG Function ( Call vector table entry = 261 )
;*
;*  EXIT-NORMAL: AX = 0
;*               The correct size of the LVB is returned
;*
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS
;*
;*  INTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;*  EXTERNAL REFERENCES:
;*    ROUTINES: NONE
;*
;****************************************************************************/

GetLVBInfo PROC FAR                     ;@P1 begin
        public  GetLVBInfo
        Call    RegSave

        mov     ax,ERROR_VIO_INVALID_PARMS
        .if     <[si].vp_parmlength ge vp_li_attrsize>
            .if     <[si].vp_li_fidatt e bx>
                .if     <[si].vp_li_width e bx>
                    mov     ax,es:[di].env_cols
                .else
                    mov     ax,[si].vp_li_width
                .endif
                .if     <[si].vp_li_height e bx>
                    mul     es:[di].env_rows
                .else
                    mul     [si].vp_li_height
                .endif
                shl     ax,1            ; 2 bytes per cell * number of cells
                .if     <c>
                    shl     dx,1
                    inc     dx
                .else
                    shl     dx,1
                .endif
                mov     [si].vp_li_allocl,ax
                mov     [si].vp_li_alloch,dx
                xor     ax,ax
            .endif
        .endif
        .if     <[si].vp_parmlength ge vp_li_attroffst> near
            mov     cx,[si].vp_li_attrsize
            .if     <zero cx> near                                      ;@T52
                mov     cx,es:[di].env_attrbufsiz
                mov     [si].vp_li_attrsize,cx
            .else
                .if     <cx ae es:[di].env_attrbufsiz> and
                .if     <[si].vp_parmlength ae vp_li_attrseg+2>
                    mov     bx,[si].vp_li_attroffst
                    mov     cx,[si].vp_li_attrseg
                    mov     ds,cx
                    mov     cx,es:[di].env_attrbufsiz
                    add     di,env_attrbuf
                    .repeat
                        mov     dl,es:[di]
                        mov     ds:[bx],dl
                        inc     di
                        inc     bx
                        dec     cx
                    .until  <z>                                         ;@T71
                .else
                    mov     ax,ERROR_VIO_INVALID_LENGTH
                .endif
            .endif
        .endif

        Call    RegRest
        ret     12
GetLVBInfo ENDP                         ;@P1 end


R2CSEG  ENDS
        END

