;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = WDHEQU.INC
;*
;* DESCRIPTIVE NAME =         macros, definitions for base video
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION          macros, definitions for base video
;*
;* FUNCTIONS    NONE
;*              
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   12/11/88              P3108   GreInitialize is necessary in DevEnable for VIO  
;*   12/19/88              P3258   Deadlock when MOUOPEN reenters VIOCALLS under
;*                                 DosStartSession when VIO or PM app is in a popup
;*   02/21/89              B700261 Emulate GRows as 16*TRows,
;*   03/08/89              B700065 Shadow the cursor type,
;*   03/25/89              132 DCR 132 changes
;*   04/04/89              B700??? Sizzle work,
;*   05/01/89              HM00550 Clear carry flag for SetBuffAddr routine,
;*   08/07/89              B706051 Add codepage variables for vio_windowable,
;*   09/26/89              B785912 Change default attribute to 07,
;*   11/02/89              549     Seltable changes due to rangeless sessions
;*   02/05/90              704     DCR 704 work
;*   07/31/90              B790152 Return correct number of bytes in LVB,
;*   04/11/91              1348    NAKADA, Enable DBCS support in Vio-Window
;*   05/11/93  @TK1        A64278  TAK, Console creation serialization  
;*
;*****************************************************************************/

                .286p                   ;Generate protect mode code

WDHGSEG         EQU     <_DATA>                                         ;          

;/*
;** Equates used by the Windowable Device Handler
;*/

;/*
;** Stack frame used by all WDH routines
;*/

stackframe      STRUC                   ;VDH Stack Frame

stk_regfs       dw      ?               ;Reg ES save area ;          
stk_reges       dw      ?               ;Reg ES save area
stk_regds       dw      ?               ;Reg DS save area
stk_regdi       dw      ?               ;Reg DI save area
stk_regdih      dw      ?               ;For EDI
stk_regsi       dw      ?               ;Reg SI save area
stk_regsih      dw      ?               ;For ESI
stk_regbp       dw      ?               ;Reg BP save area
stk_regbph      dw      ?               ;For EBP
stk_regsp       dw      ?               ;Reg SP save area
stk_regsph      dw      ?               ;For ESP
stk_regbx       dw      ?               ;Reg BX save area
stk_regbxh      dw      ?               ;For EBX
stk_regdx       dw      ?               ;Reg DX save area
stk_regdxh      dw      ?               ;For EDX
stk_regcx       dw      ?               ;Reg CX save area
stk_regcxh      dw      ?               ;For ECX
stk_regax       dw      ?               ;Reg AX save area
stk_regaxh      dw      ?               ;For EAX
stk_flags       dw      ?               ;Reg FL save area
stk_retaddr     dd      ?               ;Return Address
stk_function    dd      ?               ;Function Number
stk_parmblock   dd      ?               ;Parameter Block Address
stk_envblock    dd      ?               ;Environment Block Address

stackframe      ENDS

;/*
;** Instance data for Windowable Device Handler is defined in BVSCB.INC
;*/

;/*
;** Environment Block used by Windowable Device Handler
;*/

IFDEF D1348
DBCSEvBufSiz    EQU     10                                              ;@A01
ENDIF ;D1348

wdhenvironment  STRUC

env_viops       dw      (1+size VioPresentationSpace)/2 dup (0) ;Room for VIOPS

env_conhandle   dw      0               ;Console Handle
env_processes   dw      0               ;Processes

env_startline   dw      0               ;Starting line of cursor ;          
env_endline     dw      0               ;Ending line of cursor   ;          

env_mdlen       dw      34              ;Length of mode data (=34)
env_type        db      1               ;Type for Mode
env_colors      db      4               ;Colors for Mode
env_cols        dw      80              ;Number of screen columns for text
env_rows        dw      25              ;Number of screen rows for text
env_gcols       dw      640             ;Number of screen columns for graphics
env_grows       dw      400             ;Number of screen rows for graphics ;          
env_attrformat  db      0               ;Attribute format
env_attrbytes   db      1               ;Number of attribute bytes      ;          
env_bufaddr     dd      000B8000h       ;Address of video buffer
env_bufsize     dd      00000FA0h       ;Size of video buffer
env_fullbufsz   dd      00000FA0h       ;Full buffer save size
env_partbufsz   dd      00000FA0h       ;Partial buffer save size
env_extdata     dd      0               ;Extended mode data address

env_scrlleft    dw      0               ;Scrollable Screen Rect                   
env_scrltop     dw      0               ;Scrollable Screen Rect                   
env_scrlright   dw      79              ;Scrollable Screen Rect                   
env_scrlbottom  dw      24              ;Scrollable Screen Rect                   

env_attrbufsiz  dw      1
env_attrbuf     db      07              ;default attribute                          
                db      0               ;second byte of 3 byte attribute                
                db      0               ;third byte of 3 byte attribute                 
                db      0               ;waste byte to keep structure aligned           
env_consolesem  dd      0               ;console creation semaphore     @TK1
env_consinit    db      0               ;console initialization flag    @TK1

IFDEF D1348
                                        ;/Enable multiple DBCS env.
                                        ; E.g., if font resource exists,
                                        ; Chinese, Korean, and Japanese
                                        ; DBCSs are displayed simultaneously.

;/*
;** This structure must be the same as that in pmaviop.h.
;** From here...
;*/

env_DBCSEvBuff  db      DBCSEvBufSiz dup (0)    ;lcid = 0 : default
env_CodePage    dw      ?
env_CtryCode    dw      2 dup (0)

env_DBCSEvBuff1 db      DBCSEvBufSiz dup (0)    ;lcid = 1
env_CodePage1   dw      ?
env_CtryCode1   dw      2 dup (0)

env_DBCSEvBuff2 db      DBCSEvBufSiz dup (0)    ;lcid = 2
env_CodePage2   dw      ?
env_CtryCode2   dw      2 dup (0)

env_DBCSEvBuff3 db      DBCSEvBufSiz dup (0)    ;lcid = 3
env_CodePage3   dw      ?
env_CtryCode3   dw      2 dup (0)

env_grid_color  DD      ?
env_reserved    DD      ?

;/*
;** ...to here
;*/

env_lvbsize     dw      0               ; LVB size (LVB and PS)
                                        ; if 64K, set 0FFFFh
                                        ;/prepare the 2nd LVB for DBCS flag
env_dbcslvbsel  dw      0               ; DBCS flag LVB selector
env_funcindx    dw      0               ; function index for DBCS BufferUpdate
                                        ;/DBCS BufferUpdate (bisecting DBCS
                                        ; character status)
env_dbcsstatus  dw      0               ; bisecting DBCS character status
ENDIF ;D1348

wdhenvironment  ENDS

;/*
;** Engine Call Equates
;*/

GreCharRectLo   EQU     403Bh
GreCharRectHi   EQU     0000h
GreCharStrLo    EQU     403Ch
GreCharStrHi    EQU     0000h
GreScrollRectLo EQU     403Dh
GreScrollRectHi EQU     0000h
GreUpdateCursorLo EQU   403Eh
GreUpdateCursorHi EQU   0000h
GreQueryFontslo EQU     4230h
GreQueryFontsHi EQU     0000h
GreQueryDevCapsLo EQU   40D1h
GreQueryDevCapsHi EQU   0000h
GreDeleteSetIdLo EQU    4222h
GreDeleteSetIdHi EQU    0000h
GreQuerySetIdsLo EQU    4224h
GreQuerySetIdsHi EQU    0000h
GreCreateLogicalFontLo EQU 422Dh
GreCreateLogicalFontHi EQU 0000h

;/*
;** GRE Equates
;*/

LCID_RANGE_AVIO EQU     2
ExtAttrib       EQU     4                                               ;          

IFDEF D1348
                                ;/Set the format ID and attribute count
DefaultFormat   equ     00h     ; default format ID
DefaultAttrCount equ    1       ; default attribute count
DefaultFMTATTR  equ     DefaultFormat or (DefaultAttrCount shl 8)
DefaultCellSize equ     DefaultAttrCount + 1

WorldFormat     equ     70h     ; world format ID
WorldAttrCount  equ     3       ; world attribute count
WorldFMTATTR    equ     WorldFormat or (WorldAttrCount shl 8)
WorldCellSize   equ     WorldAttrCount + 1

PSFormat        equ     00h     ; default PS format
PSAttrCount     equ     1       ; default PS attibute count
PSFMTATTR       equ     PSFormat or (PSAttrCount shl 8)
PSCellSize      equ     PSAttrCount + 1

ExtPSFormat     equ     00h     ; extended PS format
ExtPSAttrCount  equ     3       ; extended PS attribute count
ExtPSFMTATTR    equ     ExtPSFormat or (ExtPSAttrCount shl 8)
ExtPSCellSize   equ     ExtPSAttrCount + 1

                                ;/function index for DBCS BufferUpdate
DefaultFmtIndx  equ     0       ; index of default format function
WorldFmtIndx    equ     2       ; index of world format function
PSFmtIndx       equ     4       ; index of default PS format function
ExtPSFmtIndx    equ     6       ; index of extended PS format function

                                ;/DBCS BufferUpdate (bisecting DBCS character
                                ; status)
BisectDBCS_START        equ     0001h   ; bisected starting DBCS character
BisectDBCS_LAST         equ     0002h   ; bisected ending DBCS character
BisectDBCS_LEFT         equ     0004h   ; bisected DBCS character in left side
BisectDBCS_RIGHT        equ     0008h   ; bisected DBCS character in right side
ENDIF ;D1348

