;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHDATA.INC
;*
;* DESCRIPTIVE NAME = BASE VIDEO DEFINITIONS
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  This file contains some of the definitions needed for
;*              different resolutions
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   04/14/89              B701111 Remove negative logic, 
;*   06/10/89                      Init SCREEN$ handle to zero to avoid extra open
;*   08/22/89              B785343 Add unique code for CGA 8x8 fonts. B785343
;*   01/24/90              704     DCR 704 work
;*   07/08/91                      Reduce memory consumption
;*
;*****************************************************************************/

_DATA   SEGMENT WORD PUBLIC 'DATA'

        PUBLIC  __acrtused
__acrtused equ  1                       ;C Comp puts out 'EXTRN __acrtused:ABS'

IF (VDH8514A NE 1)                                                      ;          

        EXTRN   BVHINSTANCE:WORD                                        ;@T52

        PUBLIC  _hScreenDD                                              ;@T52
_hScreenDD      dd      BVHINSTANCE                                     ;@T52
ENDIF                                                                   ;          

IF VDHVGA

;/*
;** This is the default color lookup table used on a VGA when a color mode is
;** specified via VioSetMode and the 'enable color burst' flag is specified.
;*/

        PUBLIC  _ColorCLUT
_ColorCLUT      label byte
;/*
;**     This table is used for high resolution modes on a color monitor
;**     including 0*, 1*, 2*, 3*, 0+, 1+, 2+, 3+, 10, 11, 12
;*/
        db      00h,00h,00h,00h,00h,2Ah,00h,2Ah,00h,00h,2Ah,2Ah
        db      2Ah,00h,00h,2Ah,00h,2Ah,2Ah,2Ah,00h,2Ah,2Ah,2Ah
        db      00h,00h,15h,00h,00h,3Fh,00h,2Ah,15h,00h,2Ah,3Fh
        db      2Ah,00h,15h,2Ah,00h,3Fh,2Ah,2Ah,15h,2Ah,2Ah,3Fh

        db      00h,15h,00h,00h,15h,2Ah,00h,3Fh,00h,00h,3Fh,2Ah
        db      2Ah,15h,00h,2Ah,15h,2Ah,2Ah,3Fh,00h,2Ah,3Fh,2Ah
        db      00h,15h,15h,00h,15h,3Fh,00h,3Fh,15h,00h,3Fh,3Fh
        db      2Ah,15h,15h,2Ah,15h,3Fh,2Ah,3Fh,15h,2Ah,3Fh,3Fh

        db      15h,00h,00h,15h,00h,2Ah,15h,2Ah,00h,15h,2Ah,2Ah
        db      3Fh,00h,00h,3Fh,00h,2Ah,3Fh,2Ah,00h,3Fh,2Ah,2Ah
        db      15h,00h,15h,15h,00h,3Fh,15h,2Ah,15h,15h,2Ah,3Fh
        db      3Fh,00h,15h,3Fh,00h,3Fh,3Fh,2Ah,15h,3Fh,2Ah,3Fh

        db      15h,15h,00h,15h,15h,2Ah,15h,3Fh,00h,15h,3Fh,2Ah
        db      3Fh,15h,00h,3Fh,15h,2Ah,3Fh,3Fh,00h,3Fh,3Fh,2Ah
        db      15h,15h,15h,15h,15h,3Fh,15h,3Fh,15h,15h,3Fh,3Fh
        db      3Fh,15h,15h,3Fh,15h,3Fh,3Fh,3Fh,15h,3Fh,3Fh,3Fh
        PUBLIC  _ColorCLUTCount
_ColorCLUTCount dw ($-_ColorCLUT)/3

;/*
;** This is the default color lookup table used on a VGA when a monochrome
;** mode is specified via VioSetMode.
;*/

        PUBLIC  _MonoCLUT
_MonoCLUT       label byte
;/*
;**     This table is used for monochrome modes on a color monitor
;**     including 7, 7+, F
;*/
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah

        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh

        PUBLIC  _MonoCLUTCount
_MonoCLUTCount  dw ($-_MonoCLUT)/3

;/*
;** This is the default color lookup table used on a VGA when a color mode is
;** specified via VioSetMode and the 'disable color burst' flag is specified.
;*/

        PUBLIC  _SumCLUT
_SumCLUT        label byte
        db      00h,00h,00h,05h,05h,05h,11h,11h,11h,1Ch,1Ch,1Ch
        db      08h,08h,08h,0Bh,0Bh,0Bh,25h,25h,25h,28h,28h,28h
        db      02h,02h,02h,07h,07h,07h,1Bh,1Bh,1Bh,20h,20h,20h
        db      0Fh,0Fh,0Fh,14h,14h,14h,28h,28h,28h,2Ch,2Ch,2Ch

        db      0Ch,0Ch,0Ch,11h,11h,11h,25h,25h,25h,2Ah,2Ah,2Ah
        db      14h,14h,14h,1Eh,1Eh,1Eh,32h,32h,32h,36h,36h,36h
        db      0Fh,0Fh,0Fh,13h,13h,13h,27h,27h,27h,2Ch,2Ch,2Ch
        db      1Bh,1Bh,1Bh,20h,20h,20h,34h,34h,34h,39h,39h,39h

        db      06h,06h,06h,0Bh,0Bh,0Bh,1Fh,1Fh,1Fh,24h,24h,24h
        db      13h,13h,13h,18h,18h,18h,2Ch,2Ch,2Ch,30h,30h,30h
        db      09h,09h,09h,0Dh,0Dh,0Dh,21h,21h,21h,26h,26h,26h
        db      15h,15h,15h,1Ah,1Ah,1Ah,2Eh,2Eh,2Eh,33h,33h,33h

        db      13h,13h,13h,17h,17h,17h,2Bh,2Bh,2Bh,30h,30h,30h
        db      1Fh,1Fh,1Fh,24h,24h,24h,38h,38h,38h,3Dh,3Dh,3Dh
        db      0Eh,0Eh,0Eh,18h,18h,18h,2Dh,2Dh,2Dh,32h,32h,32h
        db      20h,20h,20h,24h,24h,24h,38h,38h,38h,3Fh,3Fh,3Fh

        PUBLIC  _SumCLUTCount
_SumCLUTCount   dw ($-_SumCLUT)/3

        public  _SumCLUTLow
_SumCLUTLow     label byte
        db      00h,00h,00h, 05h,05h,05h, 11h,11h,11h, 1Ch,1Ch,1Ch
        db      08h,08h,08h, 0Bh,0Bh,0Bh, 14h,14h,14h, 28h,28h,28h
        db      00h,00h,00h, 05h,05h,05h, 11h,11h,11h, 1Ch,1Ch,1Ch
        db      08h,08h,08h, 0Bh,0Bh,0Bh, 14h,14h,14h, 28h,28h,28h

        db      0Eh,0Eh,0Eh, 18h,18h,18h, 2Dh,2Dh,2Dh, 32h,32h,32h
        db      20h,20h,20h, 24h,24h,24h, 38h,38h,38h, 3Fh,3Fh,3Fh
        db      0Eh,0Eh,0Eh, 18h,18h,18h, 2Dh,2Dh,2Dh, 32h,32h,32h
        db      20h,20h,20h, 24h,24h,24h, 38h,38h,38h, 3Fh,3Fh,3Fh
        PUBLIC  _SumCLUTLowCount
_SumCLUTLowCount dw ($-_SumCLUTLow)/3   ; count of 3 byte entries

        public  _ColorCLUTLow
;/*
;**     This table is used for low resolution modes on a color monitor
;**     including 0, 1, 2, 3, 4, 5, 6, D, E
;*/
_ColorCLUTLow label byte
        db      00h,00h,00h,00h,00h,2Ah,00h,2Ah,00h,00h,2Ah,2Ah
        db      2Ah,00h,00h,2Ah,00h,2Ah,2Ah,15h,00h,2Ah,2Ah,2Ah
        db      00h,00h,00h,00h,00h,2Ah,00h,2Ah,00h,00h,2Ah,2Ah
        db      2Ah,00h,00h,2Ah,00h,2Ah,2Ah,15h,00h,2Ah,2Ah,2Ah

        db      15h,15h,15h,15h,15h,3Fh,15h,3Fh,15h,15h,3Fh,3Fh
        db      3Fh,15h,15h,3Fh,15h,3Fh,3Fh,3Fh,15h,3Fh,3Fh,3Fh
        db      15h,15h,15h,15h,15h,3Fh,15h,3Fh,15h,15h,3Fh,3Fh
        db      3Fh,15h,15h,3Fh,15h,3Fh,3Fh,3Fh,15h,3Fh,3Fh,3Fh

        PUBLIC  _ColorCLUTLowCount
_ColorCLUTLowCount dw ($-_ColorCLUTLow)/3       ; count of 3 byte entries

        public  _ColorCLUT256
;/*
;**     This table is used for low resolution 256 color mode
;**     on a color monitor including 13
;*/
_ColorCLUT256   label byte
        db      00h,00h,00h, 00h,00h,2Ah, 00h,2Ah,00h, 00h,2Ah,2Ah
        db      2Ah,00h,00h, 2Ah,00h,2Ah, 2Ah,15h,00h, 2Ah,2Ah,2Ah
        db      15h,15h,15h, 15h,15h,3Fh, 15h,3Fh,15h, 15h,3Fh,3Fh
        db      3Fh,15h,15h, 3Fh,15h,3Fh, 3Fh,3Fh,15h, 3Fh,3Fh,3Fh

        db      00h,00h,00h, 05h,05h,05h, 08h,08h,08h, 0Bh,0Bh,0Bh
        db      0Eh,0Eh,0Eh, 11h,11h,11h, 14h,14h,14h, 18h,18h,18h
        db      1Ch,1Ch,1Ch, 20h,20h,20h, 24h,24h,24h, 28h,28h,28h
        db      2Dh,2Dh,2Dh, 32h,32h,32h, 38h,38h,38h, 3Fh,3Fh,3Fh

        db      00h,00h,3Fh, 10h,00h,3Fh, 1Fh,00h,3Fh, 2Fh,00h,3Fh
        db      3Fh,00h,3Fh, 3Fh,00h,2Fh, 3Fh,00h,1Fh, 3Fh,00h,10h
        db      3Fh,00h,00h, 3Fh,10h,00h, 3Fh,1Fh,00h, 3Fh,2Fh,00h
        db      3Fh,3Fh,00h, 2Fh,3Fh,00h, 1Fh,3Fh,00h, 10h,3Fh,00h

        db      00h,3Fh,00h, 00h,3Fh,10h, 00h,3Fh,1Fh, 00h,3Fh,2Fh
        db      00h,3Fh,3Fh, 00h,2Fh,3Fh, 00h,1Fh,3Fh, 00h,10h,3Fh
        db      1Fh,1Fh,3Fh, 27h,1Fh,3Fh, 2Fh,1Fh,3Fh, 37h,1Fh,3Fh
        db      3Fh,1Fh,3Fh, 3Fh,1Fh,37h, 3Fh,1Fh,2Fh, 3Fh,1Fh,27h

        db      3Fh,1Fh,1Fh, 3Fh,27h,1Fh, 3Fh,2Fh,1Fh, 3Fh,37h,1Fh
        db      3Fh,3Fh,1Fh, 37h,3Fh,1Fh, 2Fh,3Fh,1Fh, 27h,3Fh,1Fh
        db      1Fh,3Fh,1Fh, 1Fh,3Fh,27h, 1Fh,3Fh,2Fh, 1Fh,3Fh,37h
        db      1Fh,3Fh,3Fh, 1Fh,37h,3Fh, 1Fh,2Fh,3Fh, 1Fh,27h,3Fh

        db      2Dh,2Dh,3Fh, 31h,2Dh,3Fh, 36h,2Dh,3Fh, 3Ah,2Dh,3Fh
        db      3Fh,2Dh,3Fh, 3Fh,2Dh,3Ah, 3Fh,2Dh,36h, 3Fh,2Dh,31h
        db      3Fh,2Dh,2Dh, 3Fh,31h,2Dh, 3Fh,36h,2Dh, 3Fh,3Ah,2Dh
        db      3Fh,3Fh,2Dh, 3Ah,3Fh,2Dh, 36h,3Fh,2Dh, 31h,3Fh,2Dh

        db      2Dh,3Fh,2Dh, 2Dh,3Fh,31h, 2Dh,3Fh,36h, 2Dh,3Fh,3Ah
        db      2Dh,3Fh,3Fh, 2Dh,3Ah,3Fh, 2Dh,36h,3Fh, 2Dh,31h,3Fh
        db      00h,00h,1Ch, 07h,00h,1Ch, 0Eh,00h,1Ch, 15h,00h,1Ch
        db      1Ch,00h,1Ch, 1Ch,00h,15h, 1Ch,00h,0Eh, 1Ch,00h,07h

        db      1Ch,00h,00h, 1Ch,07h,00h, 1Ch,0Eh,00h, 1Ch,15h,00h
        db      1Ch,1Ch,00h, 15h,1Ch,00h, 0Eh,1Ch,00h, 07h,1Ch,00h
        db      00h,1Ch,00h, 00h,1Ch,07h, 00h,1Ch,0Eh, 00h,1Ch,15h
        db      00h,1Ch,1Ch, 00h,15h,1Ch, 00h,0Eh,1Ch, 00h,07h,1Ch

        db      0Eh,0Eh,1Ch, 11h,0Eh,1Ch, 15h,0Eh,1Ch, 18h,0Eh,1Ch
        db      1Ch,0Eh,1Ch, 1Ch,0Eh,18h, 1Ch,0Eh,15h, 1Ch,0Eh,11h
        db      1Ch,0Eh,0Eh, 1Ch,11h,0Eh, 1Ch,15h,0Eh, 1Ch,08h,0Eh
        db      1Ch,1Ch,0Eh, 18h,1Ch,0Eh, 15h,1Ch,0Eh, 11h,1Ch,0Eh

        db      0Eh,1Ch,0Eh, 0Eh,1Ch,11h, 0Eh,1Ch,15h, 0Eh,1Ch,18h
        db      0Eh,1Ch,1Ch, 0Eh,18h,1Ch, 0Eh,15h,1Ch, 0Eh,11h,1Ch
        db      14h,14h,1Ch, 16h,14h,1Ch, 18h,14h,1Ch, 1Ah,14h,1Ch
        db      1Ch,14h,1Ch, 1Ch,14h,1Ah, 1Ch,14h,18h, 1Ch,14h,16h

        db      1Ch,14h,14h, 1Ch,16h,14h, 1Ch,18h,14h, 1Ch,1Ah,14h
        db      1Ch,1Ch,14h, 1Ah,1Ch,14h, 18h,1Ch,14h, 16h,1Ch,14h
        db      14h,1Ch,14h, 14h,1Ch,16h, 14h,1Ch,18h, 14h,1Ch,1Ah
        db      14h,1Ch,1Ch, 14h,1Ah,1Ch, 14h,18h,1Ch, 14h,16h,1Ch

        db      00h,00h,10h, 04h,00h,10h, 08h,00h,10h, 0Ch,00h,10h
        db      10h,00h,10h, 10h,00h,0Ch, 10h,00h,08h, 10h,00h,04h
        db      10h,00h,00h, 10h,04h,00h, 10h,08h,00h, 10h,0Ch,00h
        db      10h,10h,00h, 0Ch,10h,00h, 08h,10h,00h, 04h,10h,00h

        db      00h,10h,00h, 00h,10h,04h, 00h,10h,08h, 00h,10h,0Ch
        db      00h,10h,10h, 00h,0Ch,10h, 00h,08h,10h, 00h,04h,10h
        db      08h,08h,10h, 0Ah,08h,10h, 0Ch,08h,10h, 0Eh,08h,10h
        db      10h,08h,10h, 10h,08h,0Eh, 10h,08h,0Ch, 10h,08h,0Ah

        db      10h,08h,08h, 10h,0Ah,08h, 10h,0Ch,08h, 10h,0Eh,08h
        db      10h,10h,08h, 0Eh,10h,08h, 0Ch,10h,08h, 0Ah,10h,08h
        db      08h,10h,08h, 08h,10h,0Ah, 08h,10h,0Ch, 08h,10h,0Eh
        db      08h,10h,10h, 08h,0Eh,10h, 08h,0Ch,10h, 08h,0Ah,10h

        db      0Bh,0Bh,10h, 0Ch,0Bh,10h, 0Dh,0Bh,10h, 0Fh,0Bh,10h
        db      10h,0Bh,10h, 10h,0Bh,0Fh, 10h,0Bh,0Dh, 10h,0Bh,0Ch
        db      10h,0Bh,0Bh, 10h,0Ch,0Bh, 10h,0Dh,0Bh, 10h,0Fh,0Bh
        db      10h,10h,0Bh, 0Fh,10h,0Bh, 0Dh,10h,0Bh, 0Ch,10h,0Bh

        db      0Bh,10h,0Bh, 0Bh,10h,0Ch, 0Bh,10h,0Dh, 0Bh,10h,0Fh
        db      0Bh,10h,10h, 0Bh,0Fh,10h, 0Bh,0Dh,10h, 0Bh,0Ch,10h

        db      15h,15h,15h,15h,15h,3Fh,15h,3Fh,15h,15h,3Fh,3Fh
        db      3Fh,15h,15h,3Fh,15h,3Fh,3Fh,3Fh,15h,3Fh,3Fh,3Fh

        PUBLIC  _ColorCLUT256Count
_ColorCLUT256Count dw ($-_ColorCLUT256)/3       ; count of 3 byte entries
        public  _SumCLUT256
;/*
;**     This table is used for low resolution 256 color mode
;**     on a monochrome monitor including BIOS mode 13
;*/
_SumCLUT256  label byte
        db      00h,00h,00h, 05h,05h,05h, 11h,11h,11h, 1Ch,1Ch,1Ch
        db      08h,08h,08h, 0Bh,0Bh,0Bh, 14h,14h,14h, 28h,28h,28h
        db      0Eh,0Eh,0Eh, 18h,18h,18h, 2Dh,2Dh,2Dh, 32h,32h,32h
        db      20h,20h,20h, 24h,24h,24h, 38h,38h,38h, 3Fh,3Fh,3Fh

        db      00h,00h,00h, 05h,05h,05h, 08h,08h,08h, 0Bh,0Bh,0Bh
        db      0Eh,0Eh,0Eh, 11h,11h,11h, 14h,14h,14h, 18h,18h,18h
        db      1Ch,1Ch,1Ch, 20h,20h,20h, 24h,24h,24h, 28h,28h,28h
        db      2Dh,2Dh,2Dh, 32h,32h,32h, 38h,38h,38h, 3Fh,3Fh,3Fh

        db      07h,07h,07h, 0Ch,0Ch,0Ch, 10h,10h,10h, 15h,15h,15h
        db      1Ah,1Ah,1Ah, 18h,18h,18h, 16h,16h,16h, 15h,15h,15h
        db      13h,13h,13h, 1Ch,1Ch,1Ch, 25h,25h,25h, 2Fh,2Fh,2Fh
        db      38h,38h,38h, 33h,33h,33h, 2Eh,2Eh,2Eh, 2Ah,2Ah,2Ah

        db      25h,25h,25h, 27h,27h,27h, 29h,29h,29h, 2Ah,2Ah,2Ah
        db      2Ch,2Ch,2Ch, 23h,23h,23h, 19h,19h,19h, 10h,10h,10h
        db      23h,23h,23h, 25h,25h,25h, 27h,27h,27h, 2Ah,2Ah,2Ah
        db      2Ch,2Ch,2Ch, 2Bh,2Bh,2Bh, 2Ah,2Ah,2Ah, 29h,29h,29h

        db      29h,29h,29h, 2Dh,2Dh,2Dh, 32h,32h,32h, 37h,37h,37h
        db      3Bh,3Bh,3Bh, 39h,39h,39h, 37h,37h,37h, 34h,34h,34h
        db      32h,32h,32h, 33h,33h,33h, 34h,34h,34h, 35h,35h,35h
        db      35h,35h,35h, 31h,31h,31h, 2Ch,2Ch,2Ch, 27h,27h,27h

        db      2Fh,2Fh,2Fh, 30h,30h,30h, 32h,32h,32h, 33h,33h,33h
        db      34h,34h,34h, 34h,34h,34h, 33h,33h,33h, 33h,33h,33h
        db      32h,32h,32h, 35h,35h,35h, 38h,38h,38h, 3Ah,3Ah,3Ah
        db      3Dh,3Dh,3Dh, 3Ch,3Ch,3Ch, 3Ah,3Ah,3Ah, 39h,39h,39h

        db      38h,38h,38h, 38h,38h,38h, 39h,39h,39h, 39h,39h,39h
        db      3Ah,3Ah,3Ah, 37h,37h,37h, 34h,34h,34h, 31h,31h,31h
        db      03h,03h,03h, 05h,05h,05h, 07h,07h,07h, 09h,09h,09h
        db      0Bh,0Bh,0Bh, 0Bh,0Bh,0Bh, 0Ah,0Ah,0Ah, 09h,09h,09h

        db      08h,08h,08h, 0Dh,0Dh,0Dh, 11h,11h,11h, 15h,15h,15h
        db      19h,19h,19h, 17h,17h,17h, 15h,15h,15h, 13h,13h,13h
        db      11h,11h,11h, 11h,11h,11h, 12h,12h,12h, 13h,13h,13h
        db      14h,14h,14h, 0Fh,0Fh,0Fh, 0Bh,0Bh,0Bh, 07h,07h,07h

        db      10h,10h,10h, 10h,10h,10h, 12h,12h,12h, 13h,13h,13h
        db      14h,14h,14h, 13h,13h,13h, 13h,13h,13h, 13h,13h,13h
        db      12h,12h,12h, 14h,14h,14h, 16h,16h,16h, 18h,18h,18h
        db      1Ah,1Ah,1Ah, 19h,19h,19h, 18h,18h,18h, 17h,17h,17h

        db      16h,16h,16h, 17h,17h,17h, 17h,17h,17h, 17h,17h,17h
        db      18h,18h,18h, 15h,15h,15h, 14h,14h,14h, 11h,11h,11h
        db      15h,15h,15h, 15h,15h,15h, 16h,16h,16h, 17h,17h,17h
        db      17h,17h,17h, 17h,17h,17h, 17h,17h,17h, 17h,17h,17h

        db      16h,16h,16h, 18h,18h,18h, 19h,19h,19h, 1Ah,1Ah,1Ah
        db      1Bh,1Bh,1Bh, 1Bh,1Bh,1Bh, 1Ah,1Ah,1Ah, 19h,19h,19h
        db      19h,19h,19h, 19h,19h,19h, 19h,19h,19h, 19h,19h,19h
        db      1Ah,1Ah,1Ah, 18h,18h,18h, 17h,17h,17h, 16h,16h,16h

        db      02h,02h,02h, 03h,03h,03h, 04h,04h,04h, 05h,05h,05h
        db      07h,07h,07h, 06h,06h,06h, 06h,06h,06h, 05h,05h,05h
        db      05h,05h,05h, 07h,07h,07h, 0Ah,0Ah,0Ah, 0Ch,0Ch,0Ch
        db      0Eh,0Eh,0Eh, 0Dh,0Dh,0Dh, 0Ch,0Ch,0Ch, 0Bh,0Bh,0Bh

        db      09h,09h,09h, 0Ah,0Ah,0Ah, 0Ah,0Ah,0Ah, 0Bh,0Bh,0Bh
        db      0Bh,0Bh,0Bh, 09h,09h,09h, 06h,06h,06h, 04h,04h,04h
        db      09h,09h,09h, 09h,09h,09h, 0Ah,0Ah,0Ah, 0Bh,0Bh,0Bh
        db      0Bh,0Bh,0Bh, 0Bh,0Bh,0Bh, 0Bh,0Bh,0Bh, 0Bh,0Bh,0Bh

        db      0Ah,0Ah,0Ah, 0Ch,0Ch,0Ch, 0Dh,0Dh,0Dh, 0Eh,0Eh,0Eh
        db      0Fh,0Fh,0Fh, 0Fh,0Fh,0Fh, 0Eh,0Eh,0Eh, 0Dh,0Dh,0Dh
        db      0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh
        db      0Eh,0Eh,0Eh, 0Ch,0Ch,0Ch, 0Bh,0Bh,0Bh, 0Ah,0Ah,0Ah

        db      0Ch,0Ch,0Ch, 0Ch,0Ch,0Ch, 0Ch,0Ch,0Ch, 0Dh,0Dh,0Dh
        db      0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh, 0Dh,0Dh,0Dh
        db      0Ch,0Ch,0Ch, 0Dh,0Dh,0Dh, 0Eh,0Eh,0Eh, 0Fh,0Fh,0Fh
        db      0Fh,0Fh,0Fh, 0Fh,0Fh,0Fh, 0Fh,0Fh,0Fh, 0Eh,0Eh,0Eh

        db      0Eh,0Eh,0Eh, 0Eh,0Eh,0Eh, 0Eh,0Eh,0Eh, 0Eh,0Eh,0Eh
        db      0Eh,0Eh,0Eh, 0Eh,0Eh,0Eh, 0Dh,0Dh,0Dh, 0Ch,0Ch,0Ch
        db      15h,15h,15h,1Ah,1Ah,1Ah,2Eh,2Eh,2Eh,32h,32h,32h
        db      22h,22h,22h,26h,26h,26h,3Ah,3Ah,3Ah,3Fh,3Fh,3Fh
        PUBLIC  _SumCLUT256Count
_SumCLUT256Count dw ($-_SumCLUT256)/3   ; count of 3 byte entries

ENDIF   ; VDHVGA

IF VDHCGA                               ;           Beginning 

        PUBLIC  _CGAFont                ;Lower 128 characters for CGA

_CGAFont        label byte
        db      000h,000h,000h,000h,000h,000h,000h,000h,07Eh,081h,0A5h,081h,0BDh,099h,081h,07Eh
        db      07Eh,0FFh,0DBh,0FFh,0C3h,0E7h,0FFh,07Eh,06Ch,0FEh,0FEh,0FEh,07Ch,038h,010h,000h
        db      010h,038h,07Ch,0FEh,07Ch,038h,010h,000h,038h,07Ch,038h,0FEh,0FEh,07Ch,038h,07Ch
        db      010h,010h,038h,07Ch,0FEh,07Ch,038h,07Ch,000h,000h,018h,03Ch,03Ch,018h,000h,000h
        db      0FFh,0FFh,0E7h,0C3h,0C3h,0E7h,0FFh,0FFh,000h,03Ch,066h,042h,042h,066h,03Ch,000h
        db      0FFh,0C3h,099h,0BDh,0BDh,099h,0C3h,0FFh,00Fh,007h,00Fh,07Dh,0CCh,0CCh,0CCh,078h
        db      03Ch,066h,066h,066h,03Ch,018h,07Eh,018h,03Fh,033h,03Fh,030h,030h,070h,0F0h,0E0h
        db      07Fh,063h,07Fh,063h,063h,067h,0E6h,0C0h,099h,05Ah,03Ch,0E7h,0E7h,03Ch,05Ah,099h

        db      080h,0E0h,0F8h,0FEh,0F8h,0E0h,080h,000h,002h,00Eh,03Eh,0FEh,03Eh,00Eh,002h,000h
        db      018h,03Ch,07Eh,018h,018h,07Eh,03Ch,018h,066h,066h,066h,066h,066h,000h,066h,000h
        db      07Fh,0DBh,0DBh,07Bh,01Bh,01Bh,01Bh,000h,03Eh,063h,038h,06Ch,06Ch,038h,0CCh,078h
        db      000h,000h,000h,000h,07Eh,07Eh,07Eh,000h,018h,03Ch,07Eh,018h,07Eh,03Ch,018h,0FFh
        db      018h,03Ch,07Eh,018h,018h,018h,018h,000h,018h,018h,018h,018h,07Eh,03Ch,018h,000h
        db      000h,018h,00Ch,0FEh,00Ch,018h,000h,000h,000h,030h,060h,0FEh,060h,030h,000h,000h
        db      000h,000h,0C0h,0C0h,0C0h,0FEh,000h,000h,000h,024h,066h,0FFh,066h,024h,000h,000h
        db      000h,018h,03Ch,07Eh,0FFh,0FFh,000h,000h,000h,0FFh,0FFh,07Eh,03Ch,018h,000h,000h

        db      000h,000h,000h,000h,000h,000h,000h,000h,030h,078h,078h,030h,030h,000h,030h,000h
        db      06Ch,06Ch,06Ch,000h,000h,000h,000h,000h,06Ch,06Ch,0FEh,06Ch,0FEh,06Ch,06Ch,000h
        db      030h,07Ch,0C0h,078h,00Ch,0F8h,030h,000h,000h,0C6h,0CCh,018h,030h,066h,0C6h,000h
        db      038h,06Ch,038h,076h,0DCh,0CCh,076h,000h,060h,060h,0C0h,000h,000h,000h,000h,000h
        db      018h,030h,060h,060h,060h,030h,018h,000h,060h,030h,018h,018h,018h,030h,060h,000h
        db      000h,066h,03Ch,0FFh,03Ch,066h,000h,000h,000h,030h,030h,0FCh,030h,030h,000h,000h
        db      000h,000h,000h,000h,000h,030h,030h,060h,000h,000h,000h,0FCh,000h,000h,000h,000h
        db      000h,000h,000h,000h,000h,030h,030h,000h,006h,00Ch,018h,030h,060h,0C0h,080h,000h

        db      07Ch,0C6h,0CEh,0DEh,0F6h,0E6h,07Ch,000h,030h,070h,030h,030h,030h,030h,0FCh,000h
        db      078h,0CCh,00Ch,038h,060h,0CCh,0FCh,000h,078h,0CCh,00Ch,038h,00Ch,0CCh,078h,000h
        db      01Ch,03Ch,06Ch,0CCh,0FEh,00Ch,01Eh,000h,0FCh,0C0h,0F8h,00Ch,00Ch,0CCh,078h,000h
        db      038h,060h,0C0h,0F8h,0CCh,0CCh,078h,000h,0FCh,0CCh,00Ch,018h,030h,030h,030h,000h
        db      078h,0CCh,0CCh,078h,0CCh,0CCh,078h,000h,078h,0CCh,0CCh,07Ch,00Ch,018h,070h,000h
        db      000h,030h,030h,000h,000h,030h,030h,000h,000h,030h,030h,000h,000h,030h,030h,060h
        db      018h,030h,060h,0C0h,060h,030h,018h,000h,000h,000h,0FCh,000h,000h,0FCh,000h,000h
        db      060h,030h,018h,00Ch,018h,030h,060h,000h,078h,0CCh,00Ch,018h,030h,000h,030h,000h

        db      07Ch,0C6h,0DEh,0DEh,0DEh,0C0h,078h,000h,030h,078h,0CCh,0CCh,0FCh,0CCh,0CCh,000h
        db      0FCh,066h,066h,07Ch,066h,066h,0FCh,000h,03Ch,066h,0C0h,0C0h,0C0h,066h,03Ch,000h
        db      0F8h,06Ch,066h,066h,066h,06Ch,0F8h,000h,0FEh,062h,068h,078h,068h,062h,0FEh,000h
        db      0FEh,062h,068h,078h,068h,060h,0F0h,000h,03Ch,066h,0C0h,0C0h,0CEh,066h,03Eh,000h
        db      0CCh,0CCh,0CCh,0FCh,0CCh,0CCh,0CCh,000h,078h,030h,030h,030h,030h,030h,078h,000h
        db      01Eh,00Ch,00Ch,00Ch,0CCh,0CCh,078h,000h,0E6h,066h,06Ch,078h,06Ch,066h,0E6h,000h
        db      0F0h,060h,060h,060h,062h,066h,0FEh,000h,0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,000h
        db      0C6h,0E6h,0F6h,0DEh,0CEh,0C6h,0C6h,000h,038h,06Ch,0C6h,0C6h,0C6h,06Ch,038h,000h

        db      0FCh,066h,066h,07Ch,060h,060h,0F0h,000h,078h,0CCh,0CCh,0CCh,0DCh,078h,01Ch,000h
        db      0FCh,066h,066h,07Ch,06Ch,066h,0E6h,000h,078h,0CCh,0E0h,070h,01Ch,0CCh,078h,000h
        db      0FCh,0B4h,030h,030h,030h,030h,078h,000h,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0FCh,000h
        db      0CCh,0CCh,0CCh,0CCh,0CCh,078h,030h,000h,0C6h,0C6h,0C6h,0D6h,0FEh,0EEh,0C6h,000h
        db      0C6h,0C6h,06Ch,038h,038h,06Ch,0C6h,000h,0CCh,0CCh,0CCh,078h,030h,030h,078h,000h
        db      0FEh,0C6h,08Ch,018h,032h,066h,0FEh,000h,078h,060h,060h,060h,060h,060h,078h,000h
        db      0C0h,060h,030h,018h,00Ch,006h,002h,000h,078h,018h,018h,018h,018h,018h,078h,000h
        db      010h,038h,06Ch,0C6h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0FFh

        db      030h,030h,018h,000h,000h,000h,000h,000h,000h,000h,078h,00Ch,07Ch,0CCh,076h,000h
        db      0E0h,060h,060h,07Ch,066h,066h,0DCh,000h,000h,000h,078h,0CCh,0C0h,0CCh,078h,000h
        db      01Ch,00Ch,00Ch,07Ch,0CCh,0CCh,076h,000h,000h,000h,078h,0CCh,0FCh,0C0h,078h,000h
        db      038h,06Ch,060h,0F0h,060h,060h,0F0h,000h,000h,000h,076h,0CCh,0CCh,07Ch,00Ch,0F8h
        db      0E0h,060h,06Ch,076h,066h,066h,0E6h,000h,030h,000h,070h,030h,030h,030h,078h,000h
        db      00Ch,000h,00Ch,00Ch,00Ch,0CCh,0CCh,078h,0E0h,060h,066h,06Ch,078h,06Ch,0E6h,000h
        db      070h,030h,030h,030h,030h,030h,078h,000h,000h,000h,0CCh,0FEh,0FEh,0D6h,0C6h,000h
        db      000h,000h,0F8h,0CCh,0CCh,0CCh,0CCh,000h,000h,000h,078h,0CCh,0CCh,0CCh,078h,000h

        db      000h,000h,0DCh,066h,066h,07Ch,060h,0F0h,000h,000h,076h,0CCh,0CCh,07Ch,00Ch,01Eh
        db      000h,000h,0DCh,076h,066h,060h,0F0h,000h,000h,000h,07Ch,0C0h,078h,00Ch,0F8h,000h
        db      010h,030h,07Ch,030h,030h,034h,018h,000h,000h,000h,0CCh,0CCh,0CCh,0CCh,076h,000h
        db      000h,000h,0CCh,0CCh,0CCh,078h,030h,000h,000h,000h,0C6h,0D6h,0FEh,0FEh,06Ch,000h
        db      000h,000h,0C6h,06Ch,038h,06Ch,0C6h,000h,000h,000h,0CCh,0CCh,0CCh,07Ch,00Ch,0F8h
        db      000h,000h,0FCh,098h,030h,064h,0FCh,000h,01Ch,030h,030h,0E0h,030h,030h,01Ch,000h
        db      018h,018h,018h,000h,018h,018h,018h,000h,0E0h,030h,030h,01Ch,030h,030h,0E0h,000h
        db      076h,0DCh,000h,000h,000h,000h,000h,000h,000h,010h,038h,06Ch,0C6h,0C6h,0FEh,000h

ENDIF   ; VDHCGA                        ;           End 

IF ROMFONT_SUPPORT                      ;                     

        PUBLIC  BldFont                 ;Upper 128 characters for CGA

BldFont label byte
        db      078h,0CCh,0C0h,0CCh,078h,018h,00Ch,078h ;80h
        db      000h,0CCh,000h,0CCh,0CCh,0CCh,07Eh,000h ;81h
        db      01Ch,000h,078h,0CCh,0FCh,0C0h,078h,000h ;82h
        db      07Eh,0C3h,03Ch,006h,03Eh,066h,03Fh,000h ;83h
        db      0CCh,000h,078h,00Ch,07Ch,0CCh,07Eh,000h ;84h
        db      0E0h,000h,078h,00Ch,07Ch,0CCh,07Eh,000h ;85h
        db      030h,030h,078h,00Ch,07Ch,0CCh,07Eh,000h ;86h
        db      000h,000h,078h,0C0h,0C0h,078h,00Ch,038h ;87h
        db      07Eh,0C3h,03Ch,066h,07Eh,060h,03Ch,000h ;88h
        db      0CCh,000h,078h,0CCh,0FCh,0C0h,078h,000h ;89h
        db      0E0h,000h,078h,0CCh,0FCh,0C0h,078h,000h ;8Ah
        db      0CCh,000h,070h,030h,030h,030h,078h,000h ;8Bh
        db      07Ch,0C6h,038h,018h,018h,018h,03Ch,000h ;8Ch
        db      0E0h,000h,070h,030h,030h,030h,078h,000h ;8Dh
        db      0C6h,038h,06Ch,0C6h,0FEh,0C6h,0C6h,000h ;8Eh
        db      030h,030h,000h,078h,0CCh,0FCh,0CCh,000h ;8Fh
        db      01Ch,000h,0FCh,060h,078h,060h,0FCh,000h ;90h
        db      000h,000h,07Fh,00Ch,07Fh,0CCh,07Fh,000h ;91h
        db      03Eh,06Ch,0CCh,0FEh,0CCh,0CCh,0CEh,000h ;92h
        db      078h,0CCh,000h,078h,0CCh,0CCh,078h,000h ;93h
        db      000h,0CCh,000h,078h,0CCh,0CCh,078h,000h ;94h
        db      000h,0E0h,000h,078h,0CCh,0CCh,078h,000h ;95h
        db      078h,0CCh,000h,0CCh,0CCh,0CCh,07Eh,000h ;96h
        db      000h,0E0h,000h,0CCh,0CCh,0CCh,07Eh,000h ;97h
        db      000h,0CCh,000h,0CCh,0CCh,07Ch,00Ch,0F8h ;98h
        db      0C3h,018h,03Ch,066h,066h,03Ch,018h,000h ;99h
        db      0CCh,000h,0CCh,0CCh,0CCh,0CCh,078h,000h ;9Ah
        db      018h,018h,07Eh,0C0h,0C0h,07Eh,018h,018h ;9Bh
        db      038h,06Ch,064h,0F0h,060h,0E6h,0FCh,000h ;9Ch
        db      0CCh,0CCh,078h,0FCh,030h,0FCh,030h,030h ;9Dh
        db      0F8h,0CCh,0CCh,0FAh,0C6h,0CFh,0C6h,0C7h ;9Eh
        db      00Eh,01Bh,018h,03Ch,018h,018h,0D8h,070h ;9Fh
        db      01Ch,000h,078h,00Ch,07Ch,0CCh,07Eh,000h ;A0h
        db      038h,000h,070h,030h,030h,030h,078h,000h ;A1h
        db      000h,01Ch,000h,078h,0CCh,0CCh,078h,000h ;A2h
        db      000h,01Ch,000h,0CCh,0CCh,0CCh,07Eh,000h ;A3h
        db      000h,0F8h,000h,0F8h,0CCh,0CCh,0CCh,000h ;A4h
        db      0FCh,000h,0CCh,0ECh,0FCh,0DCh,0CCh,000h ;A5h
        db      03Ch,06Ch,06Ch,03Eh,000h,07Eh,000h,000h ;A6h
        db      038h,06Ch,06Ch,038h,000h,07Ch,000h,000h ;A7h
        db      030h,000h,030h,060h,0C0h,0CCh,078h,000h ;A8h
        db      000h,000h,000h,0FCh,0C0h,0C0h,000h,000h ;A9h
        db      000h,000h,000h,0FCh,00Ch,00Ch,000h,000h ;AAh
        db      0C3h,0C6h,0CCh,0DEh,033h,066h,0CCh,00Fh ;ABh
        db      0C3h,0C6h,0CCh,0DBh,037h,06Fh,0CFh,003h ;ACh
        db      018h,018h,000h,018h,018h,018h,018h,000h ;ADh
        db      000h,033h,066h,0CCh,066h,033h,000h,000h ;AEh
        db      000h,0CCh,066h,033h,066h,0CCh,000h,000h ;AFh
        db      022h,088h,022h,088h,022h,088h,022h,088h ;B0h
        db      055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh ;B1h
        db      0DBh,077h,0DBh,0EEh,0DBh,077h,0DBh,0EEh ;B2h
        db      018h,018h,018h,018h,018h,018h,018h,018h ;B3h
        db      018h,018h,018h,018h,0F8h,018h,018h,018h ;B4h
        db      018h,018h,0F8h,018h,0F8h,018h,018h,018h ;B5h
        db      036h,036h,036h,036h,0F6h,036h,036h,036h ;B6h
        db      000h,000h,000h,000h,0FEh,036h,036h,036h ;B7h
        db      000h,000h,0F8h,018h,0F8h,018h,018h,018h ;B8h
        db      036h,036h,0F6h,006h,0F6h,036h,036h,036h ;B9h
        db      036h,036h,036h,036h,036h,036h,036h,036h ;BAh
        db      000h,000h,0FEh,006h,0F6h,036h,036h,036h ;BBh
        db      036h,036h,0F6h,006h,0FEh,000h,000h,000h ;BCh
        db      036h,036h,036h,036h,0FEh,000h,000h,000h ;BDh
        db      018h,018h,0F8h,018h,0F8h,000h,000h,000h ;BEh
        db      000h,000h,000h,000h,0F8h,018h,018h,018h ;BFh
        db      018h,018h,018h,018h,01Fh,000h,000h,000h ;C0h
        db      018h,018h,018h,018h,0FFh,000h,000h,000h ;C1h
        db      000h,000h,000h,000h,0FFh,018h,018h,018h ;C2h
        db      018h,018h,018h,018h,01Fh,018h,018h,018h ;C3h
        db      000h,000h,000h,000h,0FFh,000h,000h,000h ;C4h
        db      018h,018h,018h,018h,0FFh,018h,018h,018h ;C5h
        db      018h,018h,01Fh,018h,01Fh,018h,018h,018h ;C6h
        db      036h,036h,036h,036h,037h,036h,036h,036h ;C7h
        db      036h,036h,037h,030h,03Fh,000h,000h,000h ;C8h
        db      000h,000h,03Fh,030h,037h,036h,036h,036h ;C9h
        db      036h,036h,0F7h,000h,0FFh,000h,000h,000h ;CAh
        db      000h,000h,0FFh,000h,0F7h,036h,036h,036h ;CBh
        db      036h,036h,037h,030h,037h,036h,036h,036h ;CCh
        db      000h,000h,0FFh,000h,0FFh,000h,000h,000h ;CDh
        db      036h,036h,0F7h,000h,0F7h,036h,036h,036h ;CEh
        db      018h,018h,0FFh,000h,0FFh,000h,000h,000h ;CFh
        db      036h,036h,036h,036h,0FFh,000h,000h,000h ;D0h
        db      000h,000h,0FFh,000h,0FFh,018h,018h,018h ;D1h
        db      000h,000h,000h,000h,0FFh,036h,036h,036h ;D2h
        db      036h,036h,036h,036h,03Fh,000h,000h,000h ;D3h
        db      018h,018h,01Fh,018h,01Fh,000h,000h,000h ;D4h
        db      000h,000h,01Fh,018h,01Fh,018h,018h,018h ;D5h
        db      000h,000h,000h,000h,03Fh,036h,036h,036h ;D6h
        db      036h,036h,036h,036h,0FFh,036h,036h,036h ;D7h
        db      018h,018h,0FFh,018h,0FFh,018h,018h,018h ;D8h
        db      018h,018h,018h,018h,0F8h,000h,000h,000h ;D9h
        db      000h,000h,000h,000h,01Fh,018h,018h,018h ;DAh
        db      0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh ;DBh
        db      000h,000h,000h,000h,0FFh,0FFh,0FFh,0FFh ;DCh
        db      0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h ;DDh
        db      00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh ;DEh
        db      0FFh,0FFh,0FFh,0FFh,000h,000h,000h,000h ;DFh
        db      000h,000h,076h,0DCh,0C8h,0DCh,076h,000h ;E0h
        db      000h,078h,0CCh,0F8h,0CCh,0F8h,0C0h,0C0h ;E1h
        db      000h,0FCh,0CCh,0C0h,0C0h,0C0h,0C0h,000h ;E2h
        db      000h,0FEh,06Ch,06Ch,06Ch,06Ch,06Ch,000h ;E3h
        db      0FCh,0CCh,060h,030h,060h,0CCh,0FCh,000h ;E4h
        db      000h,000h,07Eh,0D8h,0D8h,0D8h,070h,000h ;E5h
        db      000h,066h,066h,066h,066h,07Ch,060h,0C0h ;E6h
        db      000h,076h,0DCh,018h,018h,018h,018h,000h ;E7h
        db      0FCh,030h,078h,0CCh,0CCh,078h,030h,0FCh ;E8h
        db      038h,06Ch,0C6h,0FEh,0C6h,06Ch,038h,000h ;E9h
        db      038h,06Ch,0C6h,0C6h,06Ch,06Ch,0EEh,000h ;EAh
        db      01Ch,030h,018h,07Ch,0CCh,0CCh,078h,000h ;EBh
        db      000h,000h,07Eh,0DBh,0DBh,07Eh,000h,000h ;ECh
        db      006h,00Ch,07Eh,0DBh,0DBh,07Eh,060h,0C0h ;EDh
        db      038h,060h,0C0h,0F8h,0C0h,060h,038h,000h ;EEh
        db      078h,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,000h ;EFh
        db      000h,0FCh,000h,0FCh,000h,0FCh,000h,000h ;F0h
        db      030h,030h,0FCh,030h,030h,000h,0FCh,000h ;F1h
        db      060h,030h,018h,030h,060h,000h,0FCh,000h ;F2h
        db      018h,030h,060h,030h,018h,000h,0FCh,000h ;F3h
        db      00Eh,01Bh,01Bh,018h,018h,018h,018h,018h ;F4h
        db      018h,018h,018h,018h,018h,0D8h,0D8h,070h ;F5h
        db      030h,030h,000h,0FCh,000h,030h,030h,000h ;F6h
        db      000h,076h,0DCh,000h,076h,0DCh,000h,000h ;F7h
        db      038h,06Ch,06Ch,038h,000h,000h,000h,000h ;F8h
        db      000h,000h,000h,018h,018h,000h,000h,000h ;F9h
        db      000h,000h,000h,000h,018h,000h,000h,000h ;FAh
        db      00Fh,00Ch,00Ch,00Ch,0ECh,06Ch,03Ch,01Ch ;FBh
        db      078h,06Ch,06Ch,06Ch,06Ch,000h,000h,000h ;FCh
        db      070h,018h,030h,060h,078h,000h,000h,000h ;FDh
        db      000h,000h,03Ch,03Ch,03Ch,03Ch,000h,000h ;FEh
        db      000h,000h,000h,000h,000h,000h,000h,000h ;FFh
        db      0C00h dup (?)           ;Filler for real mode

ENDIF   ; ROMFONT_SUPPORT

_DATA   ENDS

EXTRN   _HugeShift:WORD

