/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VDHDATA.H
 *
 * DESCRIPTIVE NAME = Video Device Handler data include file
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS    NONE
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Global variables - data shared by more than one VDH routine
*/

#if DEBUG
unsigned DEBUG_OUT = 0;              /* Debug printf (trace) output request */
#if VDHVGA
char *DEBUG_BVH_VERSION = "BVHVGA ";
#endif  /* VDHVGA */
#if VDHEGA
char *DEBUG_BVH_VERSION = "BVHEGA ";
#endif  /* VDHEGA */
#if VDHCGA
char *DEBUG_BVH_VERSION = "BVHCGA ";
#endif  /* VDHCGA */
#if VDHMPA
char *DEBUG_BVH_VERSION = "BVHMPA ";
#endif  /* VDHMPA */
#if VDH8514A
char *DEBUG_BVH_VERSION = "BVH8514A ";
#endif  /* VDH8514A */
#if VDHINIT
char *DEBUG_BVH_VERSION = "BVHINIT ";
#endif  /* VDHINIT */
#if VDHWNDW
char *DEBUG_BVH_VERSION = "BVHWNDW ";
#endif  /* VDHWNDW */

UCHAR   DEBUG_ACTIVE[]  =
        {
        0, /* FnTextBufferUpdate        */
        0, /* FnInitializeEnvironment   */
        1, /* FnSaveEnvironment         */
        1, /* FnRestoreEnvironment      */
        0, /* FnReturnConfigInfo        */
        0, /* FnGetDBCSDisplayInfo      */
        0, /* FnGetColorLookupTable     */
        0, /* FnSetColorLookupTable     */
        0, /* FnGetCursorInfo           */
        0, /* FnSetCursorInfo           */
        0, /* FnGetFont                 */
        0, /* FnSetFont                 */
        0, /* FnGetMode                 */
        0, /* FnSetMode                 */
        0, /* FnGetPaletteRegisters     */
        0, /* FnSetPaletteRegisters     */
        0, /* FnGetPhysBuf              */
        0, /* FnFreePhysBuf             */
        0, /* FnGetVariableInfo         */
        0, /* FnSetVariableInfo         */
        0, /* FnExtendedVioCall         */
        0, /* FnReserved1               */              /* print screen */
        0, /* FnReserved2               */              /* write TTY    */
        0, /* FnGetLVBInfo              */              /*                     */
        0, /* FnGetState                */              /*                     */
        0, /* FnSetState                */              /*                     */
        0xFF    /* end marker for humans */
        };
/* unsigned     DEBUG_NAME_LEN  = 24; */  /* debug name string length */
char    *DEBUG_NAME[]   =
        {     /* names for function codes */
        "FnTextBufferUpdate\x0A\x0D",
        "FnInitializeEnvironment\x0A\x0D",
        "FnSaveEnvironment\x0A\x0D",
        "FnRestoreEnvironment\x0A\x0D",
        "FnReturnConfigInfo\x0A\x0D",
        "FnGetDBCSDisplayInfo\x0A\x0D",
        "FnGetColorLookupTable\x0A\x0D",
        "FnSetColorLookupTable\x0A\x0D",
        "FnGetCursorInfo\x0A\x0D",
        "FnSetCursorInfo\x0A\x0D",
        "FnGetFont\x0A\x0D",
        "FnSetFont\x0A\x0D",
        "FnGetMode\x0A\x0D",
        "FnSetMode\x0A\x0D",
        "FnGetPaletteRegisters\x0A\x0D",
        "FnSetPaletteRegisters\x0A\x0D",
        "FnGetPhysBuf\x0A\x0D",
        "FnFreePhysBuf\x0A\x0D",
        "FnGetVariableInfo\x0A\x0D",
        "FnSetVariableInfo\x0A\x0D",
        "FnExtendedVioCall\x0A\x0D",
        "FnReserved1\x0A\x0D",          /* print screen */
        "FnReserved2\x0A\x0D",          /* write TTY    */
        "FnGetLVBInfo\x0A\x0D",         /*                     */
        "FnGetState\x0A\x0D",
        "FnSetState\x0A\x0D",
        "EndOfTable\x0A\x0D",
        };
#endif  /* DEBUG */

#if VDHVGA

/*
** The following is a programming table for the intensity values
** to be used on 8 to 32 shade monochrome VGA displays (such as LCD).
** The 16 values correspond to the 16 colors in text mode.
*/

UCHAR LCDGrayLUT[]={    0x00,0x04,0x0C,0x0E,0x08,0x09,0x0A,0x12,
                        0x01,0x07,0x19,0x1B,0x15,0x17,0x1D,0x1F };
#endif  /* VDHVGA */

USHORT HugeShift = 0;    /* Amount added to a huge selector to get to the next */
USHORT DeviceDriver = 0; /* version number                                     */
UCHAR FIRST_ENTRY = TRUE;/* Flag to force only one device initialization       */
UCHAR FIRST_INIT = TRUE; /* Flag to force only one INIT device initialization  */
UCHAR READABLE = 0;      /* Flag to determine if hardware is write-only        */
USHORT ConfigFlag = 0;
ULONG PartialSaveSize=0;/* Room required to save entire PVB in the popup mode  */
UCHAR DefaultAttribute[] = {0x07,0x0,0x0};/* default attribute used by WrtTTY  */
CLUTDATA far *LCLUT = 0 ;       /* @BB1 */

VIDEOHARDWARE VideoHardware = {0x0};  /* installed video hardware */    /*          */
ENVIRONMENT Env1 = {0}; /* Popup environment */                   /*                      */
ENVIRONMENT Env2 = {0}; /* Harderr environment */                 /*                      */

#if VDHINIT                                                           /*@ISO*/
DMQSDATA far *pDMQSdata = 0;                                          /*@ISO*/
USHORT machinetype;                                                   /*@RAD*/
#endif                                                                /*@ISO*/

#if FONT_SUPPORT

rcp_addr RomCP_tbl = {0x0};                                           /*          */
cp_addr  CodePage = {0x0};                                            /*          */
UCHAR CodePage_Support = 0;                                           /*          */
USHORT ROMCP_NUM = 0;                                 /*PTM 2895,                 */

/*            CODEPAGES CodePageTable[MAX_CODEPAGES]; */


#endif  /* FONT_SUPPORT */

#if VDH8514A                                                         /* MS00 */

USHORT (APIENTRY *ChainedCallVectorTable[MaxFn])() = {0};            /*            */

USHORT VGA_PRESENT = 0;  /* TRUE if VGA VDH has been installed */
VDHCONFIGINFO VGAConfigData = {0x0};

#endif  /* VDH8514A */                                                 /* MS00 */

#if !(VDH8514A)
extern USHORT *hScreenDD; /* Handle to screen device driver ( for DosDevIOCtl ) */ /*@T52*/
#endif

/*
** OEM Flags:
**      This word contains flags used to remember that an OEM video
**      adapter has been detected.  This may be used to control the
**      programming of features unique to a particular vendor's
**      implementation of one of the OS/2 supported video adapters.
*/

USHORT  OEMFlags        = 0x0000;
USHORT  SVGAPresent     = FALSE;                // @drw

/*
** Table of VDH entry points
**
** Device chaining is not implemented in these video device handlers.  If the
** VDH supports the VDH function, DevEnable will over-write the current
** entry in the call vector table.  If the VDH does not support the VDH
** function, the call vector table entry will not be touched.
*/

#if DEBUG                                                               /* MS07 */
static USHORT (EXPENTRY *DebugTrace)() = DEBUG_TRACE;                   /* MS07 */
#endif  /* DEBUG */                                                     /* MS07 */
static USHORT far * VDHEntryPoint[] = {                                 /* SM04398 */

#if VDH8514A

                             (USHORT far *)ChainRouter,         /* 256 */

#else

                             (USHORT far *)BufferUpdate,        /* 256 */

#endif  /* VDH8514A */                                                  /* MS00 */

                             (USHORT far *)InitEnv,             /* 257 */
                             (USHORT far *)SaveEnv,             /* 258 */
                             (USHORT far *)RestoreEnv,          /* 259 */
                             (USHORT far *)RetConfigInfo,       /* 260 */

#if VDH8514A                                                            //MS00

                             (USHORT far *)ChainRouter,         /* 261 */

#else

/* Get DBCS Display Info */  (USHORT far *)GetDBCSInfo,         /* 261             */

#endif  /* VDH8514A */                                                  /* MS00 */

#if VDHVGA || VDH8514A                                          /*               */

                             (USHORT far *)GetColorLookup,      /* 262 */
                             (USHORT far *)SetColorLookup,      /* 263 */

#else

                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 262 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 263 */

#endif  /* VDHVGA || VDH8514A                                             MS00 */

#if VDH8514A                                                            /* MS00 */

                             (USHORT far *)ChainRouter,         /* 264 */
                             (USHORT far *)ChainRouter,         /* 265 */

#else

                             (USHORT far *)GetCursorInfo,       /* 264 */
                             (USHORT far *)SetCursorInfo,       /* 265 */

#endif  /* VDH8514A                                                       MS00 */

#if ROMFONT_SUPPORT     /* VGA, EGA, CGA and INIT */              /*               */

                             (USHORT far *)GetCurrentFont,      /* 266 */
                             (USHORT far *)SetCurrentFont,      /* 267 */

#elif VDH8514A                                                          /* MS00 */

                             (USHORT far *)ChainRouter,         /* 266 */
                             (USHORT far *)ChainRouter,         /* 267 */

#else   /* MPA */

                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 266 */
                             (USHORT far *)SetCurrentFont      ,/* 267,          */

#endif  /* FONT_SUPPORT */

                             (USHORT far *)GetMode,             /* 268 */
                             (USHORT far *)SetMode,             /* 269 */

#if PALETTE_SUPPORT                                                     /* MS00 */

                             (USHORT far *)GetPaletteReg,       /* 270 */
                             (USHORT far *)SetPaletteReg,       /* 271 */

#elif VDH8514A                                                          /* MS00 */

                             (USHORT far *)ChainRouter,         /* 270 */
                             (USHORT far *)ChainRouter,         /* 271 */

#else

                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 270 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 271 */

#endif  /* PALETTE_SUPPORT                                              MS00 */

#if VDH8514A                                                            /*MS00 */

                             (USHORT far *)ChainRouter,         /* 272 */
                             (USHORT far *)ChainRouter,         /* 273 */

#else

                             (USHORT far *)GetPhysBuf,          /* 272 */
                             (USHORT far *)FreePhysBuf,         /* 273 */

#endif  /* VDH8514A                                                     MS00 */

                             (USHORT far *)GetVariableInfo,     /* 274 */
                             (USHORT far *)SetVariableInfo,     /* 275 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 276             */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 277             */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 278             */


#if VDH8514A                                                    /*                 */

                             (USHORT far *)ChainRouter,         /* 279             */
                             (USHORT far *)ChainRouter,         /*                */
                             (USHORT far *)ChainRouter,         /*                */
#else                                                           /*                 */

/* Get LVB size info     */  (USHORT far *)GetLVBInfo,          /* 279             */

                             (USHORT far *)GetState,            /*                */
                             (USHORT far *)SetState             /*                */

#endif  /* VDH8514A                                                                */
};                                                              /*                */

/*
** Video mode table -
**    typedef struct {
**              USHORT cb;              ; VioGetMode structure
**              UCHAR  fbType;
**              UCHAR  color;
**              USHORT col;
**              USHORT row;
**              USHORT hres;
**              USHORT vres;
**              UCHAR  fmt_ID;
**              UCHAR  attrib;
**              UCHAR  MemMap;          ; Index in memory map table
**              UCHAR  ROMFontIndex;    ; Index in ROM font table
**              UCHAR  CompRegs[5];     ; Unique mode-identifying registers
**              REGCMD ModeRegs[8];     ; Register command table
**              } VIDEOMODE;
**
** The mode table is arranged in a highest resolution to lowest resolution
** order so that a "best" default mode can be selected if only partial
** mode data is given via VioSetMode.
**
**            - 01/90, Mode table modified per suggestions from engineering to
** fix problem described by PTR B710847.  Misc output reg is set twice, once
** before setting the crt ctrlr regs and once after setting them.  If the
** mode uses the 28 MHz clock, the misc output reg is first set to the 25 MHz
** clock and then set to the 28 MHz clock.  (selected by bits 2 and 3 of the
** misc output reg)
*/

VIDEOMODE Modes[] = {

#if VDHVGA                                                              /*MS00 */

/*
**  Mode index 0
*/
{ 12, NOT_MONO, 4, 80, 25, 720, 400, 0, 1,            /*            VioSetMode Structure */
  MemMap_Text80, ROMFont9x16, NOT_PLASMA,
 { 0x67, 0x0C, 0x0F, 0x00 },
 {  /* [0][0-6] vga3p */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x00\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\xBF\x1F\x0\x4F\xD\xE\x0\x0\x0\x0\x9C\xAE\x8F\x28\x1F\x96\xB9\xA3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x67", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x8", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 2+, 3+ */

/*
**  Mode index 1
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 400, 0, 1,            /*  VioSetMode Structure */
  MemMap_Text80, ROMFont8x16, 0,
 { 0x63, 0x0C, 0x0F, 0x01 },
 {  /* [1][0-6] vgp3p */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x1\x1\x3\x0\x2", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\xBF\x1F\x0\x4F\xD\xE\x0\x0\x0\x0\x9C\xAE\x8F\x28\x1F\x96\xB9\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 2#, 3# */

/*
**  Mode index 2
*/
{ 12, 0, 0, 80, 25, 720, 400, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont9x16, IGNORE_CLR_BRST+NOT_PLASMA,
 { 0x66, 0x0E, 0x0F, 0x00 },
 {  /* [2][0-6] vgm7p */
  { RegOutput_CMD,  { "\x62", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x00\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x4F\x0D\x0E\x0\x0\x0\x0\x9C\xAE\x8F\x28\x0F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x66", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x08", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7+ */

/*
**  Mode index 3
**             - BEGIN
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 400, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x16, 0,
 { 0x62, 0x0E, 0x0F, 0x01 },
 {  /* [3][0-6] vgp7p */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x4F\x0D\x0E\x0\x0\x0\x0\x9C\xAE\x8F\x28\x0F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },   /*          */
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7# */                                   /*            - END */

/*
**  Mode index 4
*/
{ 12, 0, 0, 80, 25, 640, 400, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont8x16, IGNORE_CLR_BRST,
 { 0x62, 0x0E, 0x0F, 0x01 },
 {  /* [3][0-6] vgp7p */
  { RegOutput_CMD,  { "\x62", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x4F\x0D\x0E\x0\x0\x0\x0\x9C\xAE\x8F\x28\x0F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7# */

/*
**  Mode index 5
*/
{ 12, NOT_MONO, 4, 40, 25, 360, 400, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont9x16, NOT_PLASMA,
 { 0x67, 0x0C, 0x0F, 0x08 },
 {  /* [4][0-5] vga1p */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x08\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0BF\x1F\x00\x4F\x0D\x0E\x0\x0\x0\x0\x09C\xAE\x8F\x14\x1F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x67", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x8", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0+, 1+ */

/*
**  Mode index 6 - OEM 480 scan line 40 column mode
*/
{ 12, NOT_MONO, 4, 40, 30, 360, 480, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont9x16, NOT_PLASMA,
 { 0xE7, 0x0C, 0x0F, 0x08 },
 {  /* [4][0-5] vga1p */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x08\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0B\x3E\x00\x4F\x0D\x0E\x0\x0\x0\x0\x0EA\xAC\xDF\x14\x1F\xE7\x04\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xE7", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0+, 1+ */                                     /*MS?? - END */

/*
**  Mode index 7
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 400, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x16, 0,
 { 0x63, 0x0C, 0x0F, 0x09 },
 {  /* [5][0-5] vgp1p */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0BF\x1F\x00\x4F\x0D\x0E\x0\x0\x0\x0\x09C\xAE\x8F\x14\x1F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0#, 1# */

/*
**  Mode index 8 - OEM 480 scan line 40 column mode
*/
{ 12, NOT_MONO, 4, 40, 30, 320, 480, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x16, 0,
 { 0xE3, 0x0C, 0x0F, 0x09 },
 {  /* [5][0-5] vgp1sx */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0B\x3E\x00\x4F\x0D\x0E\x0\x0\x0\x0\x0EA\xAC\xDF\x14\x1F\xE7\x04\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0#, 1# */                                     /*MS?? - END */

/*
**  Mode index 9
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x14, 0,
 { 0xA3, 0x08, 0x0F, 0x01 },
 {  /* [6][0-6] vga3s */
  { RegOutput_CMD,  { "\xA3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\xBF\x1F\x0\x4D\xB\xC\x0\x0\x0\x0\x83\xA5\x5D\x28\x1F\x63\x0BA\x0A3\x0FF", 0x00, 0x18+1 } }, /*          */
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 2*, 3* */

/*
**  Mode index 10
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x14, 0,
 { 0xA3, 0x08, 0x0F, 0x09 },
 {  /* [7][0-5] vga1s */
  { RegOutput_CMD,  { "\xA3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0BF\x1F\x00\x4D\x0B\x0C\x0\x0\x0\x0\x83\xA5\x5D\x14\x1F\x63\x0BA\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0*, 1* */

/*
**  Mode index 11
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 200, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x8, 0,
 { 0x63, 0x08, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x0C7\x06\x07\x0\x0\x0\x0\x9C\xAE\x8F\x28\x1F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 2, 3 */

/*
**  Mode index 12
*/
{ 12, 0, 0, 80, 25, 720, 350, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont9x14, IGNORE_CLR_BRST+NOT_PLASMA,
 { 0xA6, 0x0E, 0x0F, 0x00 },
 {  /* [9][0-5] vgm7 */
  { RegOutput_CMD,  { "\xA2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x00\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x4D\x0B\x0C\x0\x0\x0\x0\x83\xA5\x5D\x28\x0D\x63\x0BA\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xA6", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x08", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7 */

/*
**  Mode index 13
*/
{ 12, 0, 0, 80, 25, 640, 350, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont8x14, IGNORE_CLR_BRST,
 { 0xA2, 0x0E, 0x0F, 0x01 },
 {  /* [10][0-5] vgp7 */
  { RegOutput_CMD,  { "\xA2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0BF\x1F\x00\x4D\x0B\x0C\x0\x0\x0\x0\x83\xA5\x5D\x28\x0D\x63\x0BA\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7p */

/*
**  Mode index 14
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 200, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x8, 0,
 { 0x63, 0x08, 0x0F, 0x09 },
 {  /* [11][0-5] vga1 */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x0A0\x0BF\x1F\x00\x0C7\x06\x07\x0\x0\x0\x0\x9C\xAE\x8F\x14\x1F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
/* this is BIOS compatible but is not presently being used with a
   BIOS compatible CLUT */
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 0, 1 */

/*
**  Mode index 15
*/
{ 12, NOT_MONO+GRAPHICS, 2, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_LoRes, ROMFont8x8, 0,
 { 0x63, 0x01, 0x03, 0x09 },
 {  /* [12][0-6] vga4 */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x80\xBF\x1F\x0\xC1\x0\x0\x0\x0\x0\x0\x9C\xAE\x8F\x14\x0\x96\xB9\xA2\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x13\x15\x17\x2\x4\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x01\x0\x03\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x30\x0F\x00\x0FF ", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 4, 5 */

/*
**  Mode index 16
*/
{ 12, NOT_MONO+GRAPHICS, 1, 80, 25, 640, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_LoRes, ROMFont8x8, IGNORE_CLR_BRST,
 { 0x63, 0x01, 0x01, 0x01 },
 {  /* [13][0-6] vga6 */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x01\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xBF\x1F\x0\xC1\x0\x0\x0\x0\x0\x0\x9C\xAE\x8F\x28\x0\x96\xB9\xC2\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x01\x0\x01\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x0D\x0\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 6 */

/*
**  Mode index 17
*/
{ 12, NOT_MONO+GRAPHICS, 4, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_ModeD, ROMFont8x8, IGNORE_CLR_BRST,
 { 0x63, 0x01, 0x0F, 0x09 },
 {  /* [14][0-6] vgaD */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x09\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x28\x90\x2B\x80\xBF\x1F\x0\xC0\x0\x0\x0\x0\x0\x0\x9C\xAE\x8F\x14\x0\x96\xB9\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x01\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode D */

/*
**  Mode index 18
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 25, 640, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_ModeE, ROMFont8x8, IGNORE_CLR_BRST,
 { 0x63, 0x01, 0x0F, 0x01 },
 {  /* [15][0-5] vgaE */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xBF\x1F\x0\xC0\x0\x0\x0\x0\x0\x0\x9C\xAE\x8F\x28\x0\x96\xB9\xE3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x01\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode E */

/*
**  Mode index 19
*/
{ 12, GRAPHICS, 0, 80, 25, 640, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_ModeF, ROMFont8x14, IGNORE_CLR_BRST,
 { 0xA2, 0x0B, 0x05, 0x01 },
 {  /* [16][0-6] vgaF */
  { RegOutput_CMD,  { "\xA2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xBF\x1F\x0\x40\x0\x0\x0\x0\x0\x0\x83\xA5\x5D\x28\xF\x63\xBA\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x0\x0\x18\x18\x0\x0\x0\x8\x0\x0\x0\x18\x0\x0\xB\x0\x5\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x5\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode F */

/*
**  Mode index 20
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 25, 640, 350, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode10, ROMFont8x14, IGNORE_CLR_BRST,
 { 0xA3, 0x01, 0x0F, 0x01 },
 {  /* [17][0-6] vga10 */
  { RegOutput_CMD,  { "\xA3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xBF\x1F\x0\x40\x0\x0\x0\x0\x0\x0\x83\xA5\x5D\x28\xF\x63\xBA\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 10+ */

/*
**  Mode index 21
*/
{ 12, NOT_MONO+GRAPHICS, 1, 80, 30, 640, 480, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode11, ROMFont8x16, IGNORE_CLR_BRST,
 { 0xE3, 0x01, 0x01, 0x01 },
 {  /* [18][0-6] vga11 */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0C", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\xAC\xDF\x28\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x01\x0\x01\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x01\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 11 */

/*
**  Mode index 22
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 30, 640, 480, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode12, ROMFont8x16, IGNORE_CLR_BRST,
 { 0xE3, 0x01, 0x0F, 0x01 },
 {  /* [19][0-5] vga12 */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\xAC\xDF\x28\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 12 */

/*
**  Mode index 23
*/
{ 12, NOT_MONO+GRAPHICS, 8, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode13, ROMFont8x8, IGNORE_CLR_BRST,
 { 0x63, 0x41, 0x0F, 0x01 },
 {  /* [20][0-6] vga13 */
  { RegOutput_CMD,  { "\x63", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x0E", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xBF\x1F\x0\x41\x0\x0\x0\x0\x0\x0\x9C\xAE\x8F\x28\x40\x96\xB9\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x8\x9\x0A\x0B\x0C\x0D\x0E\x0F\x41\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x40\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 13 */

/*
**  Mode index 24
*/
{ 12, NOT_MONO, 4, 80, 30, 720, 480, 0, 1,            /* VioSetMode Structure */
  MemMap_Text480, ROMFont9x16, NOT_PLASMA,
 { 0xE7, 0x0C, 0x0F, 0x00 },
 {  /* [0][0-6] vga3px */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x00\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0C", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0B\x3E\x0\x4F\xD\xE\x0\x0\x0\x0\xEA\xAC\xDF\x28\x1F\xE7\x04\xA3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xE7", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x8", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-BIOS Mode = 480-pel text (3++) */        /*STJ*/

/*
**  Mode index 25 - OEM 480 scan line mono text mode
*/
{ 12, 0, 0, 80, 30, 720, 480, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont9x16, IGNORE_CLR_BRST+NOT_PLASMA,
 { 0xE6, 0x0E, 0x0F, 0x00 },
 {  /* [2][0-6] vgm7px */
  { RegOutput_CMD,  { "\xE2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x00\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0B\x3E\x00\x4F\x0D\x0E\x0\x0\x0\x0\xEA\xAC\xDF\x28\x0F\xE7\x04\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xE6", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x08", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-Bios Mode = 480-pel mono text (7++) */          /*MS?? - END */

/*
**  Mode index 26
*/
{ 12, NOT_MONO, 4, 80, 30, 640, 480, 0, 1,            /* VioSetMode Structure */
  MemMap_Text480, ROMFont9x16, 0,
 { 0xE3, 0x0C, 0x0F, 0x01 },
 {  /* [0][0-6] vga3sx */
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0C", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0B\x3E\x0\x4F\xD\xE\x0\x0\x0\x0\xEA\xAC\xDF\x28\x1F\xE7\x04\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-BIOS Mode = 480-pel text (3##) */        /*STJ*/

/*
**  Mode index 27 - 480 scan line mono text mode
*/
{ 12, 0, 0, 80, 30, 640, 480, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont8x16, IGNORE_CLR_BRST,
 { 0xE2, 0x0E, 0x0F, 0x01 },
 {  /* [3][0-6] vgp7sx */
  { RegOutput_CMD,  { "\xE2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x55\x81\x0B\x3E\x00\x4F\x0D\x0E\x0\x0\x0\x0\xEA\xAC\xDF\x28\x0F\xE7\x04\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-Bios Mode = 480-pel mono text (7##) */          /*MS?? - END */

/*
**            specific code - BEGIN (IBM VGA-E 132 column text modes:)
*/

/*
**  Mode index 28
*/
{ 12, NOT_MONO, 4, 132, 25, 1056, 400, 0, 1,          /* VioSetMode Structure */ /*          */
  MemMap_Text80, ROMFont8x16, 0,
 { 0x73, 0x0C, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\x73", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x04F\x0D\x0E\x0\x0\x0\x0\x9C\xAE\x8F\x42\x1F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14#   */

/*
**  Mode index 29
*/
{ 12, 0, 0, 132, 25, 1056, 400, 0, 1,                 /* VioSetMode Structure */ /*          */
  MemMap_Mono, ROMFont8x16, IGNORE_CLR_BRST,
 { 0x72, 0x0E, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\x72", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x04F\x0D\x0E\x0\x0\x0\x0\x9C\xAE\x8F\x42\x0F\x96\x0B9\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14#M  */

/*
**  Mode index 30
*/
{ 12, NOT_MONO, 4, 132, 25, 1056, 350, 0, 1,          /* VioSetMode Structure */ /*          */
  MemMap_Text80, ROMFont8x14, 0,
 { 0xB3, 0x08, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\xB3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x04D\x0B\x0C\x0\x0\x0\x0\x83\xA5\x5D\x42\x1F\x93\x0BC\x0A3\x0FF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14+   */

/*
**  Mode index 31
*/
{ 12, 0, 0, 132, 25, 1056, 350, 0, 1,                 /* VioSetMode Structure */ /*          */
  MemMap_Mono, ROMFont8x14, IGNORE_CLR_BRST,
 { 0xB2, 0x0E, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\xB2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x04D\x0B\x0C\x0\x0\x0\x0\x83\xA5\x5D\x42\x0F\x93\x0BC\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xB2", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14+M  */

/*
**  Mode index 32
*/
{ 12, NOT_MONO, 4, 132, 25, 1056, 200, 0, 1,          /* VioSetMode Structure */ /*          */
  MemMap_Text80, ROMFont8x8, 0,
 { 0x73, 0x08, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\x73", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x0C7\x06\x07\x0\x0\x0\x0\x9C\xAE\x8F\x42\x1F\x93\x0BC\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x73", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x08\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14    */

/*
**  Mode index 33
*/
{ 12, 0, 0, 132, 25, 1056, 200, 0, 1,                 /* VioSetMode Structure */ /*          */
  MemMap_Mono, ROMFont8x8, IGNORE_CLR_BRST,
 { 0x72, 0x08, 0x0F, 0x01 },
 {  /* [8][0-6] vga3 */
  { RegOutput_CMD,  { "\x72", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0BF\x1F\x00\x0C7\x06\x07\x0\x0\x0\x0\x9C\xAE\x8F\x42\x0F\x93\x0BC\x0A3\x0FF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\x72", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 14M   */

/*
**  Mode index 34
*/
{ 12, NOT_MONO, 4, 132, 30, 1056, 480, 0, 1,          /* VioSetMode Structure */ /*          */
  MemMap_Text480, ROMFont8x16, 0,
 { 0xF3, 0x0C, 0x0F, 0x01 },
 {  /* [0][0-6] vga3p */
  { RegOutput_CMD,  { "\xF3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0C", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0B\x3E\x0\x4F\x0D\x0E\x0\x0\x0\x0\xEA\xAC\xDF\x42\x1F\xE7\x04\xA3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xF3", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-BIOS Mode = 132 col 480-pel text */

/*
**  Mode index 35
*/
{ 12, 0, 0, 132, 30, 1056, 480, 0, 1,                 /* VioSetMode Structure */ /*          */
  MemMap_Mono, ROMFont8x16, IGNORE_CLR_BRST,
 { 0xF2, 0x0E, 0x0F, 0x01 },
 {  /* [0][0-6] vga3p */
  { RegOutput_CMD,  { "\xF2", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x03\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0C", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8A\x9E\x0B\x3E\x0\x4F\x0D\x0E\x0\x0\x0\x0\xEA\xAC\xDF\x42\x1F\xE7\x04\xA3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xF2", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Non-BIOS Mode = 132 col 480-pel text */

/*
**{ 0x63, 0x08, 0x0F, 0x01 }, (Unique mode id registers)
**  |     |     |     |
**  |     |     |     +-2nd from beginning in Sequencers_CMD
**  |     |     |
**  |     |     +-2nd from end in Attributes_CMD
**  |     |
**  |     +-4th from end in Attributes_CMD
**  |
**  +-1st in RegOutput_CMD
*/

/*
**            specific code - END
*/

/* Mode index 36 - BEGIN (OEM 132 column text modes:) */       /*MS?? - BEGIN */
{ 12, NOT_MONO, 4, 132, 25, 1056, 400, 0, 1,
  MemMap_Text80, ROMFont8x16, NOT_PLASMA,
  { 0x6B, 0x0C, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\x6B", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\xBF\x1F\x0\x4F\xD\xE\x0\x0\x0\x0\x9C\xAE\x8F\x42\x1F\x96\xB9\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 23h,24h,27h */

/* Mode index 37 */
{ 12, 0, 0, 132, 25, 1056, 400, 0, 1,
  MemMap_Mono, ROMFont8x16, IGNORE_CLR_BRST+NOT_PLASMA,
  { 0x6A, 0x0E, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\x6A", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\xBF\x1F\x0\x4F\xD\xE\x0\x0\x0\x0\x9C\xAE\x8F\x42\x1F\x96\xB9\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 19h,1Ah,1Bh */

/* Mode index 38 */
{ 12, NOT_MONO, 4, 132, 43, 1056, 350, 0, 1,
  MemMap_Text80, ROMFont8x8, NOT_PLASMA,
  { 0xAB, 0x0C, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xAB", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\xBF\x1F\x0\x47\x6\x7\x0\x0\x0\x0\x83\xA5\x57\x42\x1F\x63\xBA\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 22h */

/* Mode index 39 */
{ 12, NOT_MONO, 4, 132, 60, 1056, 480, 0, 1,
  MemMap_Text80, ROMFont8x8, NOT_PLASMA,
  { 0xEB, 0x0C, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xEB", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\x8\x3E\x0\x47\x6\x7\x0\x0\x0\x0\xEA\xAC\xDF\x42\x1F\xE7\x4\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\xC\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0E\x00\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 28h */

/* Mode index 40 */
{ 12, 0, 0, 132, 43, 1056, 350, 0, 1,
  MemMap_Mono, ROMFont8x8, IGNORE_CLR_BRST+NOT_PLASMA,
  { 0xAA, 0x0E, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xAA", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\xBF\x1F\x0\x47\x6\x7\x0\x0\x0\x0\x83\xA5\x57\x42\x1F\x63\xBA\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 18h */

/* Mode index 41 */
{ 12, 0, 0, 132, 60, 1056, 480, 0, 1,
  MemMap_Mono, ROMFont8x8, IGNORE_CLR_BRST+NOT_PLASMA,
  { 0xEA, 0x0E, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xEA", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x03\x00\x02", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x0E", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xA0\x83\x84\x83\x8D\x9B\x8\x3E\x0\x47\x6\x7\x0\x0\x0\x0\xEA\xAC\xDF\x42\x1F\xE7\x4\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\x0E\x0\x0F\x00", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x0A\x00\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 1Ch */                                         /*MS?? - END */


/* Mode index 42 */
{ 12, NOT_MONO+GRAPHICS, 8, 80, 30, 640, 480, 0, 1,
  MemMap_Mode2E, ROMFont8x16, IGNORE_CLR_BRST+NOT_PLASMA,
  { 0xE3, 0x41, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\xFF\x00\x0E", 0x00, 0x05 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\xC3\x9F\xA1\x85\xA6\x1F\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xDF\x80\x40\xE7\x4\xE3\xFF", 0x00, 0x19 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x8\x9\xA\xB\xC\xD\xE\xF\x41\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\xFF", 0x00, 0x09 } },
  { Graphics_CMD,   { "\x1\x0\x0\x7\x0\x0\x8", 0x40, 0x07 } },
  { Terminate_CMD }
 } },   /* Mode 2E */

/*
** 664 pixel wide mode (for 132 columns in a APA VGA mode)
*/

/*
**  Mode index 43
**  @DAK 12-Sep-91
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 30, 664, 480, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode12, ROMFont8x16, IGNORE_CLR_BRST+NOT_PLASMA,
 { 0xE3, 0x01, 0x0F, 0x01 },
 {
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5F\x52\x53\x82\x55\x81\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xDF\x2A\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
  { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
  { Terminate_CMD }
 } }   /* Mode 12 */

#endif  /* VDHVGA                                                         MS00 */

#if VDHEGA                                                              /*MS00 */

/*
** Greater than 64K of memory on display adapter
*/

/*
**  Mode index 0
*/
{ 12, NOT_MONO+GRAPHICS, 2, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_LoRes, ROMFont8x8, EGA_GT_64K,
 {  /* [0][0-7] ega4 */
  { Sequencers_CMD, { "\x1\xB\x3\x0\x2", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x37\x27\x2D\x37\x30\x14\x4\x11\x0\x1\x0\x0\x0\x0\x0\x0\xE1\x24\xC7\x14\x0\xE0\xF0\xA2\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x13\x15\x17\x2\x4\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x1\x0\x3\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x30\xF\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 4, 5 */

/*
**  Mode index 1
*/
{ 12, GRAPHICS, 0, 80, 25, 640, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_ModeF, ROMFont8x14, IGNORE_CLR_BRST+EGA_GT_64K,                /*          */
 {  /* [1][0-7] egaF */
  { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA2", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x60\x4F\x56\x3A\x50\x60\x70\x1F\x0\x0\x0\x0\x0\x0\x0\x0\x5E\x2E\x5D\x28\xD\x5E\x6E\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x0\x0\x18\x18\x0\x0\x0\x8\x0\x0\x0\x18\x0\x0\xB\x0\x5\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x5\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode F */

/*
** Less than or equal to 64K of memory on display adapter
*/

/*
**  Mode index 2
*/
{ 12, NOT_MONO+GRAPHICS, 2, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_LoRes, ROMFont8x8, 0,
 {  /* [3][0-0] ega4b */
  { Sequencers_CMD, { "\x1\xB\x3\x0\x2", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x37\x27\x2D\x37\x30\x14\x4\x11\x0\x1\x0\x0\x0\x0\x0\x0\xE1\x24\xC7\x14\x0\xE0\xF0\xA2\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x13\x15\x17\x2\x4\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x1\x0\x3\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x30\xF\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 4, 5 */

/*
**  Mode index 3
*/
{ 12, GRAPHICS, 0, 80, 25, 640, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_ModeF, ROMFont8x14, IGNORE_CLR_BRST, /*          */
 {  /* [4][0-7] egaFm */
  { Sequencers_CMD, { "\x1\x5\xF\x0\x0", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA2", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x60\x4F\x56\x1A\x50\xE0\x70\x1F\x0\x0\x0\x0\x0\x0\x0\x0\x5E\x2E\x5D\x14\xD\x5E\x6E\x8B\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x0\x0\x18\x18\x0\x0\x0\x8\x0\x0\x0\x18\x0\x0\xB\x0\x5\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x7\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode Fm */

/*
**  Mode index 4
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x14, ENHANCED_MONITOR,
 {  /* [6][0-7] ega3 */
  { Sequencers_CMD, { "\x01\x01\x03\x00\x03", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA7", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5B\x4F\x53\x37\x51\x5B\x6C\x1F\x0\xD\xB\xD\x0\x0\x0\x0\x5E\x2B\x5D\x28\x1F\x5E\xA\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x8\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\xE\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 3 */

/*
**  Mode index 5
*/
{ 12, 0, 0, 80, 25, 720, 350, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, ROMFont9x14, IGNORE_CLR_BRST, /*          */
 {  /* [7][0-7] egm7 */
  { Sequencers_CMD, { "\x1\x0\x3\x0\x3", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA6", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x60\x4F\x56\x3A\x51\x60\x70\x1F\x0\xD\xB\xD\x0\x0\x0\x0\x5E\x2E\x5D\x28\x1F\x5E\x6E\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x8\x8\x8\x8\x8\x8\x8\x10\x18\x18\x18\x18\x18\x18\x18\xE\x0\xF\x8", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\xA\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 7 */

/*
**  Mode index 6
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x14, ENHANCED_MONITOR,
 {  /* [8][0-3] ega1 */
  { Sequencers_CMD, { "\x1\xB\x3\x0\x3", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA7", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x2D\x27\x2B\x2D\x28\x6D\x6C\x1F\x0\xD\xB\xD\x0\x0\x0\x0\x5E\x2B\x5D\x14\x1F\x5E\xA\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x8\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\xE\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 1 */

/*
**  Mode index 7
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 200, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x8, 0,
 {  /* [9][0-7] egc3 */
  { Sequencers_CMD, { "\x1\x1\x3\x0\x3", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x70\x4F\x5C\x2F\x5F\x7\x4\x11\x0\x7\x6\x0\x0\x0\x0\x0\xE1\x24\xC7\x28\x1F\xE0\xF0\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x8\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\xE\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 3c*/

/*
**  Mode index 8
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 200, 0, 1,            /* VioSetMode Structure */
  MemMap_Text40, ROMFont8x8, 0,
 {  /* [10][0-3] egc1 */
  { Sequencers_CMD, { "\x1\xB\x3\x0\x3", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x37\x27\x2D\x37\x31\x15\x4\x11\x0\x7\x6\x0\x0\x0\x0\x0\xE1\x24\xC7\x14\x1F\xE0\xF0\xA3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x8\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\xE\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Modes 1c */

/*
**  Mode index 9
*/
{ 12, NOT_MONO+GRAPHICS, 1, 80, 25, 640, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_LoRes, ROMFont8x8, IGNORE_CLR_BRST,
 {  /* [10][0-7] ega6 */
  { Sequencers_CMD, { "\x01\x01\x01\x00\x06", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x70\x4F\x59\x2D\x5E\x6\x4\x11\x0\x1\x0\x0\x0\x0\x0\x0\xE0\x23\xC7\x28\x0\xDF\xEF\xC2\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1\x0\x1\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\xD\x0\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 6 */

/*
**  Mode index 10
**            
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 25, 640, 350, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode10, ROMFont8x14, IGNORE_CLR_BRST+ENHANCED_MONITOR+EGA_GT_64K, /*          */
 {  /* [2][0-7] ega10 */
  { Sequencers_CMD, { "\x1\x1\xF\x0\x6", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA7", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5B\x4F\x53\x37\x52\x0\x6C\x1F\x0\x0\x0\x0\x0\x0\x0\x0\x5E\x2B\x5D\x28\xF\x5F\xA\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x1\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x5\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 10 */

/*
**  Mode index 11
**            
*/
{ 12, NOT_MONO+GRAPHICS, 4, 80, 25, 640, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_ModeE, ROMFont8x8, IGNORE_CLR_BRST,
 {  /* [13][0-5] egaE */
  { Sequencers_CMD, { "\x1\x1\xF\x0\x6", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x70\x4F\x56\x2D\x5E\x6\x4\x11\x0\x0\x0\x0\x0\x0\x0\x0\xE0\x23\xC7\x28\x0\xDF\xEF\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x1\x0\xF\x0", 0x00, 0x14 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x5\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode E */

/*
**  Mode index 12
**            
*/
{ 12, NOT_MONO+GRAPHICS, 4, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */
  MemMap_ModeD, ROMFont8x8, IGNORE_CLR_BRST,
 {  /* [12][0-7] egaD */
  { Sequencers_CMD, { "\x1\xB\xF\x0\x6", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\x23", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x37\x27\x2D\x37\x30\x14\x4\x11\x0\x0\x0\x0\x0\x0\x0\x0\xE1\x24\xC7\x14\x0\xE0\xF0\xE3\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x6\x7\x10\x11\x12\x13\x14\x15\x16\x17\x1\x0\xF\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x5\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode D */

/*
**  Mode index 13
*/
{ 12, NOT_MONO+GRAPHICS, 2, 80, 25, 640, 350, 0, 1,   /* VioSetMode Structure */
  MemMap_Mode10, ROMFont8x14, IGNORE_CLR_BRST+ENHANCED_MONITOR, /*          */
 {  /* [5][0-7] ega10s */
  { Sequencers_CMD, { "\x1\x5\xF\x0\x0", 0x00, 0x04+1 } },
  { RegOutput_CMD,  { "\xA7", MiscOutputRegWrite, 0x01 } },
  { CRTCtlRegs_CMD, { "\x5B\x4F\x53\x17\x50\xBA\x6C\x1F\x0\x0\x0\x0\x0\x0\x0\x0\x5E\x2B\x5D\x14\xF\x5F\xA\x8B\xFF", 0x00, 0x18+1 } },
  { Attributes_CMD, { "\x0\x1\x0\x0\x4\x7\x0\x0\x0\x1\x0\x0\x4\x7\x0\x0\x1\x0\x5\x0", 0x00, 0x14 } },
  { RegOutput_CMD,  { "\x00", Graphics1PosReg, 0x01 } },
  { RegOutput_CMD,  { "\x01", Graphics2PosReg, 0x01 } },
  { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x10\x7\xF\xFF", 0x00, 0x09 } },
  { Terminate_CMD }
 } },   /* Mode 10* */

#endif  /* VDHEGA */
#if VDHCGA                                                              /*MS00 */

/*
**  Mode index 0
**  for high resolution VDUs & DSMs
*/
{ 12, NOT_MONO, 4, 80, 25, 720, 350, 0, 1,            /* VioSetMode Structure */
  MemMap_Text80, ROMFont8x8, VDU_DSM_ONLY,
 {  /* [0][0-3] cga3s */
  { CRTCtlRegs_CMD, { "\x71\x50\x5A\xA\x19\x6\x19\x19\x2\xD\xB\xC\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x29", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 3* */

/*
**  Mode index 1
*/
{ 12, NOT_MONO, 4, 80, 25, 640, 200, 0, 1,            /* VioSetMode Structure */

  MemMap_Text80, ROMFont8x8, 0,

 {  /* [0][0-3] cga3 */
  { CRTCtlRegs_CMD, { "\x71\x50\x5A\xA\x1F\x6\x19\x1C\x2\x7\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x29", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 3 */

/*
**  Mode index 2
*/
{ 12, NOT_MONO+NO_CLR_BRST, 4, 80, 25, 640, 200, 0, 1,/* VioSetMode Structure */


  MemMap_Text80, ROMFont8x8, 0,

 {  /* [1][0-3] cga2 */
  { CRTCtlRegs_CMD, { "\x71\x50\x5A\xA\x1F\x6\x19\x1C\x2\x7\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x2D", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 2 */

/*
**  Mode index 3
*/
{ 12, NOT_MONO, 4, 40, 25, 320, 200, 0, 1,            /* VioSetMode Structure */


  MemMap_Text40, ROMFont8x8, 0,

 {  /* [2][0-3] cga1 */
  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x1F\x6\x19\x1C\x2\x7\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x28", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 1 */

/*
**  Mode index 4
*/
{ 12, NOT_MONO+NO_CLR_BRST, 4, 40, 25, 320, 200, 0, 1,/* VioSetMode Structure */


  MemMap_Text40, ROMFont8x8, 0,

 {  /* [3][0-3] cga0 */
  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x1F\x6\x19\x1C\x2\x7\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x2C", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 0 */

/*
**  Mode index 5
*/
{ 12, NOT_MONO+GRAPHICS, 2, 40, 25, 320, 200, 0, 1,   /* VioSetMode Structure */

  MemMap_LoRes, ROMFont8x8, 0,

 {  /* [4][0-3] cga5 */
  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x7F\x6\x64\x70\x2\x1\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x2A", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 5 */

/*
**  Mode index 6
*/
{ 12, NOT_MONO+GRAPHICS+NO_CLR_BRST, 2, 40, 25, 320, 200, 0, 1, /* VioSetMode Structure */


  MemMap_LoRes, ROMFont8x8, 0,

 {  /* [5][0-3] cga4 */
  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x7F\x6\x64\x70\x2\x1\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x2E", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x30", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 4 */

/*
**  Mode index 7
*/
{ 12, NOT_MONO+GRAPHICS, 1, 80, 25, 640, 200, 0, 1,   /* VioSetMode Structure */

  MemMap_LoRes, ROMFont8x8, IGNORE_CLR_BRST,

 {  /* [6][0-3] cga6 */
  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x7F\x6\x64\x70\x2\x1\x6\x7\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x1E", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x3F", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 6 */


/* Add BIOS mode 40 640x400 monochrome graphics here */

/*
**  Mode index 15
*/

{ 12, NOT_MONO+GRAPHICS, 1, 80, 25, 640, 400, 0, 1,   /* VioSetMode Structure */

  MemMap_Mode40, ROMFont8x8, IGNORE_CLR_BRST+IDC_PLASMA_ONLY,

 {  /* [7][0-3] dmp40 */

  { CRTCtlRegs_CMD, { "\x38\x28\x2D\xA\x7F\x6\x64\x70\x2\x1\x6\x7\x0\x0\x0\x0", 0x00, 16 } },

  { RegOutput_CMD,  { "\x1E", CGAModeCtlReg,  0x01 } },
  { RegOutput_CMD,  { "\x3F", CGAColorSelReg, 0x01 } },
  { Terminate_CMD }
 } },   /* Mode 40 */

#endif  /* VDHCGA */
#if VDHMPA                                                              /*MS00 */

/*
**  Mode index 0
*/
{ 12, 0, 0, 80, 25, 720, 350, 0, 1,                   /* VioSetMode Structure */
  MemMap_Mono, 0, IGNORE_CLR_BRST, /*          */
 {  /* [0][0-3] mpa7 */
  { RegOutput_CMD,  { "\x01", CRTCtlPort1, 0x01 } },
  { CRTCtlRegs_CMD, { "\x61\x50\x52\xF\x19\x6\x19\x19\x2\xD\xB\xC\x0\x0\x0\x0", 0x00, 16 } },
  { RegOutput_CMD,  { "\x29", CRTCtlPort1, 0x01 } },
  { Terminate_CMD }
 } }    /* Mode 7 */

#endif  /* VDHMPA                                                         MS00 */
#if VDH8514A                                                            /*MS00 */

/*
**  Mode index 0
*/
{ 12, NATIVE+GRAPHICS+NOT_MONO, 8, 85, 38, 1024, 768, 0, 1, /* VioSetMode Structure */
  0, 0, IGNORE_CLR_BRST, /*          */
 {  /* [0][0] bga1 */
  { RegOutput_CMD,  { "\x53"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x07"    , 0x4AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x60\x06", 0x12E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x00\x06", 0x1AE8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\xFB\x05", 0x16E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x9D"    , 0x02E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x81"    , 0x0AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x7F"    , 0x06E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x16"    , 0x0EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x08"    , 0x1EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x33"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\xFF"    , 0x02EA, 0x01 } },     /*          */
  { Terminate_CMD }
 } },

/*
**  Mode index 1
*/
{ 12, NATIVE+GRAPHICS+NOT_MONO, 8, 80, 34, 640, 480, 0, 1, /* VioSetMode Structure */
  0, 0, IGNORE_CLR_BRST, /*          */
 {  /* [1][0] bga2 */
  { RegOutput_CMD,  { "\x43"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x03"    , 0x4AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x18\x04", 0x12E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\xD2\x03", 0x1AE8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\xBB\x03", 0x16E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x63"    , 0x02E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x52"    , 0x0AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x4F"    , 0x06E8, 0x01 } },     /*              */
  { RegOutput_CMD,  { "\x2C"    , 0x0EE8, 0x01 } },     /*              */
  { RegOutput_CMD,  { "\x22"    , 0x1EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x23"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\xFF"    , 0x02EA, 0x01 } },     /*          */
  { Terminate_CMD }
 } },

/*
**  Mode index 2
*/
{ 12, NATIVE+GRAPHICS+NOT_MONO, 4, 85, 38, 1024, 768, 0, 1, /* VioSetMode Structure */
  0, 0, IGNORE_CLR_BRST, /*          */
 {  /* [2][0] bga3 */
  { RegOutput_CMD,  { "\x53"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x07"    , 0x4AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x60\x06", 0x12E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x00\x06", 0x1AE8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\xFB\x05", 0x16E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x9D"    , 0x02E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x81"    , 0x0AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x7F"    , 0x06E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x16"    , 0x0EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x08"    , 0x1EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x33"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\xFF"    , 0x02EA, 0x01 } },     /*          */
  { Terminate_CMD }
 } },

/*
**  Mode index 3
*/
{ 12, NATIVE+GRAPHICS+NOT_MONO, 4, 80, 34, 640, 480, 0, 1, /* VioSetMode Structure */
  0, 0, IGNORE_CLR_BRST, /*          */
 {  /* [3][0] bga4 */
  { RegOutput_CMD,  { "\x41"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x03"    , 0x4AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x30\x08", 0x12E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\xA8\x07", 0x1AE8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x79\x07", 0x16E8, SETWORD } },  /*          */
  { RegOutput_CMD,  { "\x63"    , 0x02E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x52"    , 0x0AE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x4F"    , 0x06E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x2C"    , 0x0EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x22"    , 0x1EE8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\x21"    , 0x22E8, 0x01 } },     /*          */
  { RegOutput_CMD,  { "\xFF"    , 0x02EA, 0x01 } },     /*          */
  { Terminate_CMD }
 } }

#endif  /* VDH8514A                                                      MS00 */

 };

/*
** ROM font data table -
**    typedef struct {
**              FarAddress PVB;             ; Physical starting address
**              USHORT     PVBLen;          ; Length
**              USHORT     Partner;         ; Table index to base font
**              USHORT     PelColumns;
**              USHORT     PelRows;
**              USHORT     Flags;           ; PARTIAL: 1, CODEPTS: 2, FULL: 0
**              USHORT     FirstCodePoint;
**              USHORT     NumCodePoints;
**              } FONTBUFFER;
**
** During first device initialization ( DevEnable ), physical starting
** addresses are entered into the table ( via scanning adapter ROM ).
** ROM scanning is done over an adapter-dependent range:
**         E0000 - EFFFF ( VGA )
**         C0000 - CFFFF ( EGA and PS/2 adapter )
**         F0000 - FFFFF ( CGA and MPA )
*/

#if ROMFONT_SUPPORT                                                     /*MS00 */

/*            ROMCP_TABLE RomCP_Tbl[ROM_FONTS+MAX_CODEPAGES*NUM_FONTS]; */ /* PTM 2895            */
/*            USHORT CP_Fonts [5][2] = {{8,8}, {8,14}, {9,14}, {8,16}, {9,16}};*/ /* PTM 2895 */
/*            USHORT ROMCP_NUM;                                       PTM 2895 */
/*            USHORT NumPreparedCodePages;                      */                  /*            */


                   /*
                   ** CGA, EGA and VGA ROM fonts only
                   */
FONTBUFFER Fonts[] = {
{ (char far *)0xA0000, 0x2000, NoBaseFont },     /* Font area in video buffer */
{ (char far *)0x00000, Size8, NoBaseFont, 8, 8, FULL }            /* 8x8 ROM */

#if VDHEGA || VDHVGA                                                    /*MS00 */

                   /*
                   ** EGA and VGA ROM fonts only
                   */

,{ (char far *)0x00000, Size14, NoBaseFont,  8, 14, FULL }                  /* 8x14 ROM */
,{ (char far *)0x00000, Size14, ROMFont8x14, 9, 14, PARTIAL+CODEPTS, 0, 0 } /* 9x14 ROM */

#endif  /* VDHEGA || VDHVGA                                               MS00 */

#if VDHVGA                                                              /*MS00 */

                   /*
                   ** VGA ROM fonts only
                   */
,{ (char far *)0x00000, Size16, NoBaseFont,  8, 16, FULL }                  /* 8x16 ROM */
,{ (char far *)0x00000, Size16, ROMFont8x16, 9, 16, PARTIAL+CODEPTS, 0, 0 } /* 9x16 ROM */

#endif  /* VDHVGA                                                         MS00 */

};

#endif  /* ROMFONT_SUPPORT                                                MS00 */

/*
** Memory map table -
**    typedef struct {
**              USHORT     PageLength; ; Length of each page
**              USHORT     PageReal;   ; Length of each page (Real Mode)
**              ULONG      TotalSize;  ; Total size of all pages combined
**              ULONG      TotalReal;  ; Total size of all pages (Real Mode)
**              USHORT     BitPlanes;  ; Flag byte of bit planes used
**              FarAddress Start;
**              } MEMORYMAPS;
**
** **ese memory maps are used to save and restore the physical video buffer
*/

MEMORYMAPS MemoryMaps[] = {

#if VDHMPA                                                              /*MS00 */

/*          */  {4000,  4096,  4000,  4096,  0, (char far *)0xB0000 }   /* 7 */

#endif  /* VDHMPA                                                         MS00 */
#if VDHCGA || VDHEGA || VDHVGA || VDH8514A

/*          */  {4000, 0x4000, 4000, 0x6000, 0, (char far *)0xB0000 } /* 7, 7p */
/*          */ ,{2000, 0x4000, 2000, 0x6000, 0, (char far *)0xB8000 } /* 0, 1, s, p */
/*          */ ,{4000, 0x4000, 4000, 0x6000, 0, (char far *)0xB8000 } /* 2, 3, s, p */
/*          */ ,{16192,0x4000, 16192,0x4000, 0, (char far *)0xB8000 } /* 4, 5, 6 */

#endif  /* VDHCGA || VDHEGA || VDHVGA || VDH8514A */

/*
** This is the memory map which describes CGA 640x400 graphics mode #40.
** Somehow it didn't get in here when the IDC stuff was originally added.
** This is paired with MemMap_Mode40 in VDH.H.  -AJP
*/

#if VDHCGA
/*          */ ,{32576,0x8000, 32576,0x8000, 0, (char far *)0xB8000 } /* 40 */
#endif

#if VDHEGA      /* 64K EGA default values */                           /*            */
        /*                                                          */ /*            */
        /*  PageLength, PageReal, TotalSize and TotalReal will      */ /*            */
        /*  be dynamically modify by the _getVideoType routine      */ /*            */
        /*  in VDHXCONF.C according to the memory switch setting    */ /*            */

/*          */ ,{8000, 0x3F40, 32000, 0x0FD00, 1+2+4+8, (char far *)0xA0000 } /* D */
/*          */ ,{16000,0x3E80, 64000, 0x0FA00, 1+2+4+8, (char far *)0xA0000 } /* E */
/*          */ ,{28000,0x7000, 56000, 0x0E000, 1  +4  , (char far *)0xA0000 } /* F */
/*          */ ,{28000,0x7000, 56000, 0x0E000, 1  +4  , (char far *)0xA0000 } /* 10 */

#endif  /* VDHEGA */
#if VDHVGA || VDH8514A  /* 256K VGA default values */                  /*            */

/*          */ ,{8000, 0xFF40, 32000, 0x3FD00, 1+2+4+8, (char far *)0xA0000 } /* D */
/*          */ ,{16000,0xFE80, 64000, 0x3FA00, 1+2+4+8, (char far *)0xA0000 } /* E */
/*          */ ,{28000,0xF000, 56000, 0x1E000, 1  +4  , (char far *)0xA0000 } /* F */
/*          */ ,{28000,0xF000, 112000,0x3C000, 1+2+4+8, (char far *)0xA0000 } /* 10 */

#endif  /* VDHVGA || VDH8514A */
#if VDHVGA

/*          */ ,{38400,0xA000, 38400, 0x0A000, 0,       (char far *)0xA0000 } /* 11 */
/*          */ ,{38400,0xA000, 153600,0x28000, 1+2+4+8, (char far *)0xA0000 } /* 12 */
/*          */ ,{64000,0x0000, 64000, 0x10000, 0,       (char far *)0xA0000 } /* 13 */
/*          */ ,{4800, 0x4000, 4800,  0x06000, 0,       (char far *)0xB8000 } /* Text480 */

/*
** Memory map for STARDUST 640x480x256 graphics mode.  This has been udated
** to report protected-mode total VRAM size of 300K instead of 512K.   -AJP
*/

/*          */ ,{0000, 0x0000, 307200,0x80000, 0,       (char far *)0xA0000 } /* 2E */


#endif  /* VDHVGA */
        };

