/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = vdhctl.h
 *
 * DESCRIPTIVE NAME = 
 *
 *
 * VERSION      V2.0
 *
 * DATE         
 *
 * DESCRIPTION 
 *
 * FUNCTIONS    NONE
 *
 * NOTES        NONE
 *             
 * STRUCTURES   NONE
 *
 * EXTERNAL REFERENCES
 *
 *              NONE
 *
 * EXTERNAL FUNCTIONS
 *
 *              NONE
 *
 * CHANGE ACTIVIY =
 *   DATE      FLAG       APAR    CHANGE DESCRIPTION
 *   --------  ---------- -----   --------------------------------------
 *   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
 *   12/19/88  @T6        P3250   TPL, Allow set border color for CGA                    
 *                                compatible modes,
 *   07/15/89  @T39       B784056 TPL, Remove hardware dependencies in VDHINIT
 *   08/12/89  @B18       SM01377 TLB, Allow correct config info return for               
 *                                VDHINIT
 ****************************************************************************/

/*
**    CONDITIONAL COMPILATION DEFINITIONS
**
**    One of these is supposed to be defined to be TRUE in the
**    compile command line arguments.  The others need to be defined
**    to be FALSE so they can all be used in the code.
*/

#ifndef VDHINIT
        /*
        ** if init is not defined, define it 0 
        */
        #define VDHINIT 0
#else
        /*
        ** if init is defined (assuming=-1) define vga -1 also 
        */
        #define VDHVGA  1
#endif
#ifndef VDHVGA
        #define VDHVGA  0
#endif
#ifndef VDHEGA
        #define VDHEGA  0
#endif
#ifndef VDHCGA
        #define VDHCGA  0
#endif
#ifndef VDHMPA
        #define VDHMPA  0
#endif
#ifndef VDH8514A
        #define VDH8514A        0
#endif

/*
**       Check the options now specified
*/

#if ( ( VDHVGA + VDHEGA + VDHCGA + VDHMPA + VDH8514A ) != 1)
        /*
        ** Force a compiler error message
        ** ERROR IN COMPILE COMMAND LINE PARAMETERS
        ** VIDEO DEVICE NOT CORRECTLY SPECIFIED
        */
#endif

/*
**   Set symbolic values representing features supported
**   on a subset of devices
*/


#define BLINK_SUPPORT           ( VDHVGA || VDHEGA || VDHCGA )
#define FONT_SUPPORT            ( VDHVGA || VDHEGA )
#define OVERSCAN_SUPPORT        ( VDHVGA || VDHEGA || VDHCGA )
#define PALETTE_SUPPORT         ( VDHVGA || VDHEGA )
#define ROMFONT_SUPPORT         ( VDHVGA || VDHEGA || VDHCGA )
#define UNDERSCORE_SUPPORT      ( VDHVGA || VDHEGA )
#define INTEXT_SUPPORT          ( VDHVGA )

#if DEBUG
#ifndef DEBUG_DATA
extern UCHAR DEBUG_ACTIVE[];
extern char *DEBUG_NAME[];
extern char *DEBUG_BVH_VERSION;
#endif
extern void far pascal _DPRINTF(char far *);
extern unsigned DEBUG_OUT;
extern void far int3(void);
#define FNDEBUG(Fn)     {\
        register unsigned tFn = (unsigned)(Fn - FnTextBufferUpdate);\
        unsigned trc;   \
        if (tFn <= MaxFn) {\
                if (DEBUG_OUT) { \
                        _DPRINTF((char far *)DEBUG_BVH_VERSION); \
                        _DPRINTF((char far *)DEBUG_NAME[tFn]); \
                } \
                if (DEBUG_ACTIVE[tFn])  int3(); \
        } \
        }
#else
#define FNDEBUG(Fn)
#endif

