;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   VDHCDLL.ASM -- Dynlink Register Preservation Routines

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHCDLL.ASM
;*
;* DESCRIPTIVE NAME = Dynlink Register Preservation Routines 
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  Dynlink Register Preservation Routines 
;*              This module contains register save and restore routines
;*              that are called by each top-level VDH routine
;*              immediately following entry and imediately prior to
;*              exit, respectively.
;*
;* FUNCTIONS    _SaveRegs, _RestoreRegs
;*
;* NOTES        NONE
;*             
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;****************************************************************************/

.286p


;/*
;** Include files                                                             
;*/

include struc.inc                          ; Structured assembly macros


;/*
;** Local variables                                       
;*/

SavedBX    equ WORD PTR [bp+6]             ; Storage for original BX register
SavedCX    equ WORD PTR [bp+8]             ; Storage for original CX register
SavedDX    equ WORD PTR [bp+10]            ; Storage for original DX register
SavedES    equ WORD PTR [bp+12]            ; Storage for original ES register
SavedFLAGS equ WORD PTR [bp+14]            ; Storage for original flag register


R2CSEG  SEGMENT  WORD  PUBLIC  'CODE'
ASSUME  CS:R2CSEG


;/****************************************************************************
;*
;*  SUBROUTINE NAME: SaveRegs                                         
;*                                                                    
;*  DESCRIPTIVE NAME: Save registers and flags                        
;*                                                                    
;*  FUNCTION: SaveRegs is the first call made by each of the toplevel 
;*            VDH entry points.                                       
;*                                                                    
;*  ENTRY POINT: SaveRegs                                             
;*    LINKAGE:   CALL FAR                                             
;*                                                                    
;*  INPUT: NONE                                                       
;*                                                                    
;*  EXIT-NORMAL: Registers and flags are saved on the stack           
;*                                                                    
;*  INTERNAL REFERENCES:                                              
;*    ROUTINES: NONE                                                  
;*                                                                    
;*  EXTERNAL REFERENCES:                                              
;*    ROUTINES: NONE                                                  
;*                                                                    
;****************************************************************************/

PUBLIC    _SaveRegs
_SaveRegs  PROC  FAR


;/*
;** ENTRY: SS:SP = NextIP  NextCS     
;** EXIT:  SS:SP = NextIP NextCS SavedBX SavedCX SavedDX SavedES SavedFLAGS 
;*/

     sub  sp, 10                   ; Allocate temporary storage on stack
     push bp
     mov  bp, sp

     mov ax, [bp+12]               ; Move far return address to top of the stack
     mov [bp+2], ax
     mov ax, [bp+14]
     mov [bp+4], ax

     mov SavedBX, bx               ; Now save the registers
     mov SavedCX, cx
     mov SavedDX, dx
     mov SavedES, es
     pushf
     pop SavedFLAGS

     pop bp

     ret

_SaveRegs  ENDP

;/****************************************************************************
;*                                                                     
;*  SUBROUTINE NAME: RestoreRegs                                       
;*                                                                     
;*  DESCRIPTIVE NAME: Restore registers and flags                      
;*                                                                     
;*  FUNCTION: RestoreRegs is the last call made by each of the toplevel
;*            VDH entry points, prior to returning.                    
;*                                                                     
;*  ENTRY POINT: RestoreRegs                                           
;*    LINKAGE:   CALL FAR                                              
;*                                                                     
;*  INPUT: NONE                                                        
;*                                                                     
;*  EXIT-NORMAL: Registers and flags are restored.                     
;*                                                                     
;*  INTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;*  EXTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;****************************************************************************/

PUBLIC       _RestoreRegs
_RestoreRegs  PROC  FAR


;/*
;**   ENTRY: SS:SP = NextIP NextCS SavedBX SavedCX SavedDX SavedES SavedFLAGS  
;**   EXIT:  SS:SP = NextIP NextCS                                             
;*/

     push bp
     mov  bp, sp

     push SavedFLAGS
     popf

     mov bx, SavedBX               ; Restore registers
     mov cx, SavedCX
     mov dx, SavedDX
     verr SavedES
     .if < nz >
        push 0
        pop  es                    ; If     selector, replace with zero
     .else
        mov es, SavedES
     .endif

     pop  bp

     ret 10

_RestoreRegs  ENDP


R2CSEG  ENDS

END
