;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDH.INC
;*
;* DESCRIPTIVE NAME = VDH macros and definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  VDH macros and definitions 
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*                         B726708 Removing IDC-specific code.  -AJP
;*   03/09/89                      Add new display type equates
;*   04/26/89              B701352 GET_ROMCP needed for accessfont routine  
;*                         B701338
;*   08/04/89              B785016 Remove unnecessary reg saves in FixVGABug  
;*                         B785017
;*   09/12/89              B708207 Fix from Steve Thompson for video buf 
;*                         3789    corruption problem.
;*   02/16/90              B788124 Optimize SwitchIfReverse macro  
;*   09/11/90              D1085   Add short delay macro for use between I/O's
;*   11/28/90              B718134 Define  ColorMonoMode as a byte,
;*   02/12/92              B732894 Use kernel IoDelay macro  
;*   03/01/92                      Compaq OEM fix
;*****************************************************************************/

NOT_MONO                equ     1       ;xxxxxxxb b=0 Mono-compat, b=1 Other
GET_ROMCP               equ     2                                       ;           
GET                     equ     1
SET                     equ     0
SETWORD                 equ     2

WORDS                   equ     1
BYTES                   equ     0

COLOR                   equ     1

TRUE                    equ     1
FALSE                   equ     0
NONE                    equ     0

SAVE                    equ     0
RESTORE                 equ     1

Attributes_CMD          equ     1
Sequencers_CMD          equ     2

CursorHidden            equ     00100000B

;/*
;**  Display types                                                             |
;*/

Mono8503                equ     03h     ;   VDHVGA, VDH8514A
Color8512_8513          equ     04h     ;   VDHVGA, VDH8514A
Color8514               equ     09h     ;   VDH8514A
Mono8507_8604           equ     0Bh     ;   VDH8514A ;          
Color8515               equ     0Ch     ;   VDH8514A ;          

MEM_1MB                 equ     1
VDHERROR_NO_ADAPTER     equ     0

CRTCtlAddressRegMono    equ     03B4h   ; CRT Controller Address Register (monochrome)
CRTCtlAddressRegColor   equ     03D4h   ; CRT Controller Address Register (color)


SeqAddressPort          equ     03C4h
GraphAddressPort        equ     03CEh
FeatureControlWrite     equ     03BAh   ; Read Feature Control Register
ColorAdjustment         equ     20h
AttAddressPort          equ     03C0h
MiscOutputRegRead       equ     03CCh   ; Read Miscellaneous Output Register
MiscOutputRegWrite      equ     03C2h   ; Write Miscellaneous Output Register
MonoAdjustment          equ     0
CRTCtlAddressReg        equ     03B4h   ; CRT Controller Address Register
CRTCtlDataReg           equ     03B5h   ; CRT Controller Data Register
IndMaxScanLine          equ     09h     ; CRT Maximum scan line
CHAR_SCANLINES          equ     00011111b       ; scan lines per char bits
PELAddressRead          equ     03C7h   ; PEL Address Register for data read
PELAddressWrite         equ     03C8h   ; PEL Address Register for data write
SeqDataPort             equ     03C5h
AttCtlInitializeReg     equ     03BAh   ; Feature Control Register - init AttCtl flip-flop
IndClockModeReg         equ     01h     ; Address Clocking Mode in Sequencer
IndUnderlineLoc         equ     14h     ; Address Underline Location Register
AttDataReadPort         equ     03C1h
AttDataWritePort        equ     03C0h
IndOverscanColor        equ     11h     ; Address Overscan Color Register
IndCursorStart          equ     0Ah     ; Address Cursor Start Register
IndCursorEnd            equ     0Bh     ; Address Cursor End Register
IndAttModeCtl           equ     10h     ; Address Attribute Mode Control Register
PELDataRegister         equ     03C9h   ; PEL Data Register

IndCursorHighLoc        equ     0Eh     ; Address Cursor Location High Register
IndCursorLowLoc         equ     0Fh     ; Address Cursor Location Low Register


ColorMonoFixup          equ     WORD PTR [bp-2]

MapMask                 equ     <BYTE PTR [bp+6]>
ReadMap                 equ     <BYTE PTR [bp+8]>
TableIndex              equ     WORD PTR [bp+6]
fbType                  equ     WORD PTR [bp+6]
ParameterPacket         equ     DWORD PTR [bp+6]
Direction               equ     WORD PTR [bp+10]
ColorMode               equ     <WORD PTR [bp+12]>
CharacterColumns        equ     WORD PTR [bp+14]
WordByte                equ     <WORD PTR [bp+14]>
AddressPacket           equ     DWORD PTR [bp+16]
AddressPkt              equ     DWORD PTR [bp+12]
ColorMonoMode           equ     <BYTE PTR [bp+6]>               ;;;MERGE change

WriteFunction           equ     4

VioCursorType STRUC
        CursorTopScanLine dw ?
        CursorBottomScanLine dw ?
        CursorWidth dw ?
        CursorAttribute dw ?
VioCursorType ENDS

VioCursorPos STRUC
        CursorRow dw ?
        CursorColumn dw ?
VioCursorPos ENDS

PaletteCLUT STRUC
        DataArea dd ?
        FirstEntry dw ?
        NumEntries dw ?
PaletteCLUT ENDS

RegAddress STRUC
        RegAddressPort dw ?
        RegDataPort dw ?
        RegColorAdjust dw ?
        RegFlags dw ?
RegAddress ENDS

Blink   equ     0
Overscan equ    0
Underscore equ  0
VideoEnable equ 0
DisplayMask equ 0

;/*
;**  Macros                                                                    |
;*/

;/****************************************************************************
;*
;* MACRO NAME    = @SwitchIfReverse
;*
;* DESCRIPTION   = 
;*
;* INPUT         = 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

@SwitchIfReverse macro

        .if     < Mode eq RESTORE >
            push    es
            push    ds
            xchg    si,di                                   ;          
            pop     es
            pop     ds
        .endif
        endm

;/*
;** Ensure synchonization of Attribute flip-flop by reading both the Mono
;**     and the Color ports, then set the Attribute Address port.
;*/

;/****************************************************************************
;*
;* MACRO NAME    = @SetAttAddressPort
;*
;* DESCRIPTION   = 
;*
;* INPUT         = 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

@SetAttAddressPort macro

        mov     dx,3BAh                 ;Mono status register
        cli                             ;Disallow interrupts
        in      al,dx                   ;Read port to reset flip-flop
        mov     dx,3DAh                 ;Color status register
        in      al,dx                   ;Read port to reset flip-flop
        mov     dx,AttAddressPort       ;Get the Attribute Address Port

        endm

;/****************************************************************************
;*
;* MACRO NAME    = @VideoOn
;*
;* DESCRIPTION   = 
;*
;* INPUT         = 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

@VideoOn macro

        @SetAttAddressPort              ; Set EGA/VGA port
        mov     al, 20h                 ; Enable video for EGA/VGA
        out     dx, al                  ; Disable the video signal

        endm

;/*
;** Avoid problem in VGA by writing to an undocumented I/O register.
;** If this is not done, the video buffer will be randomly corrupted
;** during a setmode.  This is not a problem using Bios since the
;** screen is always cleared after the mode has been set.
;*/

;/****************************************************************************
;*
;* MACRO NAME    = @FixVGABug
;*
;* DESCRIPTION   = 
;*
;* INPUT         = 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

@FixVGABug macro

        mov     dx,3c4h                 ;            
        mov     ax,7                    ;            
        out     dx,ax                   ;            

        mov     dx, MiscOutputRegRead   ; Read Miscellaneous Output Register
        in      al, dx
        mov     dx, CRTCtlAddressReg
        test    al, 1
        .if     < nz >
            add     dx, ColorAdjustment
        .endif
        mov     al, 03FH                ; set up index
        out     dx, al

        inc     dx                      ; point to the register
        mov     al, 1                   ; set up the data
        out     dx, al

        endm


_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

DGROUP  GROUP   CONST, _BSS, _DATA

