/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VDH.H
 *
 * DESCRIPTIVE NAME = Video Device Handler include file
 *
 *
 * VERSION       V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS     NONE
 *
 * NOTES
 *
 *
 * STRUCTURES    NONE
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define PMERR_DEV_FUNC_NOT_INSTALLED 1


#if VDHINIT                                                             /*@ISO*/
typedef struct DMQSdata {       /* DMQS data structure */               /*@ISO*/
   USHORT   next_DMQS_offset;                                           /*@ISO*/
   BYTE     slot_number;                                                /*@ISO*/
   USHORT   level_id;                                                   /*@ISO*/
   ULONG    vendor_id;                                                  /*@ISO*/
   USHORT   io_reg_base;                                                /*@ISO*/
   USHORT   mmio_regs;                                                  /*@ISO*/
   USHORT   one_meg_aperture;                                           /*@ISO*/
   USHORT   four_meg_aperture;                                          /*@ISO*/
   USHORT   vram_base;                                                  /*@ISO*/
   USHORT   monitor_id;                                                 /*@ISO*/
   BYTE     vram_size;                                                  /*@ISO*/
} DMQSDATA;                                                             /*@ISO*/

typedef struct BIOSINFO {                                               /*@RAD*/
    USHORT MachModel;                                                   /*@RAD*/
    USHORT SubModel;                                                    /*@RAD*/
    USHORT RevisionLevel;                                               /*@RAD*/
    USHORT ABIOSPresent;                                                /*@RAD*/
} BIOSINFO;                                                             /*@RAD*/

/*
**  OEM Help Function code
*/

#define OEMHLP_BIOSINFO        5   /* obtain machine type info            @RAD*/
#define OEMHLP_DMQS_INFO      10   /* get pointer to DMQS data */       /*@ISO*/

/*
**  Display Composite ID returned through monitor_id
*/

#define COMP_ID_9515       0x0F9FF                                      /*@ISO*/
#define COMP_ID_9517       0x099F0                                      /*@ISO*/
#define COMP_ID_9518       0x0F9F0                                      /*@ISO*/

/*
**  New Non-Interlaced Display types
*/

#define color9515          15    /* 1024x768 - 75 hz */                 /*@ISO*/
#define color9517          16    /* 1024x768 - 72 hz */                 /*@ISO*/
#define color9518          17    /*  640x480 - 75 hz */                 /*@ISO*/
                                 /*  720x400 - 88 hz (text) */          /*@ISO*/
#endif                                                                  /*@ISO*/

                                                        /*@T39 - Begin*/

typedef struct hardwareConfig { /* hardware configuration information */

/*
**      WARNING: this structure is also defined in IDHEQU.INC, be sure
**               to update both structures when changing this one
*/

        USHORT fVideoType;      /* video adapter(s) and monitor(s) */
        USHORT display;         /* display type         not used by BVHINIT */
        unsigned long memory;   /* memory configuration */
        USHORT Reg_132;         /* VGA-E 132 col.       not used by BVHINIT */
        UCHAR  popupMode;       /* popup mode           not used by BVHINIT */
} VIDEOHARDWARE;

/* return values from getVideoType() */
#define MPA_BIT           1      /* bit 0, MPA adapter with MONO monitor */
#define CGA_BIT           2      /* bit 1, CGA adapter with COLOR monitor */
#define EGM_BIT           4      /* bit 2, EGA adapter with MONO monitor  */
#define EGC_BIT           8      /* bit 3, EGA adapter with COLOR monitor */
#define EGA_BIT           0x10   /* bit 4, EGA adapter with ENHANCED COLOR monitor */
#define VGP_BIT           0x20   /* bit 5, VGA plasma display */
#define VGM_BIT           0x40   /* bit 6, VGA adapter with MONO monitor */
#define VGC_BIT           0x80   /* bit 7, VGA adapter with COLOR monitor  */
#define A8514M_BIT        0x100  /* bit 8, 8514A with 8507 monitor */
#define A8514C_BIT        0x200  /* bit 9, 8514A with 8512/3 monitor */
#define A8514A_BIT        0x400  /* bit 10, 8514A with 8514 monitor */
#define A8514_15_BIT      0x800  /* bit 11, 8514A with 8515 monitor */
#define A8514_03_BIT      0x1000 /* bit 12, 8514A with Monochrome 8503 monitor */
#define NODISPLAY_BIT     0x2000 /* bit 13, no display present on VGA system */
#define XGA_BIT           0x4000 /* bit 14, XGA adapter                 @T72 */
#define MONO_DISPLAYS     VGM_BIT + A8514M_BIT + A8514_03_BIT         /*@T73f*/

/*
**      Bits 0 and 1 reflect memory configuation for EGA or 8514A
**
**              0 0 - minimum memory, EGA = 64K, 8514A = .5M
**              0 1 - EGA = 128K
**              1 0 - EGA = 192K
**              1 1 - maximum memory, EGA = 256K, 8514A = 1M
*/

#define MEM_EGA64K       0x0000
#define MEM_EGA128K      0x0001
#define MEM_EGA192K      0x0002
#define MEM_EGA256K      0x0003
#define MEM_A85141MEG    0x0003

#define A8514_BITS       (A8514M_BIT|A8514C_BIT|A8514A_BIT|A8514_15_BIT|A8514_03_BIT)
#define VGA_BITS         (VGP_BIT|VGM_BIT|VGC_BIT|NODISPLAY_BIT)
#define EGA_BITS         (EGM_BIT|EGC_BIT|EGA_BIT)

/*
**    REALTO32BITADDR - seg:offet -> 32 bit address conversion
**             input:   a double word containing a segment:offset pair
**            output:   32 bit address
**
*/

#define REALTO32BITADDR(a) ((((ULONG)HIUSHORT(a))<<4L) + ((ULONG)LOUSHORT(a)))

/*MERGE***  #define REALTO32BITADDR(a) ((ULONG)((HIUSHORT(a))<<4L) + (ULONG)(LOUSHORT(a))) */

#define BIOSFONTSFOUND          0  /* return value from GetBiosFonts() */
#define NOBIOSFONTS             1  /* return value from GetBiosFonts() */
#define OEMHLP_FUNCTION_VIDEO   2  /* OEMHLP video type ioctl */
#define OEMHLP_FUNCTION_FONTS   3  /* OEMHLP.SYS returns font information */
#define OEMHLP_FUNCTION_MISC    6  /* OEMHLP.SYS get Misc. State info */
#define OEMHLP_FUNCTION_ADAPTER 7  /* OEMHLP.SYS get adapter type */    /* @T74 */
#define GETADAPTER_TYPE         6  /* parameter to DosDevIoctl */
#define VGA_MONO                7  /* return value of INT 10 function 1a */
#define VGA_COLOR               8  /* return value of INT 10 function 1a */
#define VGA_NODISPLAY           0  /* return value of INT 10 function 1a */

#define MPA_DEVICE              1  /* bit information returned from */  /* @T74 */
#define CGA_DEVICE              2  /* OEMHLP_FUNCTION_ADAPTER call  */  /* @T74 */
#define EGA_DEVICE              4  /* to OEMHLP$                    */  /* @T74 */
#define VGA_DEVICE              8                                       /* @T74 */

#define MEM_B000 0                 /* memory test location indicators */
#define MEM_B800 1
#define MEM_A000 2

#define OEMHLP_CATEGORY      0x80  /* category number of OEMHLP.SYS IOCtl */
#define OEMHLPDD_NAME   "OEMHLP$"  /* name of OEMHLP device driver        */
#define IBM_ADAPTER     6          /*          */     
#define FONT_8x8  1                /* Fonts[] indexes */
#define FONT_8x14 2
#define FONT_9x14 3
#define FONT_8x16 4
#define FONT_9x16 5


#undef VIOMODEINFO
#undef PVIOMODEINFO
struct _VDHMODEINFO {
        USHORT cb;
        UCHAR  fbType;
        UCHAR  color;
        USHORT col;
        USHORT row;
        USHORT hres;
        USHORT vres;
        UCHAR  fmt_ID;
        UCHAR  attrib;
        UCHAR far *BufferAddress;
        ULONG  BufferLength;
        ULONG  FullBufferSize;
        ULONG  PartialBufferSize;
        UCHAR far *ExtDataArea;
        };
#define VIOMODEINFO struct _VDHMODEINFO
#define PVIOMODEINFO VIOMODEINFO FAR *

struct ABIOS_Request_Block {
        USHORT ABIOS_RB_Len;            /* +00h */
        USHORT ABIOS_DevId;             /* +02h */
        USHORT ABIOS_Unit;              /* +04h */
        USHORT ABIOS_Func;              /* +06h */
        USHORT ABIOS_RBFlags;           /* +08h */
        USHORT ABIOS_ELOff;             /* +0Ah */
        USHORT ABIOS_RetCode;           /* +0Ch */
        USHORT ABIOS_TimeOut;           /* +0Eh */
        USHORT ABIOS_DataPtr1x;         /* +10h */
        USHORT ABIOS_DataPtr1l;         /* +12h */
        USHORT ABIOS_DataPtr1h;         /* +14h */
        USHORT ABIOS_unknown;           /* +16h */
        USHORT ABIOS_Count;             /* +18h */
        USHORT ABIOS_DevCntlFlag;       /* +1Ah */
        UCHAR  ABIOS_ScanLines;         /* +1Ch */
        UCHAR  ABIOS_CharGenType;       /* +1Dh */
        USHORT ABIOS_VideoMode;         /* +1Eh */
        USHORT ABIOS_MonitorType;       /* +20h */
        USHORT ABIOS_CharHeight;        /* +22h */
        USHORT ABIOS_Map2Block;         /* +24h */
        USHORT ABIOS_UpdateFontFlag;    /* +26h */
        USHORT ABIOS_CharOffset;        /* +28h */
        USHORT ABIOS_FontDataSize;      /* +2Ah */
        USHORT ABIOS_Environment;       /* +2Ch */
        USHORT ABIOS_SR_Header_Size;    /* +2Eh */
        USHORT ABIOS_SR_Hdw_Size;       /* +30h */
        USHORT ABIOS_PaletteReg;        /* +32h */
        USHORT ABIOS_PaletteValue;      /* +34h */
        }; /* End of ABIOS_Request_Block */

#define ABIOS_SR_DB_Size  ABIOS_PaletteReg   /* +32h */
#define ABIOS_SR_DAC_Size ABIOS_PaletteValue /* +34h */

#undef VIOPHYSBUF
#undef PVIOPHYSBUF
struct _VDHVIOPHYSBUF {    /* viopb */
        PBYTE    pBuf;
        ULONG    cb;
        SEL      asel[4]; /* Definitely no greater than 4 selectors */
        };
#define VIOPHYSBUF struct _VDHVIOPHYSBUF
#define PVIOPHYSBUF VIOPHYSBUF FAR *

#define WorldFormat             0x70    /* world attribute format       @P1 */
#define DefaultFormat           0x00    /* default attribute format     @P1 */
#define WorldAttrCount          0x03    /* world attribute count        @P1 */
#define DefaultAttrCount        0x01    /* default attribute count @tb15  @P1 */
#define WorldAttrMult           0x02    /* world attr save size multiplier @P1 */

/*
** Definitions
*/

/*
**  Function numbers for VDH services
*/

#define FnFillLogicalDevBlock    1L
#define FnFillInitDevBlock       3L                     /* DCR 203      @T15 */

#define FnTextBufferUpdate       256L
#define FnInitializeEnvironment  257L
#define FnSaveEnvironment        258L
#define FnRestoreEnvironment     259L
#define FnReturnConfigInfo       260L
#define FnGetDBCSDisplayInfo     261L
#define FnGetColorLookupTable    262L
#define FnSetColorLookupTable    263L
#define FnGetCursorInfo          264L
#define FnSetCursorInfo          265L
#define FnGetFont                266L
#define FnSetFont                267L
#define FnGetMode                268L
#define FnSetMode                269L
#define FnGetPaletteRegisters    270L
#define FnSetPaletteRegisters    271L
#define FnGetPhysBuf             272L
#define FnFreePhysBuf            273L
#define FnGetVariableInfo        274L
#define FnSetVariableInfo        275L
#define FnExtendedVioCall        276L
#define FnReserved1              277L   /* print screen */
#define FnReserved2              278L   /* write TTY */
#define FnGetLVBInfo             279L   /*      @P1 */
#define FnGetState               280L   /* get state */              /*          */
#define FnSetState               281L   /* set state */              /*          */
#define LASTFUNCTION             281L   /* indicate last function */ /*          */

#define MaxFn                    LASTFUNCTION-FnTextBufferUpdate+1  /* @T24 */

#if VDH8514A                                                            /*            */

#define ChainedVDHBufferUpdate    ( *ChainedCallVectorTable[0])
#define ChainedVDHInitEnv         ( *ChainedCallVectorTable[1])
#define ChainedVDHSaveEnv         ( *ChainedCallVectorTable[2])
#define ChainedVDHRestoreEnv      ( *ChainedCallVectorTable[3])
#define ChainedVDHRetConfigInfo   ( *ChainedCallVectorTable[4])
#define ChainedVDHGetDBCSInfo     ( *ChainedCallVectorTable[5])
#define ChainedVDHGetColorLookup  ( *ChainedCallVectorTable[6])
#define ChainedVDHSetColorLookup  ( *ChainedCallVectorTable[7])
#define ChainedVDHGetCursorInfo   ( *ChainedCallVectorTable[8])
#define ChainedVDHSetCursorInfo   ( *ChainedCallVectorTable[9])
#define ChainedVDHGetCurrentFont  ( *ChainedCallVectorTable[10])
#define ChainedVDHSetCurrentFont  ( *ChainedCallVectorTable[11])
#define ChainedVDHGetMode         ( *ChainedCallVectorTable[12])
#define ChainedVDHSetMode         ( *ChainedCallVectorTable[13])
#define ChainedVDHGetPaletteReg   ( *ChainedCallVectorTable[14])
#define ChainedVDHSetPaletteReg   ( *ChainedCallVectorTable[15])
#define ChainedVDHGetPhysBuf      ( *ChainedCallVectorTable[16])
#define ChainedVDHFreePhysBuf     ( *ChainedCallVectorTable[17])
#define ChainedVDHGetVariableInfo ( *ChainedCallVectorTable[18])
#define ChainedVDHSetVariableInfo ( *ChainedCallVectorTable[19])
#define ChainedVDHExtendedVioCall ( *ChainedCallVectorTable[20])    /* @T24 */
#define ChainedVDHReserved1       ( *ChainedCallVectorTable[21])    /* @T24 */
#define ChainedVDHReserved2       ( *ChainedCallVectorTable[22])    /* @T24 */
#define ChainedVDHGetLVBInfo      ( *ChainedCallVectorTable[23]) /*@T24, @P1 */
#define ChainedVDHGetState        ( *ChainedCallVectorTable[24])     /*          */
#define ChainedVDHSetState        ( *ChainedCallVectorTable[25])     /*          */

#endif  /* VDH8514A                                                                  */

#define FnChainedBufUpdate        0
#define FnChainedRetConfigInfo    4

/*
**  Minimum structure lengths for VDH functions
*/

#define MinSLen_SaveRestoreEnv  4
#define MinSLen_Cursor_Pos      8
#define MinSLen_Cursor_Type     16
#define MinSLen_Var_Blink       6
#define MinSLen_Var_Overscan    8
#define MinSLen_Var_Underscore  10
#define MinSLen_Var_VideoEnable 12
#define MinSLen_Var_DisplayMask 16
#define MinSLen_Var_CodePage    18
#define MinSLen_Var_ScrollRect  26                              /*      @P1 */
#define MinSLen_Var_ScreenDim   30                              /*      @P1 */

#define MinGLen_LVB_Size        14                              /*      @P1 */
#define MinGLen_LVB_AttrBufSize 16                              /*      @P1 */
#define MinGLen_LVB_AttrBufAddr 20                              /*      @P1 */



/*
**  Minimum data lengths for VDH parameters
*/

#define Config_Return_Length          2         /* RetConfigInfo */
#define MinDLen_Config_Adapter        4
#define MinDLen_Config_Display        6
#define MinDLen_Config_Memory         10
#define MinDLen_Config_ConfigNum      12
#define MinDLen_Config_Version        14
#define MinDLen_Config_Flag           16
#define MinDLen_Config_HWBufLen       20
#define MinDLen_Config_FullSaveSz     24
#define MinDLen_Config_PartSaveSz     28
#define MinDLen_Config_LEMAdapterdata 34        /* @BB7 */
#define MinDLen_Config_EMAdapter      36        /* @BB7 */
#define MinDLen_Config_LEMDisplaydata 38        /* @BB7 */
#define MinDLen_Config_EMDisplay      40        /* @BB7 */

#define Mode_Return_Length        2         /* Get/SetMode                   @@A */
#define MinDLen_Mode_Type         3
#define MinDLen_Mode_Color        4
#define MinDLen_Mode_Column       6
#define MinDLen_Mode_Row          8
#define MinDLen_Mode_Hres         10
#define MinDLen_Mode_Vres         12
#define MinDLen_Mode_FormatID     13
#define MinDLen_Mode_Attrib       14
#define MinDLen_Mode_BufStart     18
#define MinDLen_Mode_BufLen       22
#define MinDLen_Mode_FullBufSz    26
#define MinDLen_Mode_PartBufSz    30
#define MinDLen_Mode_ExtData      34

/*
**  Mode table index for each mode ( 0 based )
*/

/*@T39 #if defined ( VDHVGA )*/

  #define ModeIndex_VGA3p     0
  #define ModeIndex_VGP3p     1
  #define ModeIndex_VGM7p     2
  #define ModeIndex_VGC7p     3        /* P70 color                      @T71 */
  #define ModeIndex_VGP7p     4        /* P70 mono                       @T71 */
  #define ModeIndex_VGA1p     5                                         /*@T71*/
  #define ModeIndex_VGA1px    6        /* OEM mode 0+, 1+                MS?? */
  #define ModeIndex_VGP1p     7                                    /*@C29,@T71*/
  #define ModeIndex_VGP1sx    8        /* OEM mode 0#, 1#                MS?? */
  #define ModeIndex_VGE3      9                                    /*@C29,@T71*/
  #define ModeIndex_VGE1      10                                   /*@C29,@T71*/
  #define ModeIndex_VGA3      11                                        /*@T71*/
  #define ModeIndex_VGM7      12                                        /*@T71*/
  #define ModeIndex_VGA7p     13                                   /*@C29,@T71*/
  #define ModeIndex_VGA1      14                                   /*@C29,@T71*/
  #define ModeIndex_VGA4      15                                   /*@C29,@T71*/
  #define ModeIndex_VGA6      16                                   /*@C29,@T71*/
  #define ModeIndex_VGAD      17                                        /*@T71*/
  #define ModeIndex_VGAE      18                                   /*@C29,@T71*/
  #define ModeIndex_VGAF      19                                   /*@C29,@T71*/
  #define ModeIndex_VGA10     20                                        /*@T71*/
  #define ModeIndex_VGA11     21                                   /*@C29,@T71*/
  #define ModeIndex_VGA12     22                                   /*@C29,@T71*/
  #define ModeIndex_VGA13     23                                   /*@C29,@T71*/
  #define ModeIndex_VGA3px    24       /* VGA NON-BIOS mode              MS?? */
  #define ModeIndex_VGA7px    25       /* OEM NON-BIOS mode              MS?? */
  #define ModeIndex_VGA3sx    26       /* VGA NON-BIOS mode              MS?? */
  #define ModeIndex_VGA7sx    27       /* VGA NON-BIOS mode              MS?? */
  #define ModeIndex_IBM_132   28       /* VGA-E 132 column mode start    MS?? */
  #define ModeIndex_OEM_132   36       /* OEM 132 column mode start      MS?? */

/*
** Mode index for STARDUST 640x480x256 graphics mode.
*/

  #define ModeIndex_VGC2E     42

/*@T39 #elif defined ( VDHEGA )*/

  #define ModeIndex_EGA4        0                              /*            - BEGIN */
  #define ModeIndex_EGAF        1
  #define ModeIndex_EGA4b       2
  #define ModeIndex_EGAFm       3
  #define ModeIndex_EGA3        4
  #define ModeIndex_EGM7        5
  #define ModeIndex_EGA1        6
  #define ModeIndex_EGC3        7
  #define ModeIndex_EGC1        8
  #define ModeIndex_EGA6        9
  #define ModeIndex_EGAD        10
  #define ModeIndex_EGAE        11
  #define ModeIndex_EGA10       12
  #define ModeIndex_EGA10s      13                             /*            - END */

/*@T39 #elif defined ( VDHCGA )*/

  #define ModeIndex_VDUDSM3     0                              /*            - BEGIN */
  #define ModeIndex_CGA3        1
  #define ModeIndex_CGA2        2
  #define ModeIndex_CGA1        3
  #define ModeIndex_CGA0        4
  #define ModeIndex_CGA6        5
  #define ModeIndex_CGA4        6
  #define ModeIndex_CGA5        7
  #define ModeIndex_DMP40       8                             /*            - END */

/*@T39 #endif*/

/*
**  ROM Font table indices
*/

#if ROMFONT_SUPPORT                                                     /*            */

  #define Size8  0x0800
  #define Size14 0x0E00
  #define Size16 0x1000

  #define NoBaseFont  0    /* This is the physical address of the font buffer */
  #define ROMFont8x8  1
/* @C10  #define CPFont8x8   0 */


  #define ROMFont8x14 2
  #define ROMFont9x14 3
  #define ROMFont8x16 4
  #define ROMFont9x16 5

/* @C10   #define CPFont8x14 1    */
/* @C10   #define CPFont9x14 2    */
/* @C10   #define CPFont8x16 3    */
/* @C10   #define CPFont9x16 4    */

  #define CP_FONT    2                                                  /*@C10*/

  #define FONT_SIZE_TOTAL Size8 + Size14*2 + Size16*2

#endif  /*  ROMFONT_SUPPORT                                                        */

#define ROM_FONT              0
#define PHYSICAL_FONT_BUFFER  0
#define USER_FONT_SELECTABLE     (short)-1
#define USER_FONT_NOT_SELECTABLE (short)-2
#define MAX_CODEPAGES 2
#define CP_1st 0
#define CP_2nd 1
#define MAX_FONT_SIZE   32                                              /*            */
#define FONT_MAP_SIZE   65535                                           /*            */

/*
**  Memory map table indices
*/

#define MemMap_Mono             0
#define MemMap_Text40           1
#define MemMap_Text80           2
#define MemMap_LoRes            3
#define MemMap_Mode40           4                                       /* MS?? */
#define MemMap_ModeD            4
#define MemMap_ModeE            5
#define MemMap_ModeF            6
#define MemMap_Mode10           7
#define MemMap_Mode11           8
#define MemMap_Mode12           9
#define MemMap_Mode13           10
#define MemMap_Text480          11                                      /*STJ*/

#define MemMap_Mode2E           12

#define MIN_PVB_BOTTOM    0xA0000L
#define MAX_PVB_TOP       0xBFFFFL

#define BOTTOM_MONO_TEXT  0xB0000L
#define TOP_MONO_TEXT     0xB0F9FL

#if !(VDHMPA)                                                           /*            */

  #define BOTTOM_COLOR_TEXT 0xB8000L
  #define TOP_COLOR_TEXT    0xB8F9FL

  #define BOTTOM_LORES1     0xB8000L
  #define TOP_LORES1        0xB9F3FL

  #define BOTTOM_LORES2     0xBA000L
  #define TOP_LORES2        0xBBF3FL

  #define BOTTOM_GRAPHICS   0xA0000L

#if VDHEGA                                                              /*            */

  #define TOP_GRAPHICS      0xA6D60L

#endif  /*  VDHEGA                                                                    */
#if VDHVGA                                                              /*            */

  #define TOP_GRAPHICS      0xAF9FFL

#endif  /*  VDHVGA                                                                  */
#endif  /*  ! VDHMPA                                                                */

#if VDHVGA                                                          /*             */

  #define NUM_MODES     44          /*32 for           */                    /* MS?? */
  #define ROM_FONTS     5           /*@C7      # ROM fonts supported by VGA */
  #define NUM_FONTS     5           /* # fonts supported in a CP    */
  #define MAX_MODE_CMDS 7           /* Max no. CMDs to set a mode   */
  #define NUM_ATT_REGS  0x14+1

#endif  /*  VDHVGA                                                                  */

#if VDHEGA                                                              /*            */

  #define NUM_MODES     14          /* # Modes supported by EGA     */
  #define ROM_FONTS     3   /*@C7*/ /* # ROM fonts supported by EGA */
  #define NUM_FONTS     5           /* # fonts supported in a CP    */
  #define MAX_MODE_CMDS 8           /* Max no. CMDs to set a mode   */
  #define NUM_ATT_REGS  0x13+1

#endif  /*  VDHEGA                                                                   */

#if VDHCGA                                                             /*            */

  #define NUM_MODES      9         /* # Modes supported by CGA      */ /*            */
  #define ROM_FONTS      1  /*@C7*/ /* # ROM fonts supported by CGA */
  #define NUM_FONTS      1          /* # fonts supported in a CP    */
  #define CGAModeCtlReg  0x03D8
  #define CGAColorSelReg 0x03D9
  #define MAX_MODE_CMDS  7          /* Max no. CMDs to set a mode    */ /*            */
  #undef  MAX_FONT_SIZE                                                 /*            */
  #define MAX_FONT_SIZE  16                                             /*            */

#endif  /*  VDHCGA                                                                    */

#if VDHMPA                                                              /*            */

  #define NUM_MODES      1          /* # Modes supported by MONO    */
  #define MAX_MODE_CMDS  4          /* Max no. CMDs to set a mode   */

#endif  /*  VDHMPA                                                                    */

#if VDH8514A                                                            /*            */

  #define NUM_MODES      4          /* # Modes supported by 8514A   */
  #define MAX_MODE_CMDS  13         /* Max no. CMDs to set a mode @@B1 */

#endif  /*  VDH8514A                                                                  */

#define MAX_FONT_LEN    ((long)MAX_FONT_SIZE*256L)                      /*            */

#define UNSUPPORTED_FUNCTION 0 /* VDH service is not supported by this adapter */

/* DosOpen parameters */
#define SCREENDD_NAME  (PSZ)"SCREEN$"
#define RETURN_ERROR   (USHORT)0x2000     /* OpenMode bit mask */
#define NO_INHERIT     (USHORT)0x0080                           /* @T5 */
#define DENY_NONE      (USHORT)0x0040                           /* @T5 */
#define READ_WRITE     (USHORT)0x0002
#define OPEN_IF_EXISTS 0x0001             /* OpenFlag bit mask */
#define NO_SIZE        0L
#define NO_ATTRIBUTES  0
#define RESERVED_LONG  0L

/*
**  Display types
*/

#define  PlasmaDisplay  0x0A    /*   VDHVGA               */
#define  Mono8503       0x03    /*   VDHVGA, VDH8514A     */
#define  Color8512_8513 0x04    /*   VDHVGA, VDH8514A     */
#define  Color8514      0x09    /*   VDH8514A             */
#define  EnColor5154    0x02    /*   VDHEGA               */
#define  Color5153      0x01    /*   VDHCGA, VDHEGA       */
#define  Mono5151       0x00    /*   VDHMPA, VDHEGA       */
#define  NoDisplay      -1      /*   VDHVGA with VDH8514A */
#define  Mono8507_8604  0x0B    /*   VDH8514A D184        */
#define  Color8515      0x0C    /*   VDH8514A D184        */

#define MEM_1MB 1
#define VDHERROR_NO_ADAPTER 0

/*
**  Adapter types
*/

#define UNKNOWN_ADAPTER -1                                              /*@T39*/
#define TYPE_MPA    0
#define TYPE_CGA    1
#define TYPE_EGA    2
#define TYPE_VGA    3
#define TYPE_8514A  7

/*
**  Emulated Display types
*/

#define  EmDisp_8514A   0x1A18          /*D184*/
#define  EmDisp_8514L   0x0018          /*D184*/
#define  EmDisp_VGA     0x0418          /*D184*/
#define  EmDisp_EGA     0x0004          /*D184*/
#define  EmDisp_CGA     0x0002          /*D184*/
#define  EmDisp_MPA     0x0001          /*D184*/

/*
**  Emulated Adapter types
*/

#define EMULATE_TYPE_MPA    0x01
#define EMULATE_TYPE_CGA    0x02
#define EMULATE_TYPE_EGA    0x04
#define EMULATE_TYPE_VGA    0x08
#define EMULATE_TYPE_8514A  0x80

#define POWERUP  1
#define PASSTHRU 2

#define PARTIAL 0x01
#define CODEPTS 0x02
#define FULL    0x00

#define WORDS 1
#define BYTES 0

#define TRUE  1
#define FALSE 0

#define U_FONT 1                                        /* User font         */
#define C_FONT 2                                        /* CodePage font     */
#define R_FONT 3                                        /* ROM font          */
#define GET 1
#define GET_ROMCP 2
#define SET 0
#define SETWORD 2

#define INIT_ERROR 1

#define GET_ROM_FONT     2                              /*              @T11 */
#define UPDATE_HARDWARE  1
#define BACKGROUND       0

#define VALID_INITENV_FLAG (UPDATE_HARDWARE/*+INITENV_3xBOX*/)   /*D198,MS??*/

#define CURSOR_TYPE      4
#define CURSOR_POSITION  2
#define VALID_CURSOR_FLAG (UPDATE_HARDWARE+CURSOR_TYPE+CURSOR_POSITION)

#define VARIABLE_BLINK       0x02
#define VARIABLE_OVERSCAN    0x04
#define VARIABLE_UNDERSCORE  0x08
#define VARIABLE_VIDEOENABLE 0x10
#define VARIABLE_DISPLAYMASK 0x20
#define VARIABLE_CODEPAGE    0x40
#define VARIABLE_FORCECP     0x80                               /*      @P1 */
#define VARIABLE_SCROLLRECT  0x100                              /*      @P1 */
#define VARIABLE_SCREENDIM   0x200                              /*      @P1 */
#define VALID_VARIABLE_FLAG ( UPDATE_HARDWARE      + VARIABLE_BLINK      +\
                              VARIABLE_OVERSCAN    + VARIABLE_UNDERSCORE +\
                              VARIABLE_VIDEOENABLE + VARIABLE_DISPLAYMASK +\
                              VARIABLE_CODEPAGE    + VARIABLE_FORCECP    +\
                              VARIABLE_SCROLLRECT  + VARIABLE_SCREENDIM ) /* @P1 */

                                     /* InitEnvironment function */

#define bu_ReadCellStr          2                               /*      @P1 */
#define bu_WriteCellStr         7                               /*      @P1 */
#define BU_PVB_SEL_BIT        0x0001                            /*      @P1 */
#define BU_LVB_SEL_BIT        0x0002                            /*      @P1 */
#define BU_MAX_INDEX              12                            /*      @P1 */
#define BU_PARM_LENGTH            26                            /*      @P1 */

#define NOT_READABLE_HARDWARE  0xFFFF                                  /*@C39*/
#define SAVEREST_HARDWARE 0x02
#define SAVEREST_FULLPVB  0x04
#define SAVEREST_PARTPVB  0x08
#define SAVEREST_VDM      0x10                                         /*@C39*/
#define VALID_SAVEREST_FLAG ( SAVEREST_HARDWARE + SAVEREST_FULLPVB +\
                              SAVEREST_PARTPVB  + SAVEREST_VDM ) /*D198, @C39*/

#define SAVE    0
#define RESTORE 1

#define NOT_MONO    1    /*  xxxxxxxb b = 0 Mono-compatible, b = 1 Other      */
#define GRAPHICS    2    /*  xxxxxxbx b = 0 Text mode, b = 1 Graphics         */
#define NO_CLR_BRST 4    /*  xxxxxbxx b = 1 Color burst disabled              */
#define NATIVE      8    /*  xxxxbxxx b = 1 Native ( advanced function ) mode */
/* No Color burst on VGA, on CGA, color burst on modes 0,2,4 */

/* Flags used for mode data */
#define IGNORE_CLR_BRST  0x0001 /* Disable color burst doesn't make sense for this mode */
#define ENHANCED_MONITOR 0x0002 /* This mode works on EGA only with an enhanced monitor */
#define NOT_PLASMA       0x0008 /* This mode does not work on VGA with PDP monitor */

#define IDC_PLASMA_ONLY  0x0040 /* This mode may be done only on IDC Plasma Display */
#define VDU_DSM_ONLY     0x0080 /* This mode is permitted only on VDU card with DSM monitor */
#define EGA_GT_64K       0x0020 /* This mode may only be done if > 64K EGA video memory */

#define BLINK_BIT 0x08

#define SetMapMask      SETMAPMASK
#define WriteFunction 4

#define AttAddressPort      0x03C0
#define AttDataWritePort    0x03C0
#define AttDataReadPort     0x03C1

#define CRTAddressPort      0x03B4
#define CRTDataPort         0x03B5

#define SeqAddressPort      0x03C4
#define SeqDataPort         0x03C5

#define GraphAddressPort    0x03CE
#define GraphDataPort       0x03CF

#define MiscOutputRegRead   0x03CC
#define MiscOutputRegWrite  0x03C2
#define FeatureControlRead  0x03CA
#define FeatureControlWrite 0x03BA
#define VideoEnableReg      0x03C3
#define DACAddrPortWrite    0x03C8                                      /*@C39*/
#define DACAddrPortRead     0x03C7                                      /*@C39*/
#define CRTColorAddrPort    0x03D4                                      /*@C39*/

#define CRTCtlPort1 0x03B8

#if VDHEGA                                                              /*            */

  #define Graphics1PosReg 0x03CC
  #define Graphics2PosReg 0x03CA

#endif  /*  VDHEGA                                                                    */

#define UNKNOWN 0

#define NONE             0x00
#define ColorAdjustment  0x20

#define Attributes_CMD 1
#define Sequencers_CMD 2
#define CRTCtlRegs_CMD 3
#define Graphics_CMD   4
#define RegOutput_CMD  5

#define Terminate_CMD  0

/*
** OEM Definitions
*/

#define IDCDisplayType          0x1BC6  /* IDC Display type Register            */
#define IDCEnvironReg           0x17C6  /* IDC Environment Register */
#define IDC_SIGNATURE           0xE6    /* IDC Environment Reg Data */
#define IDCMasterModeReg        0x13C6  /* IDC Master Mode Register */
#define IDCExtendedModeReg      0x23C6  /* IDC Extended Mode Register */

#define PARADISE_ID             0x40    /* Paradise VGA Flag bit */


#define DACCmdReg               0x83C6  /*  STARDUST DAC command register */

#define VGA_ENV_REG             0x0F    /*  Environment Status Reg Index */
#define VGA_LOCK                0x00    /*  Value to lock VGA extended regs */
#define VGA_UNLOCK              0x05    /*  Value to unlock VGA extended regs */

#define VGA_CONFIG_REG          0x0B    /*  VGA Configuration Reg */
#define LCD_EXTERNAL            0x08    /*  External/Internal monitor bit */
#define LCD_GRAYSCALE_ADDR      0x09    /*  Gray scale address reg */
#define LCD_GRAYSCALE_DATA      0x0A    /*  Gray scale data reg */

#define VGA_VERSION_REG         0x0C    /*  Silicon Version Reg Index */
#define PROJECT_MASK            0xF8    /*  Project number mask */
#define STARLIGHT132_ID         0x1A    /*  Starlight132 project+version */
#define STARDUST_ID             0x28    /*  Stardust project number */

#define VST_EXTINT      0xCC02          /*  VioGet/SetState function # for */
                                        /*  external monitor switching. */
#define External_Monitor 1              /*  VioGet/SetState parameter values. */
#define Internal_Monitor 0              /*  for external monitor switching. */

#define VST_EXTFLG      0xCC08          /*  VioGet/SetState function # for */
                                        /*  external monitor switching inquire. */
#define Can_Switch    1                 /*  This device can switch. */
#define Cannot_Switch 0                 /*  This device can not switch. */

/*
** Flags bit definition
** WARNING: These are also defined in VDHEQU.INC, be sure to update both files
*/

#define IDC_CGA         0x0001  /*  Dual Mode Plasma Controller */
#define VDU_CGA         0x0002  /*  VDU Controller */
#define DSM_MONITOR     0x0004  /*  Dual Scan Monitor */
#define PARADISE_VGA    0x0008  /*  Paradise VGA adapter */
#define PRISM_VGA       0x0010  /*  Prism LCD VGA adapter */
#define CRYSTAL_VGA     0x0020  /*  Crystal LCD VGA adapter */
#define STARLIGHT_VGA   0x0040  /*  Starlight 132 VGA adapter */
#define STARDUST_VGA    0x0080  /*  Stardust VGA adapter */
#define VGA_E           0x0100  /*  IBM VGA-E adapter */
#define FAST_CGA        0x8000  /*  Don't wait on CGA retrace for screen update */

/*
** Internal/External switchable adapters
*/

#define INT_EXT_ADAPTER (PRISM_VGA | CRYSTAL_VGA)
#define OEM_132_COLUMNS (STARLIGHT_VGA | STARDUST_VGA)

/*
** CMOS Configuration info
*/

#define CMOS_VCFG        0x2D   /*  CMOS address for video config bits */
#define DSM_VCFG         0x01   /*  High resolution monitor */
#define VDU_VCFG         0x04   /*  CGA adapter */
#define CMOS_SYS_ID      0x24   /*  CMOS address for system ID */
#define TRIUMPH_ID       0x26   /*  Prism VGA system */
#define TARGA_ID         0x52   /*  Prism VGA system */
#define CALYPSO_ID       0x55   /*  Crystal VGA system */

/*
** Macros
*/

#define MakeFarPTR(selector,offset) (UCHAR far *)((((long)selector)<<16)+(long)offset)
#define CHECKBUFFER(i) c = PVB.FullAddress[i]; PVB.FullAddress[i] = (c ^= 0xFF);
#define OFFSET(farpointer) (USHORT)(&(farpointer))
#define SEG(farpointer)    (*((USHORT *)&(farpointer) + 1))

/*
** Type definitions
*/

/* BIOS information for EGA */                                          /*@T39*/
typedef struct
{                                                       /*@T39*/
  UCHAR  BIOS_info;                    /* 0040:0087 */                  /*@T39*/
  UCHAR  BIOS_info3;                   /* 0040:0088 */                  /*@T39*/
} EGABIOSINFO;                                                          /*@T39*/


typedef struct
          {                                                     /*      @P1 */
          USHORT Left;                                          /*      @P1 */
          USHORT Top;                                           /*      @P1 */
          USHORT Right;                                         /*      @P1 */
          USHORT Bottom;                                        /*      @P1 */
          } SCRLRECT;                                           /*      @P1 */

typedef struct
          {
          USHORT AddressPort;
          USHORT DataPort;
          USHORT ColorAdjust;
          USHORT Flags;
          } REGADDRESS;

typedef struct
          {
          UCHAR far *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
          } REGDATA;

typedef struct
          {
          USHORT far *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
          } REGDATA2;

typedef struct
          {
          UCHAR   Command;
          REGDATA RegData;
          } REGCMD;

typedef union
          {
          UCHAR far *FullAddress;
          struct {
            USHORT Offset;
            USHORT Selector;
            } part;
          } FarAddress;

typedef struct
          {
          USHORT Row;
          USHORT Column;
          } VIOCURSORPOS;

typedef struct
          {
          UCHAR Red;
          UCHAR Green;
          UCHAR Blue;
          } CLUTDATA;

typedef struct
          {
          FarAddress PVB;             /* Physical starting address       */
          USHORT     PVBLen;          /* Length                          */
          USHORT     Partner;         /* Table index to base font        */
          USHORT     PelColumns;
          USHORT     PelRows;
          USHORT     Flags;           /* PARTIAL: 1, CODEPTS: 2, FULL: 0 */
          USHORT     FirstCodePoint;
          USHORT     NumCodePoints;
          } FONTBUFFER;

#if FONT_SUPPORT                                                        /*            */


typedef struct
          {
          USHORT     PelColumns;
          USHORT     PelRows;
          USHORT     FontData;
          } USERFONT;

typedef struct
        {
        USHORT  ffh_length;     /* Length of Header             */
        USHORT  ffh_flags;      /* CodePage File flags          */
        USHORT  ffh_ptroffset;  /* Offset of first font pointer */
        USHORT  ffh_numfonts;   /* Number of fonts in the file  */
        } FONTFILEHDR;

typedef struct
          {
        USHORT  fh_length;      /* Length of Font Entry         */
        USHORT  fh_hdrlen;      /* Length of Header             */
        USHORT  fh_cpid;        /* CodePage File flags          */
        USHORT  fh_type;        /* Font Type                    */
        USHORT  fh_flags;       /* Font Flags                   */
        UCHAR   fh_cellcols;    /* Columns in character cell    */
        UCHAR   fh_cellrows;    /* Rows in character cell       */
        UCHAR   fh_basecols;    /* Columns in base cell         */
        UCHAR   fh_baserows;    /* Rows in base cell            */
        USHORT  fh_dataoffset;  /* Font data offset from header */
        USHORT  fh_datalen;     /* Length of the font data      */
        USHORT  fh_numpoints;   /* Number of code points        */
        USHORT  fh_lowpoint;    /* Lowest code point            */
        USHORT  fh_highpoint;   /* Highest code point           */
        } FONTHDR;

struct part
  {                                                    /*@C10*/
  USHORT Offset;                                                 /*@C10*/
  USHORT Selector;                                               /*@C10*/
  };                                                             /*@C10*/

typedef union
          {                                                  /*@C10*/
          struct part p;                                         /*@C10*/
          UCHAR  *ptr;                                           /*@C10*/
          } cp_addr;                                             /*@C10*/

#endif  /*  FONT_SUPPORT                                                     */

typedef struct
        {
        USHORT  PageLength;     /* Length of each page                  */
        USHORT  PageReal;       /* Length of each page (Real Mode)   @S4*/
        ULONG   TotalSize;      /* Total size of all pages combined     */
        ULONG   TotalReal;      /* Total size of pages (Real Mode)   @S4*/
        USHORT  BitPlanes;      /* Flag byte of bit planes used         */
        FarAddress Start;
        } MEMORYMAPS;

typedef struct
          {
          USHORT cb;              /* VioGetMode structure              */
          UCHAR  fbType;
          UCHAR  color;
          USHORT col;
          USHORT row;
          USHORT hres;
          USHORT vres;
          UCHAR  fmt_ID;
          UCHAR  attrib;
          UCHAR  MemMap;          /* Index in memory map table         */
          UCHAR  ROMFontIndex;    /* Index in ROM font table           */
          UCHAR  Flags;

#if VDHVGA                                                            /*            */

          UCHAR  CompRegs[4];     /* Unique mode-identifying registers: MiscOut, Att10, Att12, Seq01 */

#endif  /*  VDHVGA                                                                   */

          REGCMD ModeRegs[MAX_MODE_CMDS+1];     /* Register command table            */
          } VIDEOMODE;

typedef struct
          {
          ULONG  far *Flags;              /* ULONG ? */
          USHORT far * far *CallVectorTable;
          } DEV_PARM2;

typedef struct
          {
          ULONG EngineVersion;
          ULONG TableSize;
          } DEV_PARM1;

typedef struct
          {                       /* Real Mode data area (based at 40:0) */
                UCHAR  BIOS_PrinterData[0x10];         /* 0040:0000 */
                USHORT BIOS_equipflag;                 /* 0040:0010 */
                UCHAR  BIOS_Miscellaneous[0x37];       /* 0040:0012 */
                UCHAR  BIOS_crtmode;                   /* 0040:0049 */
                USHORT BIOS_crtcols;                   /* 0040:004A */
                USHORT BIOS_crtlen;                    /* 0040:004C */
                USHORT BIOS_crtstart;                  /* 0040:004E */
                USHORT BIOS_cursorposn[8];             /* 0040:0050 */
                union {
                  USHORT Type;
                  struct {
                    UCHAR EndCursor;
                    UCHAR StartCursor;
                    } CRTReg;
                  } BIOS_cursormode;                   /* 0040:0060 */
                UCHAR  BIOS_activepage;                /* 0040:0062 */
                USHORT BIOS_addr6845;                  /* 0040:0063 */
                UCHAR  BIOS_crtmodeset;                /* 0040:0065 */
                UCHAR  BIOS_crtpalette;                /* 0040:0066 */
                UCHAR  BIOS_SystemData[0x1D];          /* 0040:0067 */
                UCHAR  BIOS_rows;                      /* 0040:0084 */
                USHORT BIOS_points;                    /* 0040:0085 */
                UCHAR  BIOS_info;                      /* 0040:0087 */
                UCHAR  BIOS_info3;                     /* 0040:0088 */
                UCHAR  BIOS_DiskData[0x1F];            /* 0040:0089 */
                struct _VIDEO_PARAMS {
                  char far *VideoTablePtr;
                  struct _EGA_PALETTE {
                    UCHAR Palettes[16]; /* bytes 0 - 15 = palette registers */
                    UCHAR Overscan;     /* byte 16 = overscan register */
                    } far *EGARegs;
                  } far *BIOS_saveptr;                 /* 0040:00A8 */
          } VIDEO_BIOS;

typedef struct
        {
        USHORT  cb     ;
        USHORT  adapter;
        USHORT  display;
        ULONG   cbMemory;
        USHORT  Configuration; /* 1.2 */
        USHORT  DeviceDriver;
        USHORT  Flags;
        ULONG   HWBufferSize;
        ULONG   FullSaveSize;
        ULONG   PartSaveSize;
        USHORT  EMAdaptersOFF;
        USHORT  EMDisplaysOFF;
        USHORT  LEMAdapterdata; /* @BB7 */
        USHORT  EMAdapters;
        USHORT  LEMDisplaydata; /* @BB7 */
        USHORT  EMDisplays;
        } VDHCONFIGINFO;

typedef struct
          {

#if VDHCGA                                                              /*            */

          UCHAR CGAModeControl;
          UCHAR CGAColorSelect; /* Overscan */

/* IDC Only Register State Save Area */                                 /* MS?? */

          UCHAR IDCExtendedMode;  /* Extended Mode */                   /* MS?? */

#endif  /*  VDHCGA                                                                  */

#if VDHMPA                                                              /*            */

          UCHAR MPAModeControl;

#endif  /*  VDHMPA                                                                  */

#if VDHEGA || VDHVGA || VDH8514A                                        /*            */

          UCHAR MiscOutputReg;

          union {
            UCHAR All[0x04+1];
            struct {
              UCHAR Reset;
              UCHAR ClockingMode;
              UCHAR MapMask;
              } Regs;
            } Sequencers;

          union {
            UCHAR All[0x14+1];
            struct {
              UCHAR Palettes[0x0F+1];
              UCHAR ModeControl;
              UCHAR Overscan;
              UCHAR ColorPlane;
              } Regs;
            } Attributes;

          UCHAR GraphicsRegs[0x08+1];

/*
**  Extended graphics registers.  -AJP
*/

#if VDHVGA && !VDHINIT
          UCHAR ExtVGARegs[0x07];
          UCHAR DACCmd;
#endif

#if VDHEGA                                                            /*            */

          UCHAR Graphics1Position;
          UCHAR Graphics2Position;

#endif  /*  VDHEGA                                                                  */

#endif  /*  VDHEGA || VDHVGA || VDH8514A                                            */

          union
            {
            UCHAR All[0x18+1];
            struct {
              UCHAR Others1[10];
              UCHAR CursorStart;
              UCHAR CursorEnd;
              UCHAR Others2[2];
              UCHAR CursorLocHigh;
              UCHAR CursorLocLow;
              UCHAR Others3[4];
              UCHAR Underline;
              } Regs;
            } CRTCtlRegs;

          } HWREGS;

/*
**  Definition of the Environment Block and its flags
*/


#define DEFAULT_ENVFLAGS        0       /*D198*/
#define MODE_SVGA_ENVFLAG       0x8000          /*          */

typedef struct {
          USHORT        ModeDataOFF;
          UCHAR         ModeIndex;    /* Index in Mode table to current mode */
          UCHAR         ROMFontIndex; /* Index in ROM font table or FILLER   */
          VIOMODEINFO   ModeData;     /* ScrollRect must follow ModeData @P1 */
          SCRLRECT      ScrollRect;   /* Scrollable rectangle of text screen @P1 */
          USHORT        AttrBufSize;  /* Byte in an attribute for cur mode   @P1 */
          UCHAR         AttrBuf[4];   /* default attribute for current mode  @P1 */
          USHORT        EnvFlags;     /* Flag word for this environment, D198*/

#if VDHVGA                  /*                     */
                                 /*          */
          USHORT Comp_Reg;       /*          */
          USHORT XGA_PRESENT;    /*          */   /* @816 */
          USHORT PelRows;        /*            */
          USHORT PelColumns;     /*            */
          USHORT SVGAMode;       /*            */
#endif  /*  VDHVGA                                 */

#if VDH8514A                                                            /*            */

          ULONG         DisplayMask;
          USHORT        NATIVE_MODE;  /* True if native mode, false if VGA passthru */
          USHORT        VGAEnvironment; /* Start of VGA environment for chaining */

#else

          USHORT        CursorAttribute;
          HWREGS        Hardware;

#if VDHVGA                                                              /*            */

          CLUTDATA      LookupTable[0xFF+1];    /* 0x00 - 0xFF */

#endif  /* VDHVGA            @C21  moved so VideoEnable included for VGA            */

#if !(VDHVGA || VDH8514A)             /* Shadow ScanLines on non-VGA,@B10,          */

          USHORT EGAShadowTopScanLine;                                  /*@B10*/

#endif  /* !(VDHVGA || VDH8514A)                                   @B10,           */


          USHORT   VideoEnable;


#if FONT_SUPPORT                                                        /*            */

          UCHAR far *ActiveFontPTR;
          short  CodePageID; /* xxx - SELECTABLE,  0 - NOT_SELECTABLE */
          short  UserFont;   /* -1  - SELECTABLE, -2 - NOT_SELECTABLE */
          USHORT NumUSERFonts; /* These must remain at end of environment!!!! */
          USHORT USERFonts;    /* USER fonts will start here                  */

#endif  /*  FONT_SUPPORT                                                            */

#endif  /*  VDH8514A                                                                */

          } ENVIRONMENT;

/* @C10 #ifdef ROMFONT_SUPPORT */
#if FONT_SUPPORT                                                   /*@C10,          */

typedef struct                  /* PTM 2895                     */
        {                       /* To create table of ROM and   */
        USHORT  CodePageID;     /*  code page fonts to search   */
        USHORT  PelRows;        /*  to get a font               */
        USHORT  PelColumns;
/*************************************@C10 union {*/
        UCHAR far * FontPTR;                                            /*@C10*/
/*************************************@C10        FarAddress RFont_Address;*/
/*************************************@C10              } fontu;*/
        USHORT  BaseRows;                                               /*@C10*/
        USHORT  BaseColumns;                                            /*@C10*/
/*************************************@C10        union {*/
        UCHAR far * BaseFontPTR;                                        /*@C10*/
/*************************************@C10         FarAddress RBase_Address;*/
/*************************************@C10               } baseu;*/
        } ROMCP_TABLE;

typedef union                                                        /*@C10*/
          {
          struct part p;                                             /*@C10*/
          ROMCP_TABLE *ptr;                                          /*@C10*/
          } rcp_addr;                                                /*@C10*/

#endif  /*  FONT_SUPPORT                                                   */

/*****************************************************************************/
/* VDH Routine Type Definitions */
/*****************************************************************************/

typedef struct
          {
          USHORT Length;
          USHORT Flags;
/* @P1    USHORT ByteTableLen; */
/* @P1    USHORT ByteTableOFF; */
          USHORT CellTableLen;
          USHORT CellTableOFF;
          } VDH_DBCS;

typedef struct
          {
          USHORT   Length;
          USHORT   Flags;
          CLUTDATA far *LookupTable; /* 0x00 - 0xFF */
          USHORT   FirstEntry;
          USHORT   NumEntries;
          } VDH_CLUT;

typedef struct
          {
          USHORT Length;
          USHORT Flags;
          USHORT Row;
          USHORT Column;
          USHORT TopScanLine;
          USHORT BottomScanLine;
          USHORT Width;
          USHORT Attribute;
          } VDH_CURSOR;

typedef struct
          {
          USHORT     Length;
          USHORT     Flags;
          UCHAR far *FontBuffer;
          USHORT     FontLength;
          USHORT     PelColumns;
          USHORT     PelRows;
          } VDH_FONT;

typedef struct
          {
          USHORT Length;
          USHORT Flags;
          USHORT Blink;
          USHORT Overscan;
          USHORT Underscore;
          USHORT VideoEnable;
          ULONG  DisplayMask;
          USHORT CodePageID;
          USHORT ScrlLeft;                                      /*      @P1 */
          USHORT ScrlTop;                                       /*      @P1 */
          USHORT ScrlRight;                                     /*      @P1 */
          USHORT ScrlBottom;                                    /*      @P1 */
          USHORT ScreenRows;                                    /*      @P1 */
          USHORT ScreenCols;                                    /*      @P1 */
          } VDH_VARIABLE;

typedef struct
          {
          USHORT       Length;
          USHORT       Flags;
          PVIOMODEINFO ModeDataPTR;
          } VDH_MODE;

typedef struct
          {
          USHORT     Length;
          USHORT     Flags;
          REGDATA2   PaletteBuffer;
          } VDH_PALETTE;

typedef struct
          {
          USHORT      Length;
          USHORT      Flags;
          PVIOPHYSBUF PVBDataPTR;
          } VDH_GETPVB;

typedef struct
          {                   /* alternate VIOPHYSBUF structure used */
          USHORT      cb;          /* if 0 length passed in primary       */
          SEL         asel[2];     /* VIOPHYSBUF structure                */
          } ALT_VIOPHYSBUF;

typedef struct
          {
          USHORT Length;
          USHORT Flags;
          USHORT LDTSelector;
          } VDH_FREEPVB;

typedef struct
          {
          USHORT         Length;
          USHORT         Flags;
          VDHCONFIGINFO far *ConfigDataPTR;
          } VDH_CONFIG;

typedef struct
          {
          USHORT Length;
          USHORT Flags;
          } VDH_INITENV;

typedef struct
          {
          USHORT Length;
          USHORT Flags;
          USHORT PVBHugeSEL;
          } VDH_SAVEREST;

typedef struct
          {
          USHORT     Length;
          USHORT     Flags;
          UCHAR far *AppDataAddr;
          UCHAR far *AppCellAddr;
          USHORT     Index;
          USHORT     StartRow;
          USHORT     StartCol;
          USHORT     SecondRow;
          USHORT     SecondCol;
          USHORT     RepeatFactor;
          USHORT     LogicalBufSel;
          } VDH_BUFUP;

typedef struct
          {                                                /*      @P1 */
          USHORT     Length;                                    /*      @P1 */
          USHORT     Flags;                                     /*      @P1 */
          UCHAR      FormatId;                                  /*      @P1 */
          UCHAR      AttrCount;                                 /*      @P1 */
          USHORT     LVBWidth;                                  /*      @P1 */
          USHORT     LVBHeight;                                 /*      @P1 */
          ULONG      LVBSize;                                   /*      @P1 */
          USHORT     AttrBufSize;                               /*      @P1 */
          UCHAR far *AttrBufAddr;                               /*      @P1 */
          } VDH_LVB;                                            /*      @P1 */

typedef struct
          {                                                      /*          */
          USHORT  Length;                                             /*          */
          USHORT  Flags;                                              /*          */
          ULONG   OEMData;      /* OEM defines what this data is */   /*          */
          } VDH_STATE;

typedef struct                   /* Internal/External Monitor */        /* MS?? */
          {                      /* Switching Request Block   */        /* MS?? */
          USHORT  OEMLength;     /* 6 */                                /* MS?? */
          USHORT  OEMFunction;   /* 0xCC02 */                           /* MS?? */
          USHORT  OEMData1;      /* 0 = Internal, 1 = External */       /* MS?? */
          } OEM_STATE_BLOCK;                                            /* MS?? */

/*
** VDH Routine Entry Points
*/

USHORT EXPENTRY DevEnable(       DEV_PARM2 far *,   DEV_PARM1 far *,    ULONG );
USHORT EXPENTRY BufferUpdate(    ENVIRONMENT far *, VDH_BUFUP far *,    ULONG );
USHORT EXPENTRY GetDBCSInfo(     ENVIRONMENT far *, VDH_DBCS far *,     ULONG );
USHORT EXPENTRY GetColorLookup(  ENVIRONMENT far *, VDH_CLUT far *,     ULONG );
USHORT EXPENTRY SetColorLookup(  ENVIRONMENT far *, VDH_CLUT far *,     ULONG );
USHORT EXPENTRY GetCursorInfo(   ENVIRONMENT far *, VDH_CURSOR far *,   ULONG );
USHORT EXPENTRY SetCursorInfo(   ENVIRONMENT far *, VDH_CURSOR far *,   ULONG );
USHORT EXPENTRY GetCurrentFont(  ENVIRONMENT far *, VDH_FONT far *,     ULONG );
USHORT EXPENTRY SetCurrentFont(  ENVIRONMENT far *, VDH_FONT far *,     ULONG );
USHORT EXPENTRY GetVariableInfo( ENVIRONMENT far *, VDH_VARIABLE far *, ULONG );
USHORT EXPENTRY SetVariableInfo( ENVIRONMENT far *, VDH_VARIABLE far *, ULONG );
USHORT EXPENTRY GetMode(         ENVIRONMENT far *, VDH_MODE far *,     ULONG );
USHORT EXPENTRY SetMode(         ENVIRONMENT far *, VDH_MODE far *,     ULONG );
USHORT EXPENTRY GetPaletteReg(   ENVIRONMENT far *, VDH_PALETTE far *,  ULONG );
USHORT EXPENTRY SetPaletteReg(   ENVIRONMENT far *, VDH_PALETTE far *,  ULONG );
USHORT EXPENTRY GetPhysBuf(      ENVIRONMENT far *, VDH_GETPVB far *,   ULONG );
USHORT EXPENTRY FreePhysBuf(     ENVIRONMENT far *, VDH_FREEPVB far *,  ULONG );
USHORT EXPENTRY RetConfigInfo(   ENVIRONMENT far *, VDH_CONFIG far *,   ULONG );
USHORT EXPENTRY InitEnv(         ENVIRONMENT far *, VDH_INITENV far *,  ULONG );
USHORT EXPENTRY SaveEnv(         ENVIRONMENT far *, VDH_SAVEREST far *, ULONG );
USHORT EXPENTRY RestoreEnv(      ENVIRONMENT far *, VDH_SAVEREST far *, ULONG );
USHORT EXPENTRY ChainRouter(     ENVIRONMENT far *, char far *,         ULONG );
USHORT EXPENTRY GetLVBInfo(      ENVIRONMENT far *, VDH_LVB far *,      ULONG );
USHORT EXPENTRY GetState( ENVIRONMENT far *, VDH_STATE far *, ULONG ); /*          */
USHORT EXPENTRY SetState( ENVIRONMENT far *, VDH_STATE far *, ULONG ); /*          */

#if DEBUG
USHORT EXPENTRY DEBUG_TRACE(ENVIRONMENT far *, char far *, ULONG );
#endif  /*  DEBUG */


/*
** Private interfaces
*/

USHORT        near     PhysToUVirt( FarAddress, FarAddress far *, USHORT );      /*@T30*/ /*@B15*/
void          near     FreePhysToUVirt( USHORT );                                         /*@B15*/
USHORT PASCAL near     SaveRestorePVB( VDH_SAVEREST far *, USHORT, UCHAR far *, ENVIRONMENT far * ); /*@B15*/
void   PASCAL near     SaveRestoreHW( ENVIRONMENT far *, USHORT ); /*@B15*/
USHORT PASCAL near     GetModeIndex( ENVIRONMENT far * ); /*@B15*/
void                   Transfer( FarAddress *, FarAddress *, USHORT, USHORT ); /*@B15*/
USHORT        far      Query8514A( void );
USHORT        far      QueryXGA ( void );                               /*@T72*/
USHORT        far      HardwareRows( void );
USHORT        far      HardwareColumns( void );
USHORT        far      HardwareColor( void );
void          far      CharFontBegin( void );
void   EXPENTRY        CharFontEnd( UCHAR );
void          far      AccessFont( UCHAR far *, UCHAR far *, USHORT, USHORT, UCHAR far *, USHORT, UCHAR );
short  PASCAL near     ExamineConfig( void ); /*@B15*/
void   PASCAL near     LeaveNativeMode( void ); /*@B15*/
USHORT PASCAL near     SetHWMode( UCHAR, USHORT, ENVIRONMENT far * ); /*@B15,@T53*/
USHORT PASCAL near     SetHWFont( ENVIRONMENT far *, UCHAR far *, UCHAR far * ); /*@B15,@T53*/
void   PASCAL near     SetHWFontRegs( ENVIRONMENT far *, USHORT );   /*@tb35ff*/
void   PASCAL near     SetEnvMode( UCHAR, ENVIRONMENT far *, ENVIRONMENT far *, USHORT ); /*@B15,@T70*/
USHORT PASCAL near     BitNum( USHORT ); /*@B15*/
UCHAR  PASCAL near     FindFont( USHORT, USHORT, ENVIRONMENT far * ); /*@B15*/
void   EXPENTRY        SetMapMask( USHORT, USHORT );
void   EXPENTRY        AccessCursorPos(   USHORT, USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessCursorType(          USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessBlink(               USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessOverscan(            USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessUnderscore(          USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessVideoEnable(         USHORT, USHORT, USHORT far * );
void   EXPENTRY        AccessDisplayMask(                 USHORT, ULONG  far * );
void   EXPENTRY        AccessCLUT( USHORT, CLUTDATA far * far * );
void   EXPENTRY        AccessHardware( REGADDRESS far *, USHORT, USHORT, USHORT,  REGDATA far * );
void   EXPENTRY        AccessRegister( REGADDRESS far *, USHORT, UCHAR far * );
void   EXPENTRY        SET132( USHORT, USHORT );                        /*          */
USHORT EXPENTRY        QUERY132( VOID );                                /*          */
USHORT        near     getVideoType( void );                            /*@T39*/
int    PASCAL near     videoIoctl(UCHAR *, UCHAR *, unsigned);          /*@T39*/
USHORT PASCAL near     getEGAinfo(EGABIOSINFO *);                       /*@T39*/
void   PASCAL  near    GetCodePage( VOID ); /*@B15*/                                         /*@C10*/
USHORT EXPENTRY        LVB3PVBTransfer( ENVIRONMENT far *, VDH_SAVEREST far *,USHORT);
void   PASCAL  near    SetTextGrays(ENVIRONMENT far *);
USHORT PASCAL  near    IntExtState(USHORT);
UCHAR  PASCAL  near    ReadCMOS (UCHAR);

