;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    58,132
        TITLE   IDHMODE.Asm -- Windowable Device Handler Mode Routines

;/*****************************************************************************
;*
;* SOURCE FILE NAME = IDHMODE.Asm
;*
;* DESCRIPTIVE NAME = Windowable Device Handler Mode Routines 
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  This module contains the equivalent of the OS/2 1.1   
;*              hooks for Windowable and Advanced VIO.                
;*
;* FUNCTIONS    GetMode, SetMode
;*
;* NOTES        NONE
;*             
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   08/18/89  @S25       B706860 STJ, Use 1.0 length as default for GetXXXX         
;*                                calls
;****************************************************************************/

        .xlist
        INCLUDE idhequ.inc              ;Install Device Handler Equates
        INCLUDE bvsparms.inc            ;BVS Parameter Equates
        INCLUDE error2.inc              ;CP/DOS Error Codes
        INCLUDE struc.inc               ;Structured Macros
        .list

        extrn   RegSave:NEAR
        extrn   RegRest:NEAR
        extrn   SetCurPos:FAR

R2CSEG  SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:R2CSEG

;/****************************************************************************
;*                                                                     
;*  SUBROUTINE NAME: GetMode                                           
;*                                                                     
;*  DESCRIPTIVE NAME: Get current video mode setting                   
;*                                                                     
;*  FUNCTION: GetMode is called by BVS to get the current mode setting.
;*            If the request specifies hardware and the hardware is    
;*            readable, the actual hardware setting will be read and   
;*            returned.  Otherwise the returned information will be    
;*            taken from the environment buffer, if it has been passed.
;*                                                                     
;*  ENTRY POINT: GetMode                                               
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 271 )  
;*                                                                     
;*  INPUT: (Passed on stack)                                           
;*             FAR *Environment ( Environment buffer for the session ) 
;*             FAR *ParmBlock                                          
;*                     USHORT Length = length of this packet           
;*                     USHORT Flags  = 0 - Environment buffer only     
;*                                     1 - Hardware also               
;*                     VIOMODEINFO FAR *ModeDataPTR                    
;*             ULONG Function ( Call vector table entry = 271 )        
;*         (Referenced)                                                
;*             Modes[] (global data - table of supported video modes ) 
;*                                                                     
;*  EXIT-NORMAL: AX = 0                                                
;*               Current mode setting is returned                      
;*                                                                     
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS                           
;*                                                                     
;*  EFFECTS: If hardware specified and hardware is readable, the       
;*           environment buffer is updated, if passed.                 
;*                                                                     
;*  INTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;*  EXTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;****************************************************************************/

GetMode PROC    FAR
        public  GetMode
        Call    RegSave

        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength eq 8> and
        les     di,dword ptr [si].vp_offset ;Get address of mode data
        lds     si,dword ptr [bp].stk_envblock ;Get environment block
        add     si,[si].env_modeoffset  ;Get offset of mode data
        mov     cx,es:[di].mode_datalen ;Get length of mode data
        .if     <cx a 1>

            mov     ax,cx
            .if     <al a <size modedata>> ;@S25
                mov     al,mode_attrformat ;@S25
            .endif                      ;@S25

            push    di
            sub     al,size mode_datalen
            .if     <ns>
                movsw
            .endif

            sub     al,size mode_type
            .if     <ns>
                movsb
            .endif

            sub     al,size mode_colors
            .if     <ns>
                movsb
            .endif

            sub     al,size mode_cols
            .if     <ns>
                movsw
            .endif

            sub     al,size mode_rows
            .if     <ns>
                movsw
            .endif

            sub     al,size mode_gcols
            .if     <ns>
                movsw
            .endif

            sub     al,size mode_grows
            .if     <ns>
                movsw
            .endif

            sub     al,size mode_attrformat
            .if     <ns>
                movsb
            .endif

            sub     al,size mode_attrbytes
            .if     <ns>
                movsb
            .endif

            sub     al,size mode_bufaddr
            .if     <ns>
                movsw
                movsw
            .endif

            sub     al,size mode_bufsize
            .if     <ns>
                movsw
                movsw
            .endif

            sub     al,size mode_fullbufsz
            .if     <ns>
                movsw
                movsw
            .endif

            sub     al,size mode_partbufsz
            .if     <ns>
                movsw
                movsw
            .endif

            sub     al,size mode_extdata
            .if     <ns>
                movsw
                movsw
            .endif

            mov     ax,di
            pop     di
            sub     ax,di
            .if     <al a 2>            ;More than just a length request
                stosw                   ;Update length in Mode data
            .endif

            sub     ax,ax               ;Set good return code
        .endif

        Call    RegRest
        ret     12
GetMode ENDP

;/****************************************************************************
;*                                                                     
;*  SUBROUTINE NAME: SetMode                                           
;*                                                                     
;*  DESCRIPTIVE NAME: Set video mode                                   
;*                                                                     
;*  FUNCTION: SetMode is called by BVS to set the video mode.          
;*            If the request specifies hardware, the hardware and the  
;*            environment buffer, if passed, will be updated.          
;*            Otherwise just the environment buffer, if passed, will   
;*            be updated.                                              
;*                                                                     
;*  ENTRY POINT: SetMode                                               
;*    LINKAGE:   CALL FAR ( via BVS-DDI call vector table entry 272 )  
;*                                                                     
;*  INPUT: (Passed on stack)                                           
;*             FAR *Environment ( Environment buffer for the session ) 
;*             FAR *ParmBlock                                          
;*                     USHORT Length = length of this packet           
;*                     USHORT Flags  = 0 - Environment buffer only     
;*                                     1 - Hardware also               
;*                     VIOMODEINFO FAR *ModeDataPTR                    
;*             ULONG Function ( Call vector table entry = 272 )        
;*         (Referenced)                                                
;*             Modes[] (global data - table of supported video modes ) 
;*                                                                     
;*  EXIT-NORMAL: AX = 0                                                
;*               Video mode is set                                     
;*                                                                     
;*  EXIT-ERROR: AX = ERROR_VIO_INVALID_PARMS                           
;*                                                                     
;*  INTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;*  EXTERNAL REFERENCES:                                               
;*    ROUTINES: NONE                                                   
;*                                                                     
;****************************************************************************/

SetMode PROC    FAR
        public  SetMode
        Call    RegSave

        mov     ax,ERROR_VIO_INVALID_LENGTH
        .if     <[si].vp_parmlength eq 8> and
        lds     si,dword ptr [si].vp_offset ;Get address of mode data
        mov     cx,[si].mode_datalen    ;Get length of mode data
        .if     <cx ae 3> and
        mov     ax,ERROR_VIO_MODE       ;Preset mode error
        test    [si].mode_type,mode_f_graphics
        .if     <z>                     ;Mode type = Text
            .if     <cx b mode_cols+2> or
            .if     <[si].mode_cols eq 80> ;80-column modes only
                .if     <cx b mode_rows+2> or
                .if     <[si].mode_rows eq 25> ;25-row modes only
                    mov     es:[di].env_row,bx
                    mov     es:[di].env_col,bx
                    Call    SetCurPos   ;Home the cursor
                    sub     ax,ax
                .endif
            .endif
        .endif

        Call    RegRest
        ret     12
SetMode ENDP

R2CSEG  ENDS
        END

