;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = IDHEQU.INC
;*
;* DESCRIPTIVE NAME = Definitions for IDH routines
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  Definitions for IDH routines 
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   01/11/89              P2986   enhance config and codepage support
;*   03/25/89              132     DCR 132 changes
;*   03/25/89              204     DCR 204
;*   07/15/89              B784056 Remove hardware dependencies in VDHINIT  
;*   09/26/89              B785912 Change default attribute to 07,
;*   01/24/90              704     2.0 unique - DCR 704 work
;*   07/23/90              1295    DCR 1295 - Support recognition of XGA device
;*   07/31/90              B790152 Return correct number of bytes in LVB,
;*
;*****************************************************************************/

                .286p                             ;Generate protect mode code

IDHGSEG         equ     <_DATA>                   ;Default DGROUP name for C ;          

;/*
;** Equates used by the Windowable Device Handler
;*/

;/*
;** Stack frame used by all IDH routines
;*/

stackframe      STRUC                             ;VDH Stack Frame

stk_reges       dw      ?                         ;Reg ES save area
stk_regds       dw      ?                         ;Reg DS save area
stk_regdi       dw      ?                         ;Reg DI save area
stk_regsi       dw      ?                         ;Reg SI save area
stk_regbp       dw      ?                         ;Reg BP save area
stk_regsp       dw      ?                         ;Reg SP save area
stk_regbx       dw      ?                         ;Reg BX save area
stk_regdx       dw      ?                         ;Reg DX save area
stk_regcx       dw      ?                         ;Reg CX save area
stk_regax       dw      ?                         ;Reg AX save area
stk_flags       dw      ?                         ;Reg FL save area
stk_retaddr     dd      ?                         ;Return Address
stk_function    dd      ?                         ;Function Number
stk_parmblock   dd      ?                         ;Parameter Block Address
stk_envblock    dd      ?                         ;Environment Block Address

stackframe      ENDS

;/*
;** Structure used to determine video hardware configuration ;         - Begin
;*/

Vhardware STRUC

;/*
;**  WARNING: this structure is also defined in VDH.H, be sure
;**           to update both structures when changing this one
;*/

        fVideoType DW ?                          ; video hardware configuration
        display    DW ?                          ; display type  (not used by BVHINIT)
        memory     DD ?                          ; memory configuration
        Reg_132    DW ?                          ; VGA-E 132 col. (not used by BVHINIT)
        popupMode  DB ?                          ; popup mode  (not used by BVHINIT)
Vhardware ENDS

;/*
;**  Bit defintions for fVideoType
;*/

MPA_BIT            EQU 1      ; bit 0, MPA adapter with MONO monitor
CGA_BIT            EQU 2      ; bit 1, CGA adapter with COLOR monitor
EGM_BIT            EQU 4      ; bit 2, EGA adapter with MONO monitor
EGC_BIT            EQU 8      ; bit 3, EGA adapter with COLOR monitor
EGA_BIT            EQU 10h    ; bit 4, EGA adapter with ENHANCED COLOR monitor
VGP_BIT            EQU 20h    ; bit 5, VGA plasma display
VGM_BIT            EQU 40h    ; bit 6, VGA adapter with MONO monitor
VGC_BIT            EQU 80h    ; bit 7, VGA adapter with COLOR monitor
A8514M_BIT         EQU 100h   ; bit 8, 8514A with 8507 monitor
A8514C_BIT         EQU 200h   ; bit 9, 8514A with 8512/3 monitor
A8514A_BIT         EQU 400h   ; bit 10, 8514A with 8514 monitor
A8514_15_BIT       EQU 800h   ; bit 11, 8514A with 8515 monitor
A8514_03_BIT       EQU 1000h  ; bit 12, 8514A with Monochrome 8503 monitor
NODISPLAY_BIT      EQU 2000h  ; bit 13, no display present on VGA system
XGA_BIT            EQU 4000h  ; bit 14, XGA adapter present  ;          

;/*
;** Bit defintions for fVideoMemory
;**  bits 0 and 1 reflect memory configuation for EGA or 8514A
;**
;**        0 0  - minimum memory, EGA = 64K, 8514A = .5M
;**        0 1  - EGA = 128K
;**        1 0  - EGA = 192K
;**        1 1  - maximum memory, EGA = 256K, 8514A = 1M
;*/

MEM_EGA64K      EQU 0000h
MEM_EGA128K     EQU 0001h
MEM_EGA192K     EQU 0002h
MEM_EGA256K     EQU 0003h
MEM_A85141MEG   EQU 0003h

;/*
;**  All possible VGA configurations
;*/

VGA_BITS         EQU VGP_BIT+VGM_BIT+VGC_BIT+NODISPLAY_BIT
A8514_BITS       EQU A8514M_BIT+A8514C_BIT+A8514A_BIT+A8514_15_BIT+A8514_03_BIT

                                                     ;         - End

;/*
;** Structure of the global data used by IDH, IDHGSEG
;*/

idhglobal       STRUC

idh_ioport      dw      0                         ;I/O Port for Video Updates

idh_codepage    dw      0                         ;Current codepage id ;        
idh_fontsize    dw      8                         ;8x8 Font is default ;        

idh_selector    dw      0                         ;CDIB/Work Buffer selector ;        
idh_handle      dw      0                         ;Font file handle ;        

idh_scratch     dd      0                         ;Scratch area ;        

idh_cdib        db      '\SHAREMEM\DOS\CDIB',0 ;CDIB name ;        

idh_scr         db      '\DEV\SCREEN$',0 ;Name of Screen Device Driver  ;        

idhglobal       ENDS

idhenvironment  STRUC

env_modeoffset  dw      2                         ;Offset of mode data

env_mdlen       dw      34                        ;Length of mode data (=34)
env_type        db      1                         ;Type for Mode
env_colors      db      4                         ;Colors for Mode
env_cols        dw      80                        ;Number of screen columns for text
env_rows        dw      25                        ;Number of screen rows for text
env_gcols       dw      640                       ;Number of screen columns for graphics
env_grows       dw      200                       ;Number of screen rows for graphics
env_attrformat  db      0                         ;Attribute format
env_attrbytes   db      1                         ;Number of attribute bytes ;          
env_bufaddr     dd      000B8000h                 ;Address of video buffer
env_bufsize     dd      00000FA0h                 ;Size of video buffer
env_fullbufsz   dd      00000FA0h                 ;Full buffer save size
env_partbufsz   dd      00000FA0h                 ;Partial buffer save size
env_extdata     dd      0                         ;Extended mode data address
env_rectleft    dw      0                         ;Scrolling rectangle ;          
env_recttop     dw      0                         ;Scrolling rectangle ;          
env_rectright   dw      79                        ;Scrolling rectangle ;          
env_rectbottom  dw      24                        ;Scrolling rectangle ;          

env_row         dw      0                         ;Cursor Row
env_col         dw      0                         ;Cursor Column
env_startline   dw      6                         ;Cursor Startline
env_endline     dw      7                         ;Cursor Endline
env_width       dw      1                         ;Cursor Width
env_attr        dw      1                         ;Cursor Attribute

env_scrlleft    dw      0                         ;Scrollable Screen Rect  ;          
env_scrltop     dw      0                         ;Scrollable Screen Rect  ;          
env_scrlright   dw      79                        ;Scrollable Screen Rect  ;          
env_scrlbottom  dw      24                        ;Scrollable Screen Rect  ;          

env_attrbufsiz  dw      1                         ;          
env_attrbuf     db      07                        ;default attribute                         
                db      0                         ;second byte of 3 byte attribute;          
                db      0                         ;third byte of 3 byte attribute ;          
                db      0                         ;waste byte to keep structure aligned
idhenvironment  ENDS

hardwareports   STRUC                             ;Generic Video Hardware Port Equates

hp_hchartotal   db      ?                         ;Horizontal Characters Total
hp_hchardspl    db      ?                         ;Horizontal Characters Displayed
hp_hsyncpos     db      ?                         ;Horizontal Sync Position
hp_hsyncwidth   db      ?                         ;Horizontal Sync Width
hp_vchartotal   db      ?                         ;Vertical Characters Total
hp_vtotaladj    db      ?                         ;Vertical Total Adjustment
hp_vchardspl    db      ?                         ;Vertical Characters Displayed
hp_vsyncpos     db      ?                         ;Vertical Sync Position
hp_interlace    db      ?                         ;Interlace Mode
hp_maxscanline  db      ?                         ;Maximum Scan Line
hp_cursorstart  db      ?                         ;Starting Cursor Scan Line
hp_cursorend    db      ?                         ;Ending Cursor Scan Line
hp_startaddrh   db      ?                         ;Starting Address (High)
hp_startaddrl   db      ?                         ;Starting Address (Low)
hp_cursoraddrh  db      ?                         ;Cursor Address (High)
hp_cursoraddrl  db      ?                         ;Cursor Address (Low)

hardwareports   ENDS

;/*
;**  Structure defining the BIOS data area ;        
;*/

realdata        STRUC                             ;Real Mode data area (based at 40:0)
                db      00010h dup (?)
real_equipflag  dw      ?                         ;Bios Equipment Flag
                db      00037h dup (?)
real_crtmode    db      ?                         ;Bios Video Mode
real_crtcols    dw      ?                         ;Bios Video Columns
real_crtlen     dw      ?                         ;Bios Video Length
real_crtstart   dw      ?                         ;Bios Video Start Address
real_cursorposn dw      8 dup (?)                ;Bios Cursor Positions
real_cursormode dw      ?                         ;Bios Cursor Mode
real_activepage db      ?                         ;Bios Active Video Page
real_addr6845   dw      ?                         ;Bios Video Port Address
real_crtmodeset db      ?                         ;Bios Video Mode Control Register
real_crtpalette db      ?                         ;Bios Palette
                db      0001Dh dup (?)
real_rows       db      ?                         ;Bios Video Rows
real_points     dw      ?                         ;Bios Video Font Pels
real_info       db      ?                         ;Bios EGA Info Byte
real_info3      db      ?                         ;Bios EGA Info3 Byte
                db      0001Fh dup (?)
real_saveptr    dd      ?                         ;Bios Video Save Area Pointer
realdata        ENDS                              ;        

real_f_cgaemu   equ     01h                       ;INFO byte, CGA emulation flag

;/*
;**  Structure defining the ABIOS Request Block ;        
;*/


ABIOS_Request_Block     STRUC                     ;        

ABIOS_RB_Len            dw                       0 ;+00h
ABIOS_DevId             dw                       0 ;+02h
ABIOS_Unit              dw                       0 ;+04h
ABIOS_Func              dw                       0 ;+06h
ABIOS_RBFlags           dw                       0 ;+08h
ABIOS_ELOff             dw                       0 ;+0Ah
ABIOS_RetCode           dw                       0 ;+0Ch
ABIOS_TimeOut           dw                       0 ;+0Eh
ABIOS_DataPtr1x         dw                       0 ;+10h
ABIOS_DataPtr1l         dw                       0 ;+12h
ABIOS_DataPtr1h         dw                       0 ;+14h
                        dw                       0
ABIOS_Count             dw                       0 ;+18h
ABIOS_DevCntlFlag       dw                       0 ;+1Ah
ABIOS_ScanLines         db                       0 ;+1Ch
ABIOS_CharGenType       db                       0 ;+1Dh
ABIOS_VideoMode         dw                       0 ;+1Eh
ABIOS_MonitorType       dw                       0 ;+20h
ABIOS_CharHeight        dw                       0 ;+22h
ABIOS_Map2Block         dw                       0 ;+24h
ABIOS_UpdateFontFlag    dw                       0 ;+26h
ABIOS_CharOffset        dw                       0 ;+28h
ABIOS_FontDataSize      dw                       0 ;+2Ah
ABIOS_Environment       dw                       0 ;+2Ch
ABIOS_SR_Header_Size    dw                       0 ;+2Eh
ABIOS_SR_Hdw_Size       dw                       0 ;+30h
ABIOS_PaletteReg        dw                       0 ;+32h
ABIOS_PaletteValue      dw                       0 ;+34h
                        dw                       0 ;+36h
                        dw                       0 ;+38h
                        dw                       0 ;+3Ah
                        dw                       0 ;+3Ch
                        dw                       0 ;+3Eh = Padding for future use

ABIOS_Request_Block     ENDS                      ;        

