;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;*****************************************************************/
;*                                                               */
;*                                                               */
;*****************************************************************/
;**********************************************************************
;*  This section defines all the structures used.                     *
;**********************************************************************

Event_Packet  Struc
Event         dw     ?     ; mouse event
Col_Mov       dw     ?     ; column movement
Row_Mov       dw     ?     ; row movement
Event_Packet  EndS

Abs_Packet  Struc
AEvent        dw     ?
Row_Pos       dw     ?
Col_Pos       dw     ?
Row_Size      dw     ?
Col_Size      dw     ?
Abs_Packet  EndS

Dev_Data      Struc
CfgDataLen    dw     ?     ; length of data (7)
NumMics       db     ?     ; number mickeys/cm
NumButt       db     ?     ; number of buttons
IRQ           db     ?     ; IRQ level
MouseType     db     ?     ; !! mouse type attached           (KD)
ComPortNum    db     ?     ; 
Dev_Data      EndS

CFGDATLEN     EQU    size Dev_Data

;*********************************************************************
;*     Device Independent/Dependent IDC function equates.           *
;*********************************************************************

QUERYCONFIG     EQU     1        ; Query config function
READENABLE      EQU     2        ; Read enable function
READDISABLE     EQU     3        ; read disable function
ENABLEDEVICE    EQU     4        ; enable the mouse device function
DISABLEDEVICE   EQU     5        ; disable the mouse device function

PROCESSPACKET   EQU     1        ; process interrupt packet function
DISABLESUPPORT  EQU     2        ; disable all support function
PROCESSABSOLUTE EQU     3        ; process interrupt packet function
QUERYCAPS       EQU     7        ; query Mouse$ capabilities
RPTEXTITF       EQU     8        ; report extended interface
QUERYACTIVITY   EQU     9        ; query locator activity

;***************************************************
;*  This section defines MOUSE$ capability flags
;***************************************************
EIQ_CAP  EQU 1
MPX_CAP  EQU 2

;**************************** Buttons and Events *****************************
BUTTON_NONE             equ     0
BUTTON_1                equ     1
BUTTON_2                equ     2
BUTTON_3                equ     4

; locator event mask bits
EV_NONE                 equ     0000h
EV_MOVE                 equ     0001h
EV_BUTTON1_MOVE         equ     0002h
EV_BUTTON1              equ     0004h
EV_BUTTON2_MOVE         equ     0008h
EV_BUTTON2              equ     0010h
EV_BUTTON3_MOVE         equ     0020h
EV_BUTTON3              equ     0040h
EV_LOC_SMOVE            equ     0100h
EV_LOC_EXT_BUTTON       equ     0200h
EV_BUTTON1_CHANGED      equ     0400h
EV_BUTTON2_CHANGED      equ     1000h
EV_BUTTON3_CHANGED      equ     4000h
EV_END_PROX             equ     0080h

EV_DEVICESTATE_MASK     equ     EV_BUTTON1 OR EV_BUTTON2 OR EV_BUTTON3

;/* combinations, if any of the above is changed, change the following */
EV_ANY_STAT_BUTTON      equ     EV_BUTTON1 + EV_BUTTON2 + EV_BUTTON3
EV_ANY_MOVE_BUTTON      equ     EV_BUTTON1_MOVE + EV_BUTTON2_MOVE + EV_BUTTON3_MOVE
EV_ANY_MOVE             equ     EV_MOVE + EV_ANY_MOVE_BUTTON
EV_ANY_BUTTON           equ     EV_ANY_STAT_BUTTON + EV_ANY_MOVE_BUTTON
EV_STD_MOUSE            equ     EV_ANY_STAT_BUTTON + EV_ANY_MOVE

EV_BUTTON_CHG  EQU  EV_BUTTON1_CHANGED+EV_BUTTON2_CHANGED+EV_BUTTON3_CHANGED

