/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                                                                       */
/*************************************************************************/
/******************* START OF SPECIFICATIONS *****************************/
/*                                                                       */
/*  SOURCE FILE NAME: PENEI.H                                            */
/*                                                                       */
/*  DESCRIPTIVE NAME: Pen extended interface structures                  */
/*                                                                       */
/*                                                                       */
/*  STATUS:  Version 1.0                                                 */
/*                                                                       */
/*  NOTES:                                                               */
/*                                                                       */
/*  ENTRY POINTS:                                                        */
/*      See public statements                                            */
/*  EXTERNAL REFERENCES:                                                 */
/*      See extrn statements                                             */
/*                                                                       */
/******************* END  OF  SPECIFICATIONS *****************************/
/*****************************************************************************/
/* Extended Information Structures*/

#define PEN_EI_LEV_MAJOR  0       /* level of this specification             */
#define PEN_EI_LEV_MINOR  7       /* level of this specification             */

/* defines for all dev_type                                                  */
#define DT_DRIVER   0x00          /* index to access driver                  */
#define DT_CONTROL  0x01          /* control (not used by pen device driver) */
#define DT_SYSTEM   0x02          /* system  (not used by pen device driver) */
#define DT_LOCATOR  0x03          /* locator                                 */
#define DT_BUTTON   0x04          /* button                                  */
#define DT_DISPLAY  0x05          /* display                                 */

/*****************************************************************************/
/* Common Capabilities Packet                                                */

/* each capability packet starts with these common fields                    */

#define SIZEOF_DRIVER_NAME 8
#define SIZEOF_DEVICE_NAME 32
#define CCAP_DEFAULTDATA   0x01
#define CCAP_OS2INI        0x00

typedef struct _CCAP         {    /* ccap                                    */
  USHORT length;                  /* total length of  capabilities packet    */
  UCHAR  device_type;             /* device type                             */
  UCHAR  device_id;               /* device id (is returned from registration*/
  UCHAR  unit;                    /* unit number within the driver           */
  UCHAR  flags;                   /* round to word boundary                  */
  UCHAR  driver_name[SIZEOF_DRIVER_NAME];    /* device driver name           */
  UCHAR  device_name[SIZEOF_DEVICE_NAME];    /* device name                  */
  USHORT event_caps;              /* events that will be generated           */
} CCAP;

/* ccap.event_caps is defined by lev.cev.devicebits,                         */
/* bev.cev.devicebits, dev.cev.devicebits                                    */

/*****************************************************************************/
/* Driver Specific Capabilities Packet                                       */

typedef struct _DDCAP        {    /* ddcap                                   */
  CCAP   ccap;                    /* Common capabilities packet              */
  ULONG  capabilites;             /* reserved                                */
  UCHAR  unitCount;               /* number of logical devices, including one*/
                                  /* for the driver device                   */
  UCHAR  rev_major;               /* driver major level                      */
  UCHAR  rev_minor;               /* driver minor level                      */
  UCHAR  ioc_major;               /* IOCTL interface major level             */
  UCHAR  ioc_minor;               /* IOCTL interface minor level             */
  UCHAR  eif_major;               /* Extended interface major level          */
  UCHAR  eif_minor;               /* Extended interfcae minor level          */
  UCHAR  idc_major;               /* DDS IDC interface major level           */
  UCHAR  idc_minor;               /* DDS IDC interfcae minor level           */
} DDCAP;

/*****************************************************************************/
/* Locator Specific Capabilities Packet                                      */
/* This structure can be imbedded into an OEM Capabilities Structure         */
/* if you need to pass additional information such as: Whether the device    */
/* timestamp is used, if the OEM_data field is being used OR how many bytes  */
/* of it are being used.                                                     */

typedef struct _LCAP         {    /* lcap                                    */
  CCAP   ccap;                    /* Common capabilities packet              */
  USHORT type;                    /* locator type                            */
  USHORT caps;                    /* locator capabilities                    */
  USHORT sample_rate;             /* device sample rate                      */
  USHORT max_sample_rate;         /* maximum device sample rate              */
  USHORT barrel_num;              /* number of barrel buttons                */
  USHORT barrel_mask;             /* bit position of barrel buttons          */
  ULONG  dev_x_extent;            /* device x axis extent                    */
  ULONG  dev_y_extent;            /* device y axis extent                    */
  ULONG  std_x_extent;            /* standard x axis extent                  */
  ULONG  std_y_extent;            /* standard y axis extent                  */
  SHORT  dev_z_p_extent;          /* device z axis pressure extent (negative)*/
  SHORT  dev_z_h_extent;          /* device z axis height extent (positive)  */
  UCHAR  pass_rate;               /* device pass rate                        */
  UCHAR  num_mouse_but;           /* number of mouse buttons emulated by dev */
  USHORT std_res;                 /* points per inch for standard resolution */
  USHORT dev_x_res;               /* points per inch on x axis               */
  USHORT dev_y_res;               /* points per inch on y axis               */
  ULONG  dev_timestampRes;        /* device timestamp resolution in micrscds */
} LCAP;

/*defines for lcap.type */
#define LOCTYPE_MOUSE       0x0001   /* stock device                         */
#define LOCTYPE_PEN         0x0002   /* Pen                                  */
#define LOCTYPE_FINGER      0x0004   /* Finger                               */
#define LOCTYPE_OTHER       0x0008   /* Other                                */

#define LOCTYPE_ABSOLUTE    0x0010   /* Absolute                             */
#define LOCTYPE_RELATIVE    0x0020   /* Relative                             */


/* defines for LCAP.caps */
#define PENCAP_TETHERED    0x0001    /* 1 - Tethered, 0 - Untethered         */
#define PENCAP_PROXIMITY   0x0002    /* Generates enter/exit events          */
#define PENCAP_PHI         0x0004    /* Stylus angle from vertical, +y direc */
#define PENCAP_THETA       0x0008    /* Stylus angle from vertical, +x direc */
#define PENCAP_OEMDATA     0x0010    /* OEM data reported                    */
#define PENCAP_TIMESTAMP   0x0020    /* dev_timestamp reported               */
#define PENCAP_ZPRESSURE   0x0040    /* Z axis represents pressure           */
#define PENCAP_ZHEIGHT     0x0080    /* Z axis represents height             */
#define PENCAP_PIN         0x0100    /* 1=Personal Idenification Number      */
#define PENCAP_ERASER      0x0200    /* 1=device used as eraser              */
#define PENCAP_DISPLAY     0x0400    /* 1=integrated display                 */
#define PENCAP_BATTERY     0x0800    /* pen has battery                      */
#define PENCAP_FIXED_RATE  0x4000    /* Point rate cannot be changed         */

/*defines for lcap.std_res */
#define STD_RESOLUTION      1000     /* standard resolution is 1000 pts/inch */
/*****************************************************************************/
/* Button Specific Capabilities Packet                                       */
/* button index 0 is represented with the least significant                  */
/* bit in the mask (0x0001)                                                  */

typedef struct _BCAP         {    /* bcap                                        */
  CCAP   ccap;                    /* Common capabilities packet                  */
  USHORT num;                     /* number of buttons (0 to 16)                 */
  USHORT typeMask;                /* bit mask for type (1=barrel, 0=not barrel)  */
  USHORT barrel;                  /* Valid capabilites for barrel buttons   */
  USHORT nonBarrel;               /* Valid capabilites for non-barrel buttons */

  USHORT nullMask;                /* bit mask to show null assignment            */
  USHORT hotKeyMask;              /* bit mask to show assignment to hotkey       */
  USHORT shiftMask;               /* bit mask to show assignment to mouse mod    */
  USHORT appKeyMask;              /* bit mask to show assignment to appl key     */
  USHORT augKeyMask;              /* bit mask to show assignment to augmentation */
  USHORT gesKeyMask;              /* bit mask to show assignment to gesture mode */
} BCAP;

/* Defines for BCAP.barrel  and  BCAP.nonBarrel  capabilities. */
/* If these bits are set, this means the action is supported   */
/* by the barrel or nonbarrel buttons.                         */

#define CAP_NOBUTTONACTION        0x0001  /* null - do nothing (the default) */
#define CAP_SENDHOTKEY            0x0002  /* hot key support                 */
#define CAP_SHIFTBUTTON           0x0004  /* shift button support            */
#define CAP_APPLBUTTON            0x0008  /* button for application use      */
#define CAP_AUGMENTATIONBUTTON    0x0010  /* button for key augmentation     */
#define CAP_GESMODEBUTTON         0x0020  /* button for gesture mode         */

#define CAP_DEFAULT_BARREL CAP_NOBUTTONACTION|CAP_SHIFTBUTTON|CAP_GESMODEBUTTON
#define CAP_DEFAULT_NBARREL CAP_DEFAULT_BARREL| \
CAP_SENDHOTKEY|CAP_APPLBUTTON|CAP_AUGMENTATIONBUTTON

/*****************************************************************************/
/* Display Specific Capabilities Packet                                      */

typedef struct _DCAP         {    /* dcap                                    */
  CCAP   ccap;                    /* Common capabilities packet              */
  USHORT type;                    /* display type                            */
  USHORT auto_flag;               /* capable of supporting automatic inactivity */
                                  /* period (1=yes, 0 = no)                  */
  ULONG  height;                  /* screen height in .01 of inch            */
  ULONG  width;                   /* screen width  in .01 of inch            */
} DCAP;

/* defines for DCAP.type  */
#define DISPTYPE_LCD       0x0001    /* 1 - LCD,      0 - not LCD           */
#define DISPTYPE_CRT       0x0002    /* 1 - CRT,      0 - not CRT           */
#define DISPTYPE_BLANKING  0x0004    /* Display performs screen blanking    */
#define DISPTYPE_COLOR     0x0008    /* 1 - Color,    0 - Monochrome        */
#define DISPTYPE_ATTACHED  0x0010    /* 1 - Attached, 0 - Portable          */
#define DISPTYPE_NO_KBD    0x0020    /* No Keyboard Attached                */
#define DISPTYPE_BATTERY   0x0040    /* 1 - Battery,  0 - AC power          */
#define DISPTYPE_SPEAKER   0x0080    /* 1 - speaker is close to display     */

/*****************************************************************************/
/* Control Specific Registration Packet */

/* NOTE: Control devices are not registered from pen device drivers*/

typedef struct _UCAP         {    /* ucap                          */
  CCAP   ccap;                    /* Common capabilities packet    */
  USHORT cntrl_num_devices;       /* number of devices registered  */
} UCAP;

/*****************************************************************************/
/* System Specific Capabilities Packet */

/* NOTE: System devices are not registered from pen device drivers */

typedef struct _SCAP         {    /* scap                          */
  CCAP   ccap;                    /* Common capabilities packet    */
                                  /* no specific variables         */
} SCAP;

/*****************************************************************************/
/* Common Event Packet */

typedef struct _CEV          {    /* cev                                     */
  USHORT length;                  /* total length of eiq event packet        */
  UCHAR  device_type;             /* event category - system, locator, display, control */
  UCHAR  device_id;               /* identity of device that generated event */
  ULONG  timestamp;               /* millisecond timestamp (not for DD)      */
  UCHAR  session;                 /* foreground session number (not for DD)  */
  UCHAR  cntrl;                   /* control info (not for DD)               */
  USHORT devicebits;              /* event field (defined by device type)    */
} CEV;

/*****************************************************************************/
/* Locator Specific Event Packet */

typedef struct _LEV          {    /* lev                                     */
  CEV  cev;                       /* common event packet                     */
  USHORT cntrl;                   /* locator control info                    */
  USHORT scr_x;                   /* screen coords (NOT filled in by pen DD) */
  USHORT scr_y;                   /*  "                                      */
  SHORT  scr_z;                   /*  " normalized z coord (-4k to 4k)       */
  USHORT buttons;                 /* state of buttons 0 - 15;                */
  ULONG  dev_x;                   /* device coordinates                      */
  ULONG  dev_y;                   /*                                         */
  ULONG  std_x;                   /* standard coordinates                    */
  ULONG  std_y;                   /*                                         */
  SHORT  dev_z;                   /* negative = pressure, positive = height  */
  ULONG  dev_timestamp;           /* high resolution device timestamp        */
  USHORT dev_sequence;            /* increment for each event                */
                                  /* Angles range from +-180 degrees         */
  SHORT  dev_angle_theta;         /* Stylus angle from vertical, increases   */
                                  /* in positive x direction.                */
  SHORT  dev_angle_phi;           /* Stylus angle from vertical, increases   */
                                  /* in positive y direction.                */
  UCHAR  OEM_data[8];             /* OEM specific locator data (optional)    */
} LEV;

/* defines for LEV.cntrl */
#define LOC_PASS_ON        0x0001 /* Generate mouse point */
#define LOC_ARBITRATED_OUT 0x0002 /* For use my arbitration */
#define LOC_SUPPRESSED     0x0004 /* suppressed contact due to bklt auto-on  */
#define LOC_BKLT_OFF       0x0008 /* suppressed contact due to backlight off */
#define LOC_REL            0x0010 /* dev_x and dev_y are relative            */
#define LOC_ABS            0x0020 /* dev_x and dev_y are absolute            */
#define LOC_FAKE           0x0040 /* device coordinates are valid, but fake  */
#define LOC_INVALID        0x0080 /* screen coordinates are not valid        */
#define LOC_CONTACT        0x0100 /* Indicates the locator is in contact.    */
#define LOC_PROX           0x0200 /* Indicates the locator is in proximity   */
#define LOC_GSTMODE        0x0400 /* Force gesture mode                      */

/* defines for LEV.cev.devicebits */
/* low order byte = mouse event   */
#define EV_NONE         0x00      /* no buttons, no movement           */
#define EV_MOVE         0x01      /* just movement, no buttons         */
#define EV_BUTTON1_MOVE 0x02      /* movement and button 1 down        */
#define EV_BUTTON1      0x04      /* just button 1 down, no movement   */
#define EV_BUTTON2_MOVE 0x08      /* movement and button 2 down        */
#define EV_BUTTON2      0x10      /* just button 2 down, no movement   */
#define EV_BUTTON3_MOVE 0x20      /* movement and button 3 down        */
#define EV_BUTTON3      0x40      /* just button 3 down, no movement   */

#define EV_ANY_STAT_BUTTON   EV_BUTTON1 | EV_BUTTON2 | EV_BUTTON3
#define EV_ANY_MOVE_BUTTON   \
EV_BUTTON1_MOVE | EV_BUTTON2_MOVE | EV_BUTTON3_MOVE
#define EV_ANY_MOVE          EV_MOVE | EV_ANY_MOVE_BUTTON
#define EV_ANY_BUTTON        EV_ANY_STAT_BUTTON | EV_ANY_MOVE_BUTTON
#define EV_STD_MOUSE         EV_ANY_STAT_BUTTON | EV_ANY_MOVE

/*  high order byte = mouse events that changed */
#define EV_BUTTON1_CHANGED 0x0400 /* button 1 changed */
#define EV_BUTTON2_CHANGED 0x1000 /* button 2 changed */
#define EV_BUTTON3_CHANGED 0x4000 /* button 3 changed */
#define EV_BUTTON_CHG \
EV_BUTTON1_CHANGED|EV_BUTTON2_CHANGED|EV_BUTTON3_CHANGED

/*  Stroke events */
#define EV_EXIT_PROX  0x0080   /* exit proximity  */
#define EV_ENTER_PROX  0x8000  /* enter proximity */
#define EV_PROX  EV_EXIT_PROX|EV_ENTER_PROX

/*****************************************************************************/
/* Button Specific Event Packet */

typedef struct _BEV          {    /* bev                                     */
  CEV  cev;                       /* common event packet                     */
  USHORT cntrl;                   /* button  control info                    */
  USHORT state;                   /* button state mask (1=activated 0=release*/
  USHORT change;                  /* mask, 1= changed since last event report*/
  UCHAR  action;                  /* action to preform                       */
  UCHAR  value;                   /* hotKey value for hot key assignment or  */
                                  /* Mouse button selection mask             */
  UCHAR  OEM_data[8];             /* OEM specific display data (optional)    */
} BEV;

/* defines for BEV.cev.devicebits */
#define BEV_BUTTON_CHANGE  0x01 /* button change event */

/* defines for BEV.cntrl */
#define BEV_SUPPRESSED LOC_SUPPRESSED /* suppres contact due to bklt auto-on  */
#define BEV_BKLT_OFF   LOC_BKLT_OFF   /* suppres contact due to backlight off */
/*****************************************************************************/
/* Display Specific Event Packet */

typedef struct _DEV          {    /* dev                                     */
  CEV  cev;                       /* common event packet                     */
  USHORT state;                   /* state of backlight (0=off, 1=on)        */
  USHORT OEM_data[8];             /* OEM specific display data (optional)    */
} DEV;

/* defines for DEV.cev.devicebits */
#define DEV_BACKLIGHT_CHANGE    0x01 /* state of backlight changed */

/*****************************************************************************/
/* Control Specific Event Packet */

/* Note: Control devices are not provided by the device driver */

typedef struct _UEV          {    /* uev                                    */
  CEV   cev;                      /* common event packet                    */
  UCHAR cntrl_target_cat;         /* device type reported                   */
  UCHAR cntrl_target_id;          /* device id reported                     */
  UCHAR cntrl_cap_packet;         /* updated capabilities packet starts here*/
} UEV;

/* defines for UEV.cev.devicebits */
#define CNTRL_CAPCHANGED        0x01 /* update capabilities */
/*****************************************************************************/
/* System Specific Event Packet */

/* Note: System devices are not provided by the device driver */

typedef struct _SEV          {    /* sev                                */
  CEV   cev;                      /* common event packet                */
  UCHAR  sys_Mtype;               /* video mode type                    */
  UCHAR  sys_Color;               /* number of colors                   */
  USHORT sys_TCol_res;            /* text colomn resolution             */
  USHORT sys_TRow_res;            /* text row resolution                */
  USHORT sys_GCol_res;            /* graphics colomn resolution         */
  USHORT sys_GRow_res;            /* graphics row resolution            */
  UCHAR  sys_session;             /* session affected by system event   */
} SEV;

/* defines for SEV.cev.devicebits */
#define SYS_BEG_VMODE_CHANGE    0x01 /* beginning of video mode change  */
#define SYS_END_VMODE_CHANGE    0x02 /* end of video mode change        */
#define SYS_BEG_SESSION_CHANGE  0x04 /* beginning of session change     */
#define SYS_END_SESSION_CHANGE  0x08 /* end of session change           */
#define SYS_BEG_LOCKUP          0x10 /* beginning of lockup             */
#define SYS_END_LOCKUP          0x20 /* end of lockup                   */
