/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PARALLEL.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define PRT_HELPFILE_NAME       "WPHELP.HLP"
#define PARALLEL_DLL            "PARALLEL"

#define NO_ERROR                     0
#define ERROR_MORE_DATA              234
#define ERROR_INSUFFICIENT_BUFFER    122

#define ID_NUMBER_OF_DESC_LINES 8000
#define ID_FIRST_DESC_LINES     8001

#define PORT_ID_1               5001
#define PORT_DESC_1             5002
#define PORT_ID_2               5003
#define PORT_DESC_2             5004
#define PORT_ID_3               5005
#define PORT_DESC_3             5006
#define PORT_HELP_TITLE         5100
#define PORT_ERR_TITLE          7000

#define PORT_ID_FIRST           PORT_ID_1
#define PORT_ID_LAST            PORT_ID_3

#define PARALLEL_ICON           7001

#define STR_LEN_PORTNAME        64
#define STR_LEN_PORTDESC        256
#define STR_LEN_DESC            81
#define STR_LEN_TITLE           256

   /*
   ** port defaults
   */
#define DEF_INITIALIZATION      ";"
#define DEF_OLD_INITIALIZATION  ";"
#define DEF_TERMINATION         ";"
#define DEF_TIMEOUT             "45;"
#define DEF_PORTDRIVER          "PARALLEL;"

#define TIMEOUT_LOWER_LIMIT      0
#define TIMEOUT_UPPER_LIMIT      9999
#define DEF_TIMEOUT_VALUE        45

#define APPNAME_LEAD_STR           "PM_"

#define KEY_DESCRIPTION            "DESCRIPTION"
#define KEY_INITIALIZATION         "INITIALIZATION"
#define KEY_TERMINATION            "TERMINATION"
#define KEY_PORTDRIVER             "PORTDRIVER"
#define KEY_TIMEOUT                "TIMEOUT"

#define APPNAME_PM_SPOOLER_PORT    "PM_SPOOLER_PORT"

#define NumPorts() (((PORT_ID_LAST - PORT_ID_FIRST) >> 1) + 1)


typedef struct _PARALLELDATA
{
   HAB hAB;
   HMODULE hModule;
   ULONG lfModified;
   PSZ pszPortName;
   PSZ pszAppName;
   USHORT usSaveTimeOut;
   USHORT usOrgTimeOut;
   BOOL   fOrgShareAccess ;
   BOOL   fShareAccess ;
} PARALLDATA, *PPARALLDATA;

   /*
   ** Port Settings - Parallel Port
   */
#define IDD_PORTPARALLEL      21400
#define IDC_PPA_TIMEOUT       (IDD_PORTPARALLEL + 1)  /* Timeout            */
#define IDC_PPA_DESC          (IDD_PORTPARALLEL + 2)
#define IDC_PPA_SHAREHW       (IDD_PORTPARALLEL + 3)  /* share access       */
#define IDC_OK           1100                         /* OK push button     */
#define IDC_CANCEL       1101                         /* Cancel push button */
#define IDC_HELP         1102                         /* Help push button   */
#define IDC_RESET        1103                         /* Help push button   */
#define IDC_DEFAULT      1104                         /* Help push button   */

#define IDH_DLG_EXTENDED 15483
#define IDH_PPA_TIMEOUT  15484
#define IDH_PPA_SHAREHW  15822
#define IDH_PPA_DESC     15715
#define IDH_OK           1090
#define IDH_CANCEL       1091
#define IDH_RESET        1092
#define IDH_DEFAULT      1093
#define IDH_HELP         15483

