/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = s3864icd.c
 *
 * DESCRIPTIVE NAME = Chip specific PMI functions
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION PMI-file handler - Exported entry points
 *
 * FUNCTIONS
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma langlvl(extended)
#define CHIPS_ALREADY_DEFINED
#include "ipmitype.h"
#include <conio.h>
/*****************************************************************************
 *
 *  FUNCTION NAME:      pfnSetS3864ICD()
 *
 *  DESCRIPTIVE NAME:   Program the clock related registers based on the input data.
 *
 *  FUNCTION:
 *
 *  INPUT:              PVIDEO_ADAPTER - Pointer to current state of the adapter/mode
 *                      PREGS- Pointer to current register state
 *
 *  EXIT:               APIRET - return code
 *
 *  NOTES:              Program the S3864 adapters with ICD2061 clock chip
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 ****************************************************************************/
APIRET EXPENTRY  pfnSetS3864ICD(PVIDEO_ADAPTER pAdapter,PREGS pRegs)
{
  ULONG ClockSerialData;
  ULONG rc = NO_ERROR;
  USHORT crtcport = (_inp(0x3cc) & 0x01) ? 0x3D4 : 0x3B4;
  BYTE r0;
  USHORT i, j;

  if (!(pAdapter->ModeInfo.usType & MODE_FLAG_GRAPHICS))
  {
    if (pAdapter->ModeInfo.usBytesPerScanLine == 132)
      ClockSerialData = 0x05170A0;
    else
      return (ERROR_REFRESH_NOT_SUPPORTED);
  }
  else              /* graphics mode */
  {
    _outp(crtcport, 0x11);
    r0 = _inp(crtcport+1);
    _outp(crtcport+1, (r0 & 0x7F));

    _outp(crtcport, 0x42);
    r0 = _inp(crtcport+1);
    _outp(crtcport+1, (r0 & 0xdf));       /* set interlace off */

    switch(pAdapter->ModeInfo.usXResolution)
    {
      case 640:
         _outpw(crtcport, 0x3e07);
         _outpw(crtcport, 0x8013);

         switch(pAdapter->ModeInfo.bBitsPerPixel)
         {
            case 8:
            case 4:
               _outpw(crtcport, 0x4f01);
               switch(pAdapter->ModeInfo.bVrtRefresh)
               {
                  case 75:
                    _outpw(crtcport, 0x6400);
                    _outpw(crtcport, 0x4f02);
                    _outpw(crtcport, 0x8003);
                    _outpw(crtcport, 0x5204);
                    _outpw(crtcport, 0x1a05);
                    _outpw(crtcport, 0xf206);
                    _outpw(crtcport, 0x1f07);
                    _outpw(crtcport, 0xe010);
                    _outpw(crtcport, 0x8311);
                    _outpw(crtcport, 0xdf15);
                    _outpw(crtcport, 0x0016);
                    _outpw(crtcport, 0x5e3b);
                    ClockSerialData =0x049D8B5;
                    break;

                  case 72:
                    _outpw(crtcport, 0x6300);
                    _outpw(crtcport, 0x5002);
                    _outpw(crtcport, 0x8603);
                    _outpw(crtcport, 0x5404);
                    _outpw(crtcport, 0x9905);
                    _outpw(crtcport, 0x0606);
                    _outpw(crtcport, 0xe910);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0xe015);
                    _outpw(crtcport, 0x0616);
                    _outpw(crtcport, 0x5e3b);
                    ClockSerialData =0x049D8B5;
                    break;

                  case 60:
                  default:
                    _outpw(crtcport, 0x5f00);
                    _outpw(crtcport, 0x5002);
                    _outpw(crtcport, 0x8203);
                    _outpw(crtcport, 0x5404);
                    _outpw(crtcport, 0x8005);
                    _outpw(crtcport, 0x0b06);
                    _outpw(crtcport, 0xea10);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0xe715);
                    _outpw(crtcport, 0x0416);
                    _outpw(crtcport, 0x5a3b);
                    ClockSerialData =0x041A8BC;
                    break;
               }
               break;

            case 16:
               _outpw(crtcport, 0x9f01);
               switch(pAdapter->ModeInfo.bVrtRefresh)
               {
                  case 75:
                    _outpw(crtcport, 0xcd00);
                    _outpw(crtcport, 0xa002);
                    _outpw(crtcport, 0x9003);
                    _outpw(crtcport, 0xa604);
                    _outpw(crtcport, 0x1205);
                    _outpw(crtcport, 0xf206);
                    _outpw(crtcport, 0x1f07);
                    _outpw(crtcport, 0xe010);
                    _outpw(crtcport, 0x8311);
                    _outpw(crtcport, 0xdf15);
                    _outpw(crtcport, 0x0016);
                    ClockSerialData =0x049D8B5;
                    break;

                  case 72:
                    _outpw(crtcport, 0xcb00);
                    _outpw(crtcport, 0xa002);
                    _outpw(crtcport, 0x8e03);
                    _outpw(crtcport, 0xa704);
                    _outpw(crtcport, 0x1105);
                    _outpw(crtcport, 0x0606);
                    _outpw(crtcport, 0xe910);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0xe015);
                    _outpw(crtcport, 0x0616);
                    ClockSerialData =0x049D8B5;
                    break;

                  case 60:
                  default:
                    _outpw(crtcport, 0xc100);
                    _outpw(crtcport, 0xa202);
                    _outpw(crtcport, 0x8203);
                    _outpw(crtcport, 0xa404);
                    _outpw(crtcport, 0x1c05);
                    _outpw(crtcport, 0x0c06);
                    _outpw(crtcport, 0xea10);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0xa013);
                    _outpw(crtcport, 0xe715);
                    _outpw(crtcport, 0x0516);
                    ClockSerialData =0x041A8BC;
                    break;
               }
               break;

            case 24:
               if (pAdapter->ModeInfo.bVrtRefresh == 60)
                  ClockSerialData = 0x04FAC28;
               else
                  rc = ERROR_REFRESH_NOT_SUPPORTED;
               break;

            case 32:
               _outpw(crtcport, 0x3f01);

               switch(pAdapter->ModeInfo.bVrtRefresh)
               {
                  case 75:
                    _outpw(crtcport, 0xa900);
                    _outpw(crtcport, 0x4002);
                    _outpw(crtcport, 0x8003);
                    _outpw(crtcport, 0x4a04);
                    _outpw(crtcport, 0x9905);
                    _outpw(crtcport, 0x0606);
                    _outpw(crtcport, 0xea10);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0xe715);
                    _outpw(crtcport, 0x0316);
                    _outpw(crtcport, 0x8a3b);
                    _outpw(crtcport, 0x7f5d);
                    ClockSerialData =0x04B4423;
                    break;

                  case 72:
                    _outpw(crtcport, 0xa900);
                    _outpw(crtcport, 0x4002);
                    _outpw(crtcport, 0x8303);
                    _outpw(crtcport, 0x4d04);
                    _outpw(crtcport, 0x8205);
                    _outpw(crtcport, 0x0506);
                    _outpw(crtcport, 0xe810);
                    _outpw(crtcport, 0x8b11);
                    _outpw(crtcport, 0x0013);
                    _outpw(crtcport, 0xdf15);
                    _outpw(crtcport, 0x0516);
                    _outpw(crtcport, 0x933b);
                    _outpw(crtcport, 0x5f5d);
                    ClockSerialData =0x04B4423;
                    break;

                  case 60:
                  default:
                    _outpw(crtcport, 0x8900);
                    _outpw(crtcport, 0x4002);
                    _outpw(crtcport, 0x8903);
                    _outpw(crtcport, 0x4904);
                    _outpw(crtcport, 0x1605);
                    _outpw(crtcport, 0x0b06);
                    _outpw(crtcport, 0xea10);
                    _outpw(crtcport, 0x8c11);
                    _outpw(crtcport, 0x0013);
                    _outpw(crtcport, 0xe715);
                    _outpw(crtcport, 0x0316);
                    _outpw(crtcport, 0x8a3b);
                    _outpw(crtcport, 0x7f5d);
                    ClockSerialData =0x041AC3D;
                    break;
               }
               break;
         }
         break;

      case 800:
         switch(pAdapter->ModeInfo.bBitsPerPixel)
         {
            case 8:
            case 4:
              _outpw(crtcport, 0x6402);
              _outpw(crtcport, 0xf007);
              _outpw(crtcport, 0x5715);

              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0x8100);
                   _outpw(crtcport, 0x8403);
                   _outpw(crtcport, 0x6704);
                   _outpw(crtcport, 0x1105);
                   _outpw(crtcport, 0x6d06);
                   _outpw(crtcport, 0xe007);
                   _outpw(crtcport, 0x5810);
                   _outpw(crtcport, 0x8b11);
                   _outpw(crtcport, 0x0016);
                   _outpw(crtcport, 0x783b);
                   ClockSerialData =0x041AC3D;
                   break;

                 case 72:
                   _outpw(crtcport, 0x7d00);
                   _outpw(crtcport, 0x8003);
                   _outpw(crtcport, 0x6c04);
                   _outpw(crtcport, 0x1b05);
                   _outpw(crtcport, 0x9806);
                   _outpw(crtcport, 0x7c10);
                   _outpw(crtcport, 0xa211);
                   _outpw(crtcport, 0x9816);
                   _outpw(crtcport, 0x783b);
                   ClockSerialData =0x041AC3D;
                   break;

                 case 60:
                   _outpw(crtcport, 0x7f00);
                   _outpw(crtcport, 0x8203);
                   _outpw(crtcport, 0x6a04);
                   _outpw(crtcport, 0x1a05);
                   _outpw(crtcport, 0x7406);
                   _outpw(crtcport, 0x5810);
                   _outpw(crtcport, 0x8c11);
                   _outpw(crtcport, 0x7316);
                   _outpw(crtcport, 0x7a3b);
                   ClockSerialData =0x05170A0;
                   break;                       /* @V3.0YEE01 */

                 case 56:
                 default:
                   _outpw(crtcport, 0x8800);
                   _outpw(crtcport, 0x6602);
                   _outpw(crtcport, 0x8a03);
                   _outpw(crtcport, 0x6b04);
                   _outpw(crtcport, 0x1505);
                   _outpw(crtcport, 0x7706);
                   _outpw(crtcport, 0x5c10);
                   _outpw(crtcport, 0x8e11);
                   _outpw(crtcport, 0x5c15);
                   _outpw(crtcport, 0x7416);
                   _outpw(crtcport, 0x833b);

                   if (pAdapter->ModeInfo.bBitsPerPixel == 4)
                     _outpw(crtcport, 0x7b3b);
                   ClockSerialData =0x05170A0;
                   break;
              }
              break;

            case 16:
              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0x0600);
                   _outpw(crtcport, 0x8803);
                   _outpw(crtcport, 0xcd04);
                   _outpw(crtcport, 0x0105);
                   _outpw(crtcport, 0x6d06);
                   _outpw(crtcport, 0x5810);
                   _outpw(crtcport, 0x8b11);
                   _outpw(crtcport, 0x0016);
                   _outpw(crtcport, 0xe317);
                   _outpw(crtcport, 0xf83b);
                   _outpw(crtcport, 0x015d);
                   ClockSerialData =0x041AC3D;
                   break;

                 case 72:
                   _outpw(crtcport, 0xff00);
                   _outpw(crtcport, 0x8203);
                   _outpw(crtcport, 0xd604);
                   _outpw(crtcport, 0x1405);
                   _outpw(crtcport, 0x9806);
                   _outpw(crtcport, 0x7d10);
                   _outpw(crtcport, 0x8311);
                   _outpw(crtcport, 0x9816);
                   _outpw(crtcport, 0xa317);
                   _outpw(crtcport, 0xf83b);
                   _outpw(crtcport, 0x005d);
                   ClockSerialData =0x041AC3D;
                   break;

                 case 60:
                 default:
                   _outpw(crtcport, 0x0300);
                   _outpw(crtcport, 0x8603);
                   _outpw(crtcport, 0xd304);
                   _outpw(crtcport, 0x1305);
                   _outpw(crtcport, 0x7d06);
                   _outpw(crtcport, 0x5810);
                   _outpw(crtcport, 0x8c11);
                   _outpw(crtcport, 0x7316);
                   _outpw(crtcport, 0xa317);
                   _outpw(crtcport, 0xfa3b);
                   _outpw(crtcport, 0x015d);
                   ClockSerialData =0x05170A0;
                   break;
              }
              break;

            case 32:
              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   ClockSerialData =0x057801C;
                   break;

                 case 72:
                   ClockSerialData =0x057801C;
                   break;

                 case 60:
                 default:
                   ClockSerialData =0x051D82B;
                   break;
              }
              break;
         }
         break;

      case 1024:
         /*
         ** horizontal total, horizontal blanking start, end, retrace start,
         ** VGA and extended bits fixed up in appropriate refresh case.
         */

         switch(pAdapter->ModeInfo.bBitsPerPixel)
         {
            case 4:
              _outpw(crtcport, 0x8002);
              _outpw(crtcport, 0x6009);
              _outpw(crtcport, 0xff12);
              _outpw(crtcport, 0xe317);
              _outpw(crtcport, 0x9d3b);

              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0xa200);
                   _outpw(crtcport, 0x8403);
                   _outpw(crtcport, 0x8204);
                   _outpw(crtcport, 0x8e05);
                   _outpw(crtcport, 0x1e06);
                   _outpw(crtcport, 0xfd07);
                   _outpw(crtcport, 0x0110);
                   _outpw(crtcport, 0x8411);    //destroying bit 6 setting.
                   _outpw(crtcport, 0x0015);
                   _outpw(crtcport, 0x0016);
                   _outpw(crtcport, 0xeb17);
                   ClockSerialData =0x0517020;
                   break;

                 case 70:
                   _outpw(crtcport, 0xa100);
                   _outpw(crtcport, 0x8403);
                   _outpw(crtcport, 0x8404);
                   _outpw(crtcport, 0x9505);
                   _outpw(crtcport, 0x2406);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8811);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2416);
                   ClockSerialData =0x04FAC28;
                   break;

                 case 60:
                   _outpw(crtcport, 0xa300);
                   _outpw(crtcport, 0x8603);
                   _outpw(crtcport, 0x8404);
                   _outpw(crtcport, 0x9505);
                   _outpw(crtcport, 0x2506);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8711);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2116);
                   ClockSerialData =0x04B4423;
                   break;

                 case 43:                   //interlace
                 default:
                   _outpw(crtcport, 0x9900);
                   _outpw(crtcport, 0x7f02);
                   _outpw(crtcport, 0x9c03);
                   _outpw(crtcport, 0x8304);
                   _outpw(crtcport, 0x1905);
                   _outpw(crtcport, 0x9706);
                   _outpw(crtcport, 0x1f07);
                   _outpw(crtcport, 0x4009);
                   _outpw(crtcport, 0x8110);
                   _outpw(crtcport, 0x8311);
                   _outpw(crtcport, 0x7f12);
                   _outpw(crtcport, 0x8015);
                   _outpw(crtcport, 0x9616);
                   _outpw(crtcport, 0x943b);

                   _outp(crtcport,0x42);
                   r0 = _inp(crtcport+1);
                   _outp(crtcport+1, ((r0 & 0xdf) | 0x20));

                   ClockSerialData =0x0550894;
                   break;
              }
              break;

            case 8:
              _outpw(crtcport, 0x8002);
              _outpw(crtcport, 0x6009);
              _outpw(crtcport, 0xff12);
              _outpw(crtcport, 0xe317);
              _outpw(crtcport, 0x1067);

              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0xa200);
                   _outpw(crtcport, 0x8403);
                   _outpw(crtcport, 0x8204);
                   _outpw(crtcport, 0x8e05);
                   _outpw(crtcport, 0x1e06);
                   _outpw(crtcport, 0xfd07);
                   _outpw(crtcport, 0x0110);
                   _outpw(crtcport, 0x8411);    //destroying bit 6 setting.
                   _outpw(crtcport, 0x0015);
                   _outpw(crtcport, 0x0016);
                   _outpw(crtcport, 0xeb17);
                   _outpw(crtcport, 0x9a3b); //program 5d bit 6 also.
                   ClockSerialData =0x05170A0;
                   break;

                 case 70:
                   _outpw(crtcport, 0xa100);
                   _outpw(crtcport, 0x8403);
                   _outpw(crtcport, 0x8404);
                   _outpw(crtcport, 0x9505);
                   _outpw(crtcport, 0x2406);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8811);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2416);
                   _outpw(crtcport, 0x9a3b);
                   ClockSerialData =0x04FACA8;
                   break;

                 case 60:
                   _outpw(crtcport, 0xa300);
                   _outpw(crtcport, 0x8603);
                   _outpw(crtcport, 0x8404);
                   _outpw(crtcport, 0x9505);
                   _outpw(crtcport, 0x2506);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8711);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2116);
                   _outpw(crtcport, 0x9e3b);
                   ClockSerialData =0x04B44A3;
                   break;

                 case 43:                   //interlace
                 default:
                   _outpw(crtcport, 0x9900);
                   _outpw(crtcport, 0x7f02);
                   _outpw(crtcport, 0x9c03);
                   _outpw(crtcport, 0x8304);
                   _outpw(crtcport, 0x1905);
                   _outpw(crtcport, 0x9706);
                   _outpw(crtcport, 0x1f07);
                   _outpw(crtcport, 0x4009);
                   _outpw(crtcport, 0x8110);
                   _outpw(crtcport, 0x8311);
                   _outpw(crtcport, 0x7f12);
                   _outpw(crtcport, 0x8015);
                   _outpw(crtcport, 0x9616);
                   _outpw(crtcport, 0x943b);
                   _outpw(crtcport, 0x0067);

                   _outp(crtcport,0x42);
                   r0 = _inp(crtcport+1);
                   _outp(crtcport+1, ((r0 & 0xdf) | 0x20));

                   ClockSerialData =0x0550894;
                   break;

              }
              break;

            case 16:
              _outpw(crtcport, 0x4700);
              _outpw(crtcport, 0x8a03);
              _outpw(crtcport, 0x0504);
              _outpw(crtcport, 0x0105);
              _outpw(crtcport, 0x6009);
              _outpw(crtcport, 0xff12);
              _outpw(crtcport, 0x423b);
              _outpw(crtcport, 0x555d);

              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0x1e06);
                   _outpw(crtcport, 0xfd07);
                   _outpw(crtcport, 0x0110);
                   _outpw(crtcport, 0x8411);
                   _outpw(crtcport, 0x0015);
                   _outpw(crtcport, 0x0016);
                   _outpw(crtcport, 0xeb17);
                   _outpw(crtcport, 0x2854);
                   ClockSerialData =0x0517020;
                   break;

                 case 70:
                   _outpw(crtcport, 0x2406);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8811);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2416);
                   _outpw(crtcport, 0xe317);
                   _outpw(crtcport, 0x2854);
                   ClockSerialData =0x04FAC28;
                   break;

                 case 60:
                   _outpw(crtcport, 0x2506);
                   _outpw(crtcport, 0xf507);
                   _outpw(crtcport, 0x0210);
                   _outpw(crtcport, 0x8711);
                   _outpw(crtcport, 0xff12);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2116);
                   _outpw(crtcport, 0xe317);
                   _outpw(crtcport, 0x4854);
                   ClockSerialData =0x04B4423;
                   break;

                 case 43:
                 default:
                   _outpw(crtcport, 0x3800);
                   _outpw(crtcport, 0x8003);
                   _outpw(crtcport, 0x0304);
                   _outpw(crtcport, 0x0f05);
                   _outpw(crtcport, 0x9706);
                   _outpw(crtcport, 0x1f07);
                   _outpw(crtcport, 0x4009);
                   _outpw(crtcport, 0x8510);
                   _outpw(crtcport, 0x8c11);
                   _outpw(crtcport, 0x7f12);
                   _outpw(crtcport, 0x8015);
                   _outpw(crtcport, 0x9616);
                   _outpw(crtcport, 0xa317);
                   _outpw(crtcport, 0x313b);
                   _outpw(crtcport, 0x7854);
                   _outpw(crtcport, 0x755d);

                   _outp(crtcport,0x42);
                   r0 = _inp(crtcport+1);
                   _outp(crtcport+1, ((r0 & 0xdf) | 0x20));

                   ClockSerialData =0x0550894;
                   break;

              }
              break;
         }
         break;

      case 1152:
         if (pAdapter->ModeInfo.bVrtRefresh == 60)
            ClockSerialData = 0x0517020;
         else
            rc = ERROR_REFRESH_NOT_SUPPORTED;
         break;

      case 1280:
         switch(pAdapter->ModeInfo.bBitsPerPixel)
         {
            case 8:
              _outpw(crtcport, 0xa002);
              _outpw(crtcport, 0x0015);
              _outpw(crtcport, 0xc73b);
              _outpw(crtcport, 0x555e);
              _outpw(crtcport, 0x1067);
//            _outpw(crtcport, 0xfc68);

              switch(pAdapter->ModeInfo.bVrtRefresh)
              {
                 case 75:
                   _outpw(crtcport, 0xcf00);
                   _outpw(crtcport, 0x9203);
                   _outpw(crtcport, 0xa304);
                   _outpw(crtcport, 0x1505);
                   _outpw(crtcport, 0x2806);
                   _outpw(crtcport, 0x5a07);
                   _outpw(crtcport, 0x6009);
                   _outpw(crtcport, 0x0010);
                   _outpw(crtcport, 0x8311);
                   _outpw(crtcport, 0xff15);
                   _outpw(crtcport, 0x2816);
                   _outpw(crtcport, 0x3854);
                   ClockSerialData =0x04D8028;
                   break;

                 case 72:
                 case 60:
                   _outpw(crtcport, 0xcc00);
                   _outpw(crtcport, 0x8e03);
                   _outpw(crtcport, 0xa504);
                   _outpw(crtcport, 0x1905);
                   _outpw(crtcport, 0x3306);
                   _outpw(crtcport, 0x5207);
                   _outpw(crtcport, 0x4009);
                   _outpw(crtcport, 0x0510);
                   _outpw(crtcport, 0x8c11);
                   _outpw(crtcport, 0x3116);
                   _outpw(crtcport, 0x3854);
                   ClockSerialData =0x04B4423;

                   if (pAdapter->ModeInfo.bVrtRefresh == 60)
                   {
                      _outpw(crtcport, 0x5054);
                      ClockSerialData =0x045D83D;       /*            */
                   }
                   break;

                 case 45:
                 default:
                   _outpw(crtcport, 0xc000);
                   _outpw(crtcport, 0x9f02);
                   _outpw(crtcport, 0x8303);
                   _outpw(crtcport, 0xa404);
                   _outpw(crtcport, 0x1f05);
                   _outpw(crtcport, 0x1806);
                   _outpw(crtcport, 0xb207);
                   _outpw(crtcport, 0x6009);
                   _outpw(crtcport, 0x0110);
                   _outpw(crtcport, 0x8511);
                   _outpw(crtcport, 0x1816);
                   _outpw(crtcport, 0xbb3b);
                   _outpw(crtcport, 0xa854);
                   _outpw(crtcport, 0x005e);
                   _outpw(crtcport, 0x0067);
//                 _outpw(crtcport, 0xff68);

                   _outp(crtcport,0x42);
                   r0 = _inp(crtcport+1);
                   _outp(crtcport+1, ((r0 & 0xdf) | 0x20));

                   ClockSerialData =0x04FAC28;
                   break;

              }
              break;
         }
         break;

      case 1600:
         if (pAdapter->ModeInfo.bVrtRefresh == 60)
            ClockSerialData = 0x04FAC28;
         else
            rc = ERROR_REFRESH_NOT_SUPPORTED;
         break;
    }
  }               /* end MODE_FLAG_GRAPHICS test   */
  if (!rc)
  {
     /***   wait on vertical retrace twice  ***/
     /***   due to some timing problem ??   ***/
     for (j=0; j<2; j++)
     {
       i = 0;
       r0 = _inp(crtcport+6);
       while (((r0 & 0x08) == 0x08) && (i < 65535))
       {
         r0 = _inp(crtcport+6);
       }                           /* vert retrace off */

       for (i=0; i<65535; i++)
       {
         r0 = _inp(crtcport+6);
         if ((r0 & 0x08) == 0x08)
            break;
       }                           /* vert retrace on  */
     }                             /* end 2x vertical retrace */

     SETNUMBER9CLK(ClockSerialData);
  }

  return rc;
}
