/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = atimain.c
 *
 * DESCRIPTIVE NAME = Chip specific PMI functions
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION PMI-file handler - Exported entry points
 *
 * FUNCTIONS
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma langlvl(extended)
#define CHIPS_ALREADY_DEFINED
#include "ipmitype.h"
#include <conio.h>
/*****************************************************************************
 *
 *  FUNCTION NAME:      pfnSetATI32()
 *
 *  DESCRIPTIVE NAME:   Program the clock related registers based on the input data.
 *
 *  FUNCTION:
 *
 *  INPUT:              PVIDEO_ADAPTER - Pointer to current state of the adapter/mode
 *                      PREGS- Pointer to current register state
 *
 *  EXIT:               APIRET - return code
 *
 *  NOTES:              It is not necessary to verify the manufacturer if this
 *                      code handles only one manufacturer per chip. In that case,
 *                      the identify adapter would fail to identify manufacturers which
 *                      are not handled thru the ibmgpmi.dll so no futher calls into this
 *                      dll for services would be expected. However, if there are
 *                      multiple manufacturers (adapter) handled, then this function has
 *                      to specifically identify which one is being handled. 
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 ****************************************************************************/
APIRET EXPENTRY  pfnSetATI32(PVIDEO_ADAPTER pAdapter,PREGS pRegs)
{
  ULONG rc = NO_ERROR;
  BYTE r0;
  BYTE bVrtRefresh;
  if (pAdapter->ModeInfo.usType & MODE_FLAG_GRAPHICS)
  {
    switch(pAdapter->ModeInfo.usXResolution)
    {
      case 640:
         switch(pAdapter->ModeInfo.bVrtRefresh)
         {
            default:
            case 60:
 	      _outp(0x22e8, 0x0043);                                                         
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0418);                             /* v_total */              
 	      _outpw(0x1ae8, 0x03d6);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x03bf);                              /* v_disp */              
 	      _outp(0x1ee8, 0x22);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x0063);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0052);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x004f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x002c);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x26ee, 0x0050);                                                 
 	      _outpw(0x76ee, 0x0050);                                                        
 	                                                                            
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0251);                 /* dot clock 25.18 Mhz */              
              break;
         }   
         break;
      case 800:
         switch(pAdapter->ModeInfo.bVrtRefresh)
         {
            case 76:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0565);                             /* v_total */              
 	      _outpw(0x1ae8, 0x04fa);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x04ab);                              /* v_disp */              
 	      _outp(0x1ee8, 0x24);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x0086);                             /* h_total */              
 	      _outpw(0x0ae8, 0x006d);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x0063);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0028);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x26ee, 0x0070);                                                 
 	      _outpw(0x76ee, 0x0070);                                                        
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0515);                 /* dot clock 56.64 Mhz */        
              break;
            case 72:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0537);                             /* v_total */              
 	      _outpw(0x1ae8, 0x04f8);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x04ab);                              /* v_disp */              
 	      _outp(0x1ee8, 0x06);                            /* v_sync_wid */               
 	      _outpw(0x02e8, 0x0082);                             /* h_total */              
 	      _outpw(0x0ae8, 0x006a);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x0063);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x000f);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x26ee, 0x0070);                                                 
 	      _outpw(0x76ee, 0x0070);                                                        
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0411);                 /* dot clock 50.35 Mhz */        
              break;
            default:
            case 60:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x04e3);                             /* v_total */              
 	      _outpw(0x1ae8, 0x04b0);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x04ab);                              /* v_disp */              
 	      _outp(0x1ee8, 0x04);                            /* v_sync_wid */               
 	      _outpw(0x02e8, 0x0083);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0068);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x0063);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0010);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x26ee, 0x0070);                                                 
 	      _outpw(0x76ee, 0x0070);                                                        
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0331);                 /* dot clock 40.00 Mhz */        
              break;
         }
         break;
      case 1024:
         switch(pAdapter->ModeInfo.bVrtRefresh)
         {
            case 76:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x064a);                             /* v_total */              
 	      _outpw(0x1ae8, 0x060b);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x05ff);                              /* v_disp */              
 	      _outpw(0x1ee8, 0x4);                             /* v_sync_wid */               
 	      _outpw(0x02e8, 0x00a2);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0087);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x007f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0xb);                          /* h_sync_wid */                 
                                                                              
 	      _outpw(0x26ee, 0x0080);                                                 
 	      _outpw(0x76ee, 0x0080);                                                        
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x062D);                  /* dot clock 80 Mhz */                
              break;
            case 70:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0643);                             /* v_total */              
 	      _outpw(0x1ae8, 0x0601);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x05ff);                              /* v_disp */              
 	      _outp(0x1ee8, 0x08);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x00a6);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0083);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x007f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0016);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0639);                    /* dot clock 75 Mhz */              
                                                                              
 	      _outpw(0x26ee, 0x0080);                                                 
 	      _outpw(0x76ee, 0x0080);                                                        
              break;
            case 72:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0649);                             /* v_total */              
 	      _outpw(0x1ae8, 0x0602);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x05ff);                              /* v_disp */              
 	      _outp(0x1ee8, 0x26);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x00a1);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0082);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x007f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0032);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x0639);                   /* dot clock 75 Mhz */             
                                                                              
                                                                              
 	      _outpw(0x26ee, 0x0080);                                                 
 	      _outpw(0x76ee, 0x0080);                                                        
              break;
            case 60:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x063b);                             /* v_total */              
 	      _outpw(0x1ae8, 0x0600);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x05ff);                              /* v_disp */              
 	      _outp(0x1ee8, 0x04);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x00a7);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0085);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x007f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0008);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                                                        
 	      _outpw(0x4aee, 0x053d);                    /* dot clock 65 Mhz */              
                                                                              
 	      _outpw(0x26ee, 0x0080);                                                 
 	      _outpw(0x76ee, 0x0080);                                                        
            default:
            case 44:
            case 87:
            case 43:
 	      _outpw(0x5aee, 0x0001);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);                /* shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0000);                /* shadow CRT registers */              
 	      _outpw(0x4ae8, 0x0006);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x12e8, 0x0660);                             /* v_total */              
 	      _outpw(0x1ae8, 0x0600);                         /* v_sync_strt */              
 	      _outpw(0x16e8, 0x05ff);                              /* v_disp */              
 	      _outp(0x1ee8, 0x08);                             /* v_sync_wid */              
 	      _outpw(0x02e8, 0x009d);                             /* h_total */              
 	      _outpw(0x0ae8, 0x0081);                         /* h_sync_strt */              
 	      _outpw(0x06e8, 0x007f);                              /* h_disp */              
 	      _outpw(0x0ee8, 0x0016);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0033);                                                        
 	      _outpw(0x4aee, 0x031d);                    /* dot clock 45 Mhz */              
                                                                              
 	      _outpw(0x26ee, 0x0080);                                                 
 	      _outpw(0x76ee, 0x0080);                                                        
              break;
         }
         break;
      case 1280:
         bVrtRefresh = pAdapter->ModeInfo.bVrtRefresh;
         if (DACType != ATI68875_DAC) 
         {
           /*
           ** support only interlaced
           */
           bVrtRefresh = 46;
         }
         switch(bVrtRefresh)
         {
            case 74:
 	      _outpw(0x22e8, 0x0043);                           /* disp_cntl */              
 	      _outpw(0x4aee, 0x0e21);                /* dot clock 135.00 Mhz */              
                                                                              
 	      _outpw(0x5aee, 0x0002);              /* shadow 2 CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x02e8, 0x00d5);                             /* h_total */              
 	      _outpw(0x06e8, 0x009f);                              /* h_disp */              
 	      _outpw(0x0ae8, 0x00a3);                         /* h_sync_strt */              
 	      _outpw(0x0ee8, 0x0012);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x12e8, 0x084b);                             /* v_total */              
 	      _outpw(0x16e8, 0x07ff);                              /* v_disp */              
 	      _outpw(0x1ae8, 0x07ff);                         /* v_sync_strt */              
 	      _outpw(0x1ee8, 0x001e);                          /* v_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                           /* disp_cntl */              
                                                                              
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
                                                                              
              _outpw(0x46ee, 0x003f);                          /* shadow_ctl */
                                                                                
                                                                                
              /* Set DAC values for MUX mode */                                  
                                                                                
              /* disable vga pass through and set pixel clock slow */        
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
              _outp(0x4aee, 0x51);                           /* clock_sel */   
                                                                              
                                                                              
              /* config High DAC addr via ext_ge_config and set to 8bpp */   
              _outpw(0x7aee, 0x201a);                       /* ext_ge_config */
                                                                              
                                                                              
              /* set input_clk_sel, output_clk_sel, and mux_ctl */           
              _outp(0x02ed, 0x01);                   /* input_clk_sel - last */
              _outp(0x02ea, 0x09);                         /* _outpput_clk_sel */
              _outp(0x02eb, 0x1d);                                /* mux_ctl */
                                                                             
                                                                             
                                                                             
                                                                             
              /* reset ext_ge_config to 8bpp and select multiplex pixels */  
              /* also select 6-bit DAC operation */                          
              _outpw(0x7aee, 0x011a);                       /* ext_ge_config */
                                                                             
                                                                             
              /* set pixel_delay, blank_adjust, horizontal_skew */           
              /* blank_adjust = 1, pixel_delay = 0. */                       
                                                                             
              r0 = _inp(0x92ef);                            /* r_rom_cntl + 1 */
              r0 &= 0xf0;
              r0 |= 0x01;
              _outp(0x7eef, r0);                      /* rom_eeprom_cntl + 1 */
                                                                             
                                                                             
                                                                             
                                                                             
              /* set dac_mask to 0xff for 8bpp */                            
              _outp(0x02ea, 0xff);                               /* dac_mask */
                                                                              
                                                                              
 	      _outpw(0x4aee, 0x0e21);                     /* reset clock_sel */              
 	      _outpw(0x4ae8, 0x0007);               /* re enable 8514 compat */              
                                                                              
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
                                                                              
              break;
            case 70:
 	      _outpw(0x22e8, 0x0043);                            /* disp_cntl */             
 	      _outpw(0x4aee, 0x0e05);                            /* clock_sel */             
                                                                              
 	      _outpw(0x5aee, 0x0002);              /* shadow 2 CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x02e8, 0x00d2);                             /* h_total */              
 	      _outpw(0x06e8, 0x009f);                              /* h_disp */              
 	      _outpw(0x0ae8, 0x00a9);                         /* h_sync_strt */              
 	      _outpw(0x0ee8, 0x000e);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x12e8, 0x0851);                             /* v_total */              
 	      _outpw(0x16e8, 0x07ff);                              /* v_disp */              
 	      _outpw(0x1ae8, 0x0800);                         /* v_sync_strt */              
 	      _outpw(0x1ee8, 0x0005);                          /* v_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                            /* disp_cntl */             
                                                                              
 	      _outpw(0x26ee, 0x00a0);                            /* crt_pitch */      
 	      _outpw(0x76ee, 0x00a0);                             /* ge_pitch */             
                                                                              
              _outpw(0x46ee, 0x003f);                           /* shadow_ctl */                                                                             
                                                                                
                                                                                
              /* Set DAC values for MUX mode */                                  
                                                                              
              /* disable vga pass through and set pixel clock slow */        
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
              _outp(0x4aee, 0x51);                           /* clock_sel */   
                                                                              
                                                                              
              /* config High DAC addr via ext_ge_config and set to 8bpp */   
              _outpw(0x7aee, 0x201a);                       /* ext_ge_config */
                                                                              
                                                                              
              /* set input_clk_sel, output_clk_sel, and mux_ctl */           
              _outp(0x02ed, 0x01);                   /* input_clk_sel - last */
              _outp(0x02ea, 0x09);                         /* output_clk_sel */
              _outp(0x02eb, 0x1d);                                /* mux_ctl */
                                                                              
                                                                              
                                                                              
              /* reset ext_ge_config to 8bpp and select multiplex pixels */  
              /* also select 6-bit DAC operation */                          
              _outpw(0x7aee, 0x011a);                       /* ext_ge_config */
                                                                              
                                                                              
              /* set pixel_delay, blank_adjust, horizontal_skew */           
              /* blank_adjust = 1, pixel_delay = 0. */                       
                                                                              
              r0 = _inp(0x92ef);                            /* r_rom_cntl + 1 */
              r0 &= 0xf0;
              r0 |= 0x01;
              _outp(0x7eef, r0);                      /* rom_eeprom_cntl + 1 */
                                                                              
                                                                              
                                                                              
                                                                              
              /* set dac_mask to 0xff for 8bpp */                            
              _outp(0x02ea, 0xff);                               /* dac_mask */
                                                                              
                                                                              
 	      _outpw(0x4aee, 0x0e05);                     /* reset clock_sel */              
 	      _outpw(0x4ae8, 0x0007);               /* re enable 8514 compat */              
                                                                              
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
              break;
            case 60:
              /* Set CRTC values into Shadow Set 2 then select it */             
                                                                                 
 	      _outpw(0x22e8, 0x0043);                           /* disp_cntl */              
 	      _outpw(0x4aee, 0x0a29);                /* dot clock 110.00 Mhz */              
                                                                             
                                                                             
 	      _outpw(0x5aee, 0x0002);              /* shadow 2 CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
                                                                             
                                                                             
 	      _outpw(0x02e8, 0x00d6);                             /* h_total */              
 	      _outpw(0x06e8, 0x009f);                              /* h_disp */              
 	      _outpw(0x0ae8, 0x00a9);                         /* h_sync_strt */              
 	      _outpw(0x0ee8, 0x002e);                          /* h_sync_wid */              
                                                                             
 	      _outpw(0x12e8, 0x0852);                             /* v_total */              
 	      _outpw(0x16e8, 0x07ff);                              /* v_disp */              
 	      _outpw(0x1ae8, 0x0800);                         /* v_sync_strt */              
 	      _outpw(0x1ee8, 0x0025);                          /* v_sync_wid */              
                                                                              
 	      _outpw(0x22e8, 0x0023);                           /* disp_cntl */              
                                                                              
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
                                                                              
              _outpw(0x46ee, 0x003f);                          /* shadow_ctl */
                                                                                  
              /* Set DAC values for MUX mode */                                  
                                                                                  
              /* disable vga pass through and set pixel clock slow */        
 	      _outpw(0x4ae8, 0x0007);                 /* disable passthrough */              
              _outp(0x4aee, 0x51);                           /* clock_sel */   
                                                                             
                                                                             
              /* config High DAC addr via ext_ge_config and set to 8bpp */   
              _outpw(0x7aee, 0x201a);                       /* ext_ge_config */
                                                                             
                                                                             
              /* set input_clk_sel, output_clk_sel, and mux_ctl */           
              _outp(0x02ed, 0x01);                   /* input_clk_sel - last */
              _outp(0x02ea, 0x09);                         /* output_clk_sel */
              _outp(0x02eb, 0x1d);                                /* mux_ctl */
                                                                             
                                                                             
                                                                             
                                                                             
              /* reset ext_ge_config to 8bpp and select multiplex pixels */  
              /* also select 6-bit DAC operation */                          
              _outpw(0x7aee, 0x011a);                       /* ext_ge_config */
                                                                             
                                                                             
              /* set pixel_delay, blank_adjust, horizontal_skew */           
              /* blank_adjust = 1, pixel_delay = 0. */                       
                                                                             
              r0 = _inp(0x92ef);                            /* r_rom_cntl + 1 */
              r0 &= 0xf0;
              r0 |= 0x01;
              _outp(0x7eef, r0);                      /* rom_eeprom_cntl + 1 */
                                                                              
                                                                              
                                                                              
                                                                              
              /* set dac_mask to 0xff for 8bpp */                            
              _outp(0x02ea, 0xff);                               /* dac_mask */
                                                                              
                                                                              
 	      _outpw(0x4aee, 0x0a29);                     /* reset clock_sel */              
 	      _outpw(0x4ae8, 0x0007);               /* re enable 8514 compat */              
                                                                            
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
              break;                                                                  
            default:
            case 46:
 	      _outp(0x22e8, 0x0043);                            /* disp_cntl */              
 	      _outpw(0x4aee, 0x062d);                           /* clock_sel */              
                                                                              
 	      _outpw(0x5aee, 0x0000);            /* non-shadow CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0001);              /* shadow 1 CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x5aee, 0x0002);              /* shadow 2 CRT registers */              
 	      _outpw(0x46ee, 0x0000);                       /* unlock values */              
 	      _outpw(0x4ae8, 0x0005);                 /* disable passthrough */              
                                                                              
 	      _outpw(0x02e8, 0x00c7);                             /* h_total */              
 	      _outpw(0x06e8, 0x009f);                              /* h_disp */              
 	      _outpw(0x0ae8, 0x00a9);                         /* h_sync_strt */              
 	      _outpw(0x0ee8, 0x000a);                          /* h_sync_wid */              
                                                                              
 	      _outpw(0x12e8, 0x08f8);                             /* v_total */              
 	      _outpw(0x16e8, 0x07ff);                              /* v_disp */              
 	      _outpw(0x1ae8, 0x0811);                         /* v_sync_strt */              
 	      _outpw(0x1ee8, 0x000a);                          /* v_sync_wid */              
                                                                              
 	      _outpw(0x26ee, 0x00a0);                           /* crt_pitch */       
 	      _outpw(0x76ee, 0x00a0);                            /* ge_pitch */              
                                                                              
              _outpw(0x46ee, 0x003f);                          /* shadow_ctl */
                                                                              
 	      _outpw(0x22e8, 0x0033);                           /* disp_cntl */              
              break;
         }
      default:
         rc = ERROR_MODE_NOT_SUPPORTED;
    }
  }
  return rc;
}
