;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)virtsym.inc	6.2 91/09/24
;      SCCSID = @(#)virtsym.inc	6.2 91/09/24
;       Virtsym.inc:  Selector Manager symbols for
;       old 16 bit assembly code.


;
;



; shared memory rmp global record format, one record per shared segment:

sm_s STRUC
sm_handle       dw      ?               ; shared memory segment handle
sm_selector     dw      ?               ; shared memory segment selector
sm_refcount     dw      ?               ; reference count of segment users
sm_name         db      ?               ; name string - ASCIIZ
sm_s ENDS


; shared memory rmp local record format, one record per process for every
;       shared segment accessed by it.

lsm_s   STRUC
lsm_ptda        dw      ?               ; ptda handle
lsm_seghandle   dw      ?               ; shared memory segment handle
lsm_refcount    dw      ?               ; ref. count of shared segment for
                                        ;       given ptda
lsm_s   ENDS


; Flags passed into w_FreeSeg

WFS_INTERNAL    equ     0
WFS_EXTERNAL    equ     1
WFS_TERMINATION equ     2


; Flags passed into w_AllocSeg
; WARNING: These flags values are external. DO NOT CHANGE THEIR VALUES!

WAS_PRIVATE      equ     0
WAS_GIVESEG      equ     1
WAS_GETSEG       equ     2
WAS_DISCARDABLE  equ     4
WAS_SHRINKABLE   equ     8
WAS_FLAGSMASK    equ     0fh
WAS_DISCBITSHIFT equ     3

; SegAlloc flag arguments:
;
;       D_DPL0          ring 0 access
;       D_DPL3          ring 3 access

; SegAlloc SelectorFlag arguments; sensible combinations are:
;       SA_GDT [+SA_ALLOCATED]
;       SA_LDT [+SA_SPECIFIC [+SA_ALLOCATED]]

SA_GDT          equ     00h     ; GDT selector if clear
SA_LDT          equ     01h     ; LDT selector if set
SA_SPECIFIC     equ     02h     ; use selector at ((SS:SP)) (SA_LDT only)
SA_ALLOCATED    equ     04h     ; selector at ((SS:SP)) already allocated

; SegAlloc handle flag definitions

HF_MOVABLE      equ     0000h           ; Is movable (resident) segment
HF_FIXED        equ     0000h           ; Is fixed (resident) segment
HF_ZEROINIT     equ     0001h           ; Zero init on alloc/realloc
HF_NONCONTIG    equ     0002h           ; non-contiguous memory if resident
HF_SWAPPABLE    equ     0004h           ; Is swappable segment
HF_LOWMEM       equ     0008h           ; Low memory alloc request
HF_HIMEM        equ     0000h           ; High memory alloc request

; SetDescInfo flag arguments:

SD_ALL          equ     00h     ; initialize descriptor (all fields)
SD_UVIRT        equ     D_UVIRT ; is a PhysToUvirt request


;   SegLock flag arguments

ML_LONG         equ     01h     ; long term lock DevHlp exported, Don't change!
ML_DEVHLP       equ     02h     ; Devhlp locks
ML_HIMEM        equ     02h     ; Fix in high memory (This flag is ignored!)
ML_VERIFY       equ     04h     ; Don't make memory fixed. Exported.
ML_NONCONTIG    equ     80h     ; Don't make memory contiguous. Exported

;   SegLock blockflag arguments

MW_BVALID       equ     0h      ; DevHlp exported, Don't change this value!
MW_TEST         equ     01h     ; Return if valid, DevHlp exported don't change!


;*      GDTPOOLSIZE - controls size of the pool of available GDT selectors.
;       Equates used to avoid magic numbers.

GDTPTDASELS     equ     255                             ; one per PTDA
GDTALIASSELS    equ     30                              ; one per GDT alias
GDTKERNELSELS   equ     255                             ; needed for system init
GDTDHSELS       equ     1000                            ; reserved for DevHlp
GDTPOOLSIZE     equ     (GDTPTDASELS+GDTALIASSELS+GDTKERNELSELS+(GDTDHSELS/10))
