;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)defdbug.inc	6.1 90/11/17
;      SCCSID = @(#)defdbug.inc	13.2 89/02/01
;**	DEFDBUG.INC - Debugging Macro Definitions
;
;


AsmVars <Debug>

IFDEF	DEBUGPRT
	Debug = 0FFFFh
ENDIF


;**	DBPRT	n,m,<format string>, <arg list>
;

DBPRT	MACRO	N,M,fmts,args
	LOCAL	a,b,c,cnt
IFDEF	DEBUGPRT
.xlist
	pushf
IFNB	<N>
	DBTST	N,M
	jz	c
ENDIF

Table	SEGMENT
a	db	'&fmts',0
Table	ENDS

	push	offset DOSGROUP:a
	cnt = 2

IRP	Y,<args>
	push	Y
	cnt = cnt + 2
ENDM
	push	bp
	mov	bp,sp
	add	bp,cnt		;; make BP point to format string addr
	GENCALL	DPRINTF
	pop	bp
	add	sp,cnt		;; remove arguments and format string addr
c:	POPFF
.list
ENDIF
ENDM


;**	DBBEG - Start debugging range
;

DBBEG	MACRO	N,M
 LOCAL	lab
 IF	Debug
  pushf
  DBTST N,M
  jnz	lab	;; am to do it
  DBJMP	  %DBCNT
lab:
ENDM


;**	DBJMP - jump to debugging label
;

DBJMP	MACRO	N
 jmp DBLAB&N
ENDM


;**	DBLAB - generate debugging label
;

DBLAB	MACRO	N
DBLAB&N:
ENDM


;**	DBEND - end debugging range
;

DBEND	MACRO
 IF	Debug
  DBLAB	%DBCNT
  DBCNT = DBCNT+1
  POPFF
 ENDIF
ENDM

DBCNT = 1


;**	DBTST - test debug flags
;
;	DBTST	n,m
;
;	Where N and M are bit masks.
;
;	If one or more of the bits in N is set in the high byte
;	of BUGBITS, and one or more of the bits in M is set in
;	the low byte of BUGBITS then clear the Z flag.
;
;	In other words:
;
;	If both masks show a "hit" clear 'Z' else set 'Z'
;
;	USES	FLAGS

DBTST	MACRO	n,m
	push	ax
	mov	ax,(m shl 8)+n
	GENCALL	dbtest
	pop	ax
ENDM


;**	DBPRTC - debug print if carry set
;

DBPRTC	MACRO	N,M,fmt,args
	LOCAL	a
IFDEF DEBUGPRT
	jnc	a
	DBPRT	N,M,<fmt>,<args>
a:
ENDIF
ENDM


;**	DBPRTNC - debug print if carry clear
;

DBPRTNC	MACRO	N,M,fmt,args
	LOCAL	a
IFDEF DEBUGPRT
	jc	a
	DBPRT	N,M,<fmt>,<args>
a:
ENDIF
ENDM

