;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)abios.inc  6.4 92/02/26
;      SCCSID = @(#)abios.inc   6.4 92/02/26
;   ABIOS.INC
;
;   Definitions for ABIOS
;
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;
;   Initialization INT Definitions
;

ABIOS_Build_SPT equ     4h              ; Build System Parameter Table
ABIOS_Build_IT  equ     5h              ; Build Initialization Table


;
;   RAM Patch Header Structure
;

RamPatch        struc
RamPatchSig         dw    ?             ; Signature (0aa55h)
RamPatchSize        db    ?             ; Ram Patch Size in 512 byte blocks
RamPatchModel       db    ?             ; Model
RamPatchSubModel    db    ?             ; Sub-Model
RamPatchRevision    db    ?             ; Revision
RamPatchDevID       dw    ?             ; Device ID
RamPatchNumInit     db    ?             ; Number of Initialization Entries
RamPatchInitEntry   dw    ?             ; Initialization Table Entry Point
                    db    ?             ; Initialization Table Entry Point
RamPatchSecDevID    db    ?             ; Secondary Device ID
RamPatchRev         db    ?             ; Revision
RamPatchExtLength   dw    ?             ; Extended Header Length
RamPatchWildCard    dw    ?             ; Wild Card Install Routine
RamPatchSizeNoFill  dw    ?             ; Size - not rounded to 512 bytes
RamPatchInitRoutine dw    ?             ; Initialization Routine offset
RamPatch        ends

RamPatchSTDLen  EQU     16              ; Length of Standard ABIOS Patch Header

;
;   ABIOS System Parameter Table Format
;

SPTbl           struc
                dd      ?               ; Common Start Entry Point
                dd      ?               ; Common Interrupt Entry Point
                dd      ?               ; Common Timeout Entry Point
                dw      ?               ; Stack Required for ABIOS
                db      16 dup (?)      ; Reserved
NumEntries      dw      ?               ; Number of Init_Table Entries
SPTbl           ends


;
;   ABIOS Initialization Table Entry Format
;

IT_Entry        struc
DeviceID        dw      ?               ; Device ID
DeviceCount     dw      ?               ; Number of LIDs for this Device
DBLength        dw      ?               ; Device Block Length
InitDB_XferPtr  dd      ?               ; Init Device Block Routine Pointer
                dw      ?               ; Request Block Length
FTTLength       dw      ?               ; Function Transfer Table Length
DPLength        dw      ?               ; Data Pointers Length
                dw      4 dup (?)       ; Reserved
IT_Entry        ends


;
;   Common Data Area Structure for Status fields in LID 0
;

CDAType         struc
CDADPOffset     dw      0               ; Offset to Data Pointers
CDALids         dw      0               ; # of LIDs
CDAType         ends


;
;   Structure for one LID in CDA:
;       Device Block Pointer
;       Function Transfer Table Pointer
;

LIDEntry        struc
DBOffset        dw      ?               ; Devie Block Offset
DBSegment       dw      ?               ; Device Block Segment
FTTOffset       dw      ?               ; Function Transfer Table Offset
FTTSegment      dw      ?               ; Function Transfer Table Segment
LIDEntry        ends



;
;   Definitions for ABIOS Device Types
;

ABIOS_Internal  equ     00h             ; ABIOS Internal Calls
Diskette        equ     01h
Disk            equ     02h
Video           equ     03h
Keyboard        equ     04h
Printer         equ     05h
Asynch          equ     06h
SysTimer        equ     07h
RTCTimer        equ     08h
SysService      equ     09h
NMInterrupt     equ     0ah
PointDevice     equ     0bh
LightPen        equ     0ch
JoyStick        equ     0dh
CMOSRam         equ     0eh
DMA             equ     0fh
POS             equ     10h             ; Programmable Option Select
ErrorLog        equ     11h             ; Error Logging
SAD             equ     12h             ; Stand Alone Dump
IOPortAlloc     equ     13h             ; I/O Port Allocation
AudioTone       equ     14h
IntController   equ     15h             ; Interrupt Controller
Security        equ     16h


;
;   Structure of a Device Block
;
;   Note that the Device Block is a variable size, but these
;   fields are always present.
;

DeviceBlock     struc
DevBLength      dw      ?       ; Device Block Length
Revision        db      ?       ; Revision
                db      ?       ; Reserved
                dw      ?       ; Logical ID
DevID           dw      ?       ; Device ID
DeviceBlock     ends

;
;   Structure of a Function Transfer Table
;
;   Note that the Function Transfer Table is a variable size, but these
;   fields are always present.
;

FTTable         struc
FStart          dd      ?       ; Start Routine Entry Point
FInt            dd      ?       ; Interrupt Routine Entry Point
FTimeO          dd      ?       ; Start Routine Entry Point
FuncCount       dw      ?       ; Count of FUnctions for this Logical ID
                dw      ?       ; Reserved
FTTable         ends


;
;   Format of a Data Pointer in CDA
;

DataPtr         struc
DLimit          dw      ?       ; Limit Field
DOffset         dw      ?       ; Offset Field
DSegment        dw      ?       ; Segment Field
DataPtr         ends

;
;   Format of a Physical Data Pointer (INTEL FORMAT) in CDA
;

PhysPtr         struc
                dw      ?       ; Limit Field
PhysLSW         dw      ?       ; Lo Order 16 Bits
PhysMSW         dw      ?       ; Hi Order 16 Bits
PhysPtr         ends



;
;   Structure for dh_ABIOSGetParms Area in a Device Driver's Data Segment
;
;   Note that this is a black box area to device drivers. They should not
;   attepmt to interpret the contents of ABIOS_Parms, and should also use
;   the CallABIOS macro.
;

ABIOS_Parms     struc
RealCDA         dw      ?       ; Real Mode CDA Anchor
ProtCDA         dw      ?       ; Protect Mode CDA Anchor
RealFTT         dd      ?       ; Real Mode FTT Ptr
ProtFTT         dd      ?       ; Protect Mode FTT Ptr
RealDB          dd      ?       ; Real Mode DB Ptr
ProtDB          dd      ?       ; Protect Mode DB Ptr
ABIOS_Parms     ends

;
;   Macro for device drivers to use to invoke ABIOS from a device driver.
;   Preserves DevHlp(ABIOSCall) Interface.
;
;   Entry:
;       DS = Device Driver Data Segment
;       SI = Offset to Request Block
;       DI = Offset to ABIOS_Parms Structure
;       DH = # Funtion to call
;
;   Exit:
;       'C' is Clear
;       Destroys no registers, ABIOS Retcode is in Request Block
;

CallABIOS   macro
local   aprot, acont

    SaveReg     <es,bx,dx>

    .386p
    smsw    bx
    test    bl,1
    jnz     short aprot
                                        ; Real Mode Case
        push    [di].RealCDA            ; Anchor
        push    ds
        push    si                      ; Request Block
        les     bx,[di].RealFTT         ; ES:BX -> Function Transfer Table
        push    es
        push    bx                      ; Function Transfer Table
        push    [di].RealDB             ; Device Block
        jmp     short acont

        align   4
aprot:                                  ; Protect Mode Case
        push    [di].ProtCDA            ; Anchor
        push    ds
        push    si                      ; Request Block
        les     bx,[di].ProtFTT         ; ES:BX -> Function Transfer Table
        push    es
        push    bx                      ; Function Transfer Table
        push    [di].ProtDB             ; Device Block

acont:

    xor     dl,dl
    shr     dx,6
    add     bx,dx
    call    dword ptr es:[bx]
    add     sp,14
    CPUMode reset

    RestoreReg  <dx,bx,es>
    clc

    endm

