;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUSTRUC.INC
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION      V2.0
;*
;* DATE         07/19/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

DBUF    struc                           ; structure for read data command

dbuf_s          dw      0               ; prescott status
dbuf_x          dw      0               ; x-coord or t1
dbuf_y          dw      0               ; y-coord or t2
dbuf_z          dw      0               ; z-coord or t3
dbuf_r          dw      0               ; reservd or t4

DBUF    ends

;*
;* Seg:Off
;*
SEGOFF  struc

xoff            dw      ?
xseg            dw      ?

SEGOFF  ends


;*
;* Word Lo/Hi
;*
LOHI    struc

wlo             dw      ?
whi             dw      ?

LOHI    ends


;*
;* Word param block for IOCTLs
;*
WPARM   struc

wparm0          dw      ?
wparm1          dw      ?
wparm2          dw      ?
wparm3          dw      ?

WPARM   ends


;*
;* STH parm packet for IOCTLs
;*
STH     struc

sth_oth         dw      ?
sth_pth         dw      ?
sth_phy         dw      ?

STH     ends


;*
;* SCS parm packet for IOCTLs
;*
SCS     struc

scs_xmin        dw      ?
scs_xmax        dw      ?
scs_ymin        dw      ?
scs_ymax        dw      ?
scs_zmin        dw      ?
scs_zmax        dw      ?
scs_xhys        dw      ?
scs_yhys        dw      ?

SCS     ends


;*
;* ABIOS Parameter Block for O/S Calling Convention
;*
ABPB    struc

abpb_r_anchor   dw      ?
abpb_p_anchor   dw      ?
abpb_r_FTTptr   dd      ?
abpb_p_FTTptr   dd      ?
abpb_r_DBptr    dd      ?
abpb_p_DBptr    dd      ?

ABPB    ends


;*
;* ABIOS Request Parameter Block
;*
ABRQB   struc

abrqb_len       dw      size ABRQB      ; rqb length    (in)
abrqb_lid       dw      0               ; LID           (in)
abrqb_unit      dw      0               ; unit          (in)
abrqb_func      dw      0               ; function      (in)
abrqb_rsvd1     dw      0               ; reserved      (?)
abrqb_rsvd2     dw      0               ; reserved      (?)
abrqb_ret       dw      -1              ; return code   (in/out)
abrqb_to        dw      0               ; time out      (out)
abrqb_ssp       db      47 dup (0)      ; service specific parameters

ABRQB   ends


;*
;* ABIOS Service Specific Parameter Block for touch-send-byte-string, INPUT
;*
TSBSI   struc

tsbsi_DATcnt    db      ?               ; data byte count
tsbsi_ADDcnt    db      ?               ; additional resp byte count
tsbsi_DATptr    dd      ?               ; data ptr
tsbsi_ACKopt    dw      ?               ; acknowledge option
tsbsi_ADDptr    dd      ?               ; additional resp ptr

TSBSI   ends


;*
;* ABIOS Service Specific Parameter Block for touch-send-byte-string, OUTPUT
;*
TSBSO   struc

tsbso_rsrvd1    db      8 dup (?)
tsbso_wait      dd      ?               ; wait time for request
tsbso_rsrvd2    db      12 dup (?)
tsbso_ACKcnt    db      ?               ; ACK count
tsbso_nonACK    db      ?               ; non ACK response
tsbso_ADDcnt    db      ?               ; additional resp count

TSBSO   ends


;*
;* DosSMRegisterDD Data Struc
;*
REG     struc

reg_length      dw      8
reg_notifi      dw      ?
reg_ddname      dw      0, DSEG

REG     ends


;*
;* Global Info Seg
;*
GIS     struc

                dd      ?
gis_millisecs   dd      ?
                db      ?
                db      ?
                db      ?
                db      ?
                dw      ?
                dw      ?
                db      ?
                db      ?
                dw      ?
                db      ?

                db      ?
                db      ?
                db      ?

gis_fg_ses      db      ?
gis_max_fs_ses  db      ?
                db      ?
                db      ?
                dw      ?
                db      ?
                db      ?
                dw      ?
                dw      ?
gis_max_vio_ses dw      ?
gis_max_pm_ses  db      ?

GIS     ends


;*
;* Local Info Seg
;*
LIS     struc

lis_pid         dw      ?
lis_ppid        dw      ?
lis_tprty       dw      ?
lis_tid         dw      ?
lis_sesid       dw      ?
lis_pstat       db      ?
                db      ?
lis_fg          dw      ?
lis_ptype       db      ?
                db      ?
                dw      ?
                dw      ?
                dw      ?
                dw      ?
                dw      ?
                dw      ?
                dw      ?

LIS     ends


;*
;* Strategy Request Packet
;*
REQ     struc

req_length      db      ?
req_unit        db      ?
req_cmd         db      ?
req_status      dw      ?
                dd      ?
req_qlink       dd      ?
req_data        db      ?               ; variable length data

REQ     ends


;*
;* Strategy Init Device Request Packet
;*
INIT    struc

init_data_1     db      ?
init_pointer_1  dd      ?
init_pointer_2  dd      ?
init_data_2     db      ?

INIT    ends


;*
;* Strategy IOCTL Device Request Packet
;*
IOCTL   struc

ioctl_fcat      db      ?
ioctl_fcode     db      ?
ioctl_parms     dd      ?
ioctl_data      dd      ?
ioctl_sfn       dw      ?
ioctl_cbparms   dw      ?
ioctl_cbdata    dw      ?

IOCTL   ends


;*
;* Session Switch termination or Notification
;*
SSTN    struc

sstn_len        dw      ?               ; parm packet length
sstn_type       dw      ?               ; notification action type
sstn_new        dw      ?               ; incoming sess ID (type=2,4)
sstn_old        dw      ?               ; outgoing sess ID (type=1,2,8)

SSTN    ends


;*
;* Attach IDC Return Structure
;*
IDC     struc

idc_r_csip      dd      ?               ; real mode IDC entry (seg:off)
idc_r_ds        dw      ?               ; real mode DS of DD
idc_p_csip      dd      ?               ; prot mode IDC entry (seg:off)
idc_p_ds        dw      ?               ; prot mode DS of DD

IDC     ends


;*
;* IDC Query Config
;*
CONF    struc

conf_length     dw      size CONF
conf_irq_num    db      0
conf_mou_stat   dw      0               ; mouse device status flags (MS_?)
conf_tou_stat   dw      0               ; touch device status flags (TS_?)
;* conf_thre_ons  dw    0               ; ito Z
;* conf_thre_phy  dw    0               ; ito Z
;* conf_thre_psh  dw    0               ; ito Z

CONF    ends


;*
;* Touch Interrupt Packet
;*
TPKT    struc

tpkt_stat       dw      ?               ; status
tpkt_x          dw      ?               ; x coord
tpkt_y          dw      ?               ; y coord
tpkt_z          dw      ?               ; z coord

TPKT    ends


;*
;* DDDD Prescott Interrupt Data Packet XYZ Mode
;*
XYZ     struc

xyz_s1          db      0
xyz_z           db      0
xyz_yl          db      0
xyz_s2          db      0
xyz_yxh         db      0
xyz_xl          db      0

XYZ     ends


;*
;* DDDD Prescott Interrupt Data Packet Raw Mode
;*
RAW     struc

raw_t12h        db      0
raw_t1l         db      0
raw_t2l         db      0
raw_t34h        db      0
raw_t3l         db      0
raw_t4l         db      0

RAW     ends


;*
;* Read Raw Data Packet
;*
RR      struc

rr_stat         dw      0
rr_t1           dw      0
rr_t2           dw      0
rr_t3           dw      0
rr_t4           dw      0

RR      ends


;*
;* Read XYZ Data Packet
;*
RX      struc

rx_stat         dw      0
rx_x            dw      0
rx_y            dw      0
rx_z            dw      0

RX      ends


;*
;* Absolute Event Data Packet for Mouse Emulation
;*
ABSE    struc

abse_stat       dw      ?
abse_row_pos    dw      ?
abse_col_pos    dw      ?
abse_row_siz    dw      ?
abse_col_siz    dw      ?
;* abse_row_res dw      ?               ; drw, not used 18/7/91
;* abse_col_res dw      ?               ; drw, not used 18/7/91

ABSE    ends


;*
;* Event Queue Record
;*
EVNT    struc

evnt_stat       dw      ?               ; event status
evnt_x          dw      ?               ; x coord (raw mode t1)
evnt_y          dw      ?               ; y coord (raw mode t2)
evnt_z          dw      ?               ; z coord (raw mode t3)
evnt_rx         dw      ?               ; range of x
evnt_ry         dw      ?               ; range of y
evnt_rz         dw      ?               ; range of z

EVNT    ends


;*
;* Monitor Chain Output Buffer
;*
MOB     struc

mob_size        dw      size EVNT + 4   ; include this field in size
mob_flags       dw      0
mob_ev          db      size EVNT dup (?)
;* db ?

MOB     ends


;*
;* Coordinate System
;*
CSYS    struc

csys_x_min      dw      ?
csys_x_max      dw      ?
csys_y_min      dw      ?
csys_y_max      dw      ?
csys_z_min      dw      ?
csys_z_max      dw      ?
;* csys_x_hys   dw      ?
;* csys_y_hys   dw      ?

CSYS    ends


;*
;* Filter Constants
;*
FILT    struc

filt_parms      dd      ?               ; 4 byte floating point number
                dd      ?               ;       (ditto)
                dd      ?               ;       (ditto)
                dd      ?               ;       (ditto)
                dd      ?               ;       (ditto)
                dd      ?               ;       (ditto)
                dd      ?               ;       (ditto)

IF MC_LEVEL ge 130
filt_tau        db      ?               ; tau value
ENDIF

IF MC_LEVEL ge 190
filt_fdfwd      db      ?               ; feed forward data (64 nibbles)
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
                db      ?
ENDIF

FILT    ends


;*
;* Filter Parameters
;*
FP      struc

fp_type         dw      ?               ; filter type
fp_freq         dw      ?               ; filter cut off frequency

FP      ends


;*
;* Thresholds
;*
THRE    struc

;*
;* the order of these fields is fixed, & is determined by prescott
;*

thre_oth        dw      ?               ; on screen threshold   (ito prescott)
thre_off        dw      ?               ; lift off threshold    (ito prescott)
thre_phy        dw      ?               ; push hysteresis       (ito prescott)
thre_pth        dw      ?               ; push threshold        (ito prescott)

THRE    ends


;*
;* Selection Mechanism
;*
SELM    struc

selm_mech       db      ?               ; selection mechanism
selm_npts       dw      ?               ; sel mech num points
selm_tol        dw      ?               ; sel mech tolerance
selm_slim       dw      ?               ; sel mech search limit

SELM    ends


;*
;* Emulation Specific Prescott Parms
;*
ESP     struc

;*
;* ??? get rid of hupd_mask
;*

esp_hupd_mask   dw      ?                       ; hw update mask
esp_coord_org   db      ?                       ; coordinate origin
esp_sel_mech    db      size SELM dup (?)       ; selection mechanism
esp_coord_sys   db      size CSYS dup (?)       ; coordinate system
esp_threshold   db      size THRE dup (?)       ; thresholds
esp_filt_parm   db      size FP dup(?)          ; filter parms
esp_xoffset     dw      ?                       ; pointer X offset
esp_yoffset     dw      ?                       ; pointer Y offset
esp_rep_rate    db      ?                       ; report rate

ESP     ends


;*
;* Screen Group Control Blocks
;*
SGCB    struc

;*
;* ??? what is row/col scale fact, where is it used & is it neccessary
;*

sgcb_row_sf     dw      ?               ; row scale factor
sgcb_col_sf     dw      ?               ; col scale factor
sgcb_chn_hndl   dw      ?               ; monitor chain handle
sgcb_chn_size   db      ?               ; monitor chain size
sgcb_hndl_cnt   dw      ?               ; open handle count
sgcb_eq_base    dw      ?               ; event q base
sgcb_eq_head    dw      ?               ; event q head
sgcb_eq_tail    dw      ?               ; event q tail
sgcb_eq_pid     dw      ?               ; event q pid
sgcb_eq_size    db      ?               ; event q current size
sgcb_eq_max     dw      ?               ; event q max size
sgcb_dev_stat   dw      ?               ; device status flags
sgcb_ev_mask    dw      ?               ; event mask
sgcb_ev_time    dd      ?               ; event time stamp

sgcb_mopb       db      size MOB dup (?); monitor o/p buff

sgcb_dclk_size  dw      ?               ; 
sgcb_dclk_time  dw      ?               ; 
sgcb_dclk_type  db      ?               ; 

sgcb_eparms_off dw      ?               ; parms selection flag

;*
;* start of dos save state vars ***
;* ??? would be better to use label, same below
;*

sgcb_dos_save_start     db      ?       ; dummy for dos save

sgcb_emul_def   dw      ?               ; default emul settings ** 0.21c
sgcb_emul_curr  dw      ?               ; current emul settings ** 0.21c
sgcb_glass_mpi  dw      ?               ; glass mouse mode mickeys/inch

;*
;* ??? should hw_update mask be in ESP
;* ??? what about dev_status, should it be in ESP
;*
;* the ESP data struc is duplicated twice
;* one copy is for touch mode, the other for emulation
;* the working copy is first, the blocks are swapped on an open/close
;* dos mode always uses the first copy & does not swap them
;*

sgcb_esp        db      size ESP dup (?)

;*
;* end of dos save state vars ***
;*

sgcb_dos_save_end       db      ?       ; dummy for dos save

sgcb_esp_alt    db      size ESP dup (?)

sgcb_esp_flag   db      ?               ; esp fliped flag

SGCB    ends


ESP_ALT_OFFSET          equ     sgcb_esp_alt - sgcb_esp
SGCB_DOS_SAVE_SIZE      equ     sgcb_dos_save_end - sgcb_dos_save_start

;*
;* Monitor Register
;*
MON     struc

mon_pflag       dw      ?               ; placement flag
mon_index       dw      ?               ; DDDD index
mon_ibuff       dd      ?               ; far ptr to output buffer
mon_obuff       dw      ?               ; offset of input buffer

MON     ends


;*
;* Dos Event Packet
;*
DEVNT   struc

devnt_stat      dw      ?               ; event status
devnt_count     dw      ?               ; event counter
devnt_x         dw      ?               ; x position
devnt_y         dw      ?               ; y position
devnt_z         dw      ?               ; z value

DEVNT   ends

;*
;* end
;*
