;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUMACRO.INC
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/13/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

.xlist
       include iodelay.inc              ; IODELAY MACROS
.list

IF1                                     ; only needed on pass 1



int_err macro   seg, text
        local   start_text, end_text

seg     segment
start_text      db      text
end_text        equ     $
seg     ends

        mov     ax, seg
        mov     ds, ax
        mov     si, offset start_text
        mov     di, end_text - start_text
        mov     dl, 2bh
        call    devhlp
        ;*
        ;* NEVER COMES BACK
        ;*

        endm


;*
;* pvers
;*
pvers   macro   vers

        pxvers  <"Version =">,%(vers)

        endm

pxvers  macro   text1, text2

        if1
        %out    &text1 &text2
        %out
        endif
        endm


;*
;* error
;*
error   macro   data

        push    data
        call    err_trap

        endm


;*
;* pubdeb - make symbol conditionally public for debugging
;*
pubdeb  macro   sym

        ifdef   debsym
        public  sym
        endif

        endm


;*
;* labdeb - make a label conditionally for debugging
;*
labdeb  macro   sym
ifdef   debug

sym     equ     $
public  sym

endif
        endm


;*
;* Pop Flags Macro
;*
POPFF           macro

popf
;*              jmp     $+3
;*              iret
;*              push    cs
;*              call    $-2

                endm


;*
;* Copy data from parms to DST for IOCTL set commands
;*
PCOPY           macro   SRC, DST, COUNT

                push    si
                push    es
                push    ds
                cli
                lea     di, DST
                lds     si, SRC
                mov     cx, DGROUP
                mov     es, cx
                mov     cx, COUNT
                cld
                rep     movsb
                sti
                pop     ds
                pop     es
                pop     si

                endm


;*
;* Copy data from SRC to data pkt for IOCTL get commands
;*
PDCOPY          macro   SRC, DST, COUNT

                push    si
                push    es
                mov     cx, COUNT
                cli
                lea     si, SRC
                les     di, DST
                cld
                rep     movsb
                sti
                pop     es
                pop     si

                endm


;*
;* I/O Delay for port access
;*
IODELAY         macro

                jmp     short @F
@@:
                endm


;*
;* Get Processor Mode, CY set if Protect
;*
GET_MODE        macro

                smsw    ax
                shr     ax, 1           ; carry set if prot mode

                endm


;*
;* Device Help Semaphore Request
;*
DH_SEMREQUEST   macro   sem, time

                pushf                   ; save int state
                mov     ax, ds
                mov     bx, offset sem
                mov     cx, word ptr time
                mov     dx, word ptr time+2
                mov     dl, 6
                call    devhlp
                lahf                    ; save flags
                popf                    ; restore int state
                sahf                    ; restore flags

                endm


;*
;* Device Help Semaphore Clear
;*
DH_SEMCLEAR     macro   sem

                mov     ax, ds
                mov     bx, offset sem
                mov     dl, 7
                call    devhlp

                endm


;*
;* Device Help Device I/O Complete
;*
DH_DEVDONE      macro   seg, off

                mov     es, seg
                mov     bx, off
                mov     dl, 1
                call    devhlp

                endm


;*
;* Device Help Get a DOS Variable
;*
DH_GETDOSVAR    macro   var_num

                mov     al, var_num
                mov     dl, 24h
                call    devhlp

                endm


;*
;* Device Help Attach to a Device Driver
;*
DH_ATTACHDD     macro   name, struc

                mov     bx, offset name
                mov     di, offset struc
                mov     dl, 2ah
                call    devhlp

                endm


;*
;* Device Help Set Software Interrupt Vector
;*
DH_SETROMVEC    macro   handler, intnum, dos_ds

                mov     ax, offset handler      ; cs:
                mov     bx, intnum
                mov     si, offset dos_ds       ; cs:
                mov     dl, 1ah
                call    devhlp

                endm


;*
;* Device Help Create a Monitor Chain
;* NB: 'lea si, buff' used so complex addressing mode can be passed
;* monitor chain buffer must be in default data segment
;*
DH_MONCREATE    macro   buff, handler, handle

                push    ds
                push    es
                push    si
                push    di
                push    handle          ; save monitor handle, 0 - create
                lea     si, buff        ; buffer addr.
                mov     ax, ds
                mov     es, ax          ; es:si -> monitor chain buff
                mov     di, offset handler
                mov     ax, cs
                mov     ds, ax          ; ds:di -> notify routine
                pop     ax              ; get handle
                mov     dl, 1fh
                call    es:devhlp
                pop     di
                pop     si
                pop     es
                pop     ds

                endm


;*
;* Device Help Write to a Monitor Chain
;*
DH_MONWRITE     macro   record, count, handle, wflag

                push    si
                ;*
                ;* DS must be set to device drivers data seg
                ;*
                mov     cx, count
                mov     ax, handle
                mov     si, offset record
                mov     dh, wflag
                mov     dl, 22h
                call    devhlp
                pop     si

                endm


;*
;* Device Help Flush a Monitor Chain
;*
DH_MONFLUSH     macro   handle

                mov     ax, handle
                mov     dl, 23h
                call    devhlp

                endm


;*
;* Device Help Register a Monitor Chain
;*
DH_REGISTER     macro   ibuff, obuff, pid, handle, pflag

                push    si
                push    di
                push    es
                mov     di, obuff
                mov     cx, pid
                mov     ax, handle
                mov     dh, byte ptr pflag
                les     si, ibuff
                mov     dl, 20h
                call    devhlp
                pop     es
                pop     di
                pop     si

                endm


;*
;* Device Help Deregister a Monitor Chain
;*
DH_DEREGISTER   macro   pid, handle

                mov     ax, handle
                mov     bx, pid
                mov     dl, 21h
                call    devhlp

                endm


;*
;* Device Help Run Blocked Thread
;*
DH_RUN          macro   event

                mov     ax, event
                mov     bx, ds
                mov     dl, 5
                call    devhlp

                endm


;*
;* Device Help Block a Thread
;*
DH_BLOCK        macro   event, time, iflag

                mov     ax, event
                mov     bx, ds
                mov     di, word ptr time
                mov     cx, word ptr time+2
                mov     dh, iflag
                mov     dl, 4
                call    devhlp

                endm


;*
;* Device Help Set Timer
;*
DH_SETTIMER     macro   handler

                mov     ax, offset cs:handler
                mov     dl, 1dh
                call    devhlp

                endm


;*
;* Device Help Set Tick Count or Create Timer with count
;*
DH_TICKCOUNT    macro   handler, count

                mov     ax, offset cs:handler
                mov     bx, count
                mov     dl, 33h
                call    devhlp

                endm


;*
;* Device Help Set HW Int Handler
;*
DH_SETIRQ       macro   handler, int_num, share

                mov     ax, offset handler
                mov     bx, int_num
                mov     dh, share
                mov     dl, 1bh
                call    devhlp

                endm


;*
;* Device Help Remove HW Int Handler
;*
DH_UNSETIRQ     macro   int_num

                mov     bx, int_num
                mov     dl, 1ch
                call    devhlp

                endm


;*
;* Device Help EOI
;*
DH_EOI          macro   int_num

                mov     al, int_num
                mov     dl, 31h
                call    devhlp

                endm


;*
;* Device Help Verify Access
;*
DH_VERIFYACCESS macro   mem, len, type

                mov     ax, mem.xseg
                mov     cx, len
                mov     di, mem.xoff
                mov     dh, type
                mov     dl, 27h
                call    devhlp

                endm


;*
;* Device Help Mode Switch, Prot to Real
;*
DH_PROTTOREAL   macro

                mov     dl, 30h
                call    devhlp

                endm


;*
;* Device Help Mode Switch, Real to Prot
;*
DH_REALTOPROT   macro

                mov     dl, 2fh
                call    devhlp

                endm


;*
;* Device Help ABIOS Get LID Entry
;*
DH_GETLID       macro   devid, rellid, devstate

                mov     al, devid
                mov     bl, rellid
                mov     dh, devstate
                mov     dl, 34h
                call    devhlp

                endm


;*
;* Device Help ABIOS Free LID Entry
;*
DH_FREELID      macro   lid

                mov     ax, lid
                mov     dl, 35h
                call    devhlp

                endm


;*
;* Device Help ABIOS Call, O/S Transfer Convention
;*
DH_ABIOSCALL    macro   lid, rqb, fentry

                mov     ax, lid
                mov     si, offset rqb
                mov     dh, fentry
                mov     dl, 36h
                call    devhlp

                endm


;*
;* Device Help ABIOS Common Entry, ABIOS Transfer Convention
;*
DH_ABIOSCOMM    macro   rqb, fentry

                mov     si, offset rqb
                mov     dh, fentry
                mov     dl, 37h
                call    devhlp

                endm


;*
;* Device Help ABIOS Get Parms
;*
DH_ABIOSGPARMS  macro   lid, abpb

                mov     ax, lid
                mov     si, offset abpb
                mov     dl, 29h
                call    devhlp

                endm


;*
;* Device Help Internal Error
;*
DH_INTERR       macro   msg, len

                mov     si, offset msg
                mov     di, len
                mov     dl, 2bh
                call    devhlp

                endm


;*
;* Device Help Semaphore Clear
;*
DH_SEMCLEAR1    macro   sem

                push    ax
                push    bx
                push    dx
                mov     bx, sem.wlo
                mov     ax, sem.whi
                mov     dl, 7
                call    devhlp
                pop     dx
                pop     bx
                pop     ax

                endm


;*
;* Device Help Semaphore Handle
;*
DH_SEMHANDLE    macro   sem, usage

                mov     bx, sem.wlo
                mov     ax, sem.whi
                mov     dh, usage
                mov     dl, 8
                call    devhlp

                endm


;*
;* Device Help Lock Memory Segment
;*
DH_LOCK         macro   seg, type, wait

                mov     ax, seg
                mov     bh, type
                mov     bl, wait
                mov     dl, 13h
                call    devhlp

                endm


;*
;* Device Help UnLock Memory Segment
;*
DH_UNLOCK       macro   handle,

                mov     bx, word ptr handle
                mov     ax, word ptr handle+2
                mov     dl, 14h
                call    devhlp

                endm


;*
;* Call ABIOS, O/S Transfer Convention
;*
CALLABIOS       macro   rqb, fentry, aparms

                mov     si, offset rqb

                ;*
                ;* if( func == touch-send-byte-string )
                ;*      save DS to pointers, for bimodality
                ;*

                .if     <[si].abrqb_func eq ABIOS_SBS>
                        mov     [si].abrqb_ssp.tsbsi_DATptr.xseg, ds
                        mov     [si].abrqb_ssp.tsbsi_ADDptr.xseg, ds
                .endif

                ;*
                ;* save regs
                ;*
                push    es
                push    bx
                push    dx
                push    si
                push    di

                ;*
                ;* set up entry parms
                ;*
                mov     di, offset aparms       ; abios table

                smsw    bx                      ; get mode ...
                shr     bx, 1                   ; ... into CY

                .if     <c>                     ; prot mode
                        push    [di].abpb_p_anchor
                        push    ds              ; RQB seg/sel
                        push    si              ; RQB offset
                        les     bx, [di].abpb_p_FTTptr
                        push    es
                        push    bx
                        push    [di].abpb_p_DBptr.xseg
                        push    [di].abpb_p_DBptr.xoff

                .else                           ; real mode
                        push    [di].abpb_r_anchor
                        push    ds              ; RQB seg/sel
                        push    si              ; RQB offset
                        les     bx, [di].abpb_r_FTTptr
                        push    es
                        push    bx
                        push    [di].abpb_r_DBptr.xseg
                        push    [di].abpb_r_DBptr.xoff

                .endif                          ; mode test

                mov     dx, fentry              ; entry point index
                shl     dx, 2                   ; index dword ptrs
                add     bx, dx                  ; entry offset

                call    dword ptr es:[bx]       ; call entry point
                add     sp, 14                  ; remove parms

                ;*
                ;* restore regs
                ;*
                pop     di
                pop     si
                pop     dx
                pop     bx
                pop     es
                clc

                endm


;*
;* Set Request Packet Status
;*
SET_REQSTAT     macro   status

                mov     es, temp_es
                mov     bx, temp_bx
                mov     es:[bx].req_status, status
                endm


;*
;* IDC call to TOU DDDD, Query DDDD Configuration (called from DIDD)
;*
XIDC_Q_CONF     macro   pkt, buffer

                push    es
                push    ds
                push    ds
                pop     es
                mov     ax, 1                   ; function
                mov     di, offset buffer
                ;*
                ;* called only at init time so prot mode only
                ;*
                mov     ds, pkt.idc_p_ds
                call    es:pkt.idc_p_csip
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DDDD, Read Enable (called from DIDD)
;*
XIDC_READ_EN    macro   pkt, buffer

                push    es
                push    ds
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 2                   ; function
                mov     di, offset buffer
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DDDD, Read Disable (called from DIDD)
;*
XIDC_READ_DIS   macro   pkt

                push    es
                push    ds
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 3                   ; function
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DDDD, Device Enable (called from DIDD)
;*
XIDC_DEV_EN     macro   pkt

                push    es
                push    ds
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 4                   ; function
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DDDD, Device Disable (called from DIDD)
;*
XIDC_DEV_DIS    macro   pkt

                push    es
                push    ds
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 5                   ; function
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DDDD, Hardware Update (called from DIDD)
;*
XIDC_HW_UPDATE  macro   pkt

                push    es
                push    ds
                ;* ds -> es
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 6                   ; function
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* IDC call to TOU DIDD, Process Packet (called from DDDD)
;*
;* XIDC_PROCPKT macro   pkt, buffer
XIDC_PROCPKT    macro   pkt

;*              push    es
;*              push    ds
;*              push    ds
;*              pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 1                   ; function
;*              mov     si, offset buffer
                .if     c                       ; prot mode
;*                      mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
;*                      mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
;*              pop     ds
;*              pop     es

                endm


;*
;* IDC call to MOU DIDD, Absolute Process Packet (called from DDDD)
;*
XIDC_ABSPROCPKT macro   pkt

                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 3                   ; function
                .if     c                       ; prot mode
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        call    es:pkt.idc_r_csip
                .endif

                endm


;*
;* IDC call to TOU DIDD, Disable Support (called from DDDD)
;*
XIDC_DISSUP     macro   pkt

                push    es
                push    ds
                push    ds
                pop     es
                GET_MODE
                ;*
                ;* carry set if prot mode
                ;*
                mov     ax, 2                   ; function
                .if     c                       ; prot mode
                        mov     ds, pkt.idc_p_ds
                        call    es:pkt.idc_p_csip
                .else                           ; real mode
                        mov     ds, pkt.idc_r_ds
                        call    es:pkt.idc_r_csip
                .endif
                pop     ds
                pop     es

                endm


;*
;* Dos Int7f Parms, Data & AX return
;*
;* The following are dependant on I7F_ENTER, below
;*
I7F_IP_PARMS    equ     dword ptr [bp+10]
I7F_OP_PARMS    equ     dword ptr [bp+6]
I7F_AX_RET      equ     word  ptr [bp-2]


;*
;* Dos Int7f Entry macro (Affects I7F_IP_PARMS/OP_PARMS/AX_RET, above)
;*
I7F_ENTRY       macro

                enter   0,0
                pusha
                push    es
                push    ds
                mov     ds, cs:real_ds
                mov     I7F_AX_RET, I7F_OK
                inc     int7f_active            ; flag, int7f in progress

                endm

;*
;* Dos Int7f Exit macro
;*
I7F_EXIT        macro

                dec     int7f_active            ; flag, int7f finished
                pop     ds
                pop     es
                popa
                leave
                ret     8

                endm

ENDIF                                           ; pass 1

;*
;* MyIODelay - Perform an IO delay using kernel provided macro
;*             This macro give the proper amount of delay regardless
;*             of processor speed.
;*

MyIOdelay MACRO

        push ax
        DevIODelay <ax>                         ; Trashes AX reg
        pop  ax

        ENDM
;*
;* end
;*
