;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = GPM.INC
;*
;* DESCRIPTIVE NAME = Get & Put Message
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/08/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS    getputmsg,      getputmsg1.
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

cseg    ends                    ; keep linker happy for dosgetmessage segment!
        extrn   DOSGETMESSAGE:far
        extrn   DOSPUTMESSAGE:far
cseg    segment


MSG_LEN         equ     256


DSEG    segment

GPM_PP  struc
p1      dw      0, dseg
p2      dw      0, dseg
p3      dw      0, dseg
;* p4   dw      0, dseg
GPM_PP  ends

MAX_PARMS       equ     (size GPM_PP)/4

gpm_parms       GPM_PP  <>

msg_buff        db      MSG_LEN dup (0)
msg_count       dw      0
wrt_count       dw      0
_banner_done    dw      0                       ; 1 => banner/sign-on displayed

DSEG    ends


public  _banner_done

public  getputmsg


if 1

;/***************************************************************************
;*
;* FUNCTION NAME = getputmsg
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public  gpm_parms

PROCEDURE       getputmsg       near

PARAMETER       num_parms       word
PARAMETER       mess_num        word

BEGINPROC

        .if     <mess_num ge INF_DD_MOULD>      ; limit messages
        .if     <mess_num le INF_DD_DMC>
                jmp     gp_proc_end
        .endif
        .endif                                  ; limit messages


        .if     <num_parms gt MAX_PARMS>
                mov     num_parms, 0
                mov     mess_num, ERR_ILLEGAL
        .endif


        .if     <_banner_done eq 0>
                mov     _banner_done, 1
                mov     gpm_parms.p1, offset mparm_vers
                push    dseg
                push    offset gpm_parms
                push    1                       ; num_parms
                push    dseg
                push    offset msg_buff
                push    MSG_LEN
                push    INF_DD_SIGNON
                push    dseg
                push    offset msg_name
                push    dseg
                push    offset msg_count
                call    DOSGETMESSAGE

                push    1                       ; stdout
                push    msg_count
                push    dseg
                push    offset msg_buff
                call    DOSPUTMESSAGE
        .endif

                push    dseg
                push    offset gpm_parms
                push    num_parms
                push    dseg
                push    offset msg_buff
                push    MSG_LEN
                push    mess_num
                push    dseg
                push    offset msg_name
                push    dseg
                push    offset msg_count
                call    DOSGETMESSAGE

                push    1                       ; stdout
                push    msg_count
                push    dseg
                push    offset msg_buff
                call    DOSPUTMESSAGE

gp_proc_end:

ENDPROC         getputmsg


else


;/***************************************************************************
;*
;* FUNCTION NAME = getputmsg
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

getputmsg       proc    near

mess_num        equ     word ptr [bp+4]
num_parms       equ     word ptr [bp+6]

                enter   0,0

        .if     <num_parms gt MAX_PARMS>
                mov     num_parms, 0
                mov     mess_num, ERR_DD_ILLEGAL
        .endif

;*
;* gpm_parms needs to have stack seg not dseg initialised
;*

                push    dseg
                push    offset gpm_parms
                push    num_parms
                push    dseg
                push    offset msg_buff
                push    MSG_LEN
                push    mess_num
                push    dseg
                push    offset msg_name
                push    dseg
                push    offset msg_count
                call    DOSGETMESSAGE

                push    1                       ; stdout
                push    msg_count
                push    dseg
                push    offset msg_buff
                call    DOSPUTMESSAGE

;* ENDPROC      getputmsg

                leave
                ret

getputmsg       endp

endif


if 1

;/***************************************************************************
;*
;* FUNCTION NAME = getputmsg1
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

public  getputmsg1

PROCEDURE       getputmsg1      near

PARAMETER       num_parms1      word
PARAMETER       mess_num1       word
PARAMETER       msg_name1       dword

BEGINPROC

        .if     <num_parms gt MAX_PARMS>
                mov     num_parms1, 0
                mov     mess_num1, ERR_ILLEGAL
        .endif

                push    dseg
                push    offset gpm_parms
                push    num_parms1
                push    dseg
                push    offset msg_buff
                push    MSG_LEN
                push    mess_num1
                push    msg_name1.whi
                push    msg_name1.wlo
                push    dseg
                push    offset msg_count
                call    DOSGETMESSAGE

                push    1                       ; stdout
                push    msg_count
                push    dseg
                push    offset msg_buff
                call    DOSPUTMESSAGE

ENDPROC         getputmsg1
endif

;*
;* end
;*
